/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.tydic.active.app.atom.ActSelectDictByCodeAndPcodeAtomService;
import com.tydic.active.app.busi.ActDictionaryBusiService;
import com.tydic.active.app.common.bo.ActDicDictionaryReqBO;
import com.tydic.active.app.common.bo.DicDictionaryBO;
import com.tydic.active.app.dao.ActDicDictionaryMapper;
import com.tydic.active.app.dao.po.DicDictionaryPO;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="actDictionaryBusiService")
public class ActDictionaryBusiServiceImpl
implements ActDictionaryBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActDictionaryBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final String SYS_CODE_DEFAULT = "*";
    @Autowired
    private ActDicDictionaryMapper actDicDictionaryMapper;
    @Autowired
    private ActSelectDictByCodeAndPcodeAtomService actSelectDictByCodeAndPcodeAtomService;

    public List<DicDictionaryBO> queryBypCodeBackPo(String pCode) {
        return this.queryBypCodeBackPo(null, pCode);
    }

    public List<DicDictionaryBO> queryBypCodeBackPo(String sysCode, String pCode) {
        return this.actSelectDictByCodeAndPcodeAtomService.queryBypCodeBackPo(sysCode, pCode);
    }

    public Map<String, String> queryBypCodeBackMap(String pCode) {
        return this.queryBypCodeBackMap(null, pCode);
    }

    public Map<String, String> queryBypCodeBackMap(String sysCode, String pCode) {
        return this.actSelectDictByCodeAndPcodeAtomService.queryDictBySysCodeAndPcode(sysCode, pCode);
    }

    public DicDictionaryBO getDictionaryByBO(DicDictionaryBO dicDictionaryBO) {
        DicDictionaryBO dictionaryBO = new DicDictionaryBO();
        DicDictionaryPO dicDictionaryModel = new DicDictionaryPO();
        BeanUtils.copyProperties((Object)dicDictionaryBO, (Object)dicDictionaryModel);
        DicDictionaryPO dicDictionaryPO = this.actDicDictionaryMapper.getModelByCondition(dicDictionaryModel);
        if (null != dicDictionaryPO) {
            BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dictionaryBO);
        }
        return dictionaryBO;
    }

    public DicDictionaryPO getDicDictionaryPO(String sysCode, String pCode) {
        DicDictionaryPO queryDictionaryPO = new DicDictionaryPO();
        queryDictionaryPO.setPCode(pCode);
        if (StringUtils.isEmpty((Object)sysCode)) {
            sysCode = SYS_CODE_DEFAULT;
        }
        queryDictionaryPO.setSysCode(sysCode);
        return queryDictionaryPO;
    }

    public int updateDicDictionary(ActDicDictionaryReqBO dicDictionaryBO) {
        DicDictionaryPO dicDictionaryModel = new DicDictionaryPO();
        dicDictionaryModel.setTitle(dicDictionaryBO.getTitle());
        dicDictionaryModel.setOrderId(dicDictionaryBO.getOrderId());
        dicDictionaryModel.setDescrip(dicDictionaryBO.getDescrip());
        dicDictionaryModel.setDelFlag(dicDictionaryBO.getDelflag());
        dicDictionaryModel.setSysCode(dicDictionaryBO.getSysCode());
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.actDicDictionaryMapper.updateByCondition(dicDictionaryModel);
    }

    public int addDicDictionary(ActDicDictionaryReqBO dicDictionaryBO) {
        DicDictionaryPO dicDictionaryModel = new DicDictionaryPO();
        dicDictionaryModel.setTitle(dicDictionaryBO.getTitle());
        dicDictionaryModel.setOrderId(dicDictionaryBO.getOrderId());
        dicDictionaryModel.setDescrip(dicDictionaryBO.getDescrip());
        dicDictionaryModel.setDelFlag(dicDictionaryBO.getDelflag());
        dicDictionaryModel.setSysCode(dicDictionaryBO.getSysCode());
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.actDicDictionaryMapper.insert(dicDictionaryModel);
    }

    public int deleteDicDictionary(ActDicDictionaryReqBO dicDictionaryBO) {
        DicDictionaryPO dicDictionaryModel = new DicDictionaryPO();
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.actDicDictionaryMapper.deleteByCondition(dicDictionaryModel);
    }

    public int checkDicBy(String code, String pCode) {
        DicDictionaryPO dicDictionaryModel = new DicDictionaryPO();
        dicDictionaryModel.setPCode(pCode);
        dicDictionaryModel.setCode(code);
        return this.actDicDictionaryMapper.getCheckBy(dicDictionaryModel);
    }
}

