/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.ActRedisManager;
import com.tydic.active.app.atom.ActSelectDictByCodeAndPcodeAtomService;
import com.tydic.active.app.busi.ActQryGroupActiveInstDetailsBusiService;
import com.tydic.active.app.busi.bo.ActQryGroupActiveInstDetailsBusiReqBO;
import com.tydic.active.app.busi.bo.ActQryGroupActiveInstDetailsBusiRspBO;
import com.tydic.active.app.common.bo.ActGroupActiveInstBO;
import com.tydic.active.app.common.bo.ActGroupActiveInstDetailBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActGroupActiveInstDetailMapper;
import com.tydic.active.app.dao.ActGroupActiveInstMapper;
import com.tydic.active.app.dao.po.ActGroupActiveInstDetailPO;
import com.tydic.active.app.dao.po.ActGroupActiveInstPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActQryGroupActiveInstDetailsBusiServiceImpl
implements ActQryGroupActiveInstDetailsBusiService {
    @Autowired
    private ActGroupActiveInstMapper actGroupActiveInstMapper;
    @Autowired
    private ActGroupActiveInstDetailMapper actGroupActiveInstDetailMapper;
    @Autowired
    private ActSelectDictByCodeAndPcodeAtomService actSelectDictByCodeAndPcodeAtomService;
    @Autowired
    private ActRedisManager cacheManager;
    @Value(value="${STOCK_HANDLE_MODE}")
    private Byte stockHandleMode;

    public ActQryGroupActiveInstDetailsBusiRspBO qryGroupActiveInstDetails(ActQryGroupActiveInstDetailsBusiReqBO busiReqBO) {
        ActQryGroupActiveInstDetailsBusiRspBO rsp = new ActQryGroupActiveInstDetailsBusiRspBO();
        ActGroupActiveInstBO actGroupActiveInstBO = new ActGroupActiveInstBO();
        ActGroupActiveInstDetailPO actGroupActiveInstDetailPO = new ActGroupActiveInstDetailPO();
        actGroupActiveInstDetailPO.setActiveId(busiReqBO.getActiveId());
        actGroupActiveInstDetailPO.setOrderId(busiReqBO.getOrderId());
        ActGroupActiveInstDetailPO actGroupActiveInstDetail = this.actGroupActiveInstDetailMapper.getModelBy(actGroupActiveInstDetailPO);
        if (null == actGroupActiveInstDetail) {
            throw new BusinessException("14003", "\u4e0d\u5b58\u5728\u8be5\u62fc\u56e2\u5b9e\u4f8b\u660e\u7ec6\uff01");
        }
        ActGroupActiveInstPO actGroupActiveInstPO = this.actGroupActiveInstMapper.selectByPrimaryKey(actGroupActiveInstDetail.getGroupInstId());
        if (null == actGroupActiveInstPO) {
            throw new BusinessException("14003", "\u4e0d\u5b58\u5728\u8be5\u62fc\u56e2\u5b9e\u4f8b\u660e\u7ec6\uff01");
        }
        BeanUtils.copyProperties((Object)actGroupActiveInstPO, (Object)actGroupActiveInstBO);
        if (!ActCommConstant.StockHandleMode.NO_STOCK_LIMIT.equals(this.stockHandleMode)) {
            Integer groupMemNum = this.getGroupMemNum(actGroupActiveInstBO.getActiveId(), actGroupActiveInstBO.getGroupInstId());
            Integer lockMemNum = this.getLockMemNum(actGroupActiveInstBO.getActiveId(), actGroupActiveInstBO.getGroupInstId());
            actGroupActiveInstBO.setGroupMenNum(groupMemNum);
            actGroupActiveInstBO.setLockMemNum(lockMemNum);
        }
        Map<String, String> groupActiveInstStateStrMap = this.actSelectDictByCodeAndPcodeAtomService.queryDictBySysCodeAndPcode("MSC", "GROUP_ACTIVE_INST_PCODE");
        if (null != actGroupActiveInstBO.getState()) {
            actGroupActiveInstBO.setStateStr(groupActiveInstStateStrMap.get(actGroupActiveInstBO.getState().toString()));
        }
        List<ActGroupActiveInstDetailBO> actGroupActiveInstDetailBOs = this.getActGroupActiveInstDetailBOs(actGroupActiveInstPO, busiReqBO);
        actGroupActiveInstBO.setActGroupActiveInstDetailBOs(actGroupActiveInstDetailBOs);
        rsp.setActGroupActiveInstBO(actGroupActiveInstBO);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u62fc\u56e2\u5b9e\u4f8b\u8be6\u60c5\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }

    private Integer getLockMemNum(Long activeId, Long groupInstId) {
        String lockMemNumRedisKey = "LOCK_TOTAL_" + activeId + "_" + groupInstId;
        Long lockMemNum = this.cacheManager.incrByCount(lockMemNumRedisKey, 0L);
        return lockMemNum.intValue();
    }

    private Integer getGroupMemNum(Long activeId, Long groupInstId) {
        String groupMemNumRedisKey = "SALES_TOTAL_" + activeId + "_" + groupInstId;
        Long groupMemNum = this.cacheManager.incrByCount(groupMemNumRedisKey, 0L);
        return groupMemNum.intValue();
    }

    private List<ActGroupActiveInstDetailBO> getActGroupActiveInstDetailBOs(ActGroupActiveInstPO actGroupActiveInstPO, ActQryGroupActiveInstDetailsBusiReqBO busiReqBO) {
        ArrayList<ActGroupActiveInstDetailBO> result = new ArrayList<ActGroupActiveInstDetailBO>();
        ActGroupActiveInstDetailPO actGroupActiveInstDetailPO = new ActGroupActiveInstDetailPO();
        actGroupActiveInstDetailPO.setActiveId(busiReqBO.getActiveId());
        actGroupActiveInstDetailPO.setGroupInstId(actGroupActiveInstPO.getGroupInstId());
        actGroupActiveInstDetailPO.setOrderStatus("1");
        List<ActGroupActiveInstDetailPO> list = this.actGroupActiveInstDetailMapper.getList(actGroupActiveInstDetailPO);
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, String> isHeadFlagStrMap = this.actSelectDictByCodeAndPcodeAtomService.queryDictBySysCodeAndPcode("MSC", "IS_HEAD_FLAG_PCODE");
            for (ActGroupActiveInstDetailPO po : list) {
                ActGroupActiveInstDetailBO actGroupActiveInstDetailBO = new ActGroupActiveInstDetailBO();
                BeanUtils.copyProperties((Object)po, (Object)actGroupActiveInstDetailBO);
                if (null != actGroupActiveInstDetailBO.getIsHeadFlag()) {
                    actGroupActiveInstDetailBO.setIsHeadFlagStr(isHeadFlagStrMap.get(actGroupActiveInstDetailBO.getIsHeadFlag().toString()));
                }
                result.add(actGroupActiveInstDetailBO);
            }
        }
        return result;
    }
}

