/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.active.app.atom.ActQryKillSkuStockPriceAtomService;
import com.tydic.active.app.atom.ActQueryMerchantOrSenceAtomService;
import com.tydic.active.app.atom.bo.ActQryKillSkuStockPriceAtomReqBO;
import com.tydic.active.app.atom.bo.ActQryKillSkuStockPriceAtomRspBO;
import com.tydic.active.app.atom.bo.ActQueryMerchantOrSenceAtomReqBO;
import com.tydic.active.app.atom.bo.ActQueryMerchantOrSenceAtomRspBO;
import com.tydic.active.app.busi.ActQryKillSkyByTimeIntervalBusiService;
import com.tydic.active.app.busi.bo.ActQryKillSkyByTimeIntervalBusiReqBO;
import com.tydic.active.app.busi.bo.ActQryKillSkyByTimeIntervalBusiRspBO;
import com.tydic.active.app.common.bo.ActKIllSkuInfoBO;
import com.tydic.active.app.common.bo.ActKillSkuBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActKillTimeMapper;
import com.tydic.active.app.dao.ActivityMapper;
import com.tydic.active.app.dao.po.ActKillTimePO;
import com.tydic.active.app.dao.po.ActivityPO;
import com.tydic.active.app.facde.ActUgcServiceHolder;
import com.tydic.active.external.api.commodity.bo.ActActivityCenterSearchEsReqBO;
import com.tydic.active.external.api.commodity.bo.ActActivityCenterSearchEsRspBO;
import com.tydic.active.external.api.commodity.bo.ActSearchBarEsRspInfoBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actQryKillSkyByTimeIntervalBusiService")
public class ActQryKillSkyByTimeIntervalBusiServiceImpl
implements ActQryKillSkyByTimeIntervalBusiService {
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private ActKillTimeMapper actKillTimeMapper;
    @Autowired
    private ActUgcServiceHolder actUgcServiceHolder;
    @Autowired
    private ActQueryMerchantOrSenceAtomService actQueryMerchantOrSenceAtomService;
    @Autowired
    private ActQryKillSkuStockPriceAtomService actQryKillSkuStockPriceAtomService;

    public ActQryKillSkyByTimeIntervalBusiRspBO qryKillSkyByTimeInterval(ActQryKillSkyByTimeIntervalBusiReqBO busiReqBO) {
        Date killDayEndTIme;
        Date killDayStartTIme;
        ActQryKillSkyByTimeIntervalBusiRspBO rsp = new ActQryKillSkyByTimeIntervalBusiRspBO();
        ArrayList<ActKIllSkuInfoBO> rows = new ArrayList<ActKIllSkuInfoBO>();
        ActivityPO killActiveTime = this.activityMapper.getKillActiveTimeAndCheck(busiReqBO.getActiveCode(), Long.valueOf(busiReqBO.getOrgIdIn()), busiReqBO.getActiveId(), "10");
        if (null == killActiveTime) {
            throw new BusinessException("14003", "\u4e0d\u5b58\u5728\u8be5\u6d3b\u52a8\uff01");
        }
        if (null == busiReqBO.getKillDay()) {
            busiReqBO.setKillDay(new Date());
        }
        if (StringUtils.isNotBlank((CharSequence)busiReqBO.getStartTimeSlot()) && StringUtils.isNotBlank((CharSequence)busiReqBO.getEndTimeSlot())) {
            String qryKillDayToDay = DateUtils.dateToStr((Date)busiReqBO.getKillDay());
            String killDayStartTImeStr = qryKillDayToDay + " " + busiReqBO.getStartTimeSlot();
            String killDayEndTImeStr = qryKillDayToDay + " " + busiReqBO.getEndTimeSlot();
            killDayStartTIme = DateUtils.strToDateLong((String)killDayStartTImeStr);
            killDayEndTIme = DateUtils.strToDateLong((String)killDayEndTImeStr);
        } else {
            killDayStartTIme = busiReqBO.getKillDay();
            killDayEndTIme = busiReqBO.getKillDay();
        }
        ActKillTimePO actKillTimePO = new ActKillTimePO();
        actKillTimePO.setStartTime(killDayStartTIme);
        actKillTimePO.setEndTime(killDayEndTIme);
        actKillTimePO.setActiveId(killActiveTime.getActiveId());
        List<Long> skuIds = this.actKillTimeMapper.getSkuIdByTime(actKillTimePO);
        if (CollectionUtils.isEmpty(skuIds)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        ActActivityCenterSearchEsRspBO result = this.getActivityCenterSearchEs(skuIds, killActiveTime, busiReqBO, busiReqBO.getPageNo(), busiReqBO.getPageSize());
        if (CollectionUtils.isEmpty((Collection)result.getRows())) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        ArrayList<String> skuIdsStr = new ArrayList<String>();
        for (ActSearchBarEsRspInfoBO bo : result.getRows()) {
            skuIdsStr.add(bo.getSkuId().toString());
            ActKIllSkuInfoBO actKIllSkuInfoBO = new ActKIllSkuInfoBO();
            actKIllSkuInfoBO.setCommodityId(bo.getCommodityId().toString());
            actKIllSkuInfoBO.setCommodityName(bo.getCommodityName());
            actKIllSkuInfoBO.setSkuId(bo.getSkuId().toString());
            actKIllSkuInfoBO.setSkuName(bo.getSkuName());
            actKIllSkuInfoBO.setSkuPrice(Long.valueOf(bo.getSalePrice().longValue()));
            actKIllSkuInfoBO.setPriPicUrl(bo.getPriPicUrl());
            rows.add(actKIllSkuInfoBO);
        }
        ActQryKillSkuStockPriceAtomReqBO actQryKillSkuStockPriceAtomReqBO = new ActQryKillSkuStockPriceAtomReqBO();
        actQryKillSkuStockPriceAtomReqBO.setActiveId(killActiveTime.getActiveId());
        actQryKillSkuStockPriceAtomReqBO.setSkuIds(skuIdsStr);
        ActQryKillSkuStockPriceAtomRspBO actQryKillSkuStockPriceAtomRspBO = this.actQryKillSkuStockPriceAtomService.qryKillSkuStockPrice(actQryKillSkuStockPriceAtomReqBO);
        if (!"0000".equals(actQryKillSkuStockPriceAtomRspBO.getRespCode())) {
            throw new BusinessException(actQryKillSkuStockPriceAtomRspBO.getRespCode(), actQryKillSkuStockPriceAtomRspBO.getRespDesc());
        }
        this.setValue(rows, actQryKillSkuStockPriceAtomRspBO.getSkuIdKillSkuBOMap());
        this.calculateValue(rows, killActiveTime.getKillActiveTime());
        Calendar qryKillDay = Calendar.getInstance();
        qryKillDay.setTime(busiReqBO.getKillDay());
        Integer day = qryKillDay.get(5);
        if (day % 2 != 0) {
            Collections.sort(rows, new Comparator<ActKIllSkuInfoBO>(){

                @Override
                public int compare(ActKIllSkuInfoBO o1, ActKIllSkuInfoBO o2) {
                    if (o1.getSkuOrder() > o2.getSkuOrder()) {
                        return 1;
                    }
                    if (o1.getSkuOrder().equals(o2.getSkuOrder())) {
                        return 0;
                    }
                    return -1;
                }
            });
        }
        rsp.setRows(rows);
        rsp.setTotal(result.getTotal());
        rsp.setRecordsTotal(result.getRecordsTotal());
        rsp.setPageNo(result.getPageNo());
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u65f6\u6bb5\u79d2\u6740\u5546\u54c1\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01\uff01");
        return rsp;
    }

    private void calculateValue(List<ActKIllSkuInfoBO> rows, Double killActiveTime) {
        for (ActKIllSkuInfoBO bo : rows) {
            bo.setKillActiveTime(killActiveTime);
            Date now = new Date();
            if (now.compareTo(bo.getStartTime()) < 0) {
                bo.setIsKilling(Integer.valueOf(1));
            } else if (now.compareTo(bo.getStartTime()) >= 0 && now.compareTo(bo.getEndTime()) < 0) {
                bo.setIsKilling(Integer.valueOf(2));
            } else if (now.compareTo(bo.getEndTime()) >= 0) {
                bo.setIsKilling(Integer.valueOf(3));
            }
            BigDecimal rate = new BigDecimal(bo.getCurrentUsedStockNum()).divide(new BigDecimal(bo.getCurrentTotalStockNum()).multiply(new BigDecimal(100)), 2, RoundingMode.HALF_UP);
            bo.setKillRate(rate);
        }
    }

    private void setValue(List<ActKIllSkuInfoBO> rows, Map<String, ActKillSkuBO> skuIdKillSkuBOMap) {
        for (ActKIllSkuInfoBO bo : rows) {
            bo.setCurrentKillPrice(skuIdKillSkuBOMap.get(bo.getSkuId()).getCurrentKillPrice());
            bo.setCurrentTotalStockNum(skuIdKillSkuBOMap.get(bo.getSkuId()).getCurrentTotalStockNum());
            bo.setCurrentAvilabeStockNum(skuIdKillSkuBOMap.get(bo.getSkuId()).getCurrentAvilabeStockNum());
            bo.setCurrentUsedStockNum(skuIdKillSkuBOMap.get(bo.getSkuId()).getCurrentUsedStockNum());
            bo.setStartTime(skuIdKillSkuBOMap.get(bo.getSkuId()).getStartTime());
            bo.setEndTime(skuIdKillSkuBOMap.get(bo.getSkuId()).getEndTime());
            bo.setSkuOrder(skuIdKillSkuBOMap.get(bo.getSkuId()).getSkuOrder());
        }
    }

    private ActActivityCenterSearchEsRspBO getActivityCenterSearchEs(List<Long> skuIds, ActivityPO killActiveTime, ActQryKillSkyByTimeIntervalBusiReqBO busiReqBO, Integer pageNo, Integer pageSize) {
        ActActivityCenterSearchEsRspBO rsp = new ActActivityCenterSearchEsRspBO();
        ActActivityCenterSearchEsReqBO actActivityCenterSearchEsReqBO = new ActActivityCenterSearchEsReqBO();
        ArrayList<Integer> skuStatus = new ArrayList<Integer>();
        skuStatus.add(3);
        actActivityCenterSearchEsReqBO.setSkuStatus(skuStatus);
        actActivityCenterSearchEsReqBO.setPageNo(pageNo);
        actActivityCenterSearchEsReqBO.setPageSize(pageSize);
        actActivityCenterSearchEsReqBO.setSkuList(skuIds);
        ActQueryMerchantOrSenceAtomReqBO actQueryMerchantOrSenceAtomReqBO = new ActQueryMerchantOrSenceAtomReqBO();
        actQueryMerchantOrSenceAtomReqBO.setActiveId(killActiveTime.getActiveId());
        actQueryMerchantOrSenceAtomReqBO.setAdmOrgId(killActiveTime.getAdmOrgId());
        actQueryMerchantOrSenceAtomReqBO.setMarketingType("10");
        ActQueryMerchantOrSenceAtomRspBO atomRspBO = this.actQueryMerchantOrSenceAtomService.queryMerchantOrSence(actQueryMerchantOrSenceAtomReqBO);
        if (ActCommConstant.SendTarget.SCENE.equals(killActiveTime.getSendTarget())) {
            if (!CollectionUtils.isEmpty(atomRspBO.getSceneIds())) {
                actActivityCenterSearchEsReqBO.setSceneId(atomRspBO.getSceneIds().iterator().next());
            }
        } else if (!CollectionUtils.isEmpty(atomRspBO.getMerchantIds())) {
            actActivityCenterSearchEsReqBO.setOrgIdIn(atomRspBO.getMerchantIds().iterator().next().toString());
        }
        actActivityCenterSearchEsReqBO.setOrderByColumn(Integer.valueOf(7));
        actActivityCenterSearchEsReqBO.setRootOrgIdIn(busiReqBO.getRootOrgIdIn());
        actActivityCenterSearchEsReqBO.setParentOrgIdIn(busiReqBO.getParentOrgIdIn());
        actActivityCenterSearchEsReqBO.setIsField(false);
        rsp = this.actUgcServiceHolder.getActActivityCenterSearchEsService().qryBySearchBar(actActivityCenterSearchEsReqBO);
        if (!"0000".equals(rsp.getRespCode())) {
            throw new BusinessException(rsp.getRespCode(), rsp.getRespDesc());
        }
        return rsp;
    }
}

