/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.busi.ActSaleNumUpdateBusiService;
import com.tydic.active.app.busi.bo.ActSaleNumUpdateBusiReqBO;
import com.tydic.active.app.busi.bo.ActSaleNumUpdateBusiRspBO;
import com.tydic.active.app.dao.CommodityKillSkuMapper;
import com.tydic.active.app.dao.po.CommodityKillSkuPO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actSaleNumUpdateBusiService")
public class ActSaleNumUpdateBusiServiceImpl
implements ActSaleNumUpdateBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActSaleNumUpdateBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    private static final String SUCCESS_MSG = "\u9500\u552e\u6570\u91cf\u66f4\u65b0\u6210\u529f";
    private static final String ERROR_MSG = "\u9500\u552e\u6570\u91cf\u66f4\u65b0\u5931\u8d25";
    private static final String INCREASE = "0";
    private static final String REDUCE = "1";
    @Autowired
    private CommodityKillSkuMapper commodityKillSkuMapper;

    public ActSaleNumUpdateBusiRspBO updateSaleNum(ActSaleNumUpdateBusiReqBO busiReqBO) {
        ActSaleNumUpdateBusiRspBO rsp = new ActSaleNumUpdateBusiRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc(SUCCESS_MSG);
        if (INCREASE.equals(busiReqBO.getOperType())) {
            this.increaseSeckNum(busiReqBO, rsp);
        } else if (REDUCE.equals(busiReqBO.getOperType())) {
            this.reduceSeckNum(busiReqBO, rsp);
        } else {
            rsp.setRespCode("2002");
            rsp.setRespDesc("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
        }
        return rsp;
    }

    private void reduceSeckNum(ActSaleNumUpdateBusiReqBO busiReqBO, ActSaleNumUpdateBusiRspBO rsp) {
        CommodityKillSkuPO killSkuPO = new CommodityKillSkuPO();
        killSkuPO.setSkuState(1);
        if (!StringUtils.isBlank((CharSequence)busiReqBO.getCycId())) {
            killSkuPO.setKillCycleId(Long.valueOf(busiReqBO.getCycId()));
        }
        killSkuPO.setShopId(Long.valueOf(busiReqBO.getShopId()));
        killSkuPO.setSkuId(busiReqBO.getSkuId());
        CommodityKillSkuPO skuPO = null;
        skuPO = this.commodityKillSkuMapper.getModelBy(killSkuPO);
        if (null == skuPO) {
            rsp.setRespCode("2001");
            rsp.setRespDesc("\u9500\u552e\u6570\u91cf\u66f4\u65b0\u5931\u8d25,\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u4e3a\u7a7a");
            return;
        }
        if (skuPO.getSalesNum() - Integer.valueOf(busiReqBO.getOperNum()) < 0) {
            rsp.setRespCode("2002");
            rsp.setRespDesc("\u9500\u552e\u6570\u91cf\u66f4\u65b0\u5931\u8d25,\u53ef\u64cd\u4f5c\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
            return;
        }
        CommodityKillSkuPO commodityKillSkuPO = new CommodityKillSkuPO();
        commodityKillSkuPO.setPlateRelId(skuPO.getPlateRelId());
        commodityKillSkuPO.setSalesNum(skuPO.getSalesNum() - Integer.valueOf(busiReqBO.getOperNum()));
        int result = this.commodityKillSkuMapper.updateById(commodityKillSkuPO);
        if (result < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u9500\u552e\u6570\u91cf\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\uff0c\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6082", "\u9500\u552e\u6570\u91cf\u66f4\u65b0\u5931\u8d25,\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
    }

    private void increaseSeckNum(ActSaleNumUpdateBusiReqBO busiReqBO, ActSaleNumUpdateBusiRspBO rsp) {
        CommodityKillSkuPO killSkuPO = new CommodityKillSkuPO();
        killSkuPO.setSkuState(1);
        if (!StringUtils.isBlank((CharSequence)busiReqBO.getCycId())) {
            killSkuPO.setKillCycleId(Long.valueOf(busiReqBO.getCycId()));
        }
        killSkuPO.setShopId(Long.valueOf(busiReqBO.getShopId()));
        killSkuPO.setSkuId(busiReqBO.getSkuId());
        CommodityKillSkuPO skuPO = null;
        skuPO = this.commodityKillSkuMapper.getModelBy(killSkuPO);
        if (null == skuPO) {
            rsp.setRespCode("2001");
            rsp.setRespDesc("\u9500\u552e\u6570\u91cf\u66f4\u65b0\u5931\u8d25,\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u4e3a\u7a7a");
            return;
        }
        if (skuPO.getLockNum() < Integer.valueOf(busiReqBO.getOperNum())) {
            rsp.setRespCode("2002");
            rsp.setRespDesc("\u9500\u552e\u6570\u91cf\u66f4\u65b0\u5931\u8d25,\u53ef\u64cd\u4f5c\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
            return;
        }
        CommodityKillSkuPO commodityKillSkuPO = new CommodityKillSkuPO();
        commodityKillSkuPO.setPlateRelId(skuPO.getPlateRelId());
        commodityKillSkuPO.setSalesNum(skuPO.getSalesNum() + Integer.valueOf(busiReqBO.getOperNum()));
        commodityKillSkuPO.setLockNum(skuPO.getLockNum() - Integer.valueOf(busiReqBO.getOperNum()));
        int result = this.commodityKillSkuMapper.updateById(commodityKillSkuPO);
        if (result < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u9500\u552e\u6570\u91cf\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\uff0c\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6082", "\u9500\u552e\u6570\u91cf\u66f4\u65b0\u5931\u8d25,\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
    }
}

