/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.busi.ActSeckActStartStopBusiService;
import com.tydic.active.app.busi.bo.ActSeckActStartStopBusiReqBO;
import com.tydic.active.app.busi.bo.ActSeckActStartStopBusiRspBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.CommodityKillCycleMapper;
import com.tydic.active.app.dao.CommodityKillSkuMapper;
import com.tydic.active.app.dao.po.CommodityKillCyclePO;
import com.tydic.active.app.dao.po.CommodityKillSkuPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actSeckActStartStopBusiService")
public class ActSeckActStartStopBusiServiceImpl
implements ActSeckActStartStopBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActSeckActStartStopBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final Integer START = 0;
    private static final Integer STOP = 1;
    private CommodityKillCycleMapper commodityKillCycleMapper;
    private CommodityKillSkuMapper commodityKillSkuMapper;

    @Autowired
    public ActSeckActStartStopBusiServiceImpl(CommodityKillCycleMapper commodityKillCycleMapper, CommodityKillSkuMapper commodityKillSkuMapper) {
        this.commodityKillCycleMapper = commodityKillCycleMapper;
        this.commodityKillSkuMapper = commodityKillSkuMapper;
    }

    public ActSeckActStartStopBusiRspBO dealSeckActStartStop(ActSeckActStartStopBusiReqBO reqBO) {
        ActSeckActStartStopBusiRspBO rspBO = new ActSeckActStartStopBusiRspBO();
        for (Long killCycleId : reqBO.getKillCycleIdList()) {
            CommodityKillCyclePO cyclePO = new CommodityKillCyclePO();
            cyclePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
            cyclePO.setKillCycleId(killCycleId);
            int check = this.commodityKillCycleMapper.getCheckBy(cyclePO);
            if (check < 1) {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u79d2\u6740\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25,killCycleId=[" + killCycleId + "]\u8be5\u79d2\u6740\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
                }
                throw new BusinessException("6017", "killCycleId=[" + killCycleId + "]\u8be5\u79d2\u6740\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            }
            if (START.equals(reqBO.getOperType())) {
                this.startOrStopSeckillAct(killCycleId, ActCommConstant.ActivityState.STATE_EFFECTIVE);
                continue;
            }
            if (STOP.equals(reqBO.getOperType())) {
                this.startOrStopSeckillAct(killCycleId, ActCommConstant.ActivityState.DISABLED);
                continue;
            }
            throw new BusinessException("6017", "\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u79d2\u6740\u6d3b\u52a8\u542f\u505c\u670d\u52a1\u6210\u529f");
        return rspBO;
    }

    private void startOrStopSeckillAct(Long killCycleId, Integer status) {
        CommodityKillCyclePO cyclePO = new CommodityKillCyclePO();
        cyclePO.setKillCycleId(killCycleId);
        cyclePO.setStatus(status);
        int updateCycle = this.commodityKillCycleMapper.updateById(cyclePO);
        if (updateCycle < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u79d2\u6740\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u79d2\u6740\u5468\u671f\u8868\u5931\u8d25\uff0cupdate\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6017", "\u79d2\u6740\u6d3b\u52a8\u542f\u505c\u5931\u8d25");
        }
        CommodityKillSkuPO killSkuPO = new CommodityKillSkuPO();
        killSkuPO.setKillCycleId(killCycleId);
        killSkuPO.setSkuState(status);
        int updateSku = this.commodityKillSkuMapper.updateById(killSkuPO);
        if (updateSku < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u79d2\u6740\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u79d2\u6740\u5546\u54c1\u8868\u5931\u8d25\uff0cupdate\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6017", "\u79d2\u6740\u6d3b\u52a8\u542f\u505c\u5931\u8d25");
        }
    }
}

