/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.ability.bo.ActWelfarePointGrantApproveAbilityReqBO;
import com.tydic.active.app.ability.bo.ActWelfarePointGrantApproveAbilityRspBO;
import com.tydic.active.app.busi.ActWelfarePointGrantApproveBusiService;
import com.tydic.active.app.busi.WelfareActiveAuditOperateService;
import com.tydic.active.app.busi.bo.WelfareActiveAuditCreateReqBO;
import com.tydic.active.app.busi.bo.WelfareActiveAuditCreateRspBO;
import com.tydic.active.app.busi.bo.WelfareActiveInvokeAuditReqBO;
import com.tydic.active.app.busi.bo.WelfareActiveInvokeAuditRspBO;
import com.tydic.active.app.busi.bo.WelfarePointGrantBusiBO;
import com.tydic.active.app.busi.bo.WelfarePointsMemWalletBusiBO;
import com.tydic.active.app.constant.ActActiveConstant;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.WelfarePointGrantMapper;
import com.tydic.active.app.dao.WelfarePointsGrantMemMapper;
import com.tydic.active.app.dao.WelfarePointsMemWalletMapper;
import com.tydic.active.app.dao.po.WelfarePointGrantMemBusiPO;
import com.tydic.active.app.dao.po.WelfarePointGrantPO;
import com.tydic.active.app.dao.po.WelfarePointsGrantMemPO;
import com.tydic.active.app.dao.po.WelfarePointsMemWalletPO;
import com.tydic.uac.util.GenerateIdUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActWelfarePointGrantApproveBusiServiceImpl
implements ActWelfarePointGrantApproveBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActWelfarePointGrantApproveBusiServiceImpl.class);
    @Autowired
    private WelfareActiveAuditOperateService welfareActiveAuditOperateService;
    @Autowired
    private WelfarePointGrantMapper welfarePointGrantMapper;
    @Autowired
    private WelfarePointsGrantMemMapper grantMemMapper;
    @Autowired
    private WelfarePointsMemWalletMapper welfarePointsMemWalletMapper;
    @Autowired
    private GenerateIdUtil idUtil;

    public ActWelfarePointGrantApproveAbilityRspBO createAuditOrder(ActWelfarePointGrantApproveAbilityReqBO reqBO) {
        ActWelfarePointGrantApproveAbilityRspBO rspBO = new ActWelfarePointGrantApproveAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u521b\u5efa\u5ba1\u6279\u5355\u6210\u529f");
        List WelfarePointGrantIds = reqBO.getWelfarePointGrantIds();
        WelfarePointGrantBusiBO grantBusiBO = new WelfarePointGrantBusiBO();
        grantBusiBO.setGrantIdList(WelfarePointGrantIds);
        List<WelfarePointGrantPO> grantPOList = this.welfarePointGrantMapper.selectGrantListBy(grantBusiBO);
        Map<Long, Byte> statusMap = grantPOList.stream().collect(Collectors.toMap(WelfarePointGrantPO::getWelfarePointGrantId, WelfarePointGrantPO::getStatus));
        boolean failCount = false;
        for (Long welfarePointGrantId : WelfarePointGrantIds) {
            Byte status = statusMap.get(welfarePointGrantId);
            if (status != null) {
                if (!status.equals(ActActiveConstant.GrantStatus.APPROVE_PASS)) continue;
                throw new BusinessException("8888", "\u53d1\u653eid\u3010" + welfarePointGrantId + "\u3011\u5df2\u7ecf\u5ba1\u6279\u901a\u8fc7");
            }
            throw new BusinessException("8888", "\u53d1\u653eid\u3010" + welfarePointGrantId + "\u3011\u53d1\u653e\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        for (Long welfarePointGrantId : WelfarePointGrantIds) {
            WelfareActiveAuditCreateReqBO auditCreateReqBO = new WelfareActiveAuditCreateReqBO();
            auditCreateReqBO.setObjId(welfarePointGrantId.toString());
            auditCreateReqBO.setOrderId(welfarePointGrantId);
            auditCreateReqBO.setOrgId(reqBO.getOrgIdIn());
            auditCreateReqBO.setOrgName(reqBO.getOrgName());
            auditCreateReqBO.setUserId(String.valueOf(reqBO.getUserId()));
            auditCreateReqBO.setUserName(reqBO.getName());
            auditCreateReqBO.setMenuId("M003004");
            auditCreateReqBO.setObjType(ActCommConstant.AuditObjType.WELFARE_GRANT_AUDIT);
            WelfareActiveAuditCreateRspBO auditCreateRspBO = this.welfareActiveAuditOperateService.createAuditOrder(auditCreateReqBO);
            if ("0000".equals(auditCreateRspBO.getRespCode())) continue;
            log.error("\u53d1\u653eid\u3010" + welfarePointGrantId + "\u3011\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25\uff0c" + auditCreateRspBO.getRespDesc());
            throw new BusinessException("8888", auditCreateRspBO.getRespDesc());
        }
        return rspBO;
    }

    public ActWelfarePointGrantApproveAbilityRspBO dealAuditOrder(ActWelfarePointGrantApproveAbilityReqBO reqBO) {
        ActWelfarePointGrantApproveAbilityRspBO rspBO = new ActWelfarePointGrantApproveAbilityRspBO();
        WelfareActiveInvokeAuditReqBO invokeAuditReqBO = new WelfareActiveInvokeAuditReqBO();
        if (reqBO.getUserIdIn() == null) {
            reqBO.setUserIdIn(Long.valueOf(0L));
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)invokeAuditReqBO);
        invokeAuditReqBO.setObjIds(new HashSet(reqBO.getWelfarePointGrantIds()));
        invokeAuditReqBO.setObjType(ActCommConstant.AuditObjType.WELFARE_GRANT_AUDIT);
        WelfareActiveInvokeAuditRspBO auditRspBO = this.welfareActiveAuditOperateService.invokeAuditOrder(invokeAuditReqBO);
        if (!"0000".equals(auditRspBO.getRespCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(auditRspBO.getRespDesc());
            return rspBO;
        }
        for (Long welfarePointGrantId : reqBO.getWelfarePointGrantIds()) {
            Boolean finishFlag = (Boolean)auditRspBO.getAuditFinishMap().get(welfarePointGrantId);
            if (!finishFlag.booleanValue()) continue;
            WelfarePointGrantPO grantPO = this.welfarePointGrantMapper.selectByPrimaryKey(welfarePointGrantId);
            if (reqBO.getAuditResult().equals(ActCommConstant.AuditResult.ADOPT)) {
                grantPO.setStatus(ActActiveConstant.GrantStatus.APPROVE_PASS);
                WelfarePointGrantMemBusiPO welfarePointGrantMemBusiPO = WelfarePointGrantMemBusiPO.builder().welfarePointGrantId(welfarePointGrantId).build();
                List<WelfarePointsGrantMemPO> memList = this.grantMemMapper.selectMemListBy(welfarePointGrantMemBusiPO);
                WelfarePointsMemWalletBusiBO walletBusiBO = new WelfarePointsMemWalletBusiBO();
                walletBusiBO.setWelfarePointGrantId(welfarePointGrantId);
                this.welfarePointsMemWalletMapper.deleteBy(walletBusiBO);
                for (WelfarePointsGrantMemPO grantMemPO : memList) {
                    WelfarePointsMemWalletPO welfarePointsMemWalletPO = new WelfarePointsMemWalletPO();
                    welfarePointsMemWalletPO.setId(this.idUtil.nextId());
                    welfarePointsMemWalletPO.setRelateId(grantMemPO.getMemGrantId());
                    welfarePointsMemWalletPO.setWelfarePoints(grantMemPO.getWelfarePoints());
                    welfarePointsMemWalletPO.setBalancePoints(grantMemPO.getWelfarePoints());
                    welfarePointsMemWalletPO.setMemId(grantMemPO.getMemId());
                    welfarePointsMemWalletPO.setMemCode(grantMemPO.getMemCode());
                    welfarePointsMemWalletPO.setMemName(grantMemPO.getMemName());
                    welfarePointsMemWalletPO.setWelfareType(grantPO.getWelfareType());
                    welfarePointsMemWalletPO.setWelfarePointType(grantPO.getWelfarePointType());
                    welfarePointsMemWalletPO.setOperateTime(new Date());
                    welfarePointsMemWalletPO.setUsedPoints(BigDecimal.ZERO);
                    welfarePointsMemWalletPO.setWelfarePointCode(grantPO.getWelfarePointCode());
                    welfarePointsMemWalletPO.setWelfarePointName(grantPO.getWelfarePointName());
                    welfarePointsMemWalletPO.setGrantType(Byte.parseByte("1"));
                    welfarePointsMemWalletPO.setWelfarePointGrantId(grantMemPO.getWelfarePointGrantId());
                    welfarePointsMemWalletPO.setExtField1("0");
                    this.welfarePointsMemWalletMapper.insert(welfarePointsMemWalletPO);
                }
            } else if (reqBO.getAuditResult().equals(ActCommConstant.AuditResult.NOT_PASS)) {
                grantPO.setStatus(ActActiveConstant.GrantStatus.APPROVE_FAIL);
            }
            this.welfarePointGrantMapper.updateByPrimaryKeySelective(grantPO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setAuditFinishMap(auditRspBO.getAuditFinishMap());
        return rspBO;
    }
}

