/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.active.app.ability.bo.ActQueryOrgListAbilityReqBO;
import com.tydic.active.app.ability.bo.ActQueryOrgListAbilityRspBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointGrantAbilityReqBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointGrantDetailInfoRspBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointGrantOverviewAbilityRspBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointGrantPageAbilityReqBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointGrantPageAbilityRspBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointGrantPageBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointsChargePageBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointsChargePageReqBO;
import com.tydic.active.app.ability.bo.ActQueryWelfarePointsChargePageRsqBO;
import com.tydic.active.app.ability.bo.ActWelfarePointGrantAbilityRspBO;
import com.tydic.active.app.ability.bo.WelfarePointGrantAuthReqBO;
import com.tydic.active.app.ability.bo.WelfarePointGrantBO;
import com.tydic.active.app.ability.bo.WelfarePointGrantDetailInfoBO;
import com.tydic.active.app.ability.bo.WelfarePointOrgBO;
import com.tydic.active.app.ability.bo.WelfarePointsAttachBO;
import com.tydic.active.app.busi.ActWelfarePointGrantBusiService;
import com.tydic.active.app.busi.ActWelfarePointGrantUserBusiService;
import com.tydic.active.app.busi.ActWelfarePointsAttachBusiService;
import com.tydic.active.app.busi.bo.ActQueryWelfarePointsChargePageBusiReqBO;
import com.tydic.active.app.busi.bo.ActQueryWelfarePointsChargePageBusiRspBO;
import com.tydic.active.app.busi.bo.WelfarePointGrantOverviewBusiBO;
import com.tydic.active.app.busi.bo.WelfarePointGrantPageBusiReqBO;
import com.tydic.active.app.busi.bo.WelfarePointGrantUserCountBusiReqBO;
import com.tydic.active.app.busi.bo.WelfarePointOrgBusiBO;
import com.tydic.active.app.busi.bo.WelfarePointsAttachBusiReqBO;
import com.tydic.active.app.constant.ActActiveConstant;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.constant.ActEnumConstant;
import com.tydic.active.app.constant.ActWelfarePointsGrantConstant;
import com.tydic.active.app.dao.WelfarePointGrantMapper;
import com.tydic.active.app.dao.WelfarePointsAttachMapper;
import com.tydic.active.app.dao.WelfarePointsChangeMapper;
import com.tydic.active.app.dao.WelfarePointsChargeMapper;
import com.tydic.active.app.dao.WelfarePointsGrantMemMapper;
import com.tydic.active.app.dao.po.WelfarePointGrantPO;
import com.tydic.active.app.dao.po.WelfarePointsAttachPO;
import com.tydic.active.app.dao.po.WelfarePointsChangePO;
import com.tydic.active.app.dao.po.WelfarePointsChargePO;
import com.tydic.uac.util.GenerateIdUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ActWelfarePointGrantBusiServiceImpl
implements ActWelfarePointGrantBusiService {
    private static final Logger log = LoggerFactory.getLogger(ActWelfarePointGrantBusiServiceImpl.class);
    @Autowired
    private WelfarePointGrantMapper welfarePointGrantMapper;
    @Autowired
    private WelfarePointsGrantMemMapper memMapper;
    @Autowired
    private WelfarePointsAttachMapper welfarePointsAttachMapper;
    @Autowired
    private GenerateIdUtil idUtil;
    @Autowired
    private WelfarePointsChargeMapper welfarePointsChargeMapper;
    @Autowired
    private ActWelfarePointsAttachBusiService attachBusiService;
    @Autowired
    private ActWelfarePointGrantUserBusiService actWelfarePointGrantUserBusiService;
    @Autowired
    private WelfarePointsChangeMapper welfarePointsChangeMapper;

    public ActQueryWelfarePointGrantOverviewAbilityRspBO queryOverviewInfo(ActQueryWelfarePointGrantAbilityReqBO reqBO) {
        WelfarePointGrantPO reqPo = new WelfarePointGrantPO();
        reqPo.setOrgId(reqBO.getOrgIdWeb());
        reqPo.setOperateId(reqBO.getOperateId());
        reqPo.setOrgPermissionIds(reqBO.getOrgPermissionIds());
        reqPo.setChargeAmountStatusList(ActActiveConstant.QUERY_CHARGE_AMOUNT_STATUS_LIST);
        reqPo.setGrantAmountStatusList(ActActiveConstant.QUERY_GRANT_AMOUNT_STATUS_LIST);
        List<WelfarePointGrantOverviewBusiBO> overviewList = this.welfarePointGrantMapper.queryOverviewInfoList(reqPo);
        ActQueryWelfarePointGrantOverviewAbilityRspBO resp = new ActQueryWelfarePointGrantOverviewAbilityRspBO();
        if (CollectionUtils.isEmpty(overviewList)) {
            resp.setRespCode("0000");
            resp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return resp;
        }
        ActQueryWelfarePointGrantOverviewAbilityRspBO overviewBO = new ActQueryWelfarePointGrantOverviewAbilityRspBO();
        BigDecimal defVal = BigDecimal.ZERO;
        overviewBO.setCompanyAllAmount(defVal);
        overviewBO.setCompanyGrantAmount(defVal);
        overviewBO.setCompanyAvailableAmount(defVal);
        overviewBO.setCompanyUsedAmount(defVal);
        overviewBO.setTradeUnionAllAmount(defVal);
        overviewBO.setTradeUnionGrantAmount(defVal);
        overviewBO.setTradeUnionAvailableAmount(defVal);
        overviewBO.setTradeUnionUsedAmount(defVal);
        for (WelfarePointGrantOverviewBusiBO overviewBusiBO : overviewList) {
            Byte welfareType = overviewBusiBO.getWelfareType();
            if (ActActiveConstant.WelfareType.COMPANY.equals(welfareType)) {
                overviewBO.setCompanyAllAmount(overviewBusiBO.getAllCount());
                overviewBO.setCompanyGrantAmount(overviewBusiBO.getGrantCount());
                overviewBO.setCompanyAvailableAmount(overviewBusiBO.getAvailableCount());
                overviewBO.setCompanyUsedAmount(overviewBusiBO.getUsedCount());
                continue;
            }
            if (!ActActiveConstant.WelfareType.TRADE_UNION.equals(welfareType)) continue;
            overviewBO.setTradeUnionAllAmount(overviewBusiBO.getAllCount());
            overviewBO.setTradeUnionGrantAmount(overviewBusiBO.getGrantCount());
            overviewBO.setTradeUnionAvailableAmount(overviewBusiBO.getAvailableCount());
            overviewBO.setTradeUnionUsedAmount(overviewBusiBO.getUsedCount());
        }
        BeanUtils.copyProperties((Object)overviewBO, (Object)resp);
        resp.setRespCode("0000");
        resp.setRespDesc("\u67e5\u8be2\u6210\u529f\uff01");
        return resp;
    }

    public ActQueryWelfarePointGrantPageAbilityRspBO queryList(ActQueryWelfarePointGrantPageAbilityReqBO reqBO) {
        List<WelfarePointsChargePO> chargePOS;
        WelfarePointGrantPageBusiReqBO queryPO = new WelfarePointGrantPageBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryPO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        page.setLimit(reqBO.getPageSize().intValue());
        List<WelfarePointGrantPO> grantPOList = this.welfarePointGrantMapper.selectByCondition(queryPO, (Page<WelfarePointGrantPO>)page);
        ActQueryWelfarePointGrantPageAbilityRspBO busiRspBO = new ActQueryWelfarePointGrantPageAbilityRspBO();
        if (CollectionUtils.isEmpty(grantPOList)) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        ArrayList<ActQueryWelfarePointGrantPageBO> rows = new ArrayList<ActQueryWelfarePointGrantPageBO>();
        List grantIdList = grantPOList.stream().map(WelfarePointGrantPO::getWelfarePointGrantId).collect(Collectors.toList());
        WelfarePointGrantUserCountBusiReqBO userCountBusiReqBO = new WelfarePointGrantUserCountBusiReqBO();
        userCountBusiReqBO.setGrantIdList(grantIdList);
        Map countMap = this.actWelfarePointGrantUserBusiService.queryGrantUserCount(userCountBusiReqBO).getUserCountMap();
        int seq = 1;
        HashSet<String> set = new HashSet<String>();
        for (WelfarePointGrantPO welfarePointGrantPO : grantPOList) {
            ActQueryWelfarePointGrantPageBO rspBO = new ActQueryWelfarePointGrantPageBO();
            BeanUtils.copyProperties((Object)welfarePointGrantPO, (Object)rspBO);
            rspBO.setSerialNumber(Integer.valueOf(seq));
            rspBO.setGrantUserCount((Integer)countMap.get(welfarePointGrantPO.getWelfarePointGrantId()));
            ActWelfarePointsGrantConstant.translateCode((WelfarePointGrantBO)rspBO, false);
            if (ActActiveConstant.GrantStatus.INVALID.equals(rspBO.getStatus()) || ActActiveConstant.GrantStatus.RELEASE.equals(rspBO.getStatus())) {
                BigDecimal userPoint = rspBO.getUsedPoints() == null ? BigDecimal.ZERO : rspBO.getUsedPoints();
                BigDecimal welfarePoints = rspBO.getWelfarePoints() == null ? BigDecimal.ZERO : rspBO.getWelfarePoints();
                rspBO.setDisabledAmount(welfarePoints.subtract(userPoint));
            }
            rows.add(rspBO);
            ++seq;
            if (StringUtils.isEmpty((Object)rspBO.getWelfarePointChargeCode())) continue;
            set.add(rspBO.getWelfarePointChargeCode());
        }
        if (!CollectionUtils.isEmpty(set) && !CollectionUtils.isEmpty(chargePOS = this.welfarePointsChargeMapper.selectBywelfarePointChargeCode(new ArrayList<String>(set)))) {
            Map<String, WelfarePointsChargePO> map = chargePOS.stream().collect(Collectors.toMap(WelfarePointsChargePO::getWelfarePointChargeCode, e -> e, (first, second) -> second));
            for (ActQueryWelfarePointGrantPageBO row : rows) {
                WelfarePointsChargePO ChargePO = map.get(row.getWelfarePointChargeCode());
                if (ChargePO == null) continue;
                row.setWelfarePointsChargeId(ChargePO.getWelfarePointsChargeId());
                if (Objects.nonNull(ChargePO.getExtField1())) {
                    row.setPayType(Integer.valueOf(ChargePO.getExtField1()));
                    row.setPayTypeStr("1".equals(ChargePO.getExtField1()) ? "\u9884\u5b58\u652f\u4ed8" : "\u8d26\u671f\u652f\u4ed8");
                }
                if (!Objects.nonNull(ChargePO.getTradeMode())) continue;
                row.setTradeMode(ChargePO.getTradeMode());
                row.setTradeModeStr(ActActiveConstant.tradeModeType.SELF.equals(ChargePO.getTradeMode()) ? "\u662f" : "\u5426");
            }
        }
        busiRspBO.setRows(rows);
        busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u798f\u70b9\u53d1\u653e\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    public ActQueryWelfarePointGrantDetailInfoRspBO queryDetail(ActQueryWelfarePointGrantAbilityReqBO reqBO) {
        WelfarePointGrantPO queryPO = new WelfarePointGrantPO();
        queryPO.setWelfarePointGrantId(reqBO.getWelfarePointGrantId());
        queryPO.setWelfarePointCode(reqBO.getWelfarePointCode());
        WelfarePointGrantPO grantRecord = this.welfarePointGrantMapper.getModelBy(queryPO);
        ActQueryWelfarePointGrantDetailInfoRspBO resp = new ActQueryWelfarePointGrantDetailInfoRspBO();
        if (grantRecord == null) {
            resp.setRespCode("0000");
            resp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return resp;
        }
        WelfarePointGrantDetailInfoBO detailInfoBO = new WelfarePointGrantDetailInfoBO();
        BeanUtils.copyProperties((Object)grantRecord, (Object)detailInfoBO);
        detailInfoBO.setWelfarePointTypeStr(ActEnumConstant.WelfarePointType.getDesc(grantRecord.getWelfarePointType()));
        detailInfoBO.setWelfareTypeStr(ActEnumConstant.WelfareType.getDesc(grantRecord.getWelfareType()));
        if (grantRecord.getWelfareCompany() != null) {
            detailInfoBO.setWelfareCompanyStr(ActEnumConstant.WelfareCompanyType.getDesc(grantRecord.getWelfareCompany().byteValue()));
        }
        List<WelfarePointsAttachPO> welfareActiveAttachPOList = this.welfarePointsAttachMapper.selectListByRelatedId(grantRecord.getWelfarePointGrantId());
        ArrayList<WelfarePointsAttachBO> welfareActiveAttachBOList = new ArrayList<WelfarePointsAttachBO>();
        if (CollUtil.isNotEmpty(welfareActiveAttachPOList)) {
            for (WelfarePointsAttachPO attachPO : welfareActiveAttachPOList) {
                WelfarePointsAttachBO attachBO = new WelfarePointsAttachBO();
                BeanUtils.copyProperties((Object)attachPO, (Object)attachBO);
                welfareActiveAttachBOList.add(attachBO);
            }
        }
        detailInfoBO.setOrgIdWeb(grantRecord.getOrgId());
        detailInfoBO.setOrgNameWeb(grantRecord.getOrgName());
        detailInfoBO.setOrgCodeWeb(grantRecord.getOrgCode());
        detailInfoBO.setWelfareActiveAttachList(welfareActiveAttachBOList);
        List<WelfarePointsChargePO> chargePOS = this.welfarePointsChargeMapper.selectBywelfarePointChargeCode(Arrays.asList(grantRecord.getWelfarePointChargeCode()));
        detailInfoBO.setTradeMode(chargePOS.get(0).getTradeMode());
        resp.setDetailInfoBO(detailInfoBO);
        this.getWelfarePointsChangeInfo(grantRecord.getWelfarePointGrantId(), resp);
        this.getWelfarePointGrantRecordInfo(grantRecord.getWelfarePointGrantId(), resp);
        resp.setRespCode("0000");
        resp.setRespDesc("\u67e5\u8be2\u53d1\u653e\u8be6\u60c5\u6210\u529f\uff01");
        return resp;
    }

    public ActWelfarePointGrantAbilityRspBO addGrantInfo(WelfarePointGrantAuthReqBO reqBO) {
        WelfarePointGrantPO queryPO = new WelfarePointGrantPO();
        queryPO.setWelfarePointCode(reqBO.getWelfarePointCode());
        WelfarePointGrantPO grantRecord = this.welfarePointGrantMapper.getModelBy(queryPO);
        WelfarePointGrantPO grantPO = new WelfarePointGrantPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)grantPO);
        grantPO.setOrgId(reqBO.getOrgIdWeb());
        grantPO.setOrgName(reqBO.getOrgNameWeb());
        grantPO.setOrgCode(reqBO.getOrgCodeWeb());
        int isSuccess = 0;
        String errorMsg = "\u798f\u70b9\u53d1\u653e\u65b0\u589e\u5931\u8d25\uff01";
        String succMsg = "\u798f\u70b9\u53d1\u653e\u65b0\u589e\u6210\u529f\uff01";
        Long welfarePointGrantId = 0L;
        if (grantRecord == null) {
            welfarePointGrantId = this.idUtil.nextId();
            grantPO.setWelfarePointGrantId(welfarePointGrantId);
            grantPO.setStatus(ActActiveConstant.GrantStatus.WAIT_SAVE);
            this.setOperateInfo(reqBO, grantPO);
            grantPO.setUsedPoints(BigDecimal.ZERO);
            isSuccess = this.welfarePointGrantMapper.insert(grantPO);
        } else {
            errorMsg = "\u798f\u70b9\u53d1\u653e\u4fee\u6539\u5931\u8d25\uff01";
            succMsg = "\u798f\u70b9\u53d1\u653e\u4fee\u6539\u6210\u529f\uff01";
            welfarePointGrantId = grantRecord.getWelfarePointGrantId();
            grantPO.setWelfarePointGrantId(welfarePointGrantId);
            this.setOperateInfo(reqBO, grantPO);
            if (reqBO.getWelfarePointType().intValue() == 1) {
                grantPO.setGrantFlag("1");
            }
            isSuccess = this.welfarePointGrantMapper.updateByPrimaryKeySelective(grantPO);
        }
        ActWelfarePointGrantAbilityRspBO rsp = new ActWelfarePointGrantAbilityRspBO();
        if (isSuccess < 1) {
            rsp.setRespCode("0101");
            rsp.setRespDesc(errorMsg);
            return rsp;
        }
        List attachBOList = reqBO.getWelfareActiveAttachList();
        if (CollUtil.isNotEmpty((Collection)attachBOList)) {
            Byte busiType = ActCommConstant.WelfarePointsAttachBusiType.WELFARE_POINT_GRANT;
            WelfarePointsAttachBO delBO = new WelfarePointsAttachBO();
            delBO.setRelateId(welfarePointGrantId);
            this.attachBusiService.deleteAttach(delBO);
            WelfarePointsAttachBusiReqBO attachBusiReqBO = new WelfarePointsAttachBusiReqBO();
            attachBusiReqBO.setAttachBOList(attachBOList);
            attachBusiReqBO.setRelateId(welfarePointGrantId);
            attachBusiReqBO.setBusiType(busiType);
            this.attachBusiService.saveAttach(attachBusiReqBO);
        }
        rsp.setWelfarePointGrantId(welfarePointGrantId);
        rsp.setRespCode("0000");
        rsp.setRespDesc(succMsg);
        return rsp;
    }

    public ActQueryOrgListAbilityRspBO queryOrgList(ActQueryOrgListAbilityReqBO reqBO) {
        WelfarePointsChargePO queryChargePO = new WelfarePointsChargePO();
        queryChargePO.setIssuerId(reqBO.getUserId());
        queryChargePO.setStatusList(CollUtil.newArrayList((Object[])new Byte[]{ActActiveConstant.welfarePointsStatus.APPROVE_PASS}));
        List<WelfarePointOrgBusiBO> orgList = this.welfarePointsChargeMapper.queryOrgList(queryChargePO);
        ActQueryOrgListAbilityRspBO resp = new ActQueryOrgListAbilityRspBO();
        ArrayList<WelfarePointOrgBO> rows = new ArrayList<WelfarePointOrgBO>();
        WelfarePointOrgBO userOrg = new WelfarePointOrgBO();
        userOrg.setOrgId(reqBO.getOrgId());
        userOrg.setOrgCode(reqBO.getOrgCodeIn());
        userOrg.setOrgName(reqBO.getOrgName());
        rows.add(userOrg);
        if (CollUtil.isNotEmpty(orgList)) {
            Map<Long, WelfarePointOrgBusiBO> orgMap = orgList.stream().collect(Collectors.toMap(WelfarePointOrgBusiBO::getOrgId, e -> e));
            for (Map.Entry<Long, WelfarePointOrgBusiBO> entry : orgMap.entrySet()) {
                WelfarePointOrgBusiBO orgBusiBO = entry.getValue();
                if (orgBusiBO.getOrgId() == null || userOrg.getOrgId().equals(orgBusiBO.getOrgId())) continue;
                WelfarePointOrgBO orgOrg = new WelfarePointOrgBO();
                BeanUtils.copyProperties((Object)orgBusiBO, (Object)orgOrg);
                rows.add(orgOrg);
            }
        }
        resp.setOrgList(rows);
        resp.setRespCode("0000");
        resp.setRespDesc("\u67e5\u8be2\u53d1\u653e\u673a\u6784\u6210\u529f\uff01");
        return resp;
    }

    public ActQueryWelfarePointsChargePageRsqBO queryChargeList(ActQueryWelfarePointsChargePageReqBO reqBO) {
        ActQueryWelfarePointsChargePageBusiReqBO queryPO = new ActQueryWelfarePointsChargePageBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryPO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        page.setLimit(reqBO.getPageSize().intValue());
        queryPO.setGrantAmountStatusList(ActActiveConstant.QUERY_GRANT_AMOUNT_STATUS_LIST);
        List<ActQueryWelfarePointsChargePageBusiRspBO> grantPOList = this.welfarePointsChargeMapper.selectListByGrantCondition(queryPO, (Page<ActQueryWelfarePointsChargePageBusiRspBO>)page);
        ActQueryWelfarePointsChargePageRsqBO busiRspBO = new ActQueryWelfarePointsChargePageRsqBO();
        if (CollectionUtils.isEmpty(grantPOList)) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        ArrayList<ActQueryWelfarePointsChargePageBO> rows = new ArrayList<ActQueryWelfarePointsChargePageBO>();
        for (ActQueryWelfarePointsChargePageBusiRspBO welfarePointGrantPO : grantPOList) {
            ActQueryWelfarePointsChargePageBO rspBO = new ActQueryWelfarePointsChargePageBO();
            BeanUtils.copyProperties((Object)welfarePointGrantPO, (Object)rspBO);
            rspBO.setWelfareCompanyStr(ActEnumConstant.WelfareCompanyType.getDesc(welfarePointGrantPO.getWelfareCompany()));
            rspBO.setWelfareTypeStr(ActEnumConstant.WelfareType.getDesc(welfarePointGrantPO.getWelfareType()));
            rows.add(rspBO);
        }
        busiRspBO.setRows(rows);
        busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u798f\u70b9\u5145\u503c\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    public ActQueryWelfarePointGrantPageAbilityRspBO queryApproveList(ActQueryWelfarePointGrantPageAbilityReqBO reqBO) {
        List<WelfarePointsChargePO> chargePOS;
        WelfarePointGrantPageBusiReqBO queryPO = new WelfarePointGrantPageBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryPO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        page.setLimit(reqBO.getPageSize().intValue());
        List<WelfarePointGrantPO> grantPOList = this.welfarePointGrantMapper.selectApproveListPageByCondition(queryPO, (Page<WelfarePointGrantPO>)page);
        ActQueryWelfarePointGrantPageAbilityRspBO busiRspBO = new ActQueryWelfarePointGrantPageAbilityRspBO();
        if (CollectionUtils.isEmpty(grantPOList)) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        ArrayList<ActQueryWelfarePointGrantPageBO> rows = new ArrayList<ActQueryWelfarePointGrantPageBO>();
        List grantIdList = grantPOList.stream().map(WelfarePointGrantPO::getWelfarePointGrantId).collect(Collectors.toList());
        WelfarePointGrantUserCountBusiReqBO userCountBusiReqBO = new WelfarePointGrantUserCountBusiReqBO();
        userCountBusiReqBO.setGrantIdList(grantIdList);
        Map countMap = this.actWelfarePointGrantUserBusiService.queryGrantUserCount(userCountBusiReqBO).getUserCountMap();
        HashSet<String> set = new HashSet<String>();
        int seq = 1;
        for (WelfarePointGrantPO welfarePointGrantPO : grantPOList) {
            ActQueryWelfarePointGrantPageBO rspBO = new ActQueryWelfarePointGrantPageBO();
            BeanUtils.copyProperties((Object)welfarePointGrantPO, (Object)rspBO);
            rspBO.setSerialNumber(Integer.valueOf(seq));
            rspBO.setGrantUserCount((Integer)countMap.get(welfarePointGrantPO.getWelfarePointGrantId()));
            ActWelfarePointsGrantConstant.translateCode((WelfarePointGrantBO)rspBO, false);
            rows.add(rspBO);
            if (!StringUtils.isEmpty((Object)rspBO.getWelfarePointChargeCode())) {
                set.add(rspBO.getWelfarePointChargeCode());
            }
            ++seq;
        }
        if (!CollectionUtils.isEmpty(set) && !CollectionUtils.isEmpty(chargePOS = this.welfarePointsChargeMapper.selectBywelfarePointChargeCode(new ArrayList<String>(set)))) {
            Map<String, WelfarePointsChargePO> map = chargePOS.stream().collect(Collectors.toMap(WelfarePointsChargePO::getWelfarePointChargeCode, e -> e, (first, second) -> second));
            for (ActQueryWelfarePointGrantPageBO row : rows) {
                WelfarePointsChargePO ChargePO = map.get(row.getWelfarePointChargeCode());
                if (ChargePO == null) continue;
                row.setWelfarePointsChargeId(ChargePO.getWelfarePointsChargeId());
                if (Objects.nonNull(ChargePO.getExtField1()) && !StringUtils.isEmpty((Object)ChargePO.getExtField1())) {
                    row.setPayType(Integer.valueOf(ChargePO.getExtField1()));
                    row.setPayTypeStr("1".equals(ChargePO.getExtField1()) ? "\u9884\u5b58\u652f\u4ed8" : "\u8d26\u671f\u652f\u4ed8");
                }
                if (!Objects.nonNull(ChargePO.getTradeMode())) continue;
                row.setTradeMode(ChargePO.getTradeMode());
                row.setTradeModeStr(ActActiveConstant.tradeModeType.SELF.equals(ChargePO.getTradeMode()) ? "\u662f" : "\u5426");
            }
        }
        busiRspBO.setRows(rows);
        busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u798f\u70b9\u53d1\u653e\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    public ActQueryWelfarePointGrantPageAbilityRspBO selectWelfarePointGrant(ActQueryWelfarePointGrantPageAbilityReqBO reqBO) {
        ActQueryWelfarePointGrantPageAbilityRspBO rspBO = new ActQueryWelfarePointGrantPageAbilityRspBO();
        WelfarePointGrantPO welfarePointGrantPO = new WelfarePointGrantPO();
        welfarePointGrantPO.setWelfarePointGrantIds(reqBO.getExportWelfarePointGrantIdList());
        List<WelfarePointGrantPO> welfarePointGrantPOS = this.welfarePointGrantMapper.selectWelfarePointGrant(welfarePointGrantPO);
        if (!ObjectUtils.isEmpty(welfarePointGrantPOS)) {
            List actQueryWelfarePointGrantPageBOS = JSONObject.parseArray((String)JSON.toJSONString(welfarePointGrantPOS), ActQueryWelfarePointGrantPageBO.class);
            rspBO.setRows(actQueryWelfarePointGrantPageBOS);
        }
        log.info("^^^^^^^^^^^^^selectWelfarePointGrantselectWelfarePointGrant^^^^^^^^^^^^^^^^^{}", (Object)JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }

    private void setOperateInfo(WelfarePointGrantAuthReqBO reqBO, WelfarePointGrantPO grantPO) {
        grantPO.setOperateId(reqBO.getUserId());
        grantPO.setOperateCode(reqBO.getOccupation());
        grantPO.setOperateName(reqBO.getName());
        grantPO.setOperateTime(new Date());
    }

    private void getWelfarePointsChangeInfo(Long welfarePointGrantId, ActQueryWelfarePointGrantDetailInfoRspBO rspBO) {
        ArrayList<Byte> statusList = new ArrayList<Byte>();
        statusList.add(ActActiveConstant.GrantChangeStatus.WAIT_SUBMIT);
        statusList.add(ActActiveConstant.GrantChangeStatus.APPROVE_FAIL);
        statusList.add(ActActiveConstant.GrantChangeStatus.APPROVING);
        WelfarePointsChangePO queryWelfarePointsChangePO = new WelfarePointsChangePO();
        queryWelfarePointsChangePO.setWelfarePointGrantId(welfarePointGrantId);
        queryWelfarePointsChangePO.setStatusList(statusList);
        queryWelfarePointsChangePO.setIsInStatusFlag(1);
        WelfarePointsChangePO welfarePointsChangePO = this.welfarePointsChangeMapper.selectOneWelfarePointsChange(queryWelfarePointsChangePO);
        if (ObjectUtil.isNotEmpty((Object)welfarePointsChangePO)) {
            boolean isValidDateLong;
            boolean isValidDate;
            WelfarePointGrantDetailInfoBO changDetailInfoBO = new WelfarePointGrantDetailInfoBO();
            if (ObjectUtil.isNotEmpty((Object)welfarePointsChangePO.getExtField1())) {
                isValidDate = ActWelfarePointGrantBusiServiceImpl.isValidDateFormat(welfarePointsChangePO.getExtField1(), "yyyy-MM-dd");
                if (isValidDate) {
                    changDetailInfoBO.setEffectiveStart(DateUtils.strToDate((String)welfarePointsChangePO.getExtField1()));
                }
                if (isValidDateLong = ActWelfarePointGrantBusiServiceImpl.isValidDateFormat(welfarePointsChangePO.getExtField1(), "yyyy-MM-dd HH:mm:ss")) {
                    changDetailInfoBO.setEffectiveStart(DateUtils.strToDateLong((String)welfarePointsChangePO.getExtField1()));
                }
            }
            if (ObjectUtil.isNotEmpty((Object)welfarePointsChangePO.getExtField2())) {
                isValidDate = ActWelfarePointGrantBusiServiceImpl.isValidDateFormat(welfarePointsChangePO.getExtField2(), "yyyy-MM-dd");
                if (isValidDate) {
                    changDetailInfoBO.setEffectiveEnd(DateUtils.strToDate((String)welfarePointsChangePO.getExtField2()));
                }
                if (isValidDateLong = ActWelfarePointGrantBusiServiceImpl.isValidDateFormat(welfarePointsChangePO.getExtField2(), "yyyy-MM-dd HH:mm:ss")) {
                    changDetailInfoBO.setEffectiveEnd(DateUtils.strToDateLong((String)welfarePointsChangePO.getExtField2()));
                }
            }
            rspBO.setChangDetailInfoBO(changDetailInfoBO);
        }
    }

    private void getWelfarePointGrantRecordInfo(Long welfarePointGrantId, ActQueryWelfarePointGrantDetailInfoRspBO rspBO) {
        WelfarePointGrantPO queryWelfarePointGrantPO = new WelfarePointGrantPO();
        queryWelfarePointGrantPO.setWelfarePointGrantId(welfarePointGrantId);
        WelfarePointGrantPO welfarePointGrantPO = this.welfarePointGrantMapper.getRecordModelBy(queryWelfarePointGrantPO);
        if (ObjectUtil.isNotEmpty((Object)welfarePointGrantPO)) {
            WelfarePointGrantDetailInfoBO oldDetailInfoBO = new WelfarePointGrantDetailInfoBO();
            BeanUtils.copyProperties((Object)welfarePointGrantPO, (Object)oldDetailInfoBO);
            rspBO.setOldDetailInfoBO(oldDetailInfoBO);
        }
    }

    public static boolean isValidDateFormat(String inputDate, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setLenient(false);
            sdf.parse(inputDate);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

