/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.ability.bo.ActWelfarePointGrantReleaseReqBO;
import com.tydic.active.app.ability.bo.ActWelfarePointGrantReleaseRspBO;
import com.tydic.active.app.busi.ActWelfarePointGrantReleaseBusiService;
import com.tydic.active.app.constant.ActActiveConstant;
import com.tydic.active.app.dao.WelfarePointGrantMapper;
import com.tydic.active.app.dao.WelfarePointsChargeMapper;
import com.tydic.active.app.dao.po.WelfarePointGrantPO;
import com.tydic.active.app.dao.po.WelfarePointsChargePO;
import com.tydic.fsc.common.ability.api.FscAccountDealWelfareDeductAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountDealWelfareDeductAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountDealWelfareDeductAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActWelfarePointGrantReleaseBusiServiceImpl
implements ActWelfarePointGrantReleaseBusiService {
    @Autowired
    private WelfarePointGrantMapper welfarePointGrantMapper;
    @Autowired
    private FscAccountDealWelfareDeductAbilityService fscAccountDealWelfareDeductAbilityService;
    @Autowired
    private WelfarePointsChargeMapper welfarePointsChargeMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    public ActWelfarePointGrantReleaseRspBO dealRelease(ActWelfarePointGrantReleaseReqBO reqBO) {
        WelfarePointGrantPO grantPO = new WelfarePointGrantPO();
        grantPO.setWelfarePointGrantIds(reqBO.getWelfarePointGrantIds());
        List<WelfarePointGrantPO> grantPOS = this.welfarePointGrantMapper.getList(grantPO);
        if (CollectionUtils.isEmpty(grantPOS)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u798f\u70b9\u53d1\u653e\u8bb0\u5f55\u5931\u8d25!");
        }
        if (grantPOS.size() < reqBO.getWelfarePointGrantIds().size()) {
            throw new BusinessException("8888", "\u90e8\u5206welfarePointGrantId\u65e0\u6548!");
        }
        HashSet<String> chargeCodes = new HashSet<String>();
        for (WelfarePointGrantPO po : grantPOS) {
            if (!StringUtils.isNotBlank((String)po.getWelfarePointChargeCode())) continue;
            chargeCodes.add(po.getWelfarePointChargeCode());
        }
        List<Object> WelfarePointsChargePOs = new ArrayList();
        HashMap<String, WelfarePointsChargePO> chargeMap = new HashMap();
        if (!CollectionUtils.isEmpty(chargeCodes) && !CollectionUtils.isEmpty(WelfarePointsChargePOs = this.welfarePointsChargeMapper.selectBywelfarePointChargeCode(new ArrayList<String>(chargeCodes)))) {
            chargeMap = WelfarePointsChargePOs.stream().collect(Collectors.toMap(e -> e.getWelfarePointChargeCode(), e -> e, (k, v) -> k));
        }
        for (WelfarePointGrantPO po : grantPOS) {
            if (!ActActiveConstant.GrantStatus.INVALID.equals(po.getStatus())) {
                throw new BusinessException("8888", "\u975e\u5931\u6548\u72b6\u6001\u7684\u798f\u70b9\u8bb0\u5f55\u91ca\u653e\u65e0\u6548!");
            }
            po.setStatus(ActActiveConstant.GrantStatus.RELEASE);
            int row = this.welfarePointGrantMapper.updateByPrimaryKeySelective(po);
            if (row == 0) {
                throw new BusinessException("8888", "\u66f4\u65b0\u798f\u70b9\u53d1\u653e\u8bb0\u5f55\u72b6\u6001\u5931\u8d25!");
            }
            BigDecimal usedPoints = po.getUsedPoints() == null ? BigDecimal.ZERO : po.getUsedPoints();
            BigDecimal releaseAmout = po.getWelfarePoints().subtract(usedPoints);
            int effectRow = this.welfarePointsChargeMapper.updateReleaseAmount(releaseAmout, po.getWelfarePointChargeCode());
            if (row == 0) {
                throw new BusinessException("8888", "\u66f4\u65b0\u798f\u70b9\u91ca\u653e\u6570\u91cf\u5931\u8d25!");
            }
            this.backChargeAmount(po, chargeMap, reqBO, releaseAmout);
        }
        ActWelfarePointGrantReleaseRspBO rspBO = new ActWelfarePointGrantReleaseRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u91ca\u653e\u6210\u529f");
        return rspBO;
    }

    private Integer translate(String extField1) {
        if ("1".equals(extField1)) {
            return 3;
        }
        if ("2".equals(extField1)) {
            return 2;
        }
        return null;
    }

    void backChargeAmount(WelfarePointGrantPO po, Map<String, WelfarePointsChargePO> chargeMap, ActWelfarePointGrantReleaseReqBO reqBO, BigDecimal releaseAmout) {
        FscAccountDealWelfareDeductAbilityReqBO fscReqBO = new FscAccountDealWelfareDeductAbilityReqBO();
        fscReqBO.setSupId(this.operationOrgId);
        fscReqBO.setCreditOrgId(po.getOrgId());
        WelfarePointsChargePO welfarePointsChargePO = chargeMap.get(po.getWelfarePointChargeCode());
        if (welfarePointsChargePO == null) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u5931\u8d25!");
        }
        Integer payType2 = this.translate(welfarePointsChargePO.getExtField1());
        if (payType2 == null) {
            throw new BusinessException("8888", "\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f\u5f02\u5e38!");
        }
        fscReqBO.setPayType(payType2);
        fscReqBO.setOperationType(Integer.valueOf(1));
        fscReqBO.setOrderId(welfarePointsChargePO.getWelfarePointsChargeId());
        fscReqBO.setOrderNo(welfarePointsChargePO.getWelfarePointChargeCode());
        fscReqBO.setObjId(po.getWelfarePointGrantId());
        fscReqBO.setTotalAmount(releaseAmout.negate());
        fscReqBO.setBusiOrderType(Integer.valueOf(3));
        fscReqBO.setWelfareType(Integer.valueOf(welfarePointsChargePO.getWelfareType().byteValue()));
        fscReqBO.setWelfarePointCode(po.getWelfarePointCode());
        fscReqBO.setWelfarePointName(po.getWelfarePointName());
        fscReqBO.setUserId(reqBO.getUserId());
        fscReqBO.setUserName(reqBO.getUserName());
        fscReqBO.setName(reqBO.getName());
        fscReqBO.setOrgId(reqBO.getOrgId());
        FscAccountDealWelfareDeductAbilityRspBO fscRspBO = this.fscAccountDealWelfareDeductAbilityService.dealWelfareDeduct(fscReqBO);
        if (!"0000".equals(fscRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u798f\u70b9\u53d1\u653e\u7f16\u53f7:" + po.getWelfarePointCode() + ",\u8c03\u7528\u7ed3\u7b97\u63a5\u53e3\u9000\u6b3e\u5931\u8d25!,\u539f\u56e0:" + fscRspBO.getRespDesc());
        }
    }
}

