/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.active.app.ability.bo.WelfareActiveOperateStatusReqBO;
import com.tydic.active.app.ability.bo.WelfareActiveOperateStatusRspBO;
import com.tydic.active.app.busi.WelfareActiveOperateStatusBusiService;
import com.tydic.active.app.busi.WelfareActiveSkuSyncService;
import com.tydic.active.app.busi.bo.WelfareActiveSkuSyncReqBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.WelfareActiveMapper;
import com.tydic.active.app.dao.WelfareActiveSkuMapper;
import com.tydic.active.app.dao.po.WelfareActivePO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WelfareActiveOperateStatusBusiServiceImpl
implements WelfareActiveOperateStatusBusiService {
    @Autowired
    private WelfareActiveSkuSyncService welfareActiveSkuSyncService;
    @Autowired
    private WelfareActiveMapper welfareActiveMapper;
    @Autowired
    private WelfareActiveSkuMapper welfareActiveSkuMapper;

    public WelfareActiveOperateStatusRspBO operateActiveStatus(WelfareActiveOperateStatusReqBO reqBO) {
        WelfareActiveOperateStatusRspBO rspBO = new WelfareActiveOperateStatusRspBO();
        List activeIds = reqBO.getActiveIds();
        Byte operType2 = reqBO.getOperateType();
        ArrayList<Long> validActiveIds = new ArrayList<Long>();
        for (Long activeId : activeIds) {
            int isUpdate;
            WelfareActivePO actActivity = this.welfareActiveMapper.selectByPrimaryKey(activeId);
            if (null == actActivity) {
                throw new BusinessException("14003", "\u63a7\u5236\u6d3b\u52a8\u72b6\u6001API\uff0c\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01");
            }
            WelfareActivePO activity = new WelfareActivePO();
            activity.setActiveId(activeId);
            Byte activeStatus2 = actActivity.getActiveStatus();
            Byte auditStatus = actActivity.getAuditStatus();
            if (operType2.equals(ActCommConstant.OperateType.ENABLE)) {
                if (!activeStatus2.equals(ActCommConstant.WelfareActiveStatus.DISABLE)) {
                    throw new BusinessException("8888", "\u63a7\u5236\u6d3b\u52a8\u72b6\u6001API\uff0c\u72b6\u6001\u4e3a\u505c\u7528\u65f6\u624d\u80fd\u70b9\u51fb\u542f\u7528\uff01");
                }
                if (ActCommConstant.WelfareLongTermStatus.YES.equals(actActivity.getLongTerm())) {
                    activity.setActiveStatus(ActCommConstant.WelfareActiveStatus.VALID);
                } else if (actActivity.getStartTime().compareTo(new Date()) > 0) {
                    activity.setActiveStatus(ActCommConstant.WelfareActiveStatus.ENABLE);
                } else if (actActivity.getEndTime().compareTo(new Date()) > 0) {
                    activity.setActiveStatus(ActCommConstant.WelfareActiveStatus.VALID);
                } else {
                    activity.setActiveStatus(ActCommConstant.WelfareActiveStatus.INVALID);
                }
                validActiveIds.add(activeId);
            } else if (operType2.equals(ActCommConstant.OperateType.DISABLE)) {
                if (!activeStatus2.equals(ActCommConstant.WelfareActiveStatus.ENABLE)) {
                    throw new BusinessException("8888", "\u63a7\u5236\u6d3b\u52a8\u72b6\u6001API\uff0c\u72b6\u6001\u4e3a\u542f\u7528\u65f6\u624d\u80fd\u70b9\u51fb\u505c\u7528\uff01");
                }
                activity.setActiveStatus(ActCommConstant.WelfareActiveStatus.DISABLE);
            } else if (operType2.equals(ActCommConstant.OperateType.CLOSE)) {
                if (!activeStatus2.equals(ActCommConstant.WelfareActiveStatus.ENABLE)) {
                    throw new BusinessException("8888", "\u63a7\u5236\u6d3b\u52a8\u72b6\u6001API\uff0c\u53ea\u6709\u72b6\u6001\u4e3a\u542f\u7528\u65f6\u624d\u80fd\u70b9\u51fb\u5173\u95ed\uff01");
                }
                activity.setActiveStatus(ActCommConstant.WelfareActiveStatus.CLOSE);
            } else {
                if (operType2.equals(ActCommConstant.OperateType.DELETE)) {
                    if (!activeStatus2.equals(ActCommConstant.WelfareActiveStatus.DRAFT) && !ActCommConstant.WelfareActiveAuditStatus.REJECT.equals(auditStatus)) {
                        throw new BusinessException("8888", "\u63a7\u5236\u6d3b\u52a8\u72b6\u6001API\uff0c\u53ea\u6709\u4e3a\u8349\u7a3f\uff0c\u5ba1\u6279\u62d2\u7edd\u72b6\u6001\u4e0b\u624d\u80fd\u5220\u9664\uff01");
                    }
                    int delete = this.welfareActiveMapper.deleteByPrimaryKey(activeId);
                    if (delete != 0) continue;
                    throw new BusinessException("8888", "\u63a7\u5236\u6d3b\u52a8\u72b6\u6001API\uff0c\u5220\u9664\u5931\u8d25\uff01");
                }
                if (operType2.equals(ActCommConstant.OperateType.SAVE)) {
                    if (!activeStatus2.equals(ActCommConstant.WelfareActiveStatus.NOT_COMPLETE) && !activeStatus2.equals(ActCommConstant.WelfareActiveStatus.DRAFT)) {
                        throw new BusinessException("8888", "\u63a7\u5236\u6d3b\u52a8\u72b6\u6001API\uff0c\u53ea\u6709\u4e3a\u8349\u7a3f\u72b6\u6001\u7684\u624d\u80fd\u4fdd\u5b58\uff01");
                    }
                    activity.setActiveStatus(ActCommConstant.WelfareActiveStatus.DRAFT);
                }
            }
            if ((isUpdate = this.welfareActiveMapper.updateByPrimaryKeySelective(activity)) != 0) continue;
            throw new BusinessException("8888", "\u63a7\u5236\u6d3b\u52a8\u72b6\u6001API\uff0c\u4fee\u6539\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(validActiveIds)) {
            this.sync(validActiveIds, 1);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sync(List<Long> list, Integer dealType) {
        for (Long id : list) {
            WelfareActiveSkuSyncReqBO welfareActiveSkuSyncReqBO = new WelfareActiveSkuSyncReqBO();
            welfareActiveSkuSyncReqBO.setActiveId(id);
            List<Long> skuIdList = this.welfareActiveSkuMapper.selectSkuIdByActiveId(id);
            if (CollectionUtils.isEmpty(skuIdList)) continue;
            welfareActiveSkuSyncReqBO.setSkuIds(skuIdList);
            welfareActiveSkuSyncReqBO.setDealType(dealType);
            this.welfareActiveSkuSyncService.syncUcc(welfareActiveSkuSyncReqBO);
        }
    }
}

