/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.active.app.ability.bo.WelfareActiveSkuAddReqBO;
import com.tydic.active.app.ability.bo.WelfareActiveSkuAddRspBO;
import com.tydic.active.app.busi.WelfareActiveSkuAddBusiService;
import com.tydic.active.app.busi.WelfareActiveSkuSyncService;
import com.tydic.active.app.busi.bo.WelfareActiveSkuSyncReqBO;
import com.tydic.active.app.dao.WelfareActiveMapper;
import com.tydic.active.app.dao.WelfareActiveSkuMapper;
import com.tydic.active.app.dao.WelfareMaterialCatalogMapper;
import com.tydic.active.app.dao.po.WelfareActivePO;
import com.tydic.active.app.dao.po.WelfareActiveSkuPO;
import com.tydic.active.app.dao.po.WelfareMaterialCatalogPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WelfareActiveSkuAddBusiServiceImpl
implements WelfareActiveSkuAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(WelfareActiveSkuAddBusiServiceImpl.class);
    @Autowired
    private WelfareActiveSkuMapper welfareActiveSkuMapper;
    @Autowired
    private WelfareActiveMapper welfareActiveMapper;
    @Autowired
    private WelfareActiveSkuSyncService welfareActiveSkuSyncService;
    @Autowired
    private WelfareMaterialCatalogMapper welfareMaterialCatalogMapper;

    public WelfareActiveSkuAddRspBO addActiveSku(WelfareActiveSkuAddReqBO reqBO) {
        WelfareActiveSkuAddRspBO rspBO = new WelfareActiveSkuAddRspBO();
        WelfareActivePO welfareActivePO = this.welfareActiveMapper.selectByPrimaryKey(reqBO.getActiveId());
        if (welfareActivePO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01");
            return rspBO;
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getWelfareActiveSkuList())) {
            int j;
            int n = j = reqBO.getWelfareActiveSkuList().size() >= 1000 ? 1000 : reqBO.getWelfareActiveSkuList().size();
            for (int i = 0; i < reqBO.getWelfareActiveSkuList().size(); i += 1000) {
                List subList = reqBO.getWelfareActiveSkuList().subList(i, j);
                ArrayList<Long> skuIdList = new ArrayList<Long>();
                List welfareActiveSkuPOList = JSON.parseArray((String)JSON.toJSONString(subList), WelfareActiveSkuPO.class);
                for (WelfareActiveSkuPO welfareActiveSkuPO : welfareActiveSkuPOList) {
                    welfareActiveSkuPO.setId(Sequence.getInstance().nextId());
                    welfareActiveSkuPO.setActiveId(reqBO.getActiveId());
                    welfareActiveSkuPO.setWelfarePoint(welfareActiveSkuPO.getWelfarePoint() == null ? null : welfareActiveSkuPO.getWelfarePoint());
                    welfareActiveSkuPO.setOperateTime(new Date());
                    skuIdList.add(welfareActiveSkuPO.getSkuId());
                }
                this.welfareActiveSkuMapper.deleteBatchByActiveId(reqBO.getActiveId(), null, skuIdList, null);
                int result = this.welfareActiveSkuMapper.insertBatch(welfareActiveSkuPOList);
                if (result != welfareActiveSkuPOList.size()) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u6dfb\u52a0\u6d3b\u52a8\u5546\u54c1\u5931\u8d25\uff01");
                    return rspBO;
                }
                if (!CollectionUtils.isEmpty(skuIdList) && welfareActivePO.getActiveStatus() == 4) {
                    WelfareActiveSkuSyncReqBO welfareActiveSkuSyncReqBO = new WelfareActiveSkuSyncReqBO();
                    welfareActiveSkuSyncReqBO.setActiveId(reqBO.getActiveId());
                    welfareActiveSkuSyncReqBO.setSkuIds(skuIdList);
                    welfareActiveSkuSyncReqBO.setDealType(Integer.valueOf(1));
                    this.welfareActiveSkuSyncService.syncUcc(welfareActiveSkuSyncReqBO);
                }
                j = j + 1000 > reqBO.getWelfareActiveSkuList().size() ? reqBO.getWelfareActiveSkuList().size() : j + 1000;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getWelfareCatalogList())) {
            List<WelfareMaterialCatalogPO> catalogPOS = reqBO.getWelfareCatalogList().stream().map(obj -> {
                WelfareMaterialCatalogPO po = new WelfareMaterialCatalogPO();
                BeanUtils.copyProperties((Object)obj, (Object)po);
                po.setActiveId(reqBO.getActiveId());
                po.setId(Sequence.getInstance().nextId());
                return po;
            }).collect(Collectors.toList());
            this.welfareMaterialCatalogMapper.insertBatch(catalogPOS);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

