/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.task.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.active.app.atom.ActiveDealWaitParamsAtomService;
import com.tydic.active.app.atom.bo.TodoAddWaitDoneAbilityAtomRspBO;
import com.tydic.active.app.busi.ContractWaitDoneLogBusiService;
import com.tydic.active.app.busi.bo.ContractWaitDoneLogReqBO;
import com.tydic.active.app.dao.UocApprovalLogMapper;
import com.tydic.active.app.dao.WelfareActiveMapper;
import com.tydic.active.app.dao.WelfarePointGrantMapper;
import com.tydic.active.app.dao.WelfarePointsChangeMapper;
import com.tydic.active.app.dao.WelfarePointsChargeMapper;
import com.tydic.active.app.dao.po.UocApprovalLogPO;
import com.tydic.active.app.dao.po.WelfareActivePO;
import com.tydic.active.app.dao.po.WelfarePointGrantPO;
import com.tydic.active.app.dao.po.WelfarePointsChangePO;
import com.tydic.active.app.dao.po.WelfarePointsChargePO;
import com.tydic.active.app.task.TaskTodoWaitService;
import com.tydic.active.app.task.bo.TodoActiveWaitAbilityReqBO;
import com.tydic.active.app.task.bo.TodoAddAlreadyDoneAbilityReqBO;
import com.tydic.active.app.task.bo.TodoAddWaitDoneAbilityReqBO;
import com.tydic.active.app.task.bo.TodoCancelWaitDoneAbilityReqBO;
import com.tydic.active.app.task.bo.TodoWaitAbilityAssembleReqBO;
import com.tydic.active.app.task.bo.TodoWaitAbilityReqBO;
import com.tydic.active.app.task.util.DycActiveTodoWaitDoneProvider;
import com.tydic.active.app.task.util.TaskWaitDoneEnum;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.todo.ability.api.TodoWaitDoneWriteAbilityService;
import com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityParamBO;
import com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityRspBO;
import com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityParamBO;
import com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityRspBO;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityParamBO;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityRspBO;
import com.tydic.umc.daiban.UmcAddTaskAbilityService;
import com.tydic.umc.daiban.bo.UmcTaskReqBO;
import com.tydic.umc.daiban.bo.UmcTaskRspBO;
import com.tydic.umc.general.ability.bo.MemberAbilityBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TaskTodoWaitServiceImpl
implements TaskTodoWaitService {
    private static final Logger log = LoggerFactory.getLogger(TaskTodoWaitServiceImpl.class);
    @Autowired
    private UocApprovalLogMapper uocApprovalLogMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private UmcAddTaskAbilityService umcAddTaskAbilityService;
    @Autowired
    private ActiveDealWaitParamsAtomService activeDealWaitParamsAtomService;
    @Autowired
    private DycActiveTodoWaitDoneProvider dycActiveTodoWaitDoneProviderService;
    @Autowired
    private WelfarePointsChargeMapper welfarePointsChargeMapper;
    @Autowired
    private WelfarePointsChangeMapper welfarePointsChangeMapper;
    @Autowired
    private WelfareActiveMapper welfareActiveMapper;
    @Autowired
    private WelfarePointGrantMapper welfarePointGrantMapper;
    @Autowired
    private ContractWaitDoneLogBusiService contractWaitDoneLogBusiService;
    @Autowired
    private TodoWaitDoneWriteAbilityService todoWaitDoneWriteAbilityService;
    @Value(value="${dyc.active.add.todo.wait.done.topic:TODO_ADD_WAIT_DONE_TOPIC}")
    private String addWaitTodoTopic;
    @Value(value="${dyc.active.cancel.todo.wait.done.topic:TODO_CANCEL_WAIT_DONE_TOPIC}")
    private String cancelWaitTodoTopic;
    @Value(value="${dyc.active.done.todo.wait.done.topic:TODO_ADD_ALREADY_DONE_TOPIC}")
    private String DoneWaitTodoTopic;

    @Override
    public void handler(TodoActiveWaitAbilityReqBO todoActiveWaitAbilityReqBO) {
        log.info("TaskTodoWaitService todoActiveWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoActiveWaitAbilityReqBO));
        this.assertParam(todoActiveWaitAbilityReqBO);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        try {
            UocApprovalLogPO uocApprovalLogPO = this.listApproval(todoActiveWaitAbilityReqBO.getObjId());
            log.info("TaskTodoWaitService uocApprovalLogPO:{}", (Object)JSON.toJSONString((Object)uocApprovalLogPO));
            this.getExt2(todoActiveWaitAbilityReqBO);
            String ext2 = todoActiveWaitAbilityReqBO.getExt2();
            switch (todoActiveWaitAbilityReqBO.getOperatorType()) {
                case "0": {
                    TodoWaitAbilityReqBO todoSubmitWaitAbilityReqBO = this.operatorSubmit(uocApprovalLogPO, todoActiveWaitAbilityReqBO);
                    if (Objects.nonNull(todoSubmitWaitAbilityReqBO)) {
                        todoSubmitWaitAbilityReqBO.setExt2(ext2);
                        this.addTodoWait(todoSubmitWaitAbilityReqBO, true);
                    }
                    break;
                }
                case "1": {
                    TodoWaitAbilityReqBO todoAddPassWaitAbilityReqBO;
                    TodoWaitAbilityReqBO todoCancelPassWaitAbilityReqBO;
                    TodoWaitAbilityReqBO todoDonePassWaitAbilityReqBO = this.operatorDoneApproval(uocApprovalLogPO, todoActiveWaitAbilityReqBO);
                    Boolean flag = false;
                    if (Objects.nonNull(todoDonePassWaitAbilityReqBO)) {
                        todoDonePassWaitAbilityReqBO.setExt2(ext2);
                        flag = this.doneTodoWait(todoDonePassWaitAbilityReqBO, true);
                    }
                    if (Objects.nonNull(todoCancelPassWaitAbilityReqBO = this.operatorCancelApproval(uocApprovalLogPO, todoActiveWaitAbilityReqBO))) {
                        flag = this.cancelTodoWait(todoCancelPassWaitAbilityReqBO, flag);
                    }
                    if (uocApprovalLogPO.getFinish() == 0 && Objects.nonNull(todoAddPassWaitAbilityReqBO = this.operatorAddApproval(uocApprovalLogPO, todoActiveWaitAbilityReqBO))) {
                        todoAddPassWaitAbilityReqBO.setExt2(ext2);
                        todoAddPassWaitAbilityReqBO.setIsFirstAddWait("0");
                        this.addTodoWait(todoAddPassWaitAbilityReqBO, flag);
                    }
                    break;
                }
                case "2": {
                    TodoWaitAbilityReqBO todoReturnWaitAbilityReqBO = this.operatorReturn(uocApprovalLogPO, todoActiveWaitAbilityReqBO);
                    if (Objects.nonNull(todoReturnWaitAbilityReqBO)) {
                        this.cancelTodoWait(todoReturnWaitAbilityReqBO, true);
                    }
                    break;
                }
                default: {
                    log.error("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                    throw new RuntimeException("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                }
            }
        }
        catch (Exception e) {
            log.error("TaskTodoWaitService handler error:{}", (Throwable)e);
        }
    }

    private void getExt2(TodoActiveWaitAbilityReqBO todoActiveWaitAbilityReqBO) {
        String ext2 = null;
        switch (todoActiveWaitAbilityReqBO.getBusiCode()) {
            case "1002": 
            case "1004": {
                WelfarePointsChangePO record1 = new WelfarePointsChangePO();
                record1.setChangeId(todoActiveWaitAbilityReqBO.getObjId());
                WelfarePointsChangePO welfarePointsChangePO1 = this.welfarePointsChangeMapper.selectOneWelfarePointsChange(record1);
                if (!Objects.nonNull(welfarePointsChangePO1) || !Objects.nonNull(welfarePointsChangePO1.getChangeId())) break;
                Long changeId = welfarePointsChangePO1.getChangeId();
                Long welfarePointsChargeId = welfarePointsChangePO1.getWelfarePointsChargeId();
                todoActiveWaitAbilityReqBO.setObjId(welfarePointsChargeId);
                if (welfarePointsChargeId == null) {
                    todoActiveWaitAbilityReqBO.setObjId(welfarePointsChangePO1.getWelfarePointGrantId());
                }
                ext2 = changeId.toString();
                todoActiveWaitAbilityReqBO.setExt2(ext2);
                break;
            }
            case "1006": {
                WelfarePointsChangePO record = new WelfarePointsChangePO();
                record.setWelfarePointsChargeId(todoActiveWaitAbilityReqBO.getObjId());
                WelfarePointsChangePO welfarePointsChangePO = this.welfarePointsChangeMapper.selectOneWelfarePointsChange(record);
                if (!Objects.nonNull(welfarePointsChangePO) || !Objects.nonNull(welfarePointsChangePO.getChangeId())) break;
                Long changeId = welfarePointsChangePO.getChangeId();
                ext2 = changeId.toString();
                todoActiveWaitAbilityReqBO.setExt2(ext2);
            }
        }
    }

    private TodoWaitAbilityReqBO operatorReturn(UocApprovalLogPO uocApprovalLogPO, TodoActiveWaitAbilityReqBO todoActiveWaitAbilityReqBO) {
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoActiveWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoActiveWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoActiveWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        todoPassWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
        WelfarePointsChargePO welfarePointsChargePO = this.welfarePointsChargeMapper.selectByPrimaryKey(todoActiveWaitAbilityReqBO.getObjId());
        if (Objects.nonNull(welfarePointsChargePO)) {
            todoPassWaitAbilityReqBO.setCreateId(welfarePointsChargePO.getOperateCode());
            todoPassWaitAbilityReqBO.setCreateName(welfarePointsChargePO.getOperateName());
        }
        String nextStationId = todoActiveWaitAbilityReqBO.getStationId();
        Long objId = todoActiveWaitAbilityReqBO.getObjId();
        Assert.notNull((Object)nextStationId, (String)"\u5c97\u4f4did\u4e3a\u7a7a");
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO1 = this.listUser(nextStationId);
        if (dycStationOrgSelectUserNameRspBO1 != null && dycStationOrgSelectUserNameRspBO1.getUserList() != null && dycStationOrgSelectUserNameRspBO1.getUserList().size() > 0) {
            List userList = dycStationOrgSelectUserNameRspBO1.getUserList();
            log.info("operatorReturn return userCode:{},objId:{}", (Object)JSON.toJSONString((Object)userList), (Object)objId);
            todoPassWaitAbilityReqBO.setCancelList(userList.stream().map(user -> {
                TodoCancelWaitDoneAbilityReqBO todoCancelWaitDoneAbilityReqBO = new TodoCancelWaitDoneAbilityReqBO();
                todoCancelWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                todoCancelWaitDoneAbilityReqBO.setObjId(objId.toString());
                return todoCancelWaitDoneAbilityReqBO;
            }).collect(Collectors.toList()));
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorAddApproval(UocApprovalLogPO uocApprovalLogPO, TodoActiveWaitAbilityReqBO todoActiveWaitAbilityReqBO) {
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO1;
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoActiveWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoActiveWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoActiveWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorAddApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoActiveWaitAbilityReqBO.getObjId());
        if (!CollectionUtils.isEmpty(userCode)) {
            String regAccount = userCode.get(0).getRegAccount();
            todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
            todoPassWaitAbilityReqBO.setOperatorId(regAccount);
        }
        todoPassWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
        String nextStationId = uocApprovalLogPO.getNextStationId();
        Long objId = todoActiveWaitAbilityReqBO.getObjId();
        String objNo = null;
        String createCode = null;
        String createName = null;
        if (Objects.nonNull(nextStationId)) {
            switch (todoActiveWaitAbilityReqBO.getBusiCode()) {
                case "1005": {
                    WelfareActivePO welfareActivePO = this.welfareActiveMapper.selectByPrimaryKey(objId);
                    if (!Objects.nonNull(welfareActivePO)) break;
                    objNo = welfareActivePO.getActiveCode();
                    createCode = welfareActivePO.getCreateCode();
                    createName = welfareActivePO.getCreateName();
                    break;
                }
                case "1001": 
                case "1002": {
                    WelfarePointsChargePO welfarePointsChargePO = this.welfarePointsChargeMapper.selectByPrimaryKey(objId);
                    if (Objects.nonNull(welfarePointsChargePO)) {
                        objNo = welfarePointsChargePO.getWelfarePointChargeCode();
                        createCode = welfarePointsChargePO.getOperateCode();
                        createName = welfarePointsChargePO.getOperateName();
                    }
                    if (!todoActiveWaitAbilityReqBO.getBusiCode().equals("1002") || StringUtils.isEmpty((Object)todoActiveWaitAbilityReqBO.getExt2())) break;
                    WelfarePointsChangePO welfarePointsChangePO = new WelfarePointsChangePO();
                    welfarePointsChangePO.setChangeId(Long.parseLong(todoActiveWaitAbilityReqBO.getExt2()));
                    WelfarePointsChangePO changePO = this.welfarePointsChangeMapper.selectOneWelfarePointsChange(welfarePointsChangePO);
                    if (StringUtils.isEmpty((Object)changePO.getChangeCode())) break;
                    objNo = changePO.getChangeCode();
                    break;
                }
                case "1004": 
                case "1003": {
                    WelfarePointGrantPO welfarePointGrantPO = new WelfarePointGrantPO();
                    welfarePointGrantPO.setWelfarePointGrantId(objId);
                    WelfarePointGrantPO modelBy = this.welfarePointGrantMapper.getModelBy(welfarePointGrantPO);
                    if (Objects.nonNull(modelBy)) {
                        objNo = modelBy.getWelfarePointCode();
                        createCode = modelBy.getOperateCode();
                        createName = modelBy.getOperateName();
                    }
                    if (!todoActiveWaitAbilityReqBO.getBusiCode().equals("1004") || StringUtils.isEmpty((Object)todoActiveWaitAbilityReqBO.getExt2())) break;
                    WelfarePointsChangePO welfarePointsChangePO = new WelfarePointsChangePO();
                    welfarePointsChangePO.setChangeId(Long.parseLong(todoActiveWaitAbilityReqBO.getExt2()));
                    WelfarePointsChangePO changePO = this.welfarePointsChangeMapper.selectOneWelfarePointsChange(welfarePointsChangePO);
                    if (StringUtils.isEmpty((Object)changePO.getChangeCode())) break;
                    objNo = changePO.getChangeCode();
                }
            }
        }
        if (Objects.nonNull(nextStationId) && (dycStationOrgSelectUserNameRspBO1 = this.listUser(nextStationId.toString())) != null && dycStationOrgSelectUserNameRspBO1.getUserList() != null && dycStationOrgSelectUserNameRspBO1.getUserList().size() > 0) {
            List userList = dycStationOrgSelectUserNameRspBO1.getUserList();
            log.info("operatorAddApproval add userCode:{},objId:{}", (Object)JSON.toJSONString((Object)userList), (Object)objId);
            if (!CollectionUtils.isEmpty((Collection)userList)) {
                todoPassWaitAbilityReqBO.setExt1(objNo);
                String finalObjNo = objNo;
                todoPassWaitAbilityReqBO.setCreateId(createCode);
                todoPassWaitAbilityReqBO.setCreateName(createName);
                todoPassWaitAbilityReqBO.setExt7(uocApprovalLogPO.getAuditOrderId() + "");
                todoPassWaitAbilityReqBO.setExt8(uocApprovalLogPO.getId() + "");
                todoPassWaitAbilityReqBO.setRemark(uocApprovalLogPO.getNextStepName());
                todoPassWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                    TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                    todoAddWaitDoneAbilityReqBO.setObjId(objId.toString());
                    todoAddWaitDoneAbilityReqBO.setObjNo(finalObjNo);
                    todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                    todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                    todoAddWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getNextStepId());
                    return todoAddWaitDoneAbilityReqBO;
                }).collect(Collectors.toList()));
            }
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorCancelApproval(UocApprovalLogPO uocApprovalLogPO, TodoActiveWaitAbilityReqBO todoActiveWaitAbilityReqBO) {
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoActiveWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoActiveWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoActiveWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        todoPassWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
        WelfarePointsChargePO welfarePointsChargePO = this.welfarePointsChargeMapper.selectByPrimaryKey(todoActiveWaitAbilityReqBO.getObjId());
        if (Objects.nonNull(welfarePointsChargePO)) {
            todoPassWaitAbilityReqBO.setCreateId(welfarePointsChargePO.getOperateCode());
            todoPassWaitAbilityReqBO.setCreateName(welfarePointsChargePO.getOperateName());
        }
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        Long objId = todoActiveWaitAbilityReqBO.getObjId();
        log.info("operatorCancelApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)objId);
        if (!CollectionUtils.isEmpty(userCode)) {
            String regAccount = userCode.get(0).getRegAccount();
            todoPassWaitAbilityReqBO.setOperatorId(regAccount);
            String stationId = todoActiveWaitAbilityReqBO.getStationId();
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.listUser(stationId);
            if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
                List userList = dycStationOrgSelectUserNameRspBO.getUserList();
                List collect = userList.stream().filter($ -> !$.getLoginName().equals(regAccount)).collect(Collectors.toList());
                log.info("operatorCancelApproval cancel userCode:{},ObjId:{}", (Object)JSON.toJSONString(collect), (Object)objId);
                todoPassWaitAbilityReqBO.setCancelList(collect.stream().map(user -> {
                    TodoCancelWaitDoneAbilityReqBO todoCancelWaitDoneAbilityReqBO = new TodoCancelWaitDoneAbilityReqBO();
                    todoCancelWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                    todoCancelWaitDoneAbilityReqBO.setObjId(objId.toString());
                    todoCancelWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getStepId());
                    return todoCancelWaitDoneAbilityReqBO;
                }).collect(Collectors.toList()));
            }
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorDoneApproval(UocApprovalLogPO uocApprovalLogPO, TodoActiveWaitAbilityReqBO todoActiveWaitAbilityReqBO) {
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorDoneApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoActiveWaitAbilityReqBO.getObjId());
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        if (!CollectionUtils.isEmpty(userCode)) {
            String regAccount = userCode.get(0).getRegAccount();
            todoPassWaitAbilityReqBO.setCenterCode(todoActiveWaitAbilityReqBO.getCenterCode());
            todoPassWaitAbilityReqBO.setBusiCode(todoActiveWaitAbilityReqBO.getBusiCode());
            todoPassWaitAbilityReqBO.setBusiName(todoActiveWaitAbilityReqBO.getBusiName());
            todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
            todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
            todoPassWaitAbilityReqBO.setOperatorId(regAccount);
            todoPassWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
            String createCode = null;
            String createName = null;
            switch (todoActiveWaitAbilityReqBO.getBusiCode()) {
                case "1005": {
                    WelfareActivePO welfareActivePO = this.welfareActiveMapper.selectByPrimaryKey(todoActiveWaitAbilityReqBO.getObjId());
                    if (!Objects.nonNull(welfareActivePO)) break;
                    createCode = welfareActivePO.getCreateCode();
                    createName = welfareActivePO.getCreateName();
                    break;
                }
                case "1001": 
                case "1002": {
                    WelfarePointsChargePO welfarePointsChargePO = this.welfarePointsChargeMapper.selectByPrimaryKey(todoActiveWaitAbilityReqBO.getObjId());
                    if (!Objects.nonNull(welfarePointsChargePO)) break;
                    createCode = welfarePointsChargePO.getOperateCode();
                    createName = welfarePointsChargePO.getOperateName();
                    break;
                }
                case "1004": 
                case "1003": {
                    WelfarePointGrantPO welfarePointGrantPO = new WelfarePointGrantPO();
                    welfarePointGrantPO.setWelfarePointGrantId(todoActiveWaitAbilityReqBO.getObjId());
                    WelfarePointGrantPO modelBy = this.welfarePointGrantMapper.getModelBy(welfarePointGrantPO);
                    if (!Objects.nonNull(modelBy)) break;
                    createCode = modelBy.getOperateCode();
                    createName = modelBy.getOperateName();
                }
            }
            todoPassWaitAbilityReqBO.setCreateId(createCode);
            todoPassWaitAbilityReqBO.setCreateName(createName);
            TodoAddAlreadyDoneAbilityReqBO todoAddAlreadyDoneAbilityReqBO = new TodoAddAlreadyDoneAbilityReqBO();
            todoAddAlreadyDoneAbilityReqBO.setObjId(todoActiveWaitAbilityReqBO.getObjId().toString());
            todoAddAlreadyDoneAbilityReqBO.setAuditStatus(uocApprovalLogPO.getAuditResult() == 0 ? Boolean.TRUE : Boolean.FALSE);
            todoAddAlreadyDoneAbilityReqBO.setFinishYn(uocApprovalLogPO.getFinish() == 0 ? Boolean.FALSE : Boolean.TRUE);
            todoAddAlreadyDoneAbilityReqBO.setStepId(uocApprovalLogPO.getStepId());
            if (todoAddAlreadyDoneAbilityReqBO.getFinishYn().booleanValue()) {
                todoAddAlreadyDoneAbilityReqBO.setFinishTime(new Date());
            }
            todoAddAlreadyDoneAbilityReqBO.setAuditTime(new Date());
            todoPassWaitAbilityReqBO.setDoneList(Collections.singletonList(todoAddAlreadyDoneAbilityReqBO));
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorSubmit(UocApprovalLogPO uocApprovalLogPO, TodoActiveWaitAbilityReqBO todoActiveWaitAbilityReqBO) {
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO;
        if (Objects.isNull(uocApprovalLogPO)) {
            log.info("uocApprovalLogPO is null objId:{}", (Object)todoActiveWaitAbilityReqBO.getObjId());
            return null;
        }
        String nextStationId = uocApprovalLogPO.getNextStationId();
        Long objId = todoActiveWaitAbilityReqBO.getObjId();
        String busiCode = todoActiveWaitAbilityReqBO.getBusiCode();
        String createCode = null;
        String createName = null;
        TodoWaitAbilityReqBO todoWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        String objNo = null;
        if (Objects.nonNull(nextStationId)) {
            switch (busiCode) {
                case "1005": {
                    WelfareActivePO welfareActivePO = this.welfareActiveMapper.selectByPrimaryKey(objId);
                    if (!Objects.nonNull(welfareActivePO)) break;
                    objNo = welfareActivePO.getActiveCode();
                    createCode = welfareActivePO.getCreateCode();
                    createName = welfareActivePO.getCreateName();
                    break;
                }
                case "1001": 
                case "1002": {
                    WelfarePointsChargePO welfarePointsChargePO = this.welfarePointsChargeMapper.selectByPrimaryKey(objId);
                    if (Objects.nonNull(welfarePointsChargePO)) {
                        objNo = welfarePointsChargePO.getWelfarePointChargeCode();
                        createCode = welfarePointsChargePO.getOperateCode();
                        createName = welfarePointsChargePO.getOperateName();
                    }
                    if (!busiCode.equals("1002") || StringUtils.isEmpty((Object)todoActiveWaitAbilityReqBO.getExt2())) break;
                    WelfarePointsChangePO welfarePointsChangePO = new WelfarePointsChangePO();
                    welfarePointsChangePO.setChangeId(Long.parseLong(todoActiveWaitAbilityReqBO.getExt2()));
                    WelfarePointsChangePO changePO = this.welfarePointsChangeMapper.selectOneWelfarePointsChange(welfarePointsChangePO);
                    if (StringUtils.isEmpty((Object)changePO.getChangeCode())) break;
                    objNo = changePO.getChangeCode();
                    break;
                }
                case "1004": 
                case "1003": {
                    WelfarePointGrantPO welfarePointGrantPO = new WelfarePointGrantPO();
                    welfarePointGrantPO.setWelfarePointGrantId(objId);
                    WelfarePointGrantPO modelBy = this.welfarePointGrantMapper.getModelBy(welfarePointGrantPO);
                    if (Objects.nonNull(modelBy)) {
                        objNo = modelBy.getWelfarePointCode();
                        createCode = modelBy.getOperateCode();
                        createName = modelBy.getOperateName();
                    }
                    if (!busiCode.equals("1004") || StringUtils.isEmpty((Object)todoActiveWaitAbilityReqBO.getExt2())) break;
                    WelfarePointsChangePO welfarePointsChangePO = new WelfarePointsChangePO();
                    welfarePointsChangePO.setChangeId(Long.parseLong(todoActiveWaitAbilityReqBO.getExt2()));
                    WelfarePointsChangePO changePO = this.welfarePointsChangeMapper.selectOneWelfarePointsChange(welfarePointsChangePO);
                    if (StringUtils.isEmpty((Object)changePO.getChangeCode())) break;
                    objNo = changePO.getChangeCode();
                }
            }
        }
        if (Objects.nonNull(nextStationId) && (dycStationOrgSelectUserNameRspBO = this.listUser(nextStationId.toString())) != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
            List userList = dycStationOrgSelectUserNameRspBO.getUserList();
            log.info("dycStationOrgSelectUserNameRspBO userList:{}", (Object)JSON.toJSONString((Object)userList));
            todoWaitAbilityReqBO.setBusiCode(todoActiveWaitAbilityReqBO.getBusiCode());
            todoWaitAbilityReqBO.setBusiName(todoActiveWaitAbilityReqBO.getBusiName());
            todoWaitAbilityReqBO.setCenterCode(todoActiveWaitAbilityReqBO.getCenterCode());
            todoWaitAbilityReqBO.setExt1(objNo);
            todoWaitAbilityReqBO.setCreateId(createCode);
            todoWaitAbilityReqBO.setCreateName(createName);
            todoWaitAbilityReqBO.setExt7(uocApprovalLogPO.getAuditOrderId() + "");
            todoWaitAbilityReqBO.setExt8(uocApprovalLogPO.getId() + "");
            todoWaitAbilityReqBO.setRemark(uocApprovalLogPO.getNextStepName());
            if (Objects.nonNull(uocApprovalLogPO.getOperid())) {
                List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
                List<MemberAbilityBO> userCode = this.getUserCode(strings);
                if (!CollectionUtils.isEmpty(userCode)) {
                    todoWaitAbilityReqBO.setOperatorId(userCode.get(0).getRegAccount());
                }
                todoWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
            }
            todoWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
            String finalObjNo = objNo;
            todoWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                todoAddWaitDoneAbilityReqBO.setObjId(objId.toString());
                todoAddWaitDoneAbilityReqBO.setObjNo(finalObjNo);
                todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                todoAddWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getNextStepId());
                return todoAddWaitDoneAbilityReqBO;
            }).collect(Collectors.toList()));
        }
        return todoWaitAbilityReqBO;
    }

    public boolean addTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO, boolean addWaitDoneFlag) {
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getWaitDoneList())) {
            log.info("\u6d6e\u70b9\u5ba1\u6279\u5f85\u529e1230-------->todoWaitAbilityReqBO\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
            TodoWaitAbilityAssembleReqBO todoWaitAbilityAssembleReqBO = new TodoWaitAbilityAssembleReqBO();
            BeanUtils.copyProperties((Object)todoWaitAbilityReqBO, (Object)todoWaitAbilityAssembleReqBO);
            TodoAddWaitDoneAbilityAtomRspBO todoWaitAbilityAtomRspBO = this.activeDealWaitParamsAtomService.contractDealTodoAddWaitParams(todoWaitAbilityReqBO);
            log.error("\u5f53\u524d\u8fd4\u56de\u5f97todoWaitAbilityAtomRspBO\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)((Object)todoWaitAbilityAtomRspBO)));
            if (todoWaitAbilityAtomRspBO.getRespCode().equals("0000") && todoWaitAbilityAtomRspBO.getTodoAddWaitDoneAbilityReqBO() != null) {
                TodoWaitAbilityReqBO abilityReqBO = new TodoWaitAbilityReqBO();
                BeanUtils.copyProperties((Object)todoWaitAbilityAtomRspBO.getTodoAddWaitDoneAbilityReqBO(), (Object)abilityReqBO);
                todoWaitAbilityReqBO = abilityReqBO;
            }
            log.info("addTodoWait todoWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
            com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = (com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoWaitAbilityReqBO), com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityReqBO.class);
            if (addWaitDoneFlag) {
                try {
                    TodoAddWaitDoneAbilityRspBO doneAbilityRspBO = this.todoWaitDoneWriteAbilityService.addWaitDone(todoAddWaitDoneAbilityReqBO);
                    if ("0000".equals(doneAbilityRspBO.getRespCode())) {
                        this.addWaitDoneLog(todoAddWaitDoneAbilityReqBO, 1, 1, null);
                        return true;
                    }
                    this.addWaitDoneLog(todoAddWaitDoneAbilityReqBO, 2, 1, doneAbilityRspBO.getRespDesc());
                }
                catch (Exception e) {
                    log.error("\u65b0\u589e\u5f85\u529e\u63a8\u9001\u9519\u8bef\uff1a{}", (Object)JSON.toJSONString((Object)e));
                    String message = e.getMessage();
                    if (message != null && message.length() > 200) {
                        message = message.substring(0, 200);
                    }
                    this.addWaitDoneLog(todoAddWaitDoneAbilityReqBO, 2, 1, JSON.toJSONString((Object)message));
                }
            } else {
                this.addWaitDoneLog(todoAddWaitDoneAbilityReqBO, 2, 1, "\u524d\u7f6e\u63a8\u9001\u6d41\u7a0b\u5931\u8d25\uff0c\u672c\u6b21\u4e0d\u63a8\u9001\u3002");
            }
        }
        return false;
    }

    private void addWaitDoneLog(com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO, Integer waitDoneStatus, Integer waitDoneType, String exceptionMsg) {
        TodoAddWaitDoneAbilityParamBO paramBO = (TodoAddWaitDoneAbilityParamBO)todoAddWaitDoneAbilityReqBO.getWaitDoneList().get(0);
        ContractWaitDoneLogReqBO contractWaitDoneLogReqBO = new ContractWaitDoneLogReqBO();
        contractWaitDoneLogReqBO.setObjId(Long.valueOf(paramBO.getObjId()));
        contractWaitDoneLogReqBO.setBusiCode(todoAddWaitDoneAbilityReqBO.getBusiCode());
        contractWaitDoneLogReqBO.setBusiName(todoAddWaitDoneAbilityReqBO.getBusiName());
        contractWaitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoAddWaitDoneAbilityReqBO));
        contractWaitDoneLogReqBO.setWaitDoneStatus(waitDoneStatus);
        contractWaitDoneLogReqBO.setWaitDoneType(waitDoneType);
        contractWaitDoneLogReqBO.setTitle(paramBO.getTitle());
        contractWaitDoneLogReqBO.setExt1(exceptionMsg);
        this.contractWaitDoneLogBusiService.addWaitDoneLog(contractWaitDoneLogReqBO);
    }

    public boolean cancelTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO, boolean cancelWaitDoneFlag) {
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getCancelList())) {
            log.info("cancelTodoWait todoWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
            com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityReqBO cancelWaitDoneAbilityReqBO = (com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoWaitAbilityReqBO), com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityReqBO.class);
            if (cancelWaitDoneFlag) {
                try {
                    TodoCancelWaitDoneAbilityRspBO cancelWaitDone = this.todoWaitDoneWriteAbilityService.cancelWaitDone(cancelWaitDoneAbilityReqBO);
                    if ("0000".equals(cancelWaitDone.getRespCode())) {
                        this.cancelTodoWaitLog(cancelWaitDoneAbilityReqBO, 1, 2, null);
                        return true;
                    }
                    this.cancelTodoWaitLog(cancelWaitDoneAbilityReqBO, 2, 2, cancelWaitDone.getRespDesc());
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (message != null && message.length() > 200) {
                        message = message.substring(0, 200);
                    }
                    this.cancelTodoWaitLog(cancelWaitDoneAbilityReqBO, 2, 2, JSON.toJSONString((Object)message));
                }
            } else {
                this.cancelTodoWaitLog(cancelWaitDoneAbilityReqBO, 2, 2, "\u524d\u7f6e\u63a8\u9001\u6d41\u7a0b\u5931\u8d25\uff0c\u672c\u6b21\u4e0d\u63a8\u9001\u3002");
            }
        }
        return false;
    }

    private void cancelTodoWaitLog(com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO, Integer waitDoneStatus, Integer waitDoneType, String exceptionMsg) {
        TodoCancelWaitDoneAbilityParamBO todoAddWaitDone = (TodoCancelWaitDoneAbilityParamBO)todoAddWaitDoneAbilityReqBO.getCancelList().get(0);
        ContractWaitDoneLogReqBO contractWaitDoneLogReqBO = new ContractWaitDoneLogReqBO();
        if (!StringUtils.isEmpty((Object)todoAddWaitDone.getObjId())) {
            contractWaitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
        }
        contractWaitDoneLogReqBO.setBusiCode(todoAddWaitDoneAbilityReqBO.getBusiCode());
        contractWaitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoAddWaitDoneAbilityReqBO));
        contractWaitDoneLogReqBO.setWaitDoneStatus(waitDoneStatus);
        contractWaitDoneLogReqBO.setWaitDoneType(waitDoneType);
        contractWaitDoneLogReqBO.setExt1(exceptionMsg);
        this.contractWaitDoneLogBusiService.addWaitDoneLog(contractWaitDoneLogReqBO);
    }

    public boolean doneTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO, boolean doneWaitDoneFlag) {
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getDoneList())) {
            log.info("doneTodoWait todoWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
            com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityReqBO todoAddAlreadyDoneAbilityReqBO = (com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoWaitAbilityReqBO), com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityReqBO.class);
            if (doneWaitDoneFlag) {
                try {
                    TodoAddAlreadyDoneAbilityRspBO addAlreadyDone = this.todoWaitDoneWriteAbilityService.AddAlreadyDone(todoAddAlreadyDoneAbilityReqBO);
                    if ("0000".equals(addAlreadyDone.getRespCode())) {
                        this.doneTodoWaitLog(todoAddAlreadyDoneAbilityReqBO, 1, 3, null);
                        return true;
                    }
                    this.doneTodoWaitLog(todoAddAlreadyDoneAbilityReqBO, 2, 3, addAlreadyDone.getRespDesc());
                }
                catch (Exception e) {
                    log.error("\u6dfb\u52a0\u5df2\u529e\u63a8\u9001\u9519\u8bef\uff1a{}", (Object)JSON.toJSONString((Object)e));
                    String message = e.getMessage();
                    if (message != null && message.length() > 200) {
                        message = message.substring(0, 200);
                    }
                    this.doneTodoWaitLog(todoAddAlreadyDoneAbilityReqBO, 2, 3, JSON.toJSONString((Object)message));
                }
            } else {
                this.doneTodoWaitLog(todoAddAlreadyDoneAbilityReqBO, 2, 3, "\u524d\u7f6e\u63a8\u9001\u6d41\u7a0b\u5931\u8d25\uff0c\u672c\u6b21\u4e0d\u63a8\u9001\u3002");
            }
        }
        return false;
    }

    private void doneTodoWaitLog(com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityReqBO todoAddWaitDoneAbilityReqBO, Integer waitDoneStatus, Integer waitDoneType, String exceptionMsg) {
        TodoAddAlreadyDoneAbilityParamBO todoAddWaitDone = (TodoAddAlreadyDoneAbilityParamBO)todoAddWaitDoneAbilityReqBO.getDoneList().get(0);
        ContractWaitDoneLogReqBO contractWaitDoneLogReqBO = new ContractWaitDoneLogReqBO();
        if (!StringUtils.isEmpty((Object)todoAddWaitDone.getObjId())) {
            contractWaitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
        }
        contractWaitDoneLogReqBO.setBusiCode(todoAddWaitDoneAbilityReqBO.getBusiCode());
        contractWaitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoAddWaitDoneAbilityReqBO));
        contractWaitDoneLogReqBO.setWaitDoneStatus(waitDoneStatus);
        contractWaitDoneLogReqBO.setWaitDoneType(waitDoneType);
        contractWaitDoneLogReqBO.setExt1(exceptionMsg);
        this.contractWaitDoneLogBusiService.addWaitDoneLog(contractWaitDoneLogReqBO);
    }

    private List<MemberAbilityBO> getUserCode(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return null;
        }
        UmcTaskReqBO umcTaskReqBO = new UmcTaskReqBO();
        umcTaskReqBO.setMemIds(userIds);
        UmcTaskRspBO user = this.umcAddTaskAbilityService.qryTaskUser(umcTaskReqBO);
        if (Objects.isNull(user) || CollectionUtils.isEmpty((Collection)user.getList())) {
            return null;
        }
        return user.getList();
    }

    private DycStationOrgSelectUserNameRspBO listUser(String nextStationId) {
        if (StringUtils.isEmpty((Object)nextStationId)) {
            return new DycStationOrgSelectUserNameRspBO();
        }
        ArrayList<Long> stationIds = new ArrayList<Long>();
        for (String station : nextStationId.split(",")) {
            stationIds.add(Long.valueOf(station));
        }
        DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
        dycStationOrgSelectUserNameReqBO.setStationIds(stationIds);
        return this.dycStationOrgSelectUserNameService.selectUserNameList(dycStationOrgSelectUserNameReqBO);
    }

    @Override
    public UocApprovalLogPO listApproval(Long objId) {
        UocApprovalLogPO uocApprovalLogPO = new UocApprovalLogPO();
        uocApprovalLogPO.setOrderId(objId);
        return this.uocApprovalLogMapper.listByParam(uocApprovalLogPO).stream().filter($ -> Objects.nonNull($)).max(Comparator.comparing(UocApprovalLogPO::getDealTime)).orElse(null);
    }

    private void assertParam(TodoActiveWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        Assert.notNull((Object)todoUccWaitAbilityReqBO, (String)"PARAM_IS_NULL");
        Assert.notNull((Object)todoUccWaitAbilityReqBO.getObjId(), (String)"OBJID_IS_NULL");
        Assert.notNull((Object)todoUccWaitAbilityReqBO.getOperatorType(), (String)"OPERATOR_IS_NULL");
    }
}

