/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.timetask.impl;

import com.tydic.active.app.atom.ActQryGroupActiveDeliverGoodsAtomService;
import com.tydic.active.app.atom.bo.ActQryGroupActiveDeliverGoodsAtomReqBO;
import com.tydic.active.app.atom.bo.ActQryGroupActiveDeliverGoodsAtomRspBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActDicDictionaryMapper;
import com.tydic.active.app.dao.ActGroupActiveInstMapper;
import com.tydic.active.app.dao.po.ActGroupActiveInstPO;
import com.tydic.active.app.dao.po.DicDictionaryPO;
import com.tydic.active.app.timetask.ActNotificationShipmentTimeTaskService;
import com.tydic.active.app.timetask.bo.ActTimeTaskReqBO;
import com.tydic.active.app.timetask.bo.ActTimeTaskRspBO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/2.0.0/com.tydic.active.app.timetask.ActNotificationShipmentTimeTaskService"})
public class ActNotificationShipmentTimeTaskServiceImpl
implements ActNotificationShipmentTimeTaskService {
    private static final Logger log = LoggerFactory.getLogger(ActNotificationShipmentTimeTaskServiceImpl.class);
    @Autowired
    private ActDicDictionaryMapper actDicDictionaryMapper;
    @Autowired
    private ActGroupActiveInstMapper actGroupActiveInstMapper;
    @Autowired
    private ActQryGroupActiveDeliverGoodsAtomService actQryGroupActiveDeliverGoodsAtomService;

    @PostMapping(value={"execute"})
    public ActTimeTaskRspBO execute(@RequestBody ActTimeTaskReqBO actTimeTaskReqBO) {
        ActTimeTaskRspBO rsp = new ActTimeTaskRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u6210\u529f");
        if (log.isInfoEnabled() || log.isDebugEnabled()) {
            log.info("==========\u5f00\u59cb\u6267\u884c\u5df2\u6210\u56e2\u901a\u77e5\u53d1\u8d27\u5b9a\u65f6\u4efb\u52a1\uff0ccurrentShardValue:[" + actTimeTaskReqBO.getShardingItem() + "]==========");
        }
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        dicDictionaryPO.setPCode("MSC_totalShardCount");
        dicDictionaryPO.setCode("5");
        DicDictionaryPO dictionaryPO = this.actDicDictionaryMapper.getModelByCondition(dicDictionaryPO);
        if (null == dictionaryPO) {
            if (log.isDebugEnabled()) {
                log.debug("\u8fd8\u672a\u5728\u5b57\u5178\u4e2d\u914d\u7f6e\u603b\u5206\u7247\u503c");
            }
            return rsp;
        }
        List<ActGroupActiveInstPO> result = this.actGroupActiveInstMapper.getInstIdForNotificationShipmentByTimeTask(dictionaryPO.getTitle(), actTimeTaskReqBO.getShardingItem());
        if (!CollectionUtils.isEmpty(result)) {
            for (ActGroupActiveInstPO po : result) {
                ActQryGroupActiveDeliverGoodsAtomReqBO actQryGroupActiveDeliverGoodsAtomReqBO = new ActQryGroupActiveDeliverGoodsAtomReqBO();
                actQryGroupActiveDeliverGoodsAtomReqBO.setActiveId(po.getActiveId());
                actQryGroupActiveDeliverGoodsAtomReqBO.setGroupInstId(po.getGroupInstId());
                if (po.getGroupMenNum() >= po.getTargetMemNum()) {
                    actQryGroupActiveDeliverGoodsAtomReqBO.setDeliverType(ActCommConstant.DeliverType.DELIVER_GOODS);
                } else {
                    actQryGroupActiveDeliverGoodsAtomReqBO.setDeliverType(ActCommConstant.DeliverType.RETURN_MONEY);
                }
                ActQryGroupActiveDeliverGoodsAtomRspBO actQryGroupActiveDeliverGoodsAtomRspBO = this.actQryGroupActiveDeliverGoodsAtomService.operDeliverGoods(actQryGroupActiveDeliverGoodsAtomReqBO);
            }
        }
        if (log.isInfoEnabled() || log.isDebugEnabled()) {
            log.info("==========\u62fc\u56e2\u6d3b\u52a8\u5df2\u6210\u56e2\u901a\u77e5\u53d1\u8d27\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0ccurrentShardValue:[" + actTimeTaskReqBO.getShardingItem() + "]==========");
        }
        return rsp;
    }
}

