/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.timetask.impl;

import com.ohaotian.plugin.cache.ActRedisManager;
import com.tydic.active.app.dao.ActDicDictionaryMapper;
import com.tydic.active.app.dao.ActGroupActiveInstMapper;
import com.tydic.active.app.dao.po.ActGroupActiveInstPO;
import com.tydic.active.app.dao.po.DicDictionaryPO;
import com.tydic.active.app.timetask.ActUpdateMenNumTimeTaskService;
import com.tydic.active.app.timetask.bo.ActTimeTaskReqBO;
import com.tydic.active.app.timetask.bo.ActTimeTaskRspBO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/2.0.0/com.tydic.active.app.timetask.ActUpdateMenNumTimeTaskService"})
public class ActUpdateMenNumTimeTaskServiceImpl
implements ActUpdateMenNumTimeTaskService {
    private static final Logger log = LoggerFactory.getLogger(ActUpdateMenNumTimeTaskServiceImpl.class);
    @Autowired
    private ActDicDictionaryMapper actDicDictionaryMapper;
    @Autowired
    private ActGroupActiveInstMapper actGroupActiveInstMapper;
    @Autowired
    private ActRedisManager cacheManager;

    @PostMapping(value={"execute"})
    public ActTimeTaskRspBO execute(@RequestBody ActTimeTaskReqBO actTimeTaskReqBO) {
        ActTimeTaskRspBO rsp = new ActTimeTaskRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u6210\u529f");
        if (log.isInfoEnabled() || log.isDebugEnabled()) {
            log.info("==========\u5f00\u59cb\u6267\u884c\u62fc\u56e2\u6d3b\u52a8\u5df2\u53c2\u56e2\u4eba\u6570\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\uff0ccurrentShardValue:[" + actTimeTaskReqBO.getShardingItem() + "]==========");
        }
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        dicDictionaryPO.setPCode("MSC_totalShardCount");
        dicDictionaryPO.setCode("4");
        DicDictionaryPO dictionaryPO = this.actDicDictionaryMapper.getModelByCondition(dicDictionaryPO);
        if (null == dictionaryPO) {
            if (log.isDebugEnabled()) {
                log.debug("\u8fd8\u672a\u5728\u5b57\u5178\u4e2d\u914d\u7f6e\u603b\u5206\u7247\u503c");
            }
            return rsp;
        }
        List<ActGroupActiveInstPO> result = this.actGroupActiveInstMapper.getInstIdForUpdateMenNumByTimeTask(dictionaryPO.getTitle(), actTimeTaskReqBO.getShardingItem());
        if (!CollectionUtils.isEmpty(result)) {
            for (ActGroupActiveInstPO po : result) {
                Integer groupMemNum = this.getGroupMemNum(po.getActiveId(), po.getGroupInstId());
                Integer lockMemNum = this.getLockMemNum(po.getActiveId(), po.getGroupInstId());
                ActGroupActiveInstPO updateActGroupActiveInstPO = new ActGroupActiveInstPO();
                updateActGroupActiveInstPO.setGroupInstId(po.getGroupInstId());
                updateActGroupActiveInstPO.setGroupMenNum(groupMemNum);
                updateActGroupActiveInstPO.setLockMemNum(lockMemNum);
                this.actGroupActiveInstMapper.updateByPrimaryKeySelective(updateActGroupActiveInstPO);
            }
        }
        if (log.isInfoEnabled() || log.isDebugEnabled()) {
            log.info("==========\u62fc\u56e2\u6d3b\u52a8\u5df2\u53c2\u56e2\u4eba\u6570\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0ccurrentShardValue:[" + actTimeTaskReqBO.getShardingItem() + "]==========");
        }
        return rsp;
    }

    private Integer getLockMemNum(Long activeId, Long groupInstId) {
        String lockMemNumRedisKey = "LOCK_TOTAL_" + activeId + "_" + groupInstId;
        Long lockMemNum = this.cacheManager.incrByCount(lockMemNumRedisKey, 0L);
        return lockMemNum.intValue();
    }

    private Integer getGroupMemNum(Long activeId, Long groupInstId) {
        String groupMemNumRedisKey = "SALES_TOTAL_" + activeId + "_" + groupInstId;
        Long groupMemNum = this.cacheManager.incrByCount(groupMemNumRedisKey, 0L);
        return groupMemNum.intValue();
    }
}

