/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.utils;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static AtomicInteger counter = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpClient(String urladdr, String info) {
        String string = null;
        URL url = null;
        HttpURLConnection conn = null;
        BasicAuthenticator auth = new BasicAuthenticator("aimAdmin", "aimadmin");
        Authenticator.setDefault(auth);
        int connectTimeout = Integer.valueOf(System.getProperties().getProperty("http.connect.timeout", "10000"));
        int readTimeout = Integer.valueOf(System.getProperties().getProperty("http.read.timeout", "30000"));
        try {
            url = new URL(urladdr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setRequestProperty("Content-Type", "application/json;charset=utf-8");
            conn.getOutputStream().write(info.getBytes());
            conn.getOutputStream().flush();
            conn.getOutputStream().close();
            string = HttpUtil.readContents(conn);
        }
        catch (Exception e) {
            log.error("Exception error:{}", (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return string;
    }

    public static String readContents(HttpURLConnection httpurlconnection) {
        String string = "";
        BufferedReader in = null;
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(httpurlconnection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                string = string + inputLine;
            }
        }
        catch (IOException e) {
            log.error("Exception error:{}", (Throwable)e);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGetClient(String url) {
        String result = "";
        BufferedReader in = null;
        BasicAuthenticator auth = new BasicAuthenticator("aimAdmin", "aimadmin");
        Authenticator.setDefault(auth);
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            log.error("Exception error:{}", (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                log.error("Exception error:{}", (Throwable)e2);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean httpDownload(String httpUpUrl, String saveFile) {
        int byteread = 0;
        URL url = null;
        try {
            url = new URL(httpUpUrl);
        }
        catch (MalformedURLException e1) {
            log.error("Exception error:{}", (Throwable)e1);
            return false;
        }
        InputStream inStream = null;
        try {
            boolean bl;
            Throwable throwable;
            FileOutputStream fs;
            block32: {
                block33: {
                    fs = new FileOutputStream(saveFile);
                    throwable = null;
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    inStream = conn.getInputStream();
                    byte[] buffer = new byte[1204];
                    while ((byteread = inStream.read(buffer)) != -1) {
                        fs.write(buffer, 0, byteread);
                    }
                    fs.flush();
                    fs.close();
                    inStream.close();
                    if (conn != null) {
                        conn.disconnect();
                    }
                    bl = true;
                    if (fs == null) break block32;
                    if (throwable == null) break block33;
                    try {
                        fs.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block32;
                }
                fs.close();
            }
            return bl;
            catch (Throwable conn) {
                try {
                    try {
                        throwable = conn;
                        throw conn;
                    }
                    catch (Throwable throwable3) {
                        if (fs != null) {
                            if (throwable != null) {
                                try {
                                    fs.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                fs.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (FileNotFoundException e) {
                    log.error("Exception error:{}", (Throwable)e);
                    boolean bl2 = false;
                    return bl2;
                }
                catch (IOException e) {
                    log.error("Exception error:{}", (Throwable)e);
                    boolean bl3 = false;
                    return bl3;
                }
            }
        }
        finally {
            if (Objects.nonNull(inStream)) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error("Exception error:{}", (Throwable)e);
                }
            }
        }
    }

    public static String httpUploadByPath(String actionUrl, String path) throws Exception {
        String BOUNDARY = UUID.randomUUID().toString();
        String PREFFIX = "--";
        String LINEND = "\r\n";
        String MULTIPART_FROM_DATA = "multipart/form-data";
        String CHARSET = "UTF-8";
        URL url = new URL(actionUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(10000);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("connection", "keep-alive");
        conn.setRequestProperty("Charset", "UTF-8");
        conn.setRequestProperty("Content-Type", MULTIPART_FROM_DATA + ";boundary=" + BOUNDARY);
        DataOutputStream outStream = new DataOutputStream(conn.getOutputStream());
        if (path != null) {
            StringBuilder sb1 = new StringBuilder();
            sb1.append(PREFFIX);
            sb1.append(BOUNDARY);
            sb1.append(LINEND);
            sb1.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + path + "\"" + LINEND);
            sb1.append("Content-Type: application/octet-stream;chartset=" + CHARSET + LINEND);
            sb1.append(LINEND);
            outStream.write(sb1.toString().getBytes());
            try (FileInputStream is = new FileInputStream(path);){
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)is).read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
                outStream.write(LINEND.getBytes());
            }
            catch (Exception e) {
                log.error("Exception error:{}", (Throwable)e);
            }
        }
        byte[] end_data = (PREFFIX + BOUNDARY + PREFFIX + LINEND).getBytes();
        outStream.write(end_data);
        outStream.flush();
        outStream.close();
        int res = conn.getResponseCode();
        InputStream in = null;
        StringBuilder sb2 = new StringBuilder();
        if (res == 200) {
            int ch;
            in = conn.getInputStream();
            while ((ch = in.read()) != -1) {
                sb2.append((char)ch);
            }
        }
        if (conn != null) {
            conn.disconnect();
        }
        return sb2.toString();
    }

    public static String httpUpload(String actionUrl, String upFile) throws IOException {
        String operSystem = System.getProperties().getProperty("os.name");
        String fileName = "";
        File directory = new File(".");
        fileName = operSystem.indexOf("Windows") > 0 ? directory.getCanonicalPath() + "\\" + upFile : directory.getCanonicalPath() + "/" + upFile;
        String BOUNDARY = UUID.randomUUID().toString();
        String PREFFIX = "--";
        String LINEND = "\r\n";
        String MULTIPART_FROM_DATA = "multipart/form-data";
        String CHARSET = "UTF-8";
        URL url = new URL(actionUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(10000);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("connection", "keep-alive");
        conn.setRequestProperty("Charset", "UTF-8");
        conn.setRequestProperty("Content-Type", MULTIPART_FROM_DATA + ";boundary=" + BOUNDARY);
        DataOutputStream outStream = new DataOutputStream(conn.getOutputStream());
        if (fileName != null) {
            StringBuilder sb1 = new StringBuilder();
            sb1.append(PREFFIX);
            sb1.append(BOUNDARY);
            sb1.append(LINEND);
            sb1.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + fileName + "\"" + LINEND);
            sb1.append("Content-Type: application/octet-stream;chartset=" + CHARSET + LINEND);
            sb1.append(LINEND);
            outStream.write(sb1.toString().getBytes());
            try (FileInputStream is = new FileInputStream(fileName);){
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)is).read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
                outStream.write(LINEND.getBytes());
            }
            catch (Exception e) {
                log.error("Exception error:{}", (Throwable)e);
            }
        }
        byte[] end_data = (PREFFIX + BOUNDARY + PREFFIX + LINEND).getBytes();
        outStream.write(end_data);
        outStream.flush();
        outStream.close();
        int res = conn.getResponseCode();
        InputStream in = null;
        StringBuilder sb2 = new StringBuilder();
        if (res == 200) {
            int ch;
            in = conn.getInputStream();
            while ((ch = in.read()) != -1) {
                sb2.append((char)ch);
            }
        }
        if (conn != null) {
            conn.disconnect();
        }
        return sb2.toString();
    }

    public static boolean deleteFile(String fileName) {
        File directory = new File(".");
        String operSystem = System.getProperties().getProperty("os.name");
        try {
            String filePath = operSystem.indexOf("Windows") > 0 ? directory.getCanonicalPath() + "\\" + fileName : directory.getCanonicalPath() + "/" + fileName;
            File file = new File(filePath);
            if (!file.exists()) {
                System.out.println("\u5220\u9664\u6587\u4ef6\u5931\u8d25:" + filePath + "\u4e0d\u5b58\u5728\uff01");
                return false;
            }
            if (file.isFile()) {
                if (file.delete()) {
                    System.out.println("\u5220\u9664\u6587\u4ef6" + filePath + "\u6210\u529f\uff01");
                    return true;
                }
                System.out.println("\u5220\u9664\u6587\u4ef6" + filePath + "\u5931\u8d25\uff01");
                return false;
            }
            return false;
        }
        catch (IOException e) {
            log.error("Exception error:{}", (Throwable)e);
            return false;
        }
    }

    public static String getFileName(String inStr, String splitStr) {
        ArrayList<String> a = new ArrayList<String>();
        String str = inStr;
        if (str.substring(str.length() - splitStr.length()).equals(splitStr)) {
            str = str.substring(0, str.length() - splitStr.length());
        }
        while (str != null) {
            String tmp;
            int idx = str.indexOf(splitStr);
            if (idx == -1) {
                tmp = str.substring(0, str.length());
                a.add(tmp);
                break;
            }
            tmp = str.substring(0, idx);
            a.add(tmp);
            str = str.substring(idx + splitStr.length());
        }
        return (String)a.get(a.size() - 1);
    }

    public static int genID() {
        int rid = counter.incrementAndGet();
        if (rid > 99999999) {
            counter.set(1);
        }
        return rid;
    }

    public static String getSequence(int id) {
        String sequence = String.valueOf(id);
        int iLength = sequence.length();
        int strLen = 8 - iLength;
        if (strLen <= 0) {
            return sequence.substring(0, 7);
        }
        String str = "";
        for (int i = 1; i <= strLen; ++i) {
            str = str + "0";
        }
        sequence = str + sequence;
        return sequence;
    }

    public static class BasicAuthenticator
    extends Authenticator {
        String userName;
        String password;

        public BasicAuthenticator(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.password.toCharArray());
        }
    }
}

