/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.extend.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.active.extend.busi.AcImportActiveMemResultLogExportBusiService;
import com.tydic.active.extend.busi.bo.ActImportActiveMemResultLogBusiReqBO;
import com.tydic.active.extend.busi.bo.ActImportActiveMemResultLogBusiRspBO;
import com.tydic.active.extend.utils.ExcelUtils;
import com.tydic.active.external.api.contant.ActExternalCommonConstant;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AcImportActiveMemResultLogExportBusiServiceImpl
implements AcImportActiveMemResultLogExportBusiService {
    private static final Logger log = LoggerFactory.getLogger(AcImportActiveMemResultLogExportBusiServiceImpl.class);
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Autowired
    private FileClient fileClient;
    @Value(value="${preFilePath}")
    private String preFilePath;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers}")
    private String fastdfsTrackerServers;
    @Value(value="${export.file.public.url}")
    private String exportFilePublicUrl;

    public ActImportActiveMemResultLogBusiRspBO importResultExport(ActImportActiveMemResultLogBusiReqBO reqBO) {
        ActImportActiveMemResultLogBusiRspBO rspBO = new ActImportActiveMemResultLogBusiRspBO();
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        ArrayList Data = new ArrayList();
        int index = 0;
        for (Map map : reqBO.getImportDataMaps()) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put("\u5e8f\u53f7", ++index);
            item.put("\u624b\u673a\u53f7", map.get("regMobile") != null ? map.get("regMobile") : "");
            item.put("\u59d3\u540d", map.get("memName") != null ? map.get("memName") : "");
            item.put("\u90ae\u7bb1", map.get("regEmail") != null ? map.get("regEmail") : "");
            item.put("\u5206\u914d\u79ef\u5206", map.get("activityIntegral") != null ? map.get("activityIntegral") : "");
            Integer impResult = (Integer)map.get("impResult");
            if (impResult != null) {
                if (impResult.equals(ActExternalCommonConstant.ImportStatus.SUCCESS)) {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                } else {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                    item.put("\u5931\u8d25\u539f\u56e0", map.get("impRemark") != null ? map.get("impRemark") : "");
                }
            } else {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5bfc\u5165\u5f02\u5e38");
            }
            exportData.add(item);
            LinkedHashMap copyItem = new LinkedHashMap(item);
            Data.add(copyItem);
        }
        this.uploadFile(exportData, rspBO);
        String fullFilePath = "";
        if ("OSS".equals(this.fileType)) {
            fullFilePath = this.preFilePath + rspBO.getFilePath();
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)rspBO.getFilePath());
            fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        }
        rspBO.setExportData(Data);
        rspBO.setFullFilePath(fullFilePath);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u521b\u5efaexcel \u6570\u636e\u6210\u529f!");
        return rspBO;
    }

    private void uploadFile(List<Map<String, Object>> data, ActImportActiveMemResultLogBusiRspBO rspBO) {
        SXSSFWorkbook workbook = ExcelUtils.actCreateWorkbook(data, "\u6d3b\u52a8\u4f1a\u5458\u5bfc\u5165\u8bb0\u5f55");
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String uploadPath = "act";
        String fileName = UUID.randomUUID() + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            rspBO.setFilePath(result);
            rspBO.setFileClientType(this.fileType);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new BusinessException("14041", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
    }
}

