/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.controller;

import com.ohaotian.plugin.file.FileClient;
import com.tydic.active.app.controller.bo.ActFileUpAndDownReqBO;
import com.tydic.active.app.controller.bo.ActFileUpAndDownRspBO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/msc/ossUpload"})
public class ActFileUpAndDownController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String RSP_CODE_SUCCESS = "0000";
    public static final String RSP_CODE_FAILURE = "8888";
    public static final String RSP_CODE_OSS_UOLOAD_FAILURE = "0010";
    @Value(value="${oss.accessUrl}")
    public String accessUrl;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Autowired
    private FileClient fileClient;

    @PostMapping(value={"/fileUpload"})
    public ActFileUpAndDownRspBO fileUpload(ActFileUpAndDownReqBO reqBO) {
        ActFileUpAndDownRspBO rspBO = new ActFileUpAndDownRspBO();
        if (reqBO.getFile() == null) {
            rspBO.setRespCode(RSP_CODE_FAILURE);
            rspBO.setRespCode("\u8bf7\u4e0a\u4f20\u6587\u4ef6");
            return rspBO;
        }
        try {
            byte[] b = reqBO.getFile().getBytes();
            ByteArrayInputStream input = new ByteArrayInputStream(b);
            String fileName = UUID.randomUUID() + "." + StringUtils.substringAfterLast((String)reqBO.getFile().getOriginalFilename(), (String)".");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String uploadPath = "msc/" + sdf.format(new Date());
            rspBO.setFilePath(fileName);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)input);
            rspBO.setFilePath(this.accessUrl + "/" + result);
            rspBO.setFileClientType(this.fileType);
            rspBO.setRelativeFilePath(result);
            rspBO.setRespCode(RSP_CODE_SUCCESS);
            rspBO.setRespDesc("oss\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("oss\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668\u5931\u8d25", (Throwable)e);
            rspBO.setRespCode(RSP_CODE_OSS_UOLOAD_FAILURE);
            rspBO.setRespDesc("oss\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668\u5931\u8d25");
        }
        return rspBO;
    }
}

