/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.agreement.ability.api.AgrCreateAgreementSkuFromContractAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.ability.bo.AgrCreateAgreementSkuFromContractReqBO;
import com.tydic.agreement.ability.bo.AgrCreateAgreementSkuFromContractRspBO;
import com.tydic.agreement.busi.api.AgrCreateAgreementSkuBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuBusiRspBO;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.commodity.base.bo.UccEMdmMaterialBO;
import com.tydic.commodity.common.ability.api.UccThematerialsearchAbilityService;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityRspBO;
import com.tydic.contract.ability.ContractItemQueryAbilityService;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.ability.bo.ContractItemQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemQueryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrCreateAgreementSkuFromContractAbilityService"})
public class AgrCreateAgreementSkuFromContractAbilityServiceImpl
implements AgrCreateAgreementSkuFromContractAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrCreateAgreementSkuFromContractAbilityServiceImpl.class);
    @Autowired
    private ContractItemQueryAbilityService contractItemQueryAbilityService;
    @Autowired
    private UccThematerialsearchAbilityService uccMaterialInfoQueryAbilityService;
    @Autowired
    private AgrCreateAgreementSkuBusiService agrCreateAgreementSkuBusiService;

    @PostMapping(value={"createAgreementSkuFromContract"})
    public AgrCreateAgreementSkuFromContractRspBO createAgreementSkuFromContract(@RequestBody AgrCreateAgreementSkuFromContractReqBO reqBO) {
        AgrCreateAgreementSkuFromContractRspBO rspBO = new AgrCreateAgreementSkuFromContractRspBO();
        if (reqBO.getAgreementId() == null) {
            throw new BusinessException("0001", "\u534f\u8baeID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getContractId() == null && StringUtils.isBlank((CharSequence)reqBO.getContractCode())) {
            throw new BusinessException("0001", "\u5408\u540cID\u548c\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        ContractItemQueryAbilityReqBO contractItemQueryAbilityReqBO = new ContractItemQueryAbilityReqBO();
        contractItemQueryAbilityReqBO.setContractId(reqBO.getContractId());
        contractItemQueryAbilityReqBO.setContractCode(reqBO.getContractCode());
        contractItemQueryAbilityReqBO.setContractItemBOList(reqBO.getContractItemIds());
        contractItemQueryAbilityReqBO.setPageSize(Integer.valueOf(1000));
        ContractItemQueryAbilityRspBO contractItemQueryAbilityCheckRspBO = this.contractItemQueryAbilityService.contractItemQueryWithList(contractItemQueryAbilityReqBO);
        if (!contractItemQueryAbilityCheckRspBO.getRespCode().equals("0000")) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(contractItemQueryAbilityCheckRspBO.getRespDesc());
            return rspBO;
        }
        if (contractItemQueryAbilityCheckRspBO.getTotal() == 1) {
            this.process(rspBO, reqBO, contractItemQueryAbilityCheckRspBO);
        }
        if (contractItemQueryAbilityCheckRspBO.getTotal() > 1) {
            for (int i = 1; i <= contractItemQueryAbilityCheckRspBO.getTotal(); ++i) {
                contractItemQueryAbilityReqBO.setPageNo(Integer.valueOf(i));
                ContractItemQueryAbilityRspBO contractItemQueryAbilityRspBO = this.contractItemQueryAbilityService.contractItemQueryWithList(contractItemQueryAbilityReqBO);
                if (!contractItemQueryAbilityRspBO.getRespCode().equals("0000")) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc(contractItemQueryAbilityCheckRspBO.getRespDesc());
                    return rspBO;
                }
                this.process(rspBO, reqBO, contractItemQueryAbilityRspBO);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u534f\u8bae\u660e\u7ec6\u521b\u5efa\u6210\u529f\uff01");
        return rspBO;
    }

    private void process(AgrCreateAgreementSkuFromContractRspBO rspBO, AgrCreateAgreementSkuFromContractReqBO reqBO, ContractItemQueryAbilityRspBO contractItemQueryAbilityRspBO) {
        HashSet<String> materialCodeSet = new HashSet<String>();
        ArrayList<AgrAgreementSkuBO> agrAgreementSkuBOS = new ArrayList<AgrAgreementSkuBO>();
        if (!CollectionUtils.isEmpty((Collection)contractItemQueryAbilityRspBO.getRows())) {
            log.info("\u5408\u540c\u660e\u7ec6\u5217\u8868:{}" + JSON.toJSONString((Object)contractItemQueryAbilityRspBO.getRows()));
            for (ContractItemAbilityBO contractItemAbilityBO : contractItemQueryAbilityRspBO.getRows()) {
                try {
                    AgrAgreementSkuBO agrAgreementSkuBO = new AgrAgreementSkuBO();
                    materialCodeSet.add(contractItemAbilityBO.getMaterialCode());
                    this.convertSku(contractItemAbilityBO, agrAgreementSkuBO);
                    agrAgreementSkuBO.setAgreementId(reqBO.getAgreementId());
                    agrAgreementSkuBOS.add(agrAgreementSkuBO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u8f6c\u6362\u5408\u540c\u660e\u7ec6\u9519\u8bef:" + e.toString());
                }
            }
            UccThematerialsearchAbilityReqBO uccThematerialsearchAbilityReqBO = new UccThematerialsearchAbilityReqBO();
            uccThematerialsearchAbilityReqBO.setMaterialCodes(new ArrayList(materialCodeSet));
            uccThematerialsearchAbilityReqBO.setPageNo(-1);
            uccThematerialsearchAbilityReqBO.setPageSize(-1);
            if (log.isDebugEnabled()) {
                log.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u5408\u540c\u8f6c\u6362\u660e\u7ec6\u6821\u9a8c\u670d\u52a1\u5165\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccThematerialsearchAbilityReqBO));
            }
            UccThematerialsearchAbilityRspBO uccThematerialsearchAbilityRspBO = this.uccMaterialInfoQueryAbilityService.dealUccThematerialsearch(uccThematerialsearchAbilityReqBO);
            if (log.isDebugEnabled()) {
                log.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u5408\u540c\u8f6c\u6362\u660e\u7ec6\u6821\u9a8c\u670d\u52a1\u51fa\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccThematerialsearchAbilityRspBO));
            }
            if ("0000".equals(uccThematerialsearchAbilityRspBO.getRespCode())) {
                Map uccRspMap = uccThematerialsearchAbilityRspBO.getRows().stream().collect(Collectors.toMap(UccEMdmMaterialBO::getMaterialCode, Function.identity()));
                for (AgrAgreementSkuBO agrAgreementSkuBO : agrAgreementSkuBOS) {
                    UccEMdmMaterialBO uccEMdmMaterialBO = (UccEMdmMaterialBO)uccRspMap.get(agrAgreementSkuBO.getMaterialCode());
                    if (uccEMdmMaterialBO != null) {
                        agrAgreementSkuBO.setCatalogId(uccEMdmMaterialBO.getCatalogId().toString());
                        agrAgreementSkuBO.setCatalogCode(uccEMdmMaterialBO.getCatalogCode());
                        agrAgreementSkuBO.setCatalogName(uccEMdmMaterialBO.getCatalogName());
                        agrAgreementSkuBO.setCommodityTypeId(uccEMdmMaterialBO.getCommodityTypeId());
                        agrAgreementSkuBO.setCommodityTypeName(uccEMdmMaterialBO.getCommodityTypeName());
                        agrAgreementSkuBO.setModel(uccEMdmMaterialBO.getModel());
                        agrAgreementSkuBO.setSpec(uccEMdmMaterialBO.getSpec());
                        agrAgreementSkuBO.setFigure(uccEMdmMaterialBO.getFigure());
                        agrAgreementSkuBO.setTexture(uccEMdmMaterialBO.getTexture());
                        continue;
                    }
                    log.error("\u5408\u540c\u7269\u6599\u7f16\u7801\u67e5\u8be2\u4e0d\u5b58\u5728:" + agrAgreementSkuBO.getMaterialCode());
                }
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(uccThematerialsearchAbilityRspBO.getRespDesc());
                return;
            }
            if (!CollectionUtils.isEmpty(agrAgreementSkuBOS)) {
                AgrCreateAgreementSkuBusiReqBO createReqBO = new AgrCreateAgreementSkuBusiReqBO();
                createReqBO.setAgreementId(reqBO.getAgreementId());
                createReqBO.setMemIdIn(reqBO.getMemIdIn());
                createReqBO.setUserName(reqBO.getUserName());
                createReqBO.setAgrAgreementSkuBOs(agrAgreementSkuBOS);
                AgrCreateAgreementSkuBusiRspBO skuBusiRspBO = this.agrCreateAgreementSkuBusiService.createAgreementSku(createReqBO);
                if (!skuBusiRspBO.getRespCode().equals("0000")) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc(skuBusiRspBO.getRespDesc());
                }
            }
        }
    }

    private void convertSku(ContractItemAbilityBO contractItemAbilityBO, AgrAgreementSkuBO agrAgreementSkuBO) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("supplyCycle");
        list.add("isOilStr");
        list.add("markupRate");
        list.add("taxCatalog");
        list.add("saleStatus");
        list.add("buyNumber");
        agrAgreementSkuBO.setMaterialId(contractItemAbilityBO.getMaterialId().toString());
        agrAgreementSkuBO.setMaterialCode(contractItemAbilityBO.getMaterialCode());
        agrAgreementSkuBO.setMaterialName(contractItemAbilityBO.getMaterialName());
        agrAgreementSkuBO.setMaterialLongName(contractItemAbilityBO.getMaterialLongName());
        agrAgreementSkuBO.setModel(contractItemAbilityBO.getModel());
        agrAgreementSkuBO.setSpec(contractItemAbilityBO.getSpec());
        if (contractItemAbilityBO.getRate() == null) {
            list.add("taxRate");
        } else if (contractItemAbilityBO.getRate() == 0) {
            list.add("taxRate");
        }
        agrAgreementSkuBO.setTaxRate(Byte.valueOf(contractItemAbilityBO.getRate().byteValue()));
        agrAgreementSkuBO.setFigure(contractItemAbilityBO.getFigure());
        agrAgreementSkuBO.setCatalogId(contractItemAbilityBO.getCatalogId());
        agrAgreementSkuBO.setCatalogCode(contractItemAbilityBO.getCatalogCode());
        agrAgreementSkuBO.setCatalogName(contractItemAbilityBO.getCatalogName());
        agrAgreementSkuBO.setManufacturer(contractItemAbilityBO.getManufacturer());
        if (!StringUtils.isBlank((CharSequence)contractItemAbilityBO.getUnitId())) {
            agrAgreementSkuBO.setMeasureId(Long.valueOf(contractItemAbilityBO.getUnitId()));
        }
        agrAgreementSkuBO.setMeasureName(contractItemAbilityBO.getUnitName());
        if (contractItemAbilityBO.getAmount() != null) {
            agrAgreementSkuBO.setBuyNumber(contractItemAbilityBO.getAmount());
            agrAgreementSkuBO.setContractItemBuyNumber(contractItemAbilityBO.getAmount());
        } else {
            agrAgreementSkuBO.setBuyNumber(new BigDecimal("0"));
            agrAgreementSkuBO.setContractItemBuyNumber(new BigDecimal("0"));
        }
        if (contractItemAbilityBO.getTaxUnitPrice() == null) {
            list.add("buyPrice");
            agrAgreementSkuBO.setBuyPrice(Long.valueOf(0L));
            agrAgreementSkuBO.setBuyPriceSum(Long.valueOf(0L));
        } else {
            agrAgreementSkuBO.setBuyPrice(MoneyUtils.BigDecimal2Long((BigDecimal)contractItemAbilityBO.getTaxUnitPrice().setScale(2, 4)));
            agrAgreementSkuBO.setBuyPriceSum(MoneyUtils.BigDecimal2Long((BigDecimal)contractItemAbilityBO.getTaxUnitPrice().setScale(2, 4).multiply(agrAgreementSkuBO.getBuyNumber()).setScale(2, 4)));
        }
        agrAgreementSkuBO.setSkuSource("2");
        if (StringUtils.isBlank((CharSequence)contractItemAbilityBO.getQualityTechnicalRequirements())) {
            list.add("qualityRequire");
        }
        agrAgreementSkuBO.setQualityRequire(contractItemAbilityBO.getQualityTechnicalRequirements());
        if (StringUtils.isBlank((CharSequence)contractItemAbilityBO.getComponentID())) {
            list.add("partsNo");
        }
        agrAgreementSkuBO.setPartsNo(contractItemAbilityBO.getComponentID());
        if (StringUtils.isBlank((CharSequence)contractItemAbilityBO.getBrand())) {
            list.add("brandName");
        }
        agrAgreementSkuBO.setBrandName(contractItemAbilityBO.getBrand());
        agrAgreementSkuBO.setMarkupRate(Double.valueOf(0.0));
        agrAgreementSkuBO.setSaleStatus("2");
        if (StringUtils.isBlank((CharSequence)contractItemAbilityBO.getRemark())) {
            list.add("remark");
        }
        agrAgreementSkuBO.setRemark(contractItemAbilityBO.getRemark());
        agrAgreementSkuBO.setExtField7(((Object)list).toString());
        agrAgreementSkuBO.setContractItemId(contractItemAbilityBO.getItemId().toString());
    }
}

