/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAuditBO;
import com.tydic.agreement.ability.bo.AgrScopeSyncBO;
import com.tydic.agreement.ability.bo.AgrSkuStockInvalidBO;
import com.tydic.agreement.ability.bo.AgrskuChangePriceBO;
import com.tydic.agreement.atom.api.AgrAgreementStatusChangeAtomService;
import com.tydic.agreement.atom.api.AgrSyncSkuStatusToCommidityAtomService;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomRspBO;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomReqBO;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomRspBO;
import com.tydic.agreement.busi.api.AgrAgreementChangeApplyApprovalBusiService;
import com.tydic.agreement.busi.bo.AgrAgreementChangeApplyApprovalBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAgreementChangeApplyApprovalBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementAttachChangeMapper;
import com.tydic.agreement.dao.AgrAgreementAttachLogMapper;
import com.tydic.agreement.dao.AgrAuditMapper;
import com.tydic.agreement.dao.AgrDistributeAreaChangeMapper;
import com.tydic.agreement.dao.AgrDistributeAreaMapper;
import com.tydic.agreement.dao.AgreementAttachMapper;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementLogMapper;
import com.tydic.agreement.dao.AgreementMajorChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeChangeMapper;
import com.tydic.agreement.dao.AgreementScopeLogMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.AgreementSettlementLogMapper;
import com.tydic.agreement.dao.AgreementSettlementMapper;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.dao.AgreementSkuLogMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrAgreementAttachChangePO;
import com.tydic.agreement.po.AgrAgreementAttachLogPO;
import com.tydic.agreement.po.AgrAuditPO;
import com.tydic.agreement.po.AgrDistributeAreaChangePO;
import com.tydic.agreement.po.AgrDistributeAreaPO;
import com.tydic.agreement.po.AgreementAttachPO;
import com.tydic.agreement.po.AgreementChangePO;
import com.tydic.agreement.po.AgreementLogPO;
import com.tydic.agreement.po.AgreementMajorChangePO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementScopeChangePO;
import com.tydic.agreement.po.AgreementScopeLogPO;
import com.tydic.agreement.po.AgreementScopePO;
import com.tydic.agreement.po.AgreementSettlementLogPO;
import com.tydic.agreement.po.AgreementSettlementPO;
import com.tydic.agreement.po.AgreementSkuChangePO;
import com.tydic.agreement.po.AgreementSkuLogPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrAgreementChangeApplyApprovalBusiServiceImpl
implements AgrAgreementChangeApplyApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementChangeApplyApprovalBusiServiceImpl.class);
    @Autowired
    private AgreementChangeMapper agreementChangeMapper;
    @Autowired
    private AgrAuditMapper agrAuditMapper;
    @Autowired
    private AgreementSettlementLogMapper agreementSettlementLogMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private AgreementLogMapper agreementLogMapper;
    @Autowired
    private AgreementScopeLogMapper agreementScopeLogMapper;
    @Autowired
    private AgreementSkuLogMapper agreementSkuLogMapper;
    @Autowired
    private AgreementMajorChangeMapper agreementMajorChangeMapper;
    @Autowired
    private AgreementSkuChangeMapper agreementSkuChangeMapper;
    @Autowired
    private AgreementScopeChangeMapper agreementScopeChangeMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private AgrAgreementStatusChangeAtomService agrAgreementStatusChangeAtomService;
    @Autowired
    private AgrSyncSkuStatusToCommidityAtomService agrSyncSkuStatusToCommidityAtomService;
    @Autowired
    private AgreementAttachMapper agreementAttachMapper;
    @Autowired
    private AgrAgreementAttachLogMapper agrAgreementAttachLogMapper;
    @Autowired
    private AgrAgreementAttachChangeMapper agrAgreementAttachChangeMapper;
    @Autowired
    private AgreementSettlementMapper agreementSettlementMapper;
    private final String INVALID_SALE_STATUS = "3";
    @Autowired
    private AgrDistributeAreaChangeMapper agrDistributeAreaChangeMapper;
    @Autowired
    private AgrDistributeAreaMapper agrDistributeAreaMapper;

    @Override
    public AgrAgreementChangeApplyApprovalBusiRspBO approvalAgreementChangeApply(AgrAgreementChangeApplyApprovalBusiReqBO busiReqBO) {
        Map<Object, Object> stepChangeIdMap;
        AgrAgreementChangeApplyApprovalBusiRspBO busiRspBO = new AgrAgreementChangeApplyApprovalBusiRspBO();
        List<AgreementChangePO> agreementChangePOs = this.validAgreementChangeInfo(busiReqBO);
        ArrayList<Long> finish = new ArrayList<Long>();
        if (busiReqBO.getNotFindFlag().booleanValue()) {
            stepChangeIdMap = new HashMap();
            stepChangeIdMap.put("1", busiReqBO.getChangeIds());
        } else {
            stepChangeIdMap = this.validProcessInfo(busiReqBO);
        }
        for (String string : stepChangeIdMap.keySet()) {
            busiReqBO.setChangeIds((Set)stepChangeIdMap.get(string));
            Map<Long, Byte> map = this.validAgreementInfo(agreementChangePOs, busiReqBO.getSupplierId());
            Boolean processEndFlag = busiReqBO.getNotFindFlag() != false ? Boolean.valueOf(true) : this.invokeUacNoTaskAuditOrderAudit(string, busiReqBO);
            this.updateAgreementChangeMapper(processEndFlag, busiReqBO, map.keySet());
            if (processEndFlag.booleanValue() && AgrCommConstant.AuditResult.ADOPT.equals(busiReqBO.getAuditResult())) {
                Set<Long> skuChangeIds = this.updateAgreement(map, agreementChangePOs, busiReqBO.getSupplierId());
                if (skuChangeIds.size() > 0) {
                    this.updateAgreementSku(busiReqBO.getSupplierId(), skuChangeIds);
                }
                HashSet<Long> agreementIds = new HashSet<Long>();
                for (AgreementChangePO agreementChangePO : agreementChangePOs) {
                    finish.add(agreementChangePO.getAgreementId());
                    if (AgrCommConstant.AgreementChangeType.SUPPLEMENT.equals(agreementChangePO.getChangeType()) || AgrCommConstant.AgreementChangeType.CHANGE_PRICE.equals(agreementChangePO.getChangeType()) || AgrCommConstant.AgreementChangeType.OTHER.equals(agreementChangePO.getChangeType()) || AgrCommConstant.AgreementChangeType.TOTAL_CHANGE.equals(agreementChangePO.getChangeType())) {
                        agreementIds.add(agreementChangePO.getAgreementId());
                    }
                    if (!AgrCommConstant.AgreementChangeType.CHANGE_PRICE.equals(agreementChangePO.getChangeType())) continue;
                    AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO1 = new AgrSyncSkuStatusToCommidityAtomReqBO();
                    ArrayList<AgrskuChangePriceBO> agrskuChangePriceBOS = new ArrayList<AgrskuChangePriceBO>();
                    AgrskuChangePriceBO agrskuChangePriceBO = new AgrskuChangePriceBO();
                    agrskuChangePriceBO.setAgreementId(agreementChangePO.getAgreementId());
                    agrskuChangePriceBO.setAgreementSkuId(agreementChangePO.getAgreementSkuId());
                    agrskuChangePriceBO.setSalePrice(agreementChangePO.getSalePrice());
                    agrskuChangePriceBO.setBuyPrice(agreementChangePO.getBuyPrice());
                    agrskuChangePriceBOS.add(agrskuChangePriceBO);
                    atomReqBO1.setSkuChangePriceBOs(agrskuChangePriceBOS);
                    AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO1 = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO1);
                    log.info("\u4fee\u6539\u5546\u54c1\u5355\u4ef7===========================================" + atomRspBO1.getRespDesc().toString());
                }
                if (agreementIds.size() > 0) {
                    this.updateAgreementVersion(busiReqBO.getSupplierId(), agreementIds);
                }
                try {
                    Set<Long> set = this.updateLog(agreementChangePOs, busiReqBO.getSupplierId());
                    continue;
                }
                catch (Exception e) {
                    throw new com.tydic.uac.exception.BusinessException("0101", "\u4fee\u6539\u534f\u8bae\u7248\u672c\u5f02\u5e38\uff01\uff01" + e);
                }
            }
            if (!AgrCommConstant.AuditResult.NOT_PASS.equals(busiReqBO.getAuditResult())) continue;
            this.updateStopAgreementChange(busiReqBO.getSupplierId(), agreementChangePOs);
            for (AgreementChangePO agreementChangePO : agreementChangePOs) {
                AgreementLogPO agreementLogPO = new AgreementLogPO();
                agreementLogPO.setAgreementId(agreementChangePO.getAgreementId());
                agreementLogPO.setChangeCode(agreementChangePO.getChangeCode());
                try {
                    this.agreementLogMapper.deleteBy(agreementLogPO);
                }
                catch (Exception e) {
                    throw new BusinessException("22005", "\u534f\u8bae\u65e5\u5fd7\u8868\u5220\u9664\u5931\u8d25:" + e.getMessage());
                }
            }
        }
        busiRspBO.setAgreementIds(finish);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u534f\u8bae\u53d8\u66f4\u5ba1\u6279\u6210\u529f");
        return busiRspBO;
    }

    private List<AgreementChangePO> validAgreementChangeInfo(AgrAgreementChangeApplyApprovalBusiReqBO busiReqBO) {
        AgreementChangePO agreementChangePO = new AgreementChangePO();
        agreementChangePO.setSupplierId(busiReqBO.getSupplierId());
        agreementChangePO.setChangeIds(busiReqBO.getChangeIds());
        List<AgreementChangePO> agreementChangePOs = this.agreementChangeMapper.getList(agreementChangePO);
        if (CollectionUtils.isEmpty(agreementChangePOs)) {
            throw new com.tydic.uac.exception.BusinessException("22001", "\u53d8\u66f4\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        if (!busiReqBO.getNotFindFlag().booleanValue()) {
            HashSet<Long> statusErrors = new HashSet<Long>();
            HashSet<Long> changeIds = new HashSet<Long>();
            for (AgreementChangePO po : agreementChangePOs) {
                if (!AgrCommConstant.ChangeApplyStatus.IN_AUDIT.equals(po.getStatus())) {
                    statusErrors.add(po.getChangeId());
                }
                changeIds.add(po.getChangeId());
            }
            if (statusErrors.size() > 0 && !busiReqBO.getNotFindFlag().booleanValue()) {
                throw new com.tydic.uac.exception.BusinessException("22002", "\u53d8\u66f4\u7533\u8bf7\u3010" + ((Object)statusErrors).toString() + "\u3011\u72b6\u6001\u4e0d\u662f\u5ba1\u6838\u4e2d");
            }
            if (changeIds.size() < busiReqBO.getChangeIds().size()) {
                busiReqBO.getChangeIds().removeAll(changeIds);
                throw new com.tydic.uac.exception.BusinessException("22006", "\u53d8\u66f4\u7533\u8bf7\u3010" + busiReqBO.getChangeIds() + "\u3011\u4e0d\u5b58\u5728");
            }
        }
        return agreementChangePOs;
    }

    private Map<String, Set<Long>> validProcessInfo(AgrAgreementChangeApplyApprovalBusiReqBO busiReqBO) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>();
        AgrAuditPO agrAuditPO = new AgrAuditPO();
        agrAuditPO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_ADD_AUDIT);
        agrAuditPO.setObjIds(busiReqBO.getChangeIds());
        agrAuditPO.setTabValue(1);
        if (busiReqBO.getNotFindFlag().booleanValue()) {
            agrAuditPO.setTabValue(2);
        }
        agrAuditPO.setStationCodes(busiReqBO.getStationCodes());
        List<AgrAuditBO> agrAuditBOs = this.agrAuditMapper.getAuditInfoByObjIds(agrAuditPO);
        if (CollectionUtils.isEmpty(agrAuditBOs) && !busiReqBO.getNotFindFlag().booleanValue()) {
            throw new com.tydic.uac.exception.BusinessException("22001", "\u53d8\u66f4\u7533\u8bf7\u4e0d\u5b58\u5728\u6d41\u7a0b\u4fe1\u606f");
        }
        HashSet stepIds = new HashSet();
        HashSet<Long> auditSize = new HashSet<Long>();
        Object stepId = null;
        for (AgrAuditBO agrAuditBO : agrAuditBOs) {
            HashSet<Long> changeIdSet = (HashSet<Long>)result.get(agrAuditBO.getStepId());
            if (null == changeIdSet) {
                changeIdSet = new HashSet<Long>();
            }
            changeIdSet.add(agrAuditBO.getObjId());
            result.put(agrAuditBO.getStepId(), changeIdSet);
            auditSize.add(agrAuditBO.getObjId());
        }
        if (auditSize.size() < busiReqBO.getChangeIds().size()) {
            busiReqBO.getChangeIds().removeAll(auditSize);
            throw new com.tydic.uac.exception.BusinessException("22006", "\u53d8\u66f4\u7533\u8bf7\u3010" + busiReqBO.getChangeIds() + "\u3011\u4e0d\u5b58\u5728\u6d41\u7a0b\u4fe1\u606f");
        }
        return result;
    }

    private Map<Long, Byte> validAgreementInfo(List<AgreementChangePO> agreementChangePOs, Long supplierId) {
        HashMap<Long, Byte> result = new HashMap<Long, Byte>();
        HashSet<Long> agreementIds = new HashSet<Long>();
        for (AgreementChangePO po : agreementChangePOs) {
            agreementIds.add(po.getAgreementId());
        }
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setSupplierId(supplierId);
        agreementPO.setAgreementIds(new ArrayList<Long>(agreementIds));
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementPO> list = this.agreementMapper.checkByCondition(agreementPO);
        if (CollectionUtils.isEmpty(list)) {
            throw new com.tydic.uac.exception.BusinessException("22001", "\u534f\u8bae\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        for (AgreementPO agreementPO1 : list) {
            result.put(agreementPO1.getAgreementId(), agreementPO1.getAgreementStatus());
        }
        if (agreementIds.size() != result.keySet().size()) {
            agreementIds.removeAll(result.keySet());
            throw new com.tydic.uac.exception.BusinessException("22006", "\u534f\u8bae\u4fe1\u606f\u3010" + agreementIds + "\u3011\u4e0d\u5b58\u5728");
        }
        return result;
    }

    private Boolean invokeUacNoTaskAuditOrderAudit(String stepId, AgrAgreementChangeApplyApprovalBusiReqBO busiReqBO) {
        UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        uacNoTaskAuditOrderAuditReqBO.setObjId(new ArrayList<Long>(busiReqBO.getChangeIds()));
        uacNoTaskAuditOrderAuditReqBO.setStepId(stepId);
        uacNoTaskAuditOrderAuditReqBO.setAuditResult(busiReqBO.getAuditResult());
        uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(busiReqBO.getAuditAdvice());
        uacNoTaskAuditOrderAuditReqBO.setOperId(busiReqBO.getMemIdIn().toString());
        uacNoTaskAuditOrderAuditReqBO.setUsername(busiReqBO.getName());
        uacNoTaskAuditOrderAuditReqBO.setOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditOrderAuditReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_ADD_AUDIT);
        uacNoTaskAuditOrderAuditReqBO.setMsgFlag(Integer.valueOf(1));
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditReqBO));
        UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditRspBO));
        if (!"0000".equals(uacNoTaskAuditOrderAuditRspBO.getRespCode())) {
            throw new com.tydic.uac.exception.BusinessException(uacNoTaskAuditOrderAuditRspBO.getRespCode(), uacNoTaskAuditOrderAuditRspBO.getRespDesc());
        }
        return uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish();
    }

    private void updateAgreementChangeMapper(Boolean processEndFlag, AgrAgreementChangeApplyApprovalBusiReqBO busiReqBO, Set<Long> agreementIds) {
        if (processEndFlag.booleanValue()) {
            AgreementChangePO agreementChangePO = new AgreementChangePO();
            agreementChangePO.setChangeIds(busiReqBO.getChangeIds());
            agreementChangePO.setSupplierId(busiReqBO.getSupplierId());
            if (AgrCommConstant.AuditResult.ADOPT.equals(busiReqBO.getAuditResult())) {
                agreementChangePO.setStatus(AgrCommConstant.ChangeApplyStatus.PASS);
            } else if (AgrCommConstant.AuditResult.NOT_PASS.equals(busiReqBO.getAuditResult())) {
                agreementChangePO.setStatus(AgrCommConstant.ChangeApplyStatus.NO_PASS);
            } else {
                return;
            }
            int count = this.agreementChangeMapper.updateBy(agreementChangePO);
            if (count != busiReqBO.getChangeIds().size()) {
                throw new com.tydic.uac.exception.BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u53d8\u66f4\u8868\u72b6\u6001\u5931\u8d25");
            }
            AgreementPO agreementPO = new AgreementPO();
            agreementPO.setSupplierId(busiReqBO.getSupplierId());
            agreementPO.setAgreementIds(new ArrayList<Long>(agreementIds));
            agreementPO.setMaterialNameSum("");
            agreementPO.setAuditAdvice(busiReqBO.getAuditAdvice());
            agreementPO.setAuditResult(busiReqBO.getAuditResult());
            int count1 = this.agreementMapper.updateByCondition(agreementPO);
            if (count1 != agreementIds.size()) {
                throw new com.tydic.uac.exception.BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868extField1\u5931\u8d25");
            }
        }
    }

    private Set<Long> insertLog(List<AgreementChangePO> agreementChangePOs, Long supplierId) {
        HashSet<Long> agreementIds = new HashSet<Long>();
        if (agreementIds.size() > 0) {
            this.insertAgreementLog(agreementChangePOs, supplierId);
            this.insertAgreementSkuLog(agreementIds, supplierId);
            this.insertAgreementScopeLog(agreementIds, supplierId);
            this.insertAgreementAttachLog(agreementIds, supplierId);
        }
        return agreementIds;
    }

    private void insertAgreementSkuLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId) {
        int count;
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        agreementSkuPO.setSupplierId(supplierId);
        agreementSkuPO.setAgreementIds(agreementIds);
        agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementSkuPO> agreementSkuList = this.agreementSkuMapper.getList(agreementSkuPO);
        ArrayList<AgreementSkuLogPO> agreementSkuLogPOList = new ArrayList<AgreementSkuLogPO>();
        for (AgreementSkuPO agreementSkuPO1 : agreementSkuList) {
            AgreementSkuLogPO agreementSkuLogPO = new AgreementSkuLogPO();
            BeanUtils.copyProperties((Object)agreementSkuPO1, (Object)agreementSkuLogPO);
            agreementSkuLogPO.setAgreementLogId(agreementLogId);
            agreementSkuLogPOList.add(agreementSkuLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementSkuLogPOList) && (count = this.agreementSkuLogMapper.insertBatch(agreementSkuLogPOList)) != agreementSkuLogPOList.size()) {
            throw new com.tydic.uac.exception.BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementSettlementLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId) {
        int count;
        AgreementSettlementPO agreementSettlementPO = new AgreementSettlementPO();
        agreementSettlementPO.setAgreementIds(agreementIds);
        List<AgreementSettlementPO> list = this.agreementSettlementMapper.getList(agreementSettlementPO);
        ArrayList<AgreementSettlementLogPO> agreementSettlementLogPOList = new ArrayList<AgreementSettlementLogPO>();
        for (AgreementSettlementPO as : list) {
            AgreementSettlementLogPO agreementSettlementLogPO = new AgreementSettlementLogPO();
            BeanUtils.copyProperties((Object)as, (Object)agreementSettlementLogPO);
            Long settleMentLogId = Sequence.getInstance().nextId();
            agreementSettlementLogPO.setAgreementLogId(agreementLogId);
            agreementSettlementLogPO.setSettlementLogId(settleMentLogId);
            agreementSettlementLogPOList.add(agreementSettlementLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementSettlementLogPOList) && (count = this.agreementSettlementLogMapper.insertBatch(agreementSettlementLogPOList)) != agreementSettlementLogPOList.size()) {
            throw new com.tydic.uac.exception.BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementScopeLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId) {
        int count;
        AgreementScopePO agreementScopePO = new AgreementScopePO();
        agreementScopePO.setSupplierId(supplierId);
        agreementScopePO.setAgreementIds(agreementIds);
        agreementScopePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementScopePO> agreementScopeList = this.agreementScopeMapper.getList(agreementScopePO);
        ArrayList<AgreementScopeLogPO> agreementScopeLogPOList = new ArrayList<AgreementScopeLogPO>();
        for (AgreementScopePO agreementScopePO1 : agreementScopeList) {
            AgreementScopeLogPO agreementScopeLogPO = new AgreementScopeLogPO();
            BeanUtils.copyProperties((Object)agreementScopePO1, (Object)agreementScopeLogPO);
            agreementScopeLogPO.setAgreementLogId(agreementLogId);
            agreementScopeLogPOList.add(agreementScopeLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementScopeLogPOList) && (count = this.agreementScopeLogMapper.insertBatch(agreementScopeLogPOList)) != agreementScopeLogPOList.size()) {
            throw new com.tydic.uac.exception.BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u8303\u56f4\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementAttachLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId) {
        int count;
        AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
        agreementAttachPO.setSupplierId(supplierId);
        agreementAttachPO.setAgreementIds(agreementIds);
        agreementAttachPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementAttachPO> agreementAttachList = this.agreementAttachMapper.getList(agreementAttachPO);
        ArrayList<AgrAgreementAttachLogPO> agrAgreementAttachLogPOList = new ArrayList<AgrAgreementAttachLogPO>();
        for (AgreementAttachPO agreementAttachPO1 : agreementAttachList) {
            AgrAgreementAttachLogPO agrAgreementAttachLogPO = new AgrAgreementAttachLogPO();
            BeanUtils.copyProperties((Object)agreementAttachPO1, (Object)agrAgreementAttachLogPO);
            agrAgreementAttachLogPO.setAgreementLogId(agreementLogId);
            agrAgreementAttachLogPOList.add(agrAgreementAttachLogPO);
        }
        if (!CollectionUtils.isEmpty(agrAgreementAttachLogPOList) && (count = this.agrAgreementAttachLogMapper.insertBatch(agrAgreementAttachLogPOList)) != agrAgreementAttachLogPOList.size()) {
            throw new com.tydic.uac.exception.BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u9644\u4ef6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private Set<Long> updateLog(List<AgreementChangePO> agreementChangePOs, Long supplierId) {
        HashSet<Long> agreementIds = new HashSet<Long>();
        this.updateAgreementLog(agreementChangePOs, supplierId);
        return agreementIds;
    }

    private Set<Long> updateAgreement(Map<Long, Byte> map, List<AgreementChangePO> agreementChangePOs, Long supplierId) {
        HashSet<Long> stopAgreementIds = new HashSet<Long>();
        HashSet<Long> startAgreementIds = new HashSet<Long>();
        HashSet<Long> terminationAgreementIds = new HashSet<Long>();
        HashSet<Long> changeAgreementIds = new HashSet<Long>();
        HashSet<Long> delayAgreementIds = new HashSet<Long>();
        HashSet<AgreementChangePO> delayAgreementChangePOs = new HashSet<AgreementChangePO>();
        HashSet<Long> majorChangIds = new HashSet<Long>();
        HashSet<Long> stockChangIds = new HashSet<Long>();
        HashSet<Long> skuChangIds = new HashSet<Long>();
        block11: for (AgreementChangePO agreementChangePO : agreementChangePOs) {
            switch (agreementChangePO.getChangeType()) {
                case 1: {
                    stopAgreementIds.add(agreementChangePO.getAgreementId());
                    continue block11;
                }
                case 2: {
                    startAgreementIds.add(agreementChangePO.getAgreementId());
                    continue block11;
                }
                case 3: {
                    terminationAgreementIds.add(agreementChangePO.getAgreementId());
                    continue block11;
                }
                case 4: {
                    changeAgreementIds.add(agreementChangePO.getAgreementId());
                    skuChangIds.add(agreementChangePO.getChangeId());
                    continue block11;
                }
                case 5: {
                    delayAgreementIds.add(agreementChangePO.getAgreementId());
                    delayAgreementChangePOs.add(agreementChangePO);
                    continue block11;
                }
                case 6: {
                    skuChangIds.add(agreementChangePO.getChangeId());
                    continue block11;
                }
                case 7: {
                    majorChangIds.add(agreementChangePO.getChangeId());
                    skuChangIds.add(agreementChangePO.getChangeId());
                    continue block11;
                }
                case 8: {
                    stockChangIds.add(agreementChangePO.getAgreementId());
                    skuChangIds.add(agreementChangePO.getChangeId());
                    continue block11;
                }
                case 9: {
                    majorChangIds.add(agreementChangePO.getChangeId());
                    skuChangIds.add(agreementChangePO.getChangeId());
                    continue block11;
                }
            }
            throw new com.tydic.uac.exception.BusinessException("0002", "\u53d8\u66f4\u7c7b\u578b\u3010" + agreementChangePO.getChangeType() + "\u3011\u4e0d\u652f\u6301");
        }
        if (!CollectionUtils.isEmpty(stopAgreementIds)) {
            this.invokeAgreementStatusChange(supplierId, stopAgreementIds, AgrCommConstant.AgreementStatus.FROZEN, AgrCommConstant.AgreementStatus.SUSPEND);
        }
        if (!CollectionUtils.isEmpty(startAgreementIds)) {
            this.invokeAgreementStatusChange(supplierId, startAgreementIds, AgrCommConstant.AgreementStatus.SUSPEND, AgrCommConstant.AgreementStatus.ENABLE);
        }
        if (!CollectionUtils.isEmpty(terminationAgreementIds)) {
            HashSet<Long> startToTermination = new HashSet<Long>();
            for (Long agreementId : terminationAgreementIds) {
                if (!map.get(agreementId).equals(AgrCommConstant.AgreementStatus.ENABLE)) continue;
                startToTermination.add(agreementId);
                terminationAgreementIds.remove(agreementId);
            }
            if (!CollectionUtils.isEmpty(startToTermination)) {
                this.invokeAgreementStatusChange(supplierId, startToTermination, AgrCommConstant.AgreementStatus.ENABLE, AgrCommConstant.AgreementStatus.TERMINATION);
            }
            if (!CollectionUtils.isEmpty(terminationAgreementIds)) {
                this.invokeAgreementStatusChange(supplierId, terminationAgreementIds, AgrCommConstant.AgreementStatus.SUSPEND, AgrCommConstant.AgreementStatus.TERMINATION);
            }
        }
        if (!CollectionUtils.isEmpty(delayAgreementIds)) {
            for (Long l : delayAgreementIds) {
                if (map.get(l).equals(AgrCommConstant.AgreementStatus.BE_OVERDUE)) continue;
                delayAgreementIds.remove(l);
            }
            this.invokeAgreementStatusChange(supplierId, delayAgreementIds, AgrCommConstant.AgreementStatus.BE_OVERDUE, AgrCommConstant.AgreementStatus.ENABLE);
            this.dealDelayChange(delayAgreementChangePOs);
        }
        if (!CollectionUtils.isEmpty(changeAgreementIds)) {
            this.invokeAgreementStatusChange(supplierId, changeAgreementIds, AgrCommConstant.AgreementStatus.FROZEN, AgrCommConstant.AgreementStatus.ENABLE);
        }
        if (!CollectionUtils.isEmpty(majorChangIds)) {
            this.dealMajorChang(supplierId, majorChangIds);
        }
        if (!CollectionUtils.isEmpty(stockChangIds)) {
            this.invokeAgreementStatusChange(supplierId, stockChangIds, AgrCommConstant.AgreementStatus.FROZEN, AgrCommConstant.AgreementStatus.ENABLE);
        }
        return skuChangIds;
    }

    private void updateAgreementSku(Long supplierId, Set<Long> changIds) {
        ArrayList<Long> agreementSkuIds;
        ArrayList<AgreementSkuPO> addAgreementSkuPOList = new ArrayList<AgreementSkuPO>();
        ArrayList<AgreementSkuPO> updateAgreementSkuPOList = new ArrayList<AgreementSkuPO>();
        ArrayList<AgreementSkuPO> deleteAgreementSkuPOList = new ArrayList<AgreementSkuPO>();
        ArrayList<AgreementSkuPO> invalidAgreementSkuPOList = new ArrayList<AgreementSkuPO>();
        this.dealSkuChang(supplierId, changIds, addAgreementSkuPOList, updateAgreementSkuPOList, deleteAgreementSkuPOList, invalidAgreementSkuPOList);
        if (!CollectionUtils.isEmpty(addAgreementSkuPOList)) {
            ArrayList<AgreementSkuPO> list = new ArrayList<AgreementSkuPO>();
            for (AgreementSkuPO agreementSkuPO : addAgreementSkuPOList) {
                AgreementSkuPO addAgreementSkuPO = new AgreementSkuPO();
                BeanUtils.copyProperties((Object)agreementSkuPO, (Object)addAgreementSkuPO);
                addAgreementSkuPO.setAgreementSkuId(Sequence.getInstance().nextId());
                list.add(addAgreementSkuPO);
            }
            int count = this.agreementSkuMapper.insertBatch(list);
            if (count != list.size()) {
                throw new com.tydic.uac.exception.BusinessException("22005", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty(updateAgreementSkuPOList)) {
            Object atomRspBO;
            ArrayList<AgrskuChangePriceBO> skuChangePriceBOs = new ArrayList<AgrskuChangePriceBO>();
            for (AgreementSkuPO agreementSkuPO : updateAgreementSkuPOList) {
                AgreementSkuPO updateAgreementSkuPO = new AgreementSkuPO();
                BeanUtils.copyProperties((Object)agreementSkuPO, (Object)updateAgreementSkuPO);
                AgrskuChangePriceBO bo = new AgrskuChangePriceBO();
                if (StringUtils.hasText((String)agreementSkuPO.getExtField1()) && StringUtils.hasText((String)agreementSkuPO.getExtField2())) {
                    updateAgreementSkuPO.setBuyNumber(agreementSkuPO.getBuyNumber().add(new BigDecimal(agreementSkuPO.getExtField1()).subtract(new BigDecimal(agreementSkuPO.getExtField2()))));
                    bo.setBuyNumber(new BigDecimal(agreementSkuPO.getExtField1()).subtract(new BigDecimal(agreementSkuPO.getExtField2())));
                }
                updateAgreementSkuPO.setExtField1(null);
                updateAgreementSkuPO.setExtField2(null);
                updateAgreementSkuPO.setExtField3(null);
                updateAgreementSkuPO.setCurrentStockNumber(updateAgreementSkuPO.getBuyNumber());
                int count = this.agreementSkuMapper.updateBy(updateAgreementSkuPO);
                if (count < 1) {
                    throw new com.tydic.uac.exception.BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25");
                }
                bo.setAgreementId(agreementSkuPO.getAgreementId());
                bo.setAgreementSkuId(agreementSkuPO.getAgreementSkuId());
                bo.setBuyPrice(agreementSkuPO.getBuyPrice());
                bo.setSalePrice(agreementSkuPO.getSalePrice());
                if ("3".equals(agreementSkuPO.getSaleStatus())) {
                    bo.setCommiditySkuStatus(AgrCommConstant.CommiditySkuStatus.INVALID);
                }
                skuChangePriceBOs.add(bo);
            }
            AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
            atomReqBO.setSkuChangePriceBOs(skuChangePriceBOs);
            if (!CollectionUtils.isEmpty(invalidAgreementSkuPOList)) {
                ArrayList<Long> agreementSkuIds2 = new ArrayList<Long>();
                for (AgreementSkuPO agreementSkuPO : invalidAgreementSkuPOList) {
                    agreementSkuIds2.add(agreementSkuPO.getAgreementSkuId());
                }
                AgrSkuStockInvalidBO agrSkuStockInvalidBO = new AgrSkuStockInvalidBO();
                agrSkuStockInvalidBO.setSkuStatus(AgrCommConstant.CommiditySkuStatus.INVALID_STATUS);
                agrSkuStockInvalidBO.setAgreementSkuIds(new HashSet(agreementSkuIds2));
                atomReqBO.setSkuStockInvalidBO(agrSkuStockInvalidBO);
            }
            if (!"0000".equals((atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO)).getRespCode())) {
                throw new com.tydic.uac.exception.BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespCode());
            }
        }
        if (!CollectionUtils.isEmpty(deleteAgreementSkuPOList)) {
            agreementSkuIds = new ArrayList<Long>();
            HashSet<Long> agreementIds = new HashSet<Long>();
            for (AgreementSkuPO agreementSkuPO : deleteAgreementSkuPOList) {
                agreementSkuIds.add(agreementSkuPO.getAgreementSkuId());
                agreementIds.add(agreementSkuPO.getAgreementId());
            }
            AgreementSkuPO agreementSkuPO1 = new AgreementSkuPO();
            agreementSkuPO1.setSupplierId(supplierId);
            agreementSkuPO1.setAgreementSkuIds(agreementSkuIds);
            agreementSkuPO1.setAgreementIds(agreementIds);
            int count = this.agreementSkuMapper.deleteBy(agreementSkuPO1);
            if (count != agreementSkuIds.size()) {
                throw new com.tydic.uac.exception.BusinessException("22005", "\u5220\u9664\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25");
            }
            AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
            atomReqBO.setSkuStatus(AgrCommConstant.CommiditySkuStatus.AGREEMENT_INVALID);
            atomReqBO.setAgreementSkuIds(new HashSet<Long>(agreementSkuIds));
            AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new com.tydic.uac.exception.BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespCode());
            }
        }
        if (!CollectionUtils.isEmpty(invalidAgreementSkuPOList) && CollectionUtils.isEmpty(updateAgreementSkuPOList)) {
            agreementSkuIds = new ArrayList();
            HashSet<Long> agreementIds = new HashSet<Long>();
            for (AgreementSkuPO agreementSkuPO : invalidAgreementSkuPOList) {
                agreementSkuIds.add(agreementSkuPO.getAgreementSkuId());
                agreementIds.add(agreementSkuPO.getAgreementId());
            }
            AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
            atomReqBO.setSkuStatus(AgrCommConstant.CommiditySkuStatus.INVALID_STATUS);
            atomReqBO.setAgreementSkuIds(new HashSet<Long>(agreementSkuIds));
            AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new com.tydic.uac.exception.BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespCode());
            }
        }
    }

    private void updateAgreementVersion(Long supplierId, Set<Long> agreementIdSet) {
        int count = this.agreementMapper.updateAgreementVersion(supplierId, agreementIdSet);
        if (count != agreementIdSet.size()) {
            throw new com.tydic.uac.exception.BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868\u7248\u672c\u53f7\u5931\u8d25");
        }
        this.agreementScopeMapper.updateAgreementVersion(supplierId, agreementIdSet);
        this.agreementSkuMapper.updateAgreementVersion(supplierId, agreementIdSet);
        this.agreementAttachMapper.updateAgreementVersion(supplierId, agreementIdSet);
    }

    private void updateStopAgreementChange(Long supplierId, List<AgreementChangePO> agreementChangePOs) {
        HashSet<Long> stopAgreementIds = new HashSet<Long>();
        for (AgreementChangePO agreementChangePO : agreementChangePOs) {
            switch (agreementChangePO.getChangeType()) {
                case 1: {
                    stopAgreementIds.add(agreementChangePO.getAgreementId());
                    break;
                }
                case 4: {
                    stopAgreementIds.add(agreementChangePO.getAgreementId());
                }
            }
        }
        if (!CollectionUtils.isEmpty(stopAgreementIds)) {
            this.invokeAgreementStatusChange(supplierId, stopAgreementIds, AgrCommConstant.AgreementStatus.FROZEN, AgrCommConstant.AgreementStatus.ENABLE);
        }
    }

    private void purduceSpecialInfo(List<AgreementChangePO> agreementChangePOs, AgrAgreementChangeApplyApprovalBusiReqBO busiReqBO) {
        if (AgrCommConstant.AuditResult.NOT_PASS.equals(busiReqBO.getAuditResult())) {
            HashSet<Long> agreements = new HashSet<Long>();
            for (AgreementChangePO agreementChangePO : agreementChangePOs) {
                if (!AgrCommConstant.AgreementChangeType.STOP.equals(agreementChangePO.getChangeType())) continue;
                agreements.add(agreementChangePO.getAgreementId());
            }
            if (!CollectionUtils.isEmpty(agreements)) {
                this.invokeAgreementStatusChange(busiReqBO.getSupplierId(), agreements, AgrCommConstant.AgreementStatus.FROZEN, AgrCommConstant.AgreementStatus.ENABLE);
            }
        }
    }

    private List<AgrScopeSyncBO> updateAgreementScope(Set<Long> changIds, Long supplierId) {
        AgreementScopeChangePO agreementScopeChangePO = new AgreementScopeChangePO();
        agreementScopeChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        agreementScopeChangePO.setSupplierId(supplierId);
        agreementScopeChangePO.setChangeIds(changIds);
        List<AgreementScopeChangePO> agreementScopeChangeList = this.agreementScopeChangeMapper.getList(agreementScopeChangePO);
        ArrayList<AgreementScopePO> addAgreementScopePOList = new ArrayList<AgreementScopePO>();
        if (!CollectionUtils.isEmpty(agreementScopeChangeList)) {
            for (AgreementScopeChangePO agreementScopeChangePO1 : agreementScopeChangeList) {
                AgreementScopePO agreementScopePO = new AgreementScopePO();
                BeanUtils.copyProperties((Object)agreementScopeChangePO1, (Object)agreementScopePO);
                addAgreementScopePOList.add(agreementScopePO);
            }
        }
        ArrayList<AgrScopeSyncBO> agrScopeSyncBOS = new ArrayList<AgrScopeSyncBO>();
        HashMap syncMap = new HashMap();
        if (!CollectionUtils.isEmpty(addAgreementScopePOList)) {
            List<Long> agrIds = addAgreementScopePOList.stream().map(a -> a.getAgreementId()).distinct().collect(Collectors.toList());
            List<AgreementPO> agreementPOS = this.agreementMapper.selectAgrLessSubjectList(agrIds);
            Map<Object, Object> agrAndVendor = new HashMap();
            if (!CollectionUtils.isEmpty(agreementPOS)) {
                agrAndVendor = agreementPOS.stream().collect(Collectors.toMap(a -> a.getAgreementId(), b -> b.getVendorId(), (o, n) -> o));
            }
            HashSet<Long> agreementIds = new HashSet<Long>();
            for (AgreementScopePO agreementScopePO : addAgreementScopePOList) {
                List<AgreementScopePO> scopeCodes;
                agreementIds.add(agreementScopePO.getAgreementId());
                if (syncMap.get(agreementScopePO.getAgreementId()) != null) {
                    scopeCodes = (List)syncMap.get(agreementScopePO.getAgreementId());
                    scopeCodes.add(agreementScopePO);
                    syncMap.put(agreementScopePO.getAgreementId(), scopeCodes);
                    continue;
                }
                scopeCodes = new ArrayList<AgreementScopePO>();
                scopeCodes.add(agreementScopePO);
                syncMap.put(agreementScopePO.getAgreementId(), scopeCodes);
            }
            for (Map.Entry entry : syncMap.entrySet()) {
                AgrScopeSyncBO agrScopeSyncBO = new AgrScopeSyncBO();
                agrScopeSyncBO.setAgreementId((Long)entry.getKey());
                List scopePOS = (List)entry.getValue();
                if (scopePOS.size() == 1 && ((AgreementScopePO)scopePOS.get(0)).getScopeType().equals((byte)0)) {
                    agrScopeSyncBO.setScopeCodes("*");
                } else {
                    ArrayList<Object> scopeCodes = new ArrayList<Object>();
                    for (AgreementScopePO agreementScopePO : scopePOS) {
                        scopeCodes.add(agreementScopePO.getScopeCode());
                    }
                    if (agrAndVendor.get(agrScopeSyncBO.getAgreementId()) != null) {
                        scopeCodes.add(agrAndVendor.get(agrScopeSyncBO.getAgreementId()));
                    }
                    agrScopeSyncBO.setScopeCodes(((Object)scopeCodes).toString());
                }
                agrScopeSyncBOS.add(agrScopeSyncBO);
            }
            log.info("AgreementScopePO:" + JSON.toJSONString(agrScopeSyncBOS));
            AgreementScopePO agreementScopePO = new AgreementScopePO();
            agreementScopePO.setAgreementIds(agreementIds);
            agreementScopePO.setSupplierId(supplierId);
            this.agreementScopeMapper.deleteBy(agreementScopePO);
            int n2 = this.agreementScopeMapper.insertBatch(addAgreementScopePOList);
            if (n2 < addAgreementScopePOList.size()) {
                throw new com.tydic.uac.exception.BusinessException("22005", "\u65b0\u589e\u534f\u8bae\u8303\u56f4\u8868\u5931\u8d25");
            }
        }
        return agrScopeSyncBOS;
    }

    private void updateAgreementAttach(Set<Long> changIds, Long supplierId) {
        AgrAgreementAttachChangePO agrAgreementAttachChangePO = new AgrAgreementAttachChangePO();
        agrAgreementAttachChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        agrAgreementAttachChangePO.setSupplierId(supplierId);
        agrAgreementAttachChangePO.setChangeIds(changIds);
        List<AgrAgreementAttachChangePO> agrAgreementAttachChangePOList = this.agrAgreementAttachChangeMapper.getList(agrAgreementAttachChangePO);
        ArrayList<AgreementAttachPO> addAgreementAttachPOList = new ArrayList<AgreementAttachPO>();
        if (!CollectionUtils.isEmpty(agrAgreementAttachChangePOList)) {
            for (AgrAgreementAttachChangePO agrAgreementAttachChangePO2 : agrAgreementAttachChangePOList) {
                AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
                BeanUtils.copyProperties((Object)agrAgreementAttachChangePO2, (Object)agreementAttachPO);
                addAgreementAttachPOList.add(agreementAttachPO);
            }
        }
        if (!CollectionUtils.isEmpty(addAgreementAttachPOList)) {
            HashSet<Long> agreementIds = new HashSet<Long>();
            for (AgreementAttachPO po : addAgreementAttachPOList) {
                agreementIds.add(po.getAgreementId());
            }
            AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
            agreementAttachPO.setAgreementIds(agreementIds);
            agreementAttachPO.setSupplierId(supplierId);
            this.agreementAttachMapper.deleteBy(agreementAttachPO);
            int count2 = this.agreementAttachMapper.insertBatch(addAgreementAttachPOList);
            if (count2 < addAgreementAttachPOList.size()) {
                throw new com.tydic.uac.exception.BusinessException("22005", "\u65b0\u589e\u534f\u8bae\u9644\u4ef6\u8868\u5931\u8d25");
            }
        }
    }

    private void invokeAgreementStatusChange(Long supplierId, Set<Long> agreementIds, Byte preStatus, Byte posStatus) {
        if (!CollectionUtils.isEmpty(agreementIds)) {
            AgrAgreementStatusChangeAtomReqBO atomReqBO = new AgrAgreementStatusChangeAtomReqBO();
            atomReqBO.setSupplierId(supplierId);
            atomReqBO.setAgreementIds(agreementIds);
            atomReqBO.setAgreementStatusPre(preStatus);
            atomReqBO.setAgreementStatusPost(posStatus);
            AgrAgreementStatusChangeAtomRspBO atomRspBO = this.agrAgreementStatusChangeAtomService.updateAgreementStatus(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new com.tydic.uac.exception.BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
        }
    }

    private void dealMajorChang(Long supplierId, Set<Long> changIds) {
        AgreementMajorChangePO agreementMajorChangePO = new AgreementMajorChangePO();
        agreementMajorChangePO.setSupplierId(supplierId);
        agreementMajorChangePO.setChangeIds(changIds);
        agreementMajorChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementMajorChangePO> list = this.agreementMajorChangeMapper.getList(agreementMajorChangePO);
        if (!CollectionUtils.isEmpty(list)) {
            for (AgreementMajorChangePO agreementMajorChangePO1 : list) {
                AgreementPO agreementPO = new AgreementPO();
                BeanUtils.copyProperties((Object)agreementMajorChangePO1, (Object)agreementPO);
                int count = this.agreementMapper.updateByMajorChange(agreementPO);
                if (count != 1) {
                    throw new com.tydic.uac.exception.BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868\u5931\u8d25");
                }
                AgreementSettlementPO queryPO = new AgreementSettlementPO();
                queryPO.setChangeId(agreementMajorChangePO1.getChangeId());
                List<AgreementSettlementPO> agreementSettlementPOList = this.agreementSettlementMapper.getList(queryPO);
                AgreementSettlementPO deletePO = new AgreementSettlementPO();
                deletePO.setAgreementId(agreementMajorChangePO1.getAgreementId());
                this.agreementSettlementMapper.deleteBy(deletePO);
                if (CollectionUtils.isEmpty(agreementSettlementPOList)) continue;
                ArrayList<AgreementSettlementPO> poList = new ArrayList<AgreementSettlementPO>();
                for (AgreementSettlementPO po : agreementSettlementPOList) {
                    AgreementSettlementPO agreementSettlementPO = new AgreementSettlementPO();
                    BeanUtils.copyProperties((Object)po, (Object)agreementSettlementPO);
                    Long settlementId = Sequence.getInstance().nextId();
                    agreementSettlementPO.setSettlementId(settlementId);
                    agreementSettlementPO.setChangeId(null);
                    agreementSettlementPO.setAgreementId(agreementMajorChangePO1.getAgreementId());
                    agreementSettlementPO.setSettlementId(settlementId);
                    poList.add(agreementSettlementPO);
                }
                this.agreementSettlementMapper.insertBatch(poList);
            }
        }
        List<AgrScopeSyncBO> agrScopeSyncBOSet = this.updateAgreementScope(changIds, supplierId);
        this.updateAgreementDistributeArea(changIds);
        AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
        atomReqBO.setAgrScopeSyncBOs(agrScopeSyncBOSet);
        AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new com.tydic.uac.exception.BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespCode());
        }
        this.updateAgreementAttach(changIds, supplierId);
    }

    private void updateAgreementDistributeArea(Set<Long> changIds) {
        if (!CollectionUtils.isEmpty(changIds)) {
            AgrDistributeAreaChangePO agrDistributeAreaChangePO = new AgrDistributeAreaChangePO();
            agrDistributeAreaChangePO.setChangeIds(Lists.newArrayList(changIds));
            List<AgrDistributeAreaChangePO> agrDistributeAreaChangePOS = this.agrDistributeAreaChangeMapper.getList(agrDistributeAreaChangePO);
            if (!CollectionUtils.isEmpty(agrDistributeAreaChangePOS)) {
                List<Long> agreementIds = agrDistributeAreaChangePOS.stream().map(a -> a.getAgreementId()).distinct().collect(Collectors.toList());
                ArrayList<AgrDistributeAreaPO> insertList = new ArrayList<AgrDistributeAreaPO>();
                for (AgrDistributeAreaChangePO distributeAreaChangePO : agrDistributeAreaChangePOS) {
                    AgrDistributeAreaPO agrDistributeAreaPO = new AgrDistributeAreaPO();
                    BeanUtils.copyProperties((Object)distributeAreaChangePO, (Object)agrDistributeAreaPO);
                    agrDistributeAreaPO.setId(Sequence.getInstance().nextId());
                    insertList.add(agrDistributeAreaPO);
                }
                if (!CollectionUtils.isEmpty(agreementIds)) {
                    AgrDistributeAreaPO agrDistributeAreaPO = new AgrDistributeAreaPO();
                    agrDistributeAreaPO.setAgreementIds(agreementIds);
                    this.agrDistributeAreaMapper.deleteBy(agrDistributeAreaPO);
                }
                if (!CollectionUtils.isEmpty(insertList)) {
                    this.agrDistributeAreaMapper.insertBatch(insertList);
                }
            }
        }
    }

    private void dealSkuChang(Long supplierId, Set<Long> changIds, List<AgreementSkuPO> addAgreementSkuPOList, List<AgreementSkuPO> updateAgreementSkuPOList, List<AgreementSkuPO> deleteAgreementSkuPOList, List<AgreementSkuPO> invalidAgreementSkuPOList) {
        List<Long> agreementSkuIds;
        AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
        agreementSkuChangePO.setSupplierId(supplierId);
        agreementSkuChangePO.setChangeIds(changIds);
        agreementSkuChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementSkuChangePO> list = this.agreementSkuChangeMapper.getList(agreementSkuChangePO);
        List<Object> efficientAgreementSkuIds = new ArrayList();
        if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(agreementSkuIds = list.stream().filter(e -> e.getAgreementSkuId() != null).map(AgreementSkuChangePO::getAgreementSkuId).collect(Collectors.toList()))) {
            AgreementSkuPO seachOldPO = new AgreementSkuPO();
            seachOldPO.setAgreementSkuIds(agreementSkuIds);
            List<AgreementSkuPO> agreementSkuPOS = this.agreementSkuMapper.getList(seachOldPO);
            if (!CollectionUtils.isEmpty(agreementSkuPOS)) {
                efficientAgreementSkuIds = agreementSkuPOS.stream().filter(e -> StringUtils.isEmpty((Object)e.getSaleStatus()) || !e.getSaleStatus().equals("3")).map(AgreementSkuPO::getAgreementSkuId).collect(Collectors.toList());
            }
        }
        if (!CollectionUtils.isEmpty(list)) {
            for (AgreementSkuChangePO agreementSkuChangePO1 : list) {
                AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
                if (AgrCommConstant.AgreementSkuChangeType.ADD.equals(agreementSkuChangePO1.getChangeType())) {
                    BeanUtils.copyProperties((Object)agreementSkuChangePO1, (Object)agreementSkuPO);
                    agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                    addAgreementSkuPOList.add(agreementSkuPO);
                    continue;
                }
                if (AgrCommConstant.AgreementSkuChangeType.UPDATE.equals(agreementSkuChangePO1.getChangeType())) {
                    agreementSkuPO.setAgreementSkuId(agreementSkuChangePO1.getAgreementSkuId());
                    agreementSkuPO.setBuyPrice(agreementSkuChangePO1.getBuyPrice());
                    agreementSkuPO.setBuyPriceSum(agreementSkuChangePO1.getBuyPriceSum());
                    agreementSkuPO.setSalePrice(agreementSkuChangePO1.getSalePrice());
                    agreementSkuPO.setSalePriceSum(agreementSkuChangePO1.getSalePriceSum());
                    agreementSkuPO.setMarkupRate(agreementSkuChangePO1.getMarkupRate());
                    agreementSkuPO.setUpdateLoginId(agreementSkuChangePO1.getCreateLoginId());
                    agreementSkuPO.setUpdateName(agreementSkuChangePO1.getCreateName());
                    agreementSkuPO.setAgreementId(agreementSkuChangePO1.getAgreementId());
                    agreementSkuPO.setBuyNumber(agreementSkuChangePO1.getBuyNumber());
                    agreementSkuPO.setExtField1(agreementSkuChangePO1.getExtField1());
                    agreementSkuPO.setExtField2(agreementSkuChangePO1.getExtField2());
                    agreementSkuPO.setSaleStatus(agreementSkuChangePO1.getSaleStatus());
                    agreementSkuPO.setTaxCatalog(agreementSkuChangePO1.getTaxCatalog());
                    agreementSkuPO.setTaxRate(agreementSkuChangePO1.getTaxRate());
                    agreementSkuPO.setBrandName(agreementSkuChangePO1.getBrandName());
                    agreementSkuPO.setBrandId(agreementSkuChangePO1.getBrandId());
                    agreementSkuPO.setIsOil(agreementSkuChangePO1.getIsOil());
                    agreementSkuPO.setSupplyCycle(agreementSkuChangePO1.getSupplyCycle());
                    agreementSkuPO.setManufacturer(agreementSkuChangePO1.getManufacturer());
                    updateAgreementSkuPOList.add(agreementSkuPO);
                    if (agreementSkuChangePO1.getAgreementSkuId() == null || !"3".equals(agreementSkuChangePO1.getSaleStatus()) || !efficientAgreementSkuIds.contains(agreementSkuChangePO1.getAgreementSkuId())) continue;
                    AgreementSkuPO invalidAgreementSkuPO = new AgreementSkuPO();
                    invalidAgreementSkuPO.setAgreementSkuId(agreementSkuChangePO1.getAgreementSkuId());
                    invalidAgreementSkuPO.setAgreementId(agreementSkuChangePO1.getAgreementId());
                    invalidAgreementSkuPOList.add(invalidAgreementSkuPO);
                    continue;
                }
                agreementSkuPO.setAgreementSkuId(agreementSkuChangePO1.getAgreementSkuId());
                agreementSkuPO.setUpdateLoginId(agreementSkuChangePO1.getCreateLoginId());
                agreementSkuPO.setUpdateTime(agreementSkuChangePO1.getCreateTime());
                agreementSkuPO.setUpdateName(agreementSkuChangePO1.getCreateName());
                agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.DELETED);
                agreementSkuPO.setAgreementId(agreementSkuChangePO1.getAgreementId());
                agreementSkuPO.setSaleStatus(agreementSkuChangePO1.getSaleStatus());
                deleteAgreementSkuPOList.add(agreementSkuPO);
            }
        }
    }

    private void insertAgreementLog(List<AgreementChangePO> agreementChangePOs, Long supplierId) {
        for (AgreementChangePO agreementChangePO : agreementChangePOs) {
            AgreementPO agreementPO = new AgreementPO();
            agreementPO.setSupplierId(supplierId);
            agreementPO.setAgreementId(agreementChangePO.getAgreementId());
            agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            AgreementPO ao = this.agreementMapper.getModelBy(agreementPO);
            Long agreementLogId = Sequence.getInstance().nextId();
            AgreementLogPO agreementLogPO = new AgreementLogPO();
            BeanUtils.copyProperties((Object)ao, (Object)agreementLogPO);
            agreementLogPO.setLogStatus("2");
            agreementLogPO.setChangeCode(agreementChangePO.getChangeCode());
            agreementLogPO.setChangeType(agreementChangePO.getChangeType());
            agreementLogPO.setAgreementLogId(agreementLogId);
            AgreementLogPO apo = new AgreementLogPO();
            apo.setAgreementId(agreementChangePO.getAgreementId());
            apo.setLogStatus("1");
            this.agreementLogMapper.updateBy(apo);
            int n = this.agreementLogMapper.insert(agreementLogPO);
        }
    }

    private void updateAgreementLog(List<AgreementChangePO> agreementChangePOs, Long supplierId) {
        ArrayList<AgreementChangePO> agreementChangePOSet = new ArrayList<AgreementChangePO>();
        for (AgreementChangePO agreementChangePO : agreementChangePOs) {
            List agreementIds = agreementChangePOSet.stream().map(AgreementChangePO::getAgreementId).collect(Collectors.toList());
            if (agreementIds.contains(agreementChangePO.getAgreementId())) continue;
            agreementChangePOSet.add(agreementChangePO);
        }
        log.info("==============\u53bb\u91cd\u540e\u7684\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f\uff1a" + agreementChangePOSet);
        HashSet<Long> agreementIds = new HashSet<Long>();
        for (AgreementChangePO agreementChangePO : agreementChangePOSet) {
            agreementIds.add(agreementChangePO.getAgreementId());
            AgreementPO agreementPO = new AgreementPO();
            agreementPO.setSupplierId(supplierId);
            agreementPO.setAgreementId(agreementChangePO.getAgreementId());
            agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            AgreementPO ao = this.agreementMapper.getModelBy(agreementPO);
            AgreementLogPO agreementLogPO = new AgreementLogPO();
            agreementLogPO.setLogStatus("0");
            agreementLogPO.setAgreementId(agreementChangePO.getAgreementId());
            agreementLogPO.setChangeType(agreementChangePO.getChangeType());
            AgreementLogPO alo = this.agreementLogMapper.getModelBy(agreementLogPO);
            log.info("\u5ba1\u6279\u4e2d\u65e5\u5fd7====================" + alo);
            if (alo == null) {
                throw new com.tydic.uac.exception.BusinessException("22003", "\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u5ba1\u6279\u4e2d\u65e5\u5fd7");
            }
            AgreementLogPO apo = new AgreementLogPO();
            apo.setAgreementId(agreementChangePO.getAgreementId());
            apo.setLogStatus("1");
            apo.setPreLogStatus("2");
            this.agreementLogMapper.updateBy(apo);
            AgreementLogPO al = new AgreementLogPO();
            al.setAgreementId(agreementChangePO.getAgreementId());
            al.setLogStatus("2");
            al.setPreLogStatus("0");
            al.setAgreementVersion(ao.getAgreementVersion());
            this.agreementLogMapper.updateBy(al);
            this.insertAgreementSkuLog(agreementIds, agreementChangePO.getSupplierId(), alo.getAgreementLogId());
            this.insertAgreementScopeLog(agreementIds, agreementChangePO.getSupplierId(), alo.getAgreementLogId());
            this.insertAgreementAttachLog(agreementIds, agreementChangePO.getSupplierId(), alo.getAgreementLogId());
            this.insertAgreementSettlementLog(agreementIds, agreementChangePO.getSupplierId(), alo.getAgreementLogId());
        }
    }

    private void insertAgreementSkuLog(Set<Long> agreementIds, Long supplierId) {
        int count;
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        agreementSkuPO.setSupplierId(supplierId);
        agreementSkuPO.setAgreementIds(agreementIds);
        agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementSkuPO> agreementSkuList = this.agreementSkuMapper.getList(agreementSkuPO);
        ArrayList<AgreementSkuLogPO> agreementSkuLogPOList = new ArrayList<AgreementSkuLogPO>();
        for (AgreementSkuPO agreementSkuPO1 : agreementSkuList) {
            AgreementSkuLogPO agreementSkuLogPO = new AgreementSkuLogPO();
            BeanUtils.copyProperties((Object)agreementSkuPO1, (Object)agreementSkuLogPO);
            agreementSkuLogPOList.add(agreementSkuLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementSkuLogPOList) && (count = this.agreementSkuLogMapper.insertBatch(agreementSkuLogPOList)) != agreementSkuLogPOList.size()) {
            throw new com.tydic.uac.exception.BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementScopeLog(Set<Long> agreementIds, Long supplierId) {
        int count;
        AgreementScopePO agreementScopePO = new AgreementScopePO();
        agreementScopePO.setSupplierId(supplierId);
        agreementScopePO.setAgreementIds(agreementIds);
        agreementScopePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementScopePO> agreementScopeList = this.agreementScopeMapper.getList(agreementScopePO);
        ArrayList<AgreementScopeLogPO> agreementScopeLogPOList = new ArrayList<AgreementScopeLogPO>();
        for (AgreementScopePO agreementScopePO1 : agreementScopeList) {
            AgreementScopeLogPO agreementScopeLogPO = new AgreementScopeLogPO();
            BeanUtils.copyProperties((Object)agreementScopePO1, (Object)agreementScopeLogPO);
            agreementScopeLogPOList.add(agreementScopeLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementScopeLogPOList) && (count = this.agreementScopeLogMapper.insertBatch(agreementScopeLogPOList)) != agreementScopeLogPOList.size()) {
            throw new com.tydic.uac.exception.BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u8303\u56f4\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementAttachLog(Set<Long> agreementIds, Long supplierId) {
        int count;
        AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
        agreementAttachPO.setSupplierId(supplierId);
        agreementAttachPO.setAgreementIds(agreementIds);
        agreementAttachPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementAttachPO> agreementAttachList = this.agreementAttachMapper.getList(agreementAttachPO);
        ArrayList<AgrAgreementAttachLogPO> agrAgreementAttachLogPOList = new ArrayList<AgrAgreementAttachLogPO>();
        for (AgreementAttachPO agreementAttachPO1 : agreementAttachList) {
            AgrAgreementAttachLogPO agrAgreementAttachLogPO = new AgrAgreementAttachLogPO();
            BeanUtils.copyProperties((Object)agreementAttachPO1, (Object)agrAgreementAttachLogPO);
            agrAgreementAttachLogPOList.add(agrAgreementAttachLogPO);
        }
        if (!CollectionUtils.isEmpty(agrAgreementAttachLogPOList) && (count = this.agrAgreementAttachLogMapper.insertBatch(agrAgreementAttachLogPOList)) != agrAgreementAttachLogPOList.size()) {
            throw new com.tydic.uac.exception.BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u9644\u4ef6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void dealDelayChange(Set<AgreementChangePO> delayAgreementChangePOs) {
        if (!CollectionUtils.isEmpty(delayAgreementChangePOs)) {
            for (AgreementChangePO po : delayAgreementChangePOs) {
                AgreementPO agreementPO = new AgreementPO();
                agreementPO.setSupplierId(po.getSupplierId());
                agreementPO.setAgreementId(po.getAgreementId());
                agreementPO.setExpDate(po.getPostInvalidDate());
                int count = this.agreementMapper.updateByCondition(agreementPO);
                if (count == 1) continue;
                throw new com.tydic.uac.exception.BusinessException("22005", "\u66f4\u65b0\u534f\u8bae\u8868\u534f\u8bae\u3010" + po.getAgreementId() + "\u3011\u5230\u671f\u65f6\u95f4\u5931\u8d25");
            }
        }
    }
}

