/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.ability.bo.AgrImoprtTemplateBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrExternalImportResultLogAtomReqBO;
import com.tydic.agreement.atom.bo.AgrExternalImportResultLogAtomRspBO;
import com.tydic.agreement.atom.impl.CnncAgrExternalImportResultLogServiceHolder;
import com.tydic.agreement.busi.api.AgrBatchImportAgreementSkuBusiService;
import com.tydic.agreement.busi.api.AgrCnncAgrExportImportResultsBusiService;
import com.tydic.agreement.busi.bo.AgrBatchImportAgreementSkuBusiReqBO;
import com.tydic.agreement.busi.bo.AgrBatchImportAgreementSkuBusiRspBO;
import com.tydic.agreement.busi.bo.AgrExportImportResultsBusiReqBO;
import com.tydic.agreement.busi.bo.AgrExportImportResultsBusiRspBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuByPageBusiReqBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.constants.AgrExtCommonConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.utils.ExcelUtils;
import com.tydic.agreement.utils.HttpUtil;
import com.tydic.cfc.ability.api.CfcMeasureQryAbilityService;
import com.tydic.cfc.ability.bo.CfcMeasureQryAbilityBo;
import com.tydic.cfc.ability.bo.CfcMeasureQryAbilityReqBo;
import com.tydic.cfc.ability.bo.CfcMeasureQryAbilityRspBo;
import com.tydic.commodity.base.bo.UccEMdmMaterialBO;
import com.tydic.commodity.common.ability.api.UccCodegenerationAbilityService;
import com.tydic.commodity.common.ability.api.UccMallBrandDetailInfoGroupListAbilityService;
import com.tydic.commodity.common.ability.api.UccMdmCatalogsearchAbilityService;
import com.tydic.commodity.common.ability.api.UccQryCommodityTypeListAbilityService;
import com.tydic.commodity.common.ability.api.UccThematerialsearchAbilityService;
import com.tydic.commodity.common.ability.bo.UccCodegenerationAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCodegenerationAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccMallBrandDetailInfoGroupListAbilityBo;
import com.tydic.commodity.common.ability.bo.UccMallBrandDetailInfoGroupListAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccMallBrandDetailInfoGroupListAbilityRspBo;
import com.tydic.commodity.common.ability.bo.UccMdmCatalogsearchAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccMdmCatalogsearchAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccMdmCatalogsearchBO;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityRspBO;
import com.tydic.commodity.zone.ability.api.UccAgrSkuImportCheckAbilityService;
import com.tydic.uac.exception.BusinessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AgrBatchImportAgreementSkuBusiServiceImpl
implements AgrBatchImportAgreementSkuBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrBatchImportAgreementSkuBusiServiceImpl.class);
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private UccAgrSkuImportCheckAbilityService uccAgrSkuImportCheckAbilityService;
    @Autowired
    private UccThematerialsearchAbilityService uccMaterialInfoQueryAbilityService;
    @Autowired
    private UccQryCommodityTypeListAbilityService uccQryCommodityTypeListAbilityService;
    @Autowired
    private CfcMeasureQryAbilityService cfcMeasureQryAbilityService;
    @Autowired
    private CnncAgrExternalImportResultLogServiceHolder cnncAgrExternalImportResultLogServiceHolder;
    @Autowired
    private AgrCnncAgrExportImportResultsBusiService cnncAgrExportImportResultsBusiService;
    @Autowired
    private UccCodegenerationAbilityService uccCodegenerationAbilityService;
    @Autowired
    private UccMdmCatalogsearchAbilityService uccMdmCatalogsearchAbilityService;
    @Autowired
    private UccMallBrandDetailInfoGroupListAbilityService uccMallBrandDetailInfoGroupListAbilityService;
    @Value(value="${normal_title_count:12}")
    private int normalTitleCount;
    @Value(value="${normal_title_count:10}")
    private int supermarketStaffTitleCount;

    @Override
    public AgrBatchImportAgreementSkuBusiRspBO dealAgrDetailedBatchImportAgreement(AgrBatchImportAgreementSkuBusiReqBO busiReqBO) {
        List brandNames;
        List agreementSkuPOs;
        AgrBatchImportAgreementSkuBusiRspBO rsp = new AgrBatchImportAgreementSkuBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        if (!(AgrCommConstant.AgreementStatus.DRAFT.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.REJECT.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.NO_ASS.equals(agreement.getAgreementStatus()))) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d,\u672a\u5b8c\u6210\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u521b\u5efa\u534f\u8bae\u660e\u7ec6\uff01");
        }
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            String fileName = "content_" + new Date().getTime() + ".xlsx";
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/" + fileName);
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(busiReqBO.getUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            this.getExcelDateByImport((MultipartFile)multipartFile, data, title, busiReqBO.getImportAgrSkuType());
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("22052", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(data)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        log.info("\u6807\u9898:{}", (Object)JSON.toJSONString(title));
        HashMap<String, Integer> dateMapIndex = new HashMap<String, Integer>();
        String pCode = "";
        pCode = busiReqBO.getImportAgrSkuType() == 1 ? "IMPORT_TEMPLATE_PCODE" : "SUPERMARKET_STAFF_IMPORT_TEMPLATE_PCODE";
        String importTemplateStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", pCode, "1");
        List templateBOs = JSON.parseArray((String)importTemplateStr, AgrImoprtTemplateBO.class);
        block6: for (AgrImoprtTemplateBO bo : templateBOs) {
            for (int i = 0; i < title.size(); ++i) {
                if (!((String)title.get(i)).equals(bo.getFieldName())) continue;
                dateMapIndex.put(bo.getFieldNameEng(), i);
                continue block6;
            }
        }
        ArrayList importDataMaps = new ArrayList();
        log.info("data:" + data);
        log.info("dateMapIndex:" + dateMapIndex);
        log.info("templateBOs:" + templateBOs);
        ArrayList dateMaps = new ArrayList();
        for (List list : data) {
            boolean importErrMsgFlag = false;
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            StringBuilder importRemark = new StringBuilder();
            for (AgrImoprtTemplateBO bo : templateBOs) {
                Integer sheetKey = (Integer)dateMapIndex.get(bo.getFieldNameEng());
                if (null == sheetKey) {
                    importErrMsgFlag = true;
                    importRemark.setLength(0);
                    importRemark.append("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6570\u636e\u5e93\u6a21\u7248\u914d\u7f6e\u7684\u3010").append(bo.getFieldNameEng()).append("\u3011\u4e3a\u7a7a\uff01");
                    continue;
                }
                if (sheetKey >= list.size()) continue;
                String content = (String)list.get(sheetKey);
                if (bo.getIsMustFill().booleanValue()) {
                    if (null == content || "".equals(content) || "null".equals(content)) {
                        importErrMsgFlag = true;
                        importRemark.setLength(0);
                        importRemark.append("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u3010").append(bo.getFieldName()).append("\u3011\u5fc5\u586b\uff01");
                        continue;
                    }
                } else if ("null".equals(content)) {
                    content = "";
                }
                if ("isOil".equals(bo.getFieldNameEng())) {
                    String isOil = content;
                    if (StringUtils.isEmpty((Object)isOil)) {
                        isOil = "0";
                    } else {
                        if (!"\u5426".equals(isOil) && !"\u662f".equals(isOil)) {
                            importErrMsgFlag = true;
                            importRemark.setLength(0);
                            importRemark.append("\u662f\u5426\u6210\u54c1\u6cb9\u53ea\u80fd\u586b\u662f\u6216\u8005\u5426");
                            continue;
                        }
                        if ("\u5426".equals(isOil)) {
                            content = "0";
                        }
                        if ("\u662f".equals(isOil)) {
                            content = "1";
                        }
                    }
                }
                if ("saleStatus".equals(bo.getFieldNameEng())) {
                    String saleStatus = content;
                    if (StringUtils.isEmpty((Object)saleStatus)) {
                        content = "0";
                    } else if (!("\u6709\u6548".equals(saleStatus) || "\u9650\u91cf".equals(saleStatus) || "\u5931\u6548".equals(saleStatus))) {
                        importErrMsgFlag = true;
                        importRemark.setLength(0);
                        importRemark.append("\u9500\u552e\u72b6\u6001\u53ea\u80fd\u586b\u6709\u6548/\u9650\u91cf/\u5931\u6548");
                    } else {
                        if ("\u6709\u6548".equals(saleStatus)) {
                            content = "1";
                        }
                        if ("\u9650\u91cf".equals(saleStatus)) {
                            content = "2";
                        }
                        if ("\u5931\u6548".equals(saleStatus)) {
                            content = "3";
                        }
                    }
                }
                if ("markupRate".equals(bo.getFieldNameEng())) {
                    String markupRate = content;
                    if (StringUtils.isEmpty((Object)markupRate)) {
                        markupRate = "0";
                    }
                    if (agreement.getTradeMode() == 2 && !markupRate.equals("0")) {
                        importErrMsgFlag = true;
                        importRemark.setLength(0);
                        importRemark.append("\u534f\u8bae\u7684\u8d38\u6613\u6a21\u5f0f\u4e3a\u64ae\u5408\u6a21\u5f0f\u65f6\u52a0\u4ef7\u6bd4\u7387\u5fc5\u987b\u4e3a0");
                    }
                    content = markupRate = new BigDecimal(markupRate).divide(new BigDecimal(100)).toString();
                }
                if ("buyPrice".equals(bo.getFieldNameEng())) {
                    String buyPrice = content;
                    content = (buyPrice = new BigDecimal(buyPrice).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? buyPrice.substring(0, buyPrice.lastIndexOf(".00")) : buyPrice;
                    content = content.replace(".0", "");
                }
                if ("salePrice".equals(bo.getFieldNameEng())) {
                    String salePrice = content;
                    content = (salePrice = new BigDecimal(salePrice).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? salePrice.substring(0, salePrice.lastIndexOf(".00")) : salePrice;
                    content = content.replace(".0", "");
                }
                if ("buyNumber".equals(bo.getFieldNameEng())) {
                    content = content.replace(",", "");
                }
                dataMap.put(bo.getFieldNameEng(), content);
            }
            if (importErrMsgFlag) {
                dataMap.put("impResult", AgrExtCommonConstant.ImportResult.FAILED);
                dataMap.put("impRemark", importRemark.toString());
            } else {
                dataMap.put("impRemark", "\u6210\u529f");
                dataMap.put("impResult", AgrExtCommonConstant.ImportResult.SUCCESS);
            }
            importDataMaps.add(dataMap);
        }
        String jsonStr = JSON.toJSONString(importDataMaps);
        log.info("\u83b7\u53d6\u5230\u7684\u6570\u636e\u5bf9\u8c61\uff1a" + jsonStr);
        try {
            agreementSkuPOs = JSON.parseArray((String)jsonStr, AgreementSkuPO.class);
        }
        catch (Exception exception) {
            throw new BusinessException("22052", "\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
        }
        if (agreementSkuPOs.size() > 3000) {
            throw new BusinessException("0002", "\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u4e0d\u80fd\u8d85\u8fc7 3000\u6761\uff01");
        }
        ArrayList arrayList = new ArrayList();
        HashSet<String> materialCodeSet = new HashSet<String>();
        HashSet<String> settlementUnitNameList = new HashSet<String>();
        if (busiReqBO.getImportAgrSkuType() == 1) {
            for (int i = 0; i < agreementSkuPOs.size(); ++i) {
                if (materialCodeSet.contains(((AgreementSkuPO)agreementSkuPOs.get(i)).getMaterialCode())) {
                    throw new BusinessException("0002", "\u5b58\u5728\u76f8\u540c\u7269\u6599\u201c" + ((AgreementSkuPO)agreementSkuPOs.get(i)).getMaterialCode() + "\u201d\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165");
                }
                materialCodeSet.add(((AgreementSkuPO)agreementSkuPOs.get(i)).getMaterialCode());
                if (((AgreementSkuPO)agreementSkuPOs.get(i)).getIsOil() != null && 1 == ((AgreementSkuPO)agreementSkuPOs.get(i)).getIsOil()) {
                    if (StringUtils.isEmpty((Object)((AgreementSkuPO)agreementSkuPOs.get(i)).getSettlementUnitName())) {
                        ((AgreementSkuPO)agreementSkuPOs.get(i)).setImpRemark("\u662f\u5426\u6210\u54c1\u6cb9\u4e3a\u662f\u65f6\uff0c\u7ed3\u7b97\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!");
                        ((AgreementSkuPO)agreementSkuPOs.get(i)).setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    }
                    if (StringUtils.isEmpty((Object)((AgreementSkuPO)agreementSkuPOs.get(i)).getPackingRate())) {
                        ((AgreementSkuPO)agreementSkuPOs.get(i)).setImpRemark("\u662f\u5426\u6210\u54c1\u6cb9\u4e3a\u662f\u65f6\uff0c\u5305\u88c5\u8f6c\u6362\u7387\u4e0d\u80fd\u4e3a\u7a7a!");
                        ((AgreementSkuPO)agreementSkuPOs.get(i)).setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    }
                }
                if (StringUtils.isEmpty((Object)((AgreementSkuPO)agreementSkuPOs.get(i)).getSettlementUnitName())) continue;
                settlementUnitNameList.add(((AgreementSkuPO)agreementSkuPOs.get(i)).getSettlementUnitName());
            }
            UccThematerialsearchAbilityReqBO uccThematerialsearchAbilityReqBO = new UccThematerialsearchAbilityReqBO();
            uccThematerialsearchAbilityReqBO.setMaterialCodes(new ArrayList(materialCodeSet));
            uccThematerialsearchAbilityReqBO.setPageNo(-1);
            uccThematerialsearchAbilityReqBO.setPageSize(-1);
            if (log.isDebugEnabled()) {
                log.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u5165\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccThematerialsearchAbilityReqBO));
            }
            UccThematerialsearchAbilityRspBO uccThematerialsearchAbilityRspBO = this.uccMaterialInfoQueryAbilityService.dealUccThematerialsearch(uccThematerialsearchAbilityReqBO);
            if (log.isDebugEnabled()) {
                log.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u51fa\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccThematerialsearchAbilityRspBO));
            }
            if ("0000".equals(uccThematerialsearchAbilityRspBO.getRespCode())) {
                Map uccRspMap = uccThematerialsearchAbilityRspBO.getRows().stream().collect(Collectors.toMap(UccEMdmMaterialBO::getMaterialCode, Function.identity()));
                for (Object agreementSkuPO : agreementSkuPOs) {
                    UccEMdmMaterialBO uccEMdmMaterialBO = (UccEMdmMaterialBO)uccRspMap.get(((AgreementSkuPO)agreementSkuPO).getMaterialCode());
                    if (uccEMdmMaterialBO != null) {
                        ((AgreementSkuPO)agreementSkuPO).setMeasureId(uccEMdmMaterialBO.getMeasureId());
                        ((AgreementSkuPO)agreementSkuPO).setMeasureName(uccEMdmMaterialBO.getMeasure());
                        ((AgreementSkuPO)agreementSkuPO).setMaterialId(uccEMdmMaterialBO.getMaterialId().toString());
                        ((AgreementSkuPO)agreementSkuPO).setCatalogId(uccEMdmMaterialBO.getCatalogId().toString());
                        ((AgreementSkuPO)agreementSkuPO).setCatalogCode(uccEMdmMaterialBO.getCatalogCode());
                        ((AgreementSkuPO)agreementSkuPO).setCatalogName(uccEMdmMaterialBO.getCatalogName());
                        ((AgreementSkuPO)agreementSkuPO).setCommodityTypeId(uccEMdmMaterialBO.getCommodityTypeId());
                        ((AgreementSkuPO)agreementSkuPO).setCommodityTypeName(uccEMdmMaterialBO.getCommodityTypeName());
                        ((AgreementSkuPO)agreementSkuPO).setFigure(uccEMdmMaterialBO.getFigure());
                        ((AgreementSkuPO)agreementSkuPO).setPartsNo(uccEMdmMaterialBO.getPartNo());
                        ((AgreementSkuPO)agreementSkuPO).setManufacturer(uccEMdmMaterialBO.getManufacturer());
                        ((AgreementSkuPO)agreementSkuPO).setSpec(uccEMdmMaterialBO.getSpec());
                        ((AgreementSkuPO)agreementSkuPO).setMaterialLongName(uccEMdmMaterialBO.getLongDesc());
                        ((AgreementSkuPO)agreementSkuPO).setMaterialName(uccEMdmMaterialBO.getMaterialName());
                        continue;
                    }
                    ((AgreementSkuPO)agreementSkuPO).setImpRemark("\u7269\u8d44\u7f16\u7801\u3010" + ((AgreementSkuPO)agreementSkuPO).getMaterialCode() + "\u3011\u4e0d\u5b58\u5728!");
                    ((AgreementSkuPO)agreementSkuPO).setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                }
            } else {
                for (AgreementSkuPO agreementSkuPO : agreementSkuPOs) {
                    agreementSkuPO.setImpRemark("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165" + uccThematerialsearchAbilityRspBO.getRespDesc());
                    agreementSkuPO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                }
            }
            AgrQryAgreementSkuByPageBusiReqBO qryAgreementSkuByPageBusiReqBO = new AgrQryAgreementSkuByPageBusiReqBO();
            qryAgreementSkuByPageBusiReqBO.setAgreementId(busiReqBO.getAgreementId());
            List<AgrAgreementSkuBO> originalList = this.agreementSkuMapper.getListByCondition(qryAgreementSkuByPageBusiReqBO);
            originalList.forEach(agrAgreementSkuBO -> {
                if (materialCodeSet.contains(agrAgreementSkuBO.getMaterialCode())) {
                    throw new BusinessException("0002", "\u5b58\u5728\u76f8\u540c\u7269\u6599\u201c" + agrAgreementSkuBO.getMaterialName() + "\u201d\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165");
                }
                materialCodeSet.add(agrAgreementSkuBO.getMaterialCode());
            });
        } else {
            UccCodegenerationAbilityReqBO uccCodegenerationAbilityReqBO = new UccCodegenerationAbilityReqBO();
            uccCodegenerationAbilityReqBO.setCodeType("01");
            uccCodegenerationAbilityReqBO.setCount(Integer.valueOf(agreementSkuPOs.size()));
            UccCodegenerationAbilityRspBO uccCodegenerationAbilityRspBO = this.uccCodegenerationAbilityService.dealUccCodegeneration(uccCodegenerationAbilityReqBO);
            List codeList = new ArrayList();
            if (!"0000".equals(uccCodegenerationAbilityRspBO.getRespCode())) {
                throw new BusinessException("0002", "\u83b7\u53d6\u5546\u54c1\u7f16\u7801\u5931\u8d25" + uccCodegenerationAbilityRspBO.getRespDesc());
            }
            codeList = uccCodegenerationAbilityRspBO.getCodeList();
            Iterator catalogCodes = agreementSkuPOs.stream().map(a -> a.getCatalogCode()).distinct().collect(Collectors.toList());
            UccMdmCatalogsearchAbilityReqBO uccMdmCatalogsearchAbilityReqBO = new UccMdmCatalogsearchAbilityReqBO();
            uccMdmCatalogsearchAbilityReqBO.setCatalogCodes(catalogCodes);
            uccMdmCatalogsearchAbilityReqBO.setPageNo(-1);
            UccMdmCatalogsearchAbilityRspBO uccMdmCatalogsearchAbilityRspBO = this.uccMdmCatalogsearchAbilityService.qrymdmCatalogsearch(uccMdmCatalogsearchAbilityReqBO);
            Map<Object, Object> catalogsearchBOMap = new HashMap();
            if (!"0000".equals(uccMdmCatalogsearchAbilityRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)uccMdmCatalogsearchAbilityRspBO.getRows())) {
                throw new BusinessException("0002", "\u83b7\u53d6\u5546\u54c1\u5206\u7c7b\u4fe1\u606f\u5931\u8d25" + uccMdmCatalogsearchAbilityRspBO.getRespDesc());
            }
            catalogsearchBOMap = uccMdmCatalogsearchAbilityRspBO.getRows().stream().collect(Collectors.toMap(a -> a.getCatalogCode(), a -> a, (first, second) -> first));
            for (int i = 0; i < agreementSkuPOs.size(); ++i) {
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setSettlementUnitName(((AgreementSkuPO)agreementSkuPOs.get(i)).getMeasureName());
                settlementUnitNameList.add(((AgreementSkuPO)agreementSkuPOs.get(i)).getMeasureName());
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setMaterialId((String)codeList.get(i));
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setMaterialCode((String)codeList.get(i));
                UccMdmCatalogsearchBO uccMdmCatalogsearchBO = (UccMdmCatalogsearchBO)catalogsearchBOMap.get(((AgreementSkuPO)agreementSkuPOs.get(i)).getCatalogCode());
                if (null == uccMdmCatalogsearchBO) {
                    ((AgreementSkuPO)agreementSkuPOs.get(i)).setImpRemark("\u5546\u54c1\u5206\u7c7b\u3010" + ((AgreementSkuPO)agreementSkuPOs.get(i)).getCatalogCode() + "\u3011\u4e0d\u5b58\u5728!");
                    ((AgreementSkuPO)agreementSkuPOs.get(i)).setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    continue;
                }
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setCatalogId(uccMdmCatalogsearchBO.getCatalogId().toString());
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setCatalogName(uccMdmCatalogsearchBO.getCatalogName());
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setCommodityTypeId(uccMdmCatalogsearchBO.getCommodityTypeId());
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setCommodityTypeName(uccMdmCatalogsearchBO.getCommodityTypeName());
            }
        }
        if (!CollectionUtils.isEmpty(settlementUnitNameList)) {
            CfcMeasureQryAbilityReqBo cfcMeasureQryAbilityReqBo = new CfcMeasureQryAbilityReqBo();
            cfcMeasureQryAbilityReqBo.setMeasureNameList(new ArrayList(settlementUnitNameList));
            CfcMeasureQryAbilityRspBo cfcMeasureQryAbilityRspBo = this.cfcMeasureQryAbilityService.qryMeasure(cfcMeasureQryAbilityReqBo);
            if (cfcMeasureQryAbilityRspBo.getRespCode().equals("0000")) {
                Map measureBoMap = cfcMeasureQryAbilityRspBo.getRows().stream().collect(Collectors.toMap(CfcMeasureQryAbilityBo::getMeasureName, Function.identity(), (key1, key2) -> key2));
                if (!CollectionUtils.isEmpty(measureBoMap)) {
                    for (Object agreementSkuPO : agreementSkuPOs) {
                        CfcMeasureQryAbilityBo cfcMeasureQryAbilityBo = (CfcMeasureQryAbilityBo)measureBoMap.get(((AgreementSkuPO)agreementSkuPO).getSettlementUnitName());
                        if (cfcMeasureQryAbilityBo != null) {
                            if (cfcMeasureQryAbilityBo.getStatus() == null || cfcMeasureQryAbilityBo.getStatus().equals("00")) {
                                ((AgreementSkuPO)agreementSkuPO).setImpRemark("\u8ba1\u91cf\u5355\u4f4d" + ((AgreementSkuPO)agreementSkuPO).getSettlementUnitName() + "\u72b6\u6001\u4e3a\u505c\u7528\u72b6\u6001!");
                                ((AgreementSkuPO)agreementSkuPO).setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                                continue;
                            }
                            ((AgreementSkuPO)agreementSkuPO).setSettlementUnitId(cfcMeasureQryAbilityBo.getId().toString());
                            if (busiReqBO.getImportAgrSkuType() == 1) continue;
                            ((AgreementSkuPO)agreementSkuPO).setMeasureId(cfcMeasureQryAbilityBo.getId());
                            continue;
                        }
                        if (StringUtils.isEmpty((Object)((AgreementSkuPO)agreementSkuPO).getSettlementUnitName())) continue;
                        ((AgreementSkuPO)agreementSkuPO).setImpRemark("\u8ba1\u91cf\u5355\u4f4d" + ((AgreementSkuPO)agreementSkuPO).getSettlementUnitName() + "\u4e0d\u5b58\u5728!");
                        ((AgreementSkuPO)agreementSkuPO).setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    }
                } else {
                    for (Object agreementSkuPO : agreementSkuPOs) {
                        if (StringUtils.isEmpty((Object)((AgreementSkuPO)agreementSkuPO).getSettlementUnitName())) continue;
                        ((AgreementSkuPO)agreementSkuPO).setImpRemark("\u8ba1\u91cf\u5355\u4f4d" + ((AgreementSkuPO)agreementSkuPO).getSettlementUnitName() + "\u4e0d\u5b58\u5728!");
                        ((AgreementSkuPO)agreementSkuPO).setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(brandNames = agreementSkuPOs.stream().filter(a -> !StringUtils.isEmpty((Object)a.getBrandName())).map(a -> a.getBrandName()).distinct().collect(Collectors.toList()))) {
            UccMallBrandDetailInfoGroupListAbilityReqBo uccMallBrandDetailInfoGroupListAbilityReqBo = new UccMallBrandDetailInfoGroupListAbilityReqBo();
            uccMallBrandDetailInfoGroupListAbilityReqBo.setMallBrandNames(brandNames);
            uccMallBrandDetailInfoGroupListAbilityReqBo.setPageNo(1);
            uccMallBrandDetailInfoGroupListAbilityReqBo.setPageSize(brandNames.size());
            UccMallBrandDetailInfoGroupListAbilityRspBo uccMallBrandDetailInfoGroupListAbilityRspBo = this.uccMallBrandDetailInfoGroupListAbilityService.qryMallBrandDetailGroup(uccMallBrandDetailInfoGroupListAbilityReqBo);
            if ("0000".equals(uccMallBrandDetailInfoGroupListAbilityRspBo.getRespCode())) {
                List mallBrandBos = uccMallBrandDetailInfoGroupListAbilityRspBo.getRows();
                if (CollectionUtils.isEmpty((Collection)mallBrandBos)) {
                    for (Object agreementSkuPO : agreementSkuPOs) {
                        ((AgreementSkuPO)agreementSkuPO).setImpRemark("\u54c1\u724c" + ((AgreementSkuPO)agreementSkuPO).getBrandName() + "\u4e0d\u5b58\u5728!");
                        ((AgreementSkuPO)agreementSkuPO).setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    }
                } else {
                    Map<String, UccMallBrandDetailInfoGroupListAbilityBo> brandMap = mallBrandBos.stream().collect(Collectors.toMap(a -> a.getMallBrandName(), b -> b, (first, second) -> first));
                    for (AgreementSkuPO agreementSkuPO : agreementSkuPOs) {
                        UccMallBrandDetailInfoGroupListAbilityBo brandBo = brandMap.get(agreementSkuPO.getBrandName());
                        if (brandBo != null) {
                            if (brandBo.getBrandStatus() == null || brandBo.getBrandStatus() != 1) {
                                agreementSkuPO.setImpRemark("\u54c1\u724c" + agreementSkuPO.getSettlementUnitName() + "\u72b6\u6001\u4e0d\u4e3a\u542f\u7528\u72b6\u6001!");
                                agreementSkuPO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                                continue;
                            }
                            agreementSkuPO.setBrandId(brandBo.getMallBrandId());
                            continue;
                        }
                        agreementSkuPO.setImpRemark("\u54c1\u724c" + agreementSkuPO.getBrandName() + "\u4e0d\u5b58\u5728!");
                        agreementSkuPO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    }
                }
            }
        }
        ArrayList<AgreementSkuPO> insertSkuPoList = new ArrayList<AgreementSkuPO>();
        BigDecimal bd = new BigDecimal("10000");
        for (AgreementSkuPO po : agreementSkuPOs) {
            try {
                if (po.getMarkupRate() == null) {
                    po.setMarkupRate(new BigDecimal("0").divide(new BigDecimal(100)).doubleValue());
                }
                if (busiReqBO.getImportAgrSkuType() == null || busiReqBO.getImportAgrSkuType() != 1) {
                    po.setSettlementUnitName(null);
                    po.setSettlementUnitId(null);
                }
                po.setAgreementSkuId(Sequence.getInstance().nextId());
                po.setAgreementId(agreement.getAgreementId());
                po.setSupplierId(agreement.getSupplierId());
                po.setAgreementVersion(agreement.getAgreementVersion());
                po.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
                po.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                po.setCreateLoginId(busiReqBO.getMemIdIn());
                po.setCreateName(busiReqBO.getUserName());
                po.setCreateTime(new Date());
                po.setSkuSource("1");
                if (po.getSalePrice() == null) {
                    po.setSalePrice(new BigDecimal(po.getBuyPrice()).add(new BigDecimal(po.getBuyPrice()).multiply(new BigDecimal(po.getMarkupRate().toString()))).longValue());
                    BigDecimal bAmount = new BigDecimal(po.getSalePrice()).divide(bd).setScale(2, 4).multiply(bd).stripTrailingZeros();
                    po.setSalePrice(bAmount.longValue());
                }
                if (po.getBuyNumber() != null) {
                    po.setBuyPriceSum(new BigDecimal(po.getBuyPrice()).multiply(po.getBuyNumber()).longValue());
                    po.setSalePriceSum(new BigDecimal(po.getSalePrice()).multiply(po.getBuyNumber()).longValue());
                }
                po.setMarkupRate(new BigDecimal(po.getMarkupRate().toString()).multiply(new BigDecimal(100)).doubleValue());
                if (po.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) {
                    insertSkuPoList.add(po);
                }
                po.setCurrentStockNumber(po.getBuyNumber());
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38:" + e.toString());
            }
        }
        List agrAgreementSkuBOList = JSON.parseArray((String)JSON.toJSONString((Object)agreementSkuPOs), AgrAgreementSkuBO.class);
        AgrExportImportResultsBusiReqBO importResultsBusiReqBO = new AgrExportImportResultsBusiReqBO();
        importResultsBusiReqBO.setImportSkuList(agrAgreementSkuBOList);
        importResultsBusiReqBO.setTradeMode(agreement.getTradeMode());
        log.error("\u8c03\u7528\u5bfc\u51fa\u6587\u4ef6\u5165\u53c2:" + JSON.toJSONString((Object)importResultsBusiReqBO));
        AgrExportImportResultsBusiRspBO importResultsBusiRspBO = this.cnncAgrExportImportResultsBusiService.exportImportResults(importResultsBusiReqBO);
        log.error("\u8c03\u7528\u5bfc\u51fa\u6587\u4ef6\u51fa\u53c2:" + JSON.toJSONString((Object)((Object)importResultsBusiRspBO)));
        if (!importResultsBusiRspBO.getRespCode().equals("0000")) {
            rsp.setRespCode("8888");
            rsp.setRespCode(importResultsBusiRspBO.getRespCode());
            return rsp;
        }
        Long failedImportCounts = 0L;
        Long sucessImportCounts = 0L;
        for (AgreementSkuPO agreementSkuPO : agreementSkuPOs) {
            Long l;
            Long l2;
            if (agreementSkuPO.getImpResult().equals(AgrExtCommonConstant.ImportResult.FAILED)) {
                l2 = failedImportCounts;
                l = failedImportCounts = Long.valueOf(failedImportCounts + 1L);
                continue;
            }
            if (!agreementSkuPO.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) continue;
            l2 = sucessImportCounts;
            l = sucessImportCounts = Long.valueOf(sucessImportCounts + 1L);
        }
        AgrExternalImportResultLogAtomReqBO agrExternalImportResultLogServiceReqBO = new AgrExternalImportResultLogAtomReqBO();
        agrExternalImportResultLogServiceReqBO.setExportData(importResultsBusiRspBO.getExportData());
        agrExternalImportResultLogServiceReqBO.setFileName(importResultsBusiRspBO.getFilePath());
        agrExternalImportResultLogServiceReqBO.setFileUrl(importResultsBusiRspBO.getFullFilePath());
        agrExternalImportResultLogServiceReqBO.setSuccessCount(sucessImportCounts);
        agrExternalImportResultLogServiceReqBO.setFailureCount(failedImportCounts);
        agrExternalImportResultLogServiceReqBO.setMemId(busiReqBO.getMemIdIn());
        agrExternalImportResultLogServiceReqBO.setImpRemark("");
        agrExternalImportResultLogServiceReqBO.setImpResult(0);
        agrExternalImportResultLogServiceReqBO.setIsSkuChange(0);
        log.error("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)agrExternalImportResultLogServiceReqBO));
        AgrExternalImportResultLogAtomRspBO agrExternalImportResultLogServiceRspBO = this.cnncAgrExternalImportResultLogServiceHolder.getAgrExternalImportResultLogService().importLog(agrExternalImportResultLogServiceReqBO);
        log.error("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)((Object)agrExternalImportResultLogServiceRspBO)));
        if (insertSkuPoList.size() > 0) {
            int isInsert = this.agreementSkuMapper.insertBatch(insertSkuPoList);
            rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6210\u529f!\u603b\u5171\u3010" + data.size() + "\u3011\u6761\u6570\u636e\uff0c\u5bfc\u5165\u6210\u529f\u3010" + isInsert + "\u3011\u6761");
        }
        rsp.setImpId(agrExternalImportResultLogServiceRspBO.getImpId());
        rsp.setRespCode("0000");
        return rsp;
    }

    private void validateParam(List<AgreementSkuPO> agreementSkuPOs) {
        for (AgreementSkuPO po : agreementSkuPOs) {
            if (!StringUtils.isEmpty((Object)po.getSpec()) || !StringUtils.isEmpty((Object)po.getFigure())) continue;
            throw new BusinessException("0001", "\u89c4\u683c/\u578b\u53f7\u548c\u56fe\u53f7/\u5382\u5bb6\u96f6\u4ef6\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
    }

    private void getExcelDateByImport(MultipartFile multipartFile, List<List<String>> data, List<String> title, Integer importAgrSkuType) {
        int titleCount = importAgrSkuType == 1 ? this.normalTitleCount : this.supermarketStaffTitleCount;
        try {
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            int count = 1;
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (count < titleCount) {
                    ++count;
                    continue;
                }
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if (row.getCell(0) != null && "".equals(row.getCell(0).toString())) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelUtils.getValue(cell);
                    if (count == titleCount) {
                        title.add(String.valueOf(obj).trim());
                        continue;
                    }
                    if (count < titleCount + 2) continue;
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                ArrayList<String> d = new ArrayList<String>();
                for (String str : c) {
                    if (str.endsWith(".00")) {
                        str = str.substring(0, str.length() - 3);
                    }
                    d.add(str);
                }
                data.add(d);
            }
        }
        catch (Exception e) {
            throw new BusinessException("22052", e.getMessage());
        }
    }
}

