/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.atom.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.atom.api.AgrCheckAgreementChangeTypeAtomService;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrCheckAgreementChangeTypeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCheckAgreementChangeTypeAtomRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAuditMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrAuditPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.utils.AgrDateUtils;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="agrCheckAgreementChangeTypeAtomService")
public class AgrCheckAgreementChangeTypeAtomServiceImpl
implements AgrCheckAgreementChangeTypeAtomService {
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAuditMapper agrAuditMapper;

    @Override
    public AgrCheckAgreementChangeTypeAtomRspBO checkAgreementChangeType(AgrCheckAgreementChangeTypeAtomReqBO atomReqBO) {
        AgrCheckAgreementChangeTypeAtomRspBO atomRspBO = new AgrCheckAgreementChangeTypeAtomRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(atomReqBO.getAgreementId());
        agreementPO.setSupplierId(atomReqBO.getSupplierId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        this.checkAgreementStatusAndChangeType(atomReqBO.getChangeType(), agreement);
        this.checkAudit(agreement.getAgreementId());
        AgrAgreementBO agrAgreementBO = new AgrAgreementBO();
        BeanUtils.copyProperties((Object)agreement, (Object)agrAgreementBO);
        atomRspBO.setAgrAgreementBO(agrAgreementBO);
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u6821\u9a8c\u6210\u529f");
        return atomRspBO;
    }

    private void checkAudit(Long agreementId) {
        AgrAuditPO agrAuditPO = new AgrAuditPO();
        agrAuditPO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_ADD_AUDIT);
        agrAuditPO.setOrderId(agreementId);
        agrAuditPO.setStatus(AgrCommConstant.AuditStatus.UNDER_REVIEW);
        agrAuditPO.setObjId(agreementId);
        int count = this.agrAuditMapper.getCheckBy(agrAuditPO);
        if (count > 0) {
            throw new BusinessException("22050", "\u8be5\u534f\u8bae\u5b58\u5728\u5728\u9014\u53d8\u66f4\u7533\u8bf7");
        }
    }

    private void checkAgreementStatusAndChangeType(Byte changeType, AgreementPO agreement) {
        Byte agreementStatus = agreement.getAgreementStatus();
        String agreementStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_STATUS_PCODE", agreementStatus.toString());
        if (AgrCommConstant.AgreementChangeType.STOP.equals(changeType)) {
            if (!AgrCommConstant.AgreementStatus.ENABLE.equals(agreementStatus) && !AgrCommConstant.AgreementStatus.CLOSE.equals(agreementStatus)) {
                throw new BusinessException("22050", "\u534f\u8bae\u72b6\u6001\u3010" + agreementStatusStr + "\u3011\u4e0d\u652f\u6301\u6682\u505c\u53d8\u66f4\u7533\u8bf7");
            }
            return;
        }
        if (AgrCommConstant.AgreementChangeType.START.equals(changeType)) {
            if (!AgrCommConstant.AgreementStatus.SUSPEND.equals(agreementStatus)) {
                throw new BusinessException("22050", "\u534f\u8bae\u72b6\u6001\u3010" + agreementStatusStr + "\u3011\u4e0d\u652f\u6301\u542f\u7528\u53d8\u66f4\u7533\u8bf7");
            }
            return;
        }
        if (AgrCommConstant.AgreementChangeType.TERMINATION.equals(changeType)) {
            if (!(AgrCommConstant.AgreementStatus.SUSPEND.equals(agreementStatus) || AgrCommConstant.AgreementStatus.ENABLE.equals(agreementStatus) || AgrCommConstant.AgreementStatus.CLOSE.equals(agreementStatus))) {
                throw new BusinessException("22050", "\u534f\u8bae\u72b6\u6001\u3010" + agreementStatusStr + "\u3011\u4e0d\u652f\u6301\u7ec8\u6b62\u53d8\u66f4\u7533\u8bf7");
            }
            return;
        }
        if (AgrCommConstant.AgreementChangeType.CHANGE_PRICE.equals(changeType)) {
            if (!AgrCommConstant.AgreementStatus.ENABLE.equals(agreementStatus) && !AgrCommConstant.AgreementStatus.CLOSE.equals(agreementStatus)) {
                throw new BusinessException("22050", "\u534f\u8bae\u72b6\u6001\u3010" + agreementStatusStr + "\u3011\u4e0d\u652f\u6301\u8c03\u4ef7\u53d8\u66f4\u7533\u8bf7");
            }
            if (agreement.getTradeMode() != 2 && !AgrCommConstant.AdjustPrice.PRICE_ADJUSTMENT_BEFOREHAND.equals(agreement.getAdjustPrice())) {
                throw new BusinessException("22050", "\u8c03\u4ef7\u53d8\u66f4\u7533\u8bf7\u53ea\u9002\u7528\u4e8e\u4e8b\u524d\u8c03\u4ef7\u534f\u8bae");
            }
            return;
        }
        if (AgrCommConstant.AgreementChangeType.DELAY.equals(changeType)) {
            if (!(AgrCommConstant.AgreementStatus.ENABLE.equals(agreementStatus) || AgrCommConstant.AgreementStatus.BE_OVERDUE.equals(agreementStatus) || AgrCommConstant.AgreementStatus.CLOSE.equals(agreementStatus))) {
                throw new BusinessException("22050", "\u534f\u8bae\u72b6\u6001\u3010" + agreementStatusStr + "\u3011\u4e0d\u652f\u6301\u5ef6\u671f\u53d8\u66f4\u7533\u8bf7");
            }
            String monthStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGR_DELAY_DAY", "AGR_DELAY_DAY");
            if (null == monthStr) {
                throw new BusinessException("22050", "\u534f\u8bae\u8fc7\u671f\u6708\u6570\u4e3a\u914d\u7f6e\u5b57\u5178\u8868");
            }
            Integer months = Integer.parseInt(monthStr);
            Date agrExpDate = DateUtils.strToDate((String)DateUtils.dateToStr((Date)agreement.getExpDate()));
            Date now = DateUtils.strToDate((String)DateUtils.dateToStr((Date)new Date()));
            Date compareDate = AgrDateUtils.dateAdd(agrExpDate, months, 2);
            if (compareDate.compareTo(now) < 0) {
                throw new BusinessException("22050", "\u5ef6\u671f\u53d8\u66f4\u7533\u8bf7\u53ea\u9002\u7528\u4e8e\u5ef6\u671f\u3010" + months + "\u3011\u4e2a\u6708\u7684\u534f\u8bae");
            }
            return;
        }
        if (AgrCommConstant.AgreementChangeType.SUPPLEMENT.equals(changeType)) {
            if (!AgrCommConstant.AgreementStatus.ENABLE.equals(agreementStatus) && !AgrCommConstant.AgreementStatus.CLOSE.equals(agreementStatus)) {
                throw new BusinessException("22050", "\u534f\u8bae\u72b6\u6001\u3010" + agreementStatusStr + "\u3011\u4e0d\u652f\u6301\u8865\u5145\u53d8\u66f4\u7533\u8bf7");
            }
            return;
        }
        if (AgrCommConstant.AgreementChangeType.OTHER.equals(changeType)) {
            if (!AgrCommConstant.AgreementStatus.ENABLE.equals(agreementStatus) && !AgrCommConstant.AgreementStatus.CLOSE.equals(agreementStatus)) {
                throw new BusinessException("22050", "\u534f\u8bae\u72b6\u6001\u3010" + agreementStatusStr + "\u3011\u4e0d\u652f\u6301\u5176\u4ed6\u53d8\u66f4\u7533\u8bf7");
            }
            return;
        }
        if (AgrCommConstant.AgreementChangeType.STOCK_CHANGE.equals(changeType)) {
            if (!AgrCommConstant.AgreementStatus.ENABLE.equals(agreementStatus) && !AgrCommConstant.AgreementStatus.CLOSE.equals(agreementStatus)) {
                throw new BusinessException("22050", "\u534f\u8bae\u72b6\u6001\u3010" + agreementStatusStr + "\u3011\u4e0d\u652f\u6301\u5e93\u5b58\u53d8\u66f4\u7533\u8bf7");
            }
            return;
        }
        if (AgrCommConstant.AgreementChangeType.TOTAL_CHANGE.equals(changeType)) {
            if (!AgrCommConstant.AgreementStatus.ENABLE.equals(agreementStatus) && !AgrCommConstant.AgreementStatus.CLOSE.equals(agreementStatus)) {
                throw new BusinessException("22050", "\u534f\u8bae\u72b6\u6001\u3010" + agreementStatusStr + "\u3011\u4e0d\u652f\u6301\u6574\u4f53\u53d8\u66f4\u7533\u8bf7");
            }
            return;
        }
        throw new BusinessException("22050", "\u534f\u8bae\u53d8\u66f4\u7c7b\u578b\u3010" + changeType + "\u3011\u6682\u4e0d\u652f\u6301");
    }
}

