/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.atom.api.AgrCreateAgreementSkuAtomService;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementSkuLogMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementSkuLogPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.commodity.common.ability.api.UccUpperTaxCatCodeQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrCreateAgreementSkuAtomServiceImpl
implements AgrCreateAgreementSkuAtomService {
    private static final Logger log = LoggerFactory.getLogger(AgrCreateAgreementSkuAtomServiceImpl.class);
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementSkuLogMapper agreementSkuLogMapper;
    @Autowired
    private UccUpperTaxCatCodeQryAbilityService uccUpperTaxCatCodeQryAbilityService;

    @Override
    public AgrCreateAgreementSkuAtomRspBO createAgreementSku(AgrCreateAgreementSkuAtomReqBO atomReqBO) {
        List<String> materialIds;
        AgrCreateAgreementSkuAtomRspBO rsp = new AgrCreateAgreementSkuAtomRspBO();
        if (!(atomReqBO.isSupermarketStaff() || atomReqBO.isContractAgr() || CollectionUtils.isEmpty(materialIds = this.agreementSkuMapper.selectMaterialIds(atomReqBO.getAgreementId())))) {
            for (AgrAgreementSkuBO each : atomReqBO.getAgrAgreementSkuBOs()) {
                if (!materialIds.contains(each.getMaterialId())) continue;
                throw new ZTBusinessException("\u8be5\u534f\u8bae\u4e0b\u5df2\u5b58\u5728\u7269\u6599\uff1a" + each.getMaterialName());
            }
        }
        ArrayList<AgreementSkuPO> agrAgreementSkuPOs = new ArrayList<AgreementSkuPO>();
        ArrayList<AgreementSkuLogPO> agrAgreementSkuLogPOs = new ArrayList<AgreementSkuLogPO>();
        List taxCodes = atomReqBO.getAgrAgreementSkuBOs().stream().filter(a -> !StringUtils.isEmpty((Object)a.getTaxCatalog())).map(a -> a.getTaxCatalog()).distinct().collect(Collectors.toList());
        Map taxCatCodeMap = new HashMap();
        try {
            if (!CollectionUtils.isEmpty(taxCodes)) {
                UccUpperTaxCatCodeQryAbilityReqBo uccUpperTaxCatCodeQryAbilityReqBo = new UccUpperTaxCatCodeQryAbilityReqBo();
                uccUpperTaxCatCodeQryAbilityReqBo.setTaxCodes(taxCodes);
                UccUpperTaxCatCodeQryAbilityRspBo uccUpperTaxCatCodeQryAbilityRspBo = this.uccUpperTaxCatCodeQryAbilityService.qryUpperTaxCatCode(uccUpperTaxCatCodeQryAbilityReqBo);
                if ("0000".equals(uccUpperTaxCatCodeQryAbilityRspBo.getRespCode())) {
                    taxCatCodeMap = uccUpperTaxCatCodeQryAbilityRspBo.getTaxCatCodeMap();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        for (AgrAgreementSkuBO bo : atomReqBO.getAgrAgreementSkuBOs()) {
            List taxIds;
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            AgreementSkuLogPO agreementSkuLogPO = new AgreementSkuLogPO();
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuPO);
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuLogPO);
            if (!StringUtils.isEmpty((Object)agreementSkuPO.getTaxCatalog()) && !CollectionUtils.isEmpty((Collection)(taxIds = (List)taxCatCodeMap.get(agreementSkuPO.getTaxCatalog())))) {
                String taxCatalogList = org.apache.commons.lang3.StringUtils.join((Iterable)taxIds, (String)",");
                agreementSkuPO.setTaxCatalogList(taxCatalogList);
            }
            Long agreementSkuId = Sequence.getInstance().nextId();
            agreementSkuPO.setAgreementSkuId(agreementSkuId);
            agreementSkuPO.setAgreementId(atomReqBO.getAgreementId());
            agreementSkuPO.setAgreementVersion(atomReqBO.getAgreementVersion());
            agreementSkuPO.setSupplierId(atomReqBO.getSupplierId());
            agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuPO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuPO.setCreateLoginId(atomReqBO.getMemIdIn());
            agreementSkuPO.setCreateName(atomReqBO.getUserName());
            agreementSkuPO.setCreateTime(new Date());
            if (ObjectUtil.equal((Object)bo.getPackingRate(), null)) {
                agreementSkuPO.setPackingRate(agreementSkuPO.getPackingRate());
            } else {
                agreementSkuPO.setPackingRate("1");
            }
            if (agreementSkuPO.getBuyNumber() != null) {
                agreementSkuPO.setBuyPriceSum(new BigDecimal(agreementSkuPO.getBuyPrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
                if (agreementSkuPO.getSalePrice() != null) {
                    agreementSkuPO.setSalePriceSum(new BigDecimal(agreementSkuPO.getSalePrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
                }
                if (agreementSkuPO.getSalePrice() == null) {
                    agreementSkuPO.setSalePrice(new BigDecimal(agreementSkuPO.getBuyPrice()).add(new BigDecimal(agreementSkuPO.getBuyPrice()).multiply(new BigDecimal(agreementSkuPO.getMarkupRate().toString())).divide(new BigDecimal(100))).longValue());
                    agreementSkuPO.setSalePriceSum(new BigDecimal(agreementSkuPO.getSalePrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
                }
                agreementSkuPO.setCurrentStockNumber(agreementSkuPO.getBuyNumber());
            }
            agrAgreementSkuPOs.add(agreementSkuPO);
            Long agreementSkuLogId = Sequence.getInstance().nextId();
            agreementSkuLogPO.setAgreementSkuLogId(agreementSkuLogId);
            agreementSkuLogPO.setAgreementSkuId(agreementSkuId);
            agreementSkuLogPO.setAgreementLogId(atomReqBO.getAgreementLogId());
            agreementSkuLogPO.setAgreementId(atomReqBO.getAgreementId());
            agreementSkuLogPO.setAgreementVersion(atomReqBO.getAgreementVersion());
            agreementSkuLogPO.setSupplierId(atomReqBO.getSupplierId());
            agreementSkuLogPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuLogPO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuLogPO.setCreateLoginId(atomReqBO.getMemIdIn());
            agreementSkuLogPO.setCreateName(atomReqBO.getUserName());
            agreementSkuLogPO.setCreateTime(new Date());
            if (agreementSkuPO.getBuyNumber() != null && agreementSkuPO.getSalePrice() == null) {
                agreementSkuPO.setSalePrice(new BigDecimal(agreementSkuPO.getBuyPrice()).add(new BigDecimal(agreementSkuPO.getBuyPrice()).multiply(new BigDecimal(agreementSkuPO.getMarkupRate().toString())).divide(new BigDecimal(100))).longValue());
                agreementSkuPO.setSalePriceSum(new BigDecimal(agreementSkuPO.getSalePrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
            }
            agrAgreementSkuLogPOs.add(agreementSkuLogPO);
        }
        int isInsert = this.agreementSkuMapper.insertBatch(agrAgreementSkuPOs);
        int isInsert2 = this.agreementSkuLogMapper.insertBatch(agrAgreementSkuLogPOs);
        if (isInsert != agrAgreementSkuPOs.size()) {
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u521b\u5efa\u6210\u529f\uff01");
        return rsp;
    }

    @Override
    public AgrCreateAgreementSkuAtomRspBO createExtAgreementSku(AgrCreateAgreementSkuAtomReqBO atomReqBO) {
        AgrCreateAgreementSkuAtomRspBO rsp = new AgrCreateAgreementSkuAtomRspBO();
        ArrayList<AgreementSkuPO> agrAgreementSkuPOs = new ArrayList<AgreementSkuPO>();
        List taxCodes = atomReqBO.getAgrAgreementSkuBOs().stream().filter(a -> !StringUtils.isEmpty((Object)a.getTaxCatalog())).map(a -> a.getTaxCatalog()).distinct().collect(Collectors.toList());
        Map taxCatCodeMap = new HashMap();
        try {
            if (!CollectionUtils.isEmpty(taxCodes)) {
                UccUpperTaxCatCodeQryAbilityReqBo uccUpperTaxCatCodeQryAbilityReqBo = new UccUpperTaxCatCodeQryAbilityReqBo();
                uccUpperTaxCatCodeQryAbilityReqBo.setTaxCodes(taxCodes);
                UccUpperTaxCatCodeQryAbilityRspBo uccUpperTaxCatCodeQryAbilityRspBo = this.uccUpperTaxCatCodeQryAbilityService.qryUpperTaxCatCode(uccUpperTaxCatCodeQryAbilityReqBo);
                if ("0000".equals(uccUpperTaxCatCodeQryAbilityRspBo.getRespCode())) {
                    taxCatCodeMap = uccUpperTaxCatCodeQryAbilityRspBo.getTaxCatCodeMap();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        for (AgrAgreementSkuBO bo : atomReqBO.getAgrAgreementSkuBOs()) {
            List taxIds;
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuPO);
            Long agreementSkuId = Sequence.getInstance().nextId();
            agreementSkuPO.setAgreementSkuId(agreementSkuId);
            agreementSkuPO.setAgreementId(atomReqBO.getAgreementId());
            agreementSkuPO.setSupplierId(atomReqBO.getSupplierId());
            agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuPO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuPO.setCreateLoginId(atomReqBO.getMemIdIn());
            agreementSkuPO.setCreateName(atomReqBO.getUserName());
            agreementSkuPO.setCreateTime(new Date());
            agreementSkuPO.setAgreementVersion("null");
            agreementSkuPO.setManufacturer("null");
            agreementSkuPO.setBuyPriceSum(0L);
            agreementSkuPO.setMarkupRate(0.0);
            agreementSkuPO.setSalePrice(0L);
            agreementSkuPO.setSalePriceSum(0L);
            agreementSkuPO.setMeasureName("null");
            agreementSkuPO.setBuyNumber(BigDecimal.ZERO);
            if (!StringUtils.isEmpty((Object)agreementSkuPO.getTaxCatalog()) && !CollectionUtils.isEmpty((Collection)(taxIds = (List)taxCatCodeMap.get(agreementSkuPO.getTaxCatalog())))) {
                String taxCatalogList = org.apache.commons.lang3.StringUtils.join((Iterable)taxIds, (String)",");
                agreementSkuPO.setTaxCatalogList(taxCatalogList);
            }
            agrAgreementSkuPOs.add(agreementSkuPO);
        }
        int isInsert = this.agreementSkuMapper.insertBatch(agrAgreementSkuPOs);
        if (isInsert != agrAgreementSkuPOs.size()) {
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u521b\u5efa\u6210\u529f\uff01");
        return rsp;
    }

    public static void main(String[] args) {
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        agreementSkuPO.setBuyPrice(10000L);
        agreementSkuPO.setBuyNumber(new BigDecimal(10));
        agreementSkuPO.setMarkupRate(5.4);
        agreementSkuPO.setBuyPriceSum(new BigDecimal(agreementSkuPO.getBuyPrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
        agreementSkuPO.setSalePrice(new BigDecimal(agreementSkuPO.getBuyPrice()).add(new BigDecimal(agreementSkuPO.getBuyPrice()).multiply(new BigDecimal(agreementSkuPO.getMarkupRate().toString())).divide(new BigDecimal(100))).longValue());
        agreementSkuPO.setSalePriceSum(new BigDecimal(agreementSkuPO.getSalePrice()).multiply(agreementSkuPO.getBuyNumber()).longValue());
        System.out.println(JSON.toJSONString((Object)agreementSkuPO));
    }
}

