/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.bo.AgrskuChangePriceBO;
import com.tydic.agreement.atom.api.AgrSyncSkuStatusToCommidityAtomService;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomReqBO;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AgrSyncSkuStatusToCommidityAtomServiceImpl
implements AgrSyncSkuStatusToCommidityAtomService {
    private static final Logger log = LoggerFactory.getLogger(AgrSyncSkuStatusToCommidityAtomServiceImpl.class);
    @Value(value="${AGR_SKU_CHANGE_TOPIC}")
    private String agrSkuChangeTopic;
    @Value(value="${AGR_SKU_CHANGE_TAG}")
    private String agrSkuChangeTag;
    @Resource(name="agrSyncSkuStatusMqServiceProvider")
    private ProxyMessageProducer agrSyncSkuStatusMqServiceProvider;

    @Override
    public AgrSyncSkuStatusToCommidityAtomRspBO syncSkuStatusToCommidity(AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("agreementIds", atomReqBO.getAgreementIds());
        content.put("commiditySkuStatus", atomReqBO.getSkuStatus());
        content.put("agreementSkuIds", atomReqBO.getAgreementSkuIds());
        content.put("skuChangePriceBOs", atomReqBO.getSkuChangePriceBOs());
        content.put("agrScopeSyncBOs", atomReqBO.getAgrScopeSyncBOs());
        content.put("skuStockInvalidBO", atomReqBO.getSkuStockInvalidBO());
        log.info("\u53d1\u6d88\u606f\u540c\u6b65\u5546\u54c1\u5546\u54c1\u4e2d\u5fc3\u5165\u53c2\u4e3a" + JSON.toJSONString(content));
        this.agrSyncSkuStatusMqServiceProvider.send(new ProxyMessage(this.agrSkuChangeTopic, this.agrSkuChangeTag, JSON.toJSONString(content)));
        log.info("\u53d1\u6d88\u606f\u540c\u6b65\u5546\u54c1\u5546\u54c1\u4e2d\u5fc3\u6210\u529f");
        AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO = new AgrSyncSkuStatusToCommidityAtomRspBO();
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u6d88\u606f\u53d1\u9001\u6210\u529f");
        return atomRspBO;
    }

    public static void main(String[] args) {
        AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
        atomReqBO.setAgreementIds(new HashSet<Long>(29));
        atomReqBO.setAgreementSkuIds(new HashSet<Long>(1000000000));
        atomReqBO.setSkuStatus(AgrCommConstant.SkuStatus.AGREEMENT_FREEZEN);
        ArrayList<AgrskuChangePriceBO> skuChangePriceBOs = new ArrayList<AgrskuChangePriceBO>();
        AgrskuChangePriceBO bo = new AgrskuChangePriceBO();
        bo.setAgreementId(Long.valueOf(29L));
        bo.setAgreementSkuId(Long.valueOf(23L));
        bo.setBuyPrice(Long.valueOf(10000L));
        bo.setSalePrice(Long.valueOf(120000L));
        skuChangePriceBOs.add(bo);
        atomReqBO.setSkuChangePriceBOs(skuChangePriceBOs);
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("agreementIds", atomReqBO.getAgreementIds());
        content.put("commiditySkuStatus", atomReqBO.getSkuStatus());
        content.put("agreementSkuIds", atomReqBO.getAgreementSkuIds());
        content.put("skuChangePriceBOs", atomReqBO.getSkuChangePriceBOs());
        System.out.println(JSON.toJSONString(content));
    }
}

