/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeStockReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeStockRspBO;
import com.tydic.agreement.ability.bo.AgrSkuChangeStockBO;
import com.tydic.agreement.atom.api.AgrSyncSkuStatusToCommidityAtomService;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomReqBO;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomRspBO;
import com.tydic.agreement.busi.api.AgrAgreementSkuChangeStockBusiService;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgrAgreementSkuChangeStockBusiServiceImpl
implements AgrAgreementSkuChangeStockBusiService {
    private static final Byte CONSUME = 1;
    private static final Byte RETURN = 2;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrSyncSkuStatusToCommidityAtomService agrSyncSkuStatusToCommidityAtomService;

    @Override
    public AgrAgreementSkuChangeStockRspBO stockChange(AgrAgreementSkuChangeStockReqBO reqBO) {
        AgrAgreementSkuChangeStockRspBO rspBO = new AgrAgreementSkuChangeStockRspBO();
        ArrayList<Long> errorSkuIds = new ArrayList<Long>();
        rspBO.setFailedSkuIds(errorSkuIds);
        HashMap<Long, AgreementPO> agreementPOMap = new HashMap<Long, AgreementPO>();
        Date now = new Date();
        for (AgrSkuChangeStockBO agrSkuChangeStockBO : reqBO.getSkuStockChangeList()) {
            HashSet<Long> agreementIds;
            Integer totalLimitNum;
            Integer totalNum;
            int update;
            if (agreementPOMap.get(agrSkuChangeStockBO.getAgreementId()) == null) {
                AgreementPO agreementPO = new AgreementPO();
                agreementPO.setAgreementId(agrSkuChangeStockBO.getAgreementId());
                AgreementPO result = this.agreementMapper.getModelBy(agreementPO);
                agreementPOMap.put(agrSkuChangeStockBO.getAgreementId(), result);
            }
            BigDecimal amount = agrSkuChangeStockBO.getChangeAmount();
            if (agrSkuChangeStockBO.getType().equals(CONSUME)) {
                int update2 = this.agreementSkuMapper.AgrAgreementSkuStockChangeSub(agrSkuChangeStockBO.getAgreementId(), agrSkuChangeStockBO.getAgreementSkuId(), amount);
                if (update2 == 0) {
                    errorSkuIds.add(agrSkuChangeStockBO.getAgreementSkuId());
                }
            } else if (agrSkuChangeStockBO.getType().equals(RETURN) && (update = this.agreementSkuMapper.AgrAgreementSkuStockChangeAdd(agrSkuChangeStockBO.getAgreementId(), agrSkuChangeStockBO.getAgreementSkuId(), amount)) == 0) {
                errorSkuIds.add(agrSkuChangeStockBO.getAgreementSkuId());
            }
            if (!(totalNum = Integer.valueOf(this.agreementSkuMapper.selectSkuCount(agrSkuChangeStockBO.getAgreementId()))).equals(totalLimitNum = Integer.valueOf(this.agreementSkuMapper.selectLimitSkuCount(agrSkuChangeStockBO.getAgreementId())))) continue;
            long stockNumber = this.agreementSkuMapper.selectCurrentSkuStock(agrSkuChangeStockBO.getAgreementId());
            AgreementPO agreementPO = (AgreementPO)agreementPOMap.get(agrSkuChangeStockBO.getAgreementId());
            if (agreementPO == null) continue;
            AgreementPO updatePO = new AgreementPO();
            updatePO.setAgreementId(agrSkuChangeStockBO.getAgreementId());
            if (stockNumber <= 0L && agreementPO.getAgreementStatus().equals(AgrCommConstant.AgreementStatus.ENABLE)) {
                updatePO.setAgreementStatus(AgrCommConstant.AgreementStatus.CLOSE);
                this.agreementMapper.updateByCondition(updatePO);
                agreementIds = new HashSet<Long>();
                agreementIds.add(updatePO.getAgreementId());
                this.syncUcc(agreementIds, AgrCommConstant.CommiditySkuStatus.INVALID);
                continue;
            }
            if (!agreementPO.getExpDate().after(now) || !agreementPO.getEffDate().before(now)) continue;
            updatePO.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
            this.agreementMapper.updateByCondition(updatePO);
            agreementIds = new HashSet();
            agreementIds.add(updatePO.getAgreementId());
            this.syncUcc(agreementIds, AgrCommConstant.CommiditySkuStatus.BE_SHELF);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f\uff01");
        return rspBO;
    }

    private void syncUcc(Set<Long> agreementIds, Byte status) {
        AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
        atomReqBO.setAgreementIds(agreementIds);
        atomReqBO.setSkuStatus(status);
        AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespCode());
        }
    }
}

