/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.agreement.ability.api.AgrSyncAgreementSkuFromContractAbilityService;
import com.tydic.agreement.ability.bo.AgrSyncAgreementSkuFromContractReqBO;
import com.tydic.agreement.ability.bo.AgrSyncAgreementSkuFromContractRspBO;
import com.tydic.agreement.atom.api.AgrAgreementStatusChangeAtomService;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSettlementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSettlementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.ContractGetOldContractItemIdListAbilityService;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractGetOldContractItemIdListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractGetOldContractItemIdListAbilityRspBO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class AgrContractSyncAgreementSkuStatusConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(AgrContractSyncAgreementSkuStatusConsumer.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAgreementStatusChangeAtomService agrAgreementStatusChangeAtomService;
    @Autowired
    private AgrSyncAgreementSkuFromContractAbilityService agrSyncAgreementSkuFromContractAbilityService;
    private static final int freeze = 0;
    private static final int pass = 1;
    private static final int reject = 2;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private ContractGetOldContractItemIdListAbilityService contractGetOldContractItemIdListAbilityService;
    @Autowired
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    @Autowired
    private AgreementSettlementMapper agreementSettlementMapper;
    private static final String vendorSettlementObject = "1";

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        AgrAgreementStatusChangeAtomRspBO atomRspBO;
        log.error("\u5408\u540c\u505c\u7528\u540c\u6b65\u534f\u8bae\u5165\u53c2:" + JSON.toJSONString((Object)message.getContent()));
        JSONObject jsonObject = (JSONObject)JSON.parseObject((String)message.getContent(), JSONObject.class);
        Long agreementId = jsonObject.getLong("agrId");
        Long contractId = jsonObject.getLong("contractId");
        Integer dealType = jsonObject.getInteger("dealType");
        if (agreementId == null) {
            log.error("\u5408\u540c\u505c\u7528\u540c\u6b65\u534f\u8bae\u5165\u53c2ID\u4e3a\u7a7a");
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        if (dealType == null) {
            log.error("\u5408\u540c\u505c\u7528\u540c\u6b65\u534f\u8bae\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        if (contractId == null) {
            log.error("\u5408\u540c\u505c\u7528\u540c\u6b65\u534f\u8bae\u5165\u53c2\u5408\u540cID\u4e3a\u7a7a");
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(agreementId);
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (agreement == null) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        HashSet<Long> agreementIds = new HashSet<Long>();
        agreementIds.add(agreement.getAgreementId());
        AgrAgreementStatusChangeAtomReqBO atomReqBO = new AgrAgreementStatusChangeAtomReqBO();
        atomReqBO.setAgreementIds(agreementIds);
        atomReqBO.setAgreementStatusPre(agreement.getAgreementStatus());
        agreementPO.setOldContractId(agreement.getContractId());
        agreementPO.setContractId(contractId);
        int update = this.agreementMapper.updateByConditions(agreementPO);
        if (update < 0) {
            log.error("\u5408\u540c\u505c\u7528\u540c\u6b65\u534f\u8bae\u5931\u8d25:\u66f4\u65b0\u534f\u8bae\u5408\u540cID\u5931\u8d25");
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        if (dealType.equals(1)) {
            block24: {
                block23: {
                    try {
                        ContractGetOldContractItemIdListAbilityReqBO contractGetOldContractItemIdListAbilityReqBO = new ContractGetOldContractItemIdListAbilityReqBO();
                        contractGetOldContractItemIdListAbilityReqBO.setNewContractId(contractId);
                        ContractGetOldContractItemIdListAbilityRspBO contractItemIdListAbilityRspBO = this.contractGetOldContractItemIdListAbilityService.GetOldContractItemIdList(contractGetOldContractItemIdListAbilityReqBO);
                        if ("0000".equals(contractItemIdListAbilityRspBO.getRespCode())) {
                            Map itemLogMap = contractItemIdListAbilityRspBO.getItemLogMap();
                            if (itemLogMap != null && !CollectionUtils.isEmpty(itemLogMap.keySet())) {
                                ArrayList oldItemIds = new ArrayList();
                                oldItemIds.addAll(itemLogMap.keySet());
                                AgreementSkuPO searchPO = new AgreementSkuPO();
                                searchPO.setAgreementId(agreementId);
                                searchPO.setContractItemIds(oldItemIds.stream().map(e -> e.toString()).collect(Collectors.toList()));
                                List<AgreementSkuPO> oldAgrItems = this.agreementSkuMapper.getList(searchPO);
                                if (!CollectionUtils.isEmpty(oldAgrItems)) {
                                    ArrayList<AgreementSkuPO> updateSkuPOS = new ArrayList<AgreementSkuPO>();
                                    for (Long oldContractItemId : itemLogMap.keySet()) {
                                        AgreementSkuPO updatePO = new AgreementSkuPO();
                                        updatePO.setOldContractItemId(oldContractItemId.toString());
                                        updatePO.setNewContractItemId(((Long)itemLogMap.get(oldContractItemId)).toString());
                                        updateSkuPOS.add(updatePO);
                                    }
                                    this.agreementSkuMapper.updateContractItemIdByBatch(updateSkuPOS, agreementId);
                                }
                            }
                            break block23;
                        }
                        throw new ZTBusinessException(contractItemIdListAbilityRspBO.getRespDesc());
                    }
                    catch (Exception e2) {
                        log.error("\u4fee\u6539\u4e4b\u524d\u5148\u53bb\u66f4\u65b0\u534f\u8bae\u7684\u5408\u540c\u660e\u7ec6id\u51fa\u73b0\u5f02\u5e38" + e2.getMessage());
                        return ProxyConsumerStatus.CONSUME_SUCCESS;
                    }
                }
                ContractDetailQueryAbilityReqBO contractDetailQueryAbilityReqBO = new ContractDetailQueryAbilityReqBO();
                contractDetailQueryAbilityReqBO.setContractId(contractId);
                try {
                    ContractDetailQueryAbilityRspBO contractDetailQueryAbilityRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(contractDetailQueryAbilityReqBO);
                    if (contractDetailQueryAbilityRspBO == null) break block24;
                    log.info("\u8fdb\u5165\u4e3b\u4f53\u4fe1\u606f\u7684\u540c\u6b65\u4fee\u6539");
                    AgreementPO updateAgreementPO = new AgreementPO();
                    updateAgreementPO.setVendorContact(contractDetailQueryAbilityRspBO.getSupplierAuthorizedAgent());
                    updateAgreementPO.setVendorPhone(contractDetailQueryAbilityRspBO.getSupplierPhone());
                    updateAgreementPO.setEffDate(contractDetailQueryAbilityRspBO.getContractEffectiveDate());
                    updateAgreementPO.setExpDate(contractDetailQueryAbilityRspBO.getContractEndDate());
                    updateAgreementPO.setAgreementId(agreementId);
                    int updateCount = this.agreementMapper.updateByConditions(updateAgreementPO);
                    if (updateCount < 0) {
                        log.error("\u5408\u540c\u540c\u6b65\u534f\u8bae\u5931\u8d25:\u66f4\u65b0\u534f\u8bae\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
                        return ProxyConsumerStatus.CONSUME_SUCCESS;
                    }
                    AgreementSettlementPO searchSettlementPO = new AgreementSettlementPO();
                    searchSettlementPO.setAgreementId(agreementId);
                    List<AgreementSettlementPO> list = this.agreementSettlementMapper.getList(searchSettlementPO);
                    AgreementSettlementPO updateSettlementPO = new AgreementSettlementPO();
                    if (CollectionUtils.isEmpty(list)) break block24;
                    for (AgreementSettlementPO agreementSettlementPO : list) {
                        if (!vendorSettlementObject.equals(agreementSettlementPO.getSettlementObject())) continue;
                        BeanUtils.copyProperties((Object)agreementSettlementPO, (Object)updateSettlementPO);
                        if (contractDetailQueryAbilityRspBO.getExpectSettle() != null) {
                            updateSettlementPO.setAssign(contractDetailQueryAbilityRspBO.getExpectSettle().toString());
                        }
                        if (contractDetailQueryAbilityRspBO.getPayNodeRuleAllow() != null) {
                            updateSettlementPO.setPayMethod(contractDetailQueryAbilityRspBO.getPayNodeRuleAllow().toString());
                        }
                        updateSettlementPO.setPayDay(contractDetailQueryAbilityRspBO.getSettleDay());
                        updateSettlementPO.setSettlementDate(contractDetailQueryAbilityRspBO.getSettleDay());
                        updateSettlementPO.setTryPay(contractDetailQueryAbilityRspBO.getInvoicePay());
                        updateSettlementPO.setPrePay(contractDetailQueryAbilityRspBO.getPrePay());
                        updateSettlementPO.setComPay(contractDetailQueryAbilityRspBO.getDeliveryPay());
                        updateSettlementPO.setQuaPay(contractDetailQueryAbilityRspBO.getQuaAmount());
                        if (contractDetailQueryAbilityRspBO.getPayType() != null) {
                            updateSettlementPO.setSettlementType(contractDetailQueryAbilityRspBO.getPayType().toString());
                        }
                        updateSettlementPO.setPayDay(contractDetailQueryAbilityRspBO.getSettleDay());
                        updateSettlementPO.setSettlementDate(contractDetailQueryAbilityRspBO.getSettleDay());
                        this.agreementSettlementMapper.updateByPrimaryKey(updateSettlementPO);
                        break;
                    }
                }
                catch (Exception e3) {
                    log.error("\u534f\u8bae\u540c\u6b65\u5408\u540c\u4e3b\u4f53\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38" + e3.getMessage());
                    return ProxyConsumerStatus.CONSUME_SUCCESS;
                }
            }
            atomReqBO.setAgreementStatusPost(AgrCommConstant.AgreementStatus.CONTRACT_CONFIRM);
            AgrSyncAgreementSkuFromContractReqBO agrSyncAgreementSkuFromContractReqBO = new AgrSyncAgreementSkuFromContractReqBO();
            agrSyncAgreementSkuFromContractReqBO.setAgreementId(agreementId);
            agrSyncAgreementSkuFromContractReqBO.setContractId(contractId);
            AgrSyncAgreementSkuFromContractRspBO agrSyncAgreementSkuFromContractRspBO = this.agrSyncAgreementSkuFromContractAbilityService.syncAgreementSku(agrSyncAgreementSkuFromContractReqBO);
            if (!"0000".equals(agrSyncAgreementSkuFromContractRspBO.getRespCode())) {
                log.error("\u5408\u540c\u505c\u7528\u540c\u6b65\u534f\u8bae\u5931\u8d25:{}", (Object)agrSyncAgreementSkuFromContractRspBO.getRespDesc());
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
        }
        if (dealType.equals(0)) {
            atomReqBO.setAgreementStatusPost(AgrCommConstant.AgreementStatus.FROZEN);
            agreementPO.setAgreementPreStatus(agreement.getAgreementStatus());
            this.agreementMapper.updateByCondition(agreementPO);
        }
        if (dealType.equals(2)) {
            atomReqBO.setAgreementStatusPost(agreement.getAgreementPreStatus());
        }
        if (!"0000".equals((atomRspBO = this.agrAgreementStatusChangeAtomService.updateAgreementStatus(atomReqBO)).getRespCode())) {
            log.error("\u5408\u540c\u534f\u8bae\u64cd\u4f5c\u5931\u8d25:" + atomRspBO.getRespDesc());
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

