/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.utils;

import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static String doPost(String url, String body) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = null;
        String result = null;
        StringEntity stringEntity = null;
        try {
            HttpEntity resEntity;
            if (!StringUtils.isEmpty((Object)body)) {
                stringEntity = new StringEntity(body, Charset.forName("UTF-8"));
            }
            httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(5000).setSocketTimeout(5000).setConnectTimeout(5000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Content-type", "application/json;charset=UTF-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("HTTP\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)ex);
        }
        return result;
    }

    public static String doPost(String url, String body, String token) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = null;
        String result = null;
        StringEntity stringEntity = null;
        try {
            HttpEntity resEntity;
            if (!StringUtils.isEmpty((Object)body)) {
                stringEntity = new StringEntity(body, Charset.forName("UTF-8"));
            }
            httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(2000).setSocketTimeout(3000).setConnectTimeout(2000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Content-type", "application/json;charset=UTF-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("auth-token", token);
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("HTTP\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)ex);
        }
        return result;
    }

    public static String doGet(String url) {
        String result = null;
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(30000).setConnectTimeout(20000).build();
        httpGet.setConfig(requestConfig);
        try {
            HttpEntity resEntity;
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("HTTP\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)ex);
        }
        return result;
    }
}

