/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.agreement.ability.api.AgrAgreementAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementRspBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeBO;
import com.tydic.agreement.ability.bo.AgrPublicAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrPublicAbilityRspBO;
import com.tydic.agreement.ability.bo.AgreementSkuStockAbilityBO;
import com.tydic.agreement.atom.api.AgrAgreementStatusChangeAtomService;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomRspBO;
import com.tydic.agreement.busi.api.AgrAgreementBusiService;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrShortNameListLineMapper;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrShortNameListLinePO;
import com.tydic.agreement.po.AgreementChangePO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuChangePO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.utils.MoneyUtils;
import com.tydic.cfc.ability.api.CfcQryExpressRelationAbilityService;
import com.tydic.cfc.ability.bo.CfcQryExpressRelationAbilityReqBO;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrAgreementAbilityService"})
public class AgrAgreementAbilityServiceImpl
implements AgrAgreementAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementAbilityServiceImpl.class);
    @Autowired
    private AgrAgreementBusiService agrAgreementBusiService;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementSkuChangeMapper agreementSkuChangeMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private CfcQryExpressRelationAbilityService cfcQryExpressRelationAbilityService;
    @Autowired
    private AgrShortNameListLineMapper agrShortNameListLineMapper;
    @Autowired
    private AgreementChangeMapper agreementChangeMapper;
    @Autowired
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    @Autowired
    private AgrAgreementStatusChangeAtomService agrAgreementStatusChangeAtomService;

    @PostMapping(value={"selectListPage"})
    public AgrAgreementRspBO selectListPage(@RequestBody AgrAgreementReqBO reqBO) {
        return this.agrAgreementBusiService.selectListPage(reqBO);
    }

    @PostMapping(value={"verifyMetalContent"})
    public AgrPublicAbilityRspBO verifyMetalContent(@RequestBody AgrAgreementSkuBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        rspBO.setFlag(false);
        List<AgreementSkuPO> agreementSkuList = this.agreementSkuMapper.getList((AgreementSkuPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), AgreementSkuPO.class));
        long count = agreementSkuList.stream().filter(a -> a.getMetalContent() == null).count();
        if (count > 0L) {
            rspBO.setFlag(true);
        }
        return rspBO;
    }

    @PostMapping(value={"verifyMetalContentChange"})
    public AgrPublicAbilityRspBO verifyMetalContentChange(@RequestBody AgrAgreementSkuChangeBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        rspBO.setFlag(false);
        List<AgreementSkuChangePO> agreementSkuList = this.agreementSkuChangeMapper.getList((AgreementSkuChangePO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), AgreementSkuChangePO.class));
        long count = agreementSkuList.stream().filter(a -> a.getMetalContent() == null).count();
        if (count > 0L) {
            rspBO.setFlag(true);
        }
        return rspBO;
    }

    @PostMapping(value={"updateAgreementSkuChange"})
    public AgrPublicAbilityRspBO updateAgreementSkuChange(@RequestBody AgrPublicAbilityReqBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        ArrayList<Map<Integer, String>> rspList = new ArrayList<Map<Integer, String>>();
        HashMap<Integer, String> rspMap = new HashMap<Integer, String>();
        rspList.add(rspMap);
        rspBO.setT(rspList);
        Map m = reqBO.getM();
        Long changeId = Long.valueOf((String)m.get("changeId"));
        List skuChangeIds = (List)m.get("skuChangeIds");
        List longs = JSON.parseArray((String)JSON.toJSONString((Object)skuChangeIds), Long.class);
        AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
        agreementSkuChangePO.setChangeId(changeId);
        agreementSkuChangePO.setSkuChangeIds(longs);
        agreementSkuChangePO.setSkuSource("1");
        List<AgreementSkuChangePO> agreementSkuList = this.agreementSkuChangeMapper.getList(agreementSkuChangePO);
        long bidder = agreementSkuList.stream().filter(a -> a.getBidderAmount() == null).count();
        if (bidder > 0L) {
            throw new BusinessException("8888", "\u4e2d\u6807\u5355\u4ef7\u503c\u6709\u7a7a\uff01");
        }
        agreementSkuList.stream().forEach(a -> {
            if (null == a.getBuyNumber()) {
                a.setBuyNumber(BigDecimal.ZERO);
            }
        });
        int type = (Integer)m.get("type");
        BigDecimal currentPrice = new BigDecimal((String)m.get("currentPrice"));
        BigDecimal price = new BigDecimal((String)m.get("price"));
        ArrayList<AgreementSkuChangePO> addSkuChange = new ArrayList<AgreementSkuChangePO>();
        for (int i = 0; i < agreementSkuList.size(); ++i) {
            this.count(type, agreementSkuList.get(i), currentPrice, price, i + 1, rspList, rspMap, addSkuChange);
        }
        if (addSkuChange.size() > 0) {
            this.agreementSkuChangeMapper.updateBranchPriceById(addSkuChange);
        }
        return rspBO;
    }

    @PostMapping(value={"selectAgreementSaleOrder"})
    public AgrPublicAbilityRspBO selectAgreementSaleOrder(@RequestBody AgrPublicAbilityReqBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        String plaAgreementCode = String.valueOf(reqBO.getM().get("plaAgreementCode"));
        AgreementPO po = new AgreementPO();
        po.setPlaAgreementCode(plaAgreementCode);
        AgreementPO modelBy = this.agreementMapper.getModelBy(po);
        CfcQryExpressRelationAbilityReqBO cfcQryExpressRelationAbilityReqBO = new CfcQryExpressRelationAbilityReqBO();
        if (null != modelBy.getContractId()) {
            cfcQryExpressRelationAbilityReqBO.setObjId(modelBy.getContractId());
            cfcQryExpressRelationAbilityReqBO.setSuitType(Integer.valueOf(1));
        } else {
            cfcQryExpressRelationAbilityReqBO.setObjId(modelBy.getAgreementId());
            cfcQryExpressRelationAbilityReqBO.setSuitType(Integer.valueOf(2));
        }
        List expressList = this.cfcQryExpressRelationAbilityService.qryExpressRelationList(cfcQryExpressRelationAbilityReqBO).getExpressList();
        rspBO.setRows(expressList);
        return rspBO;
    }

    @PostMapping(value={"selectAgreementSku"})
    public AgrPublicAbilityRspBO selectAgreementSku(@RequestBody AgrPublicAbilityReqBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        String plaAgreementCode = String.valueOf(reqBO.getM().get("plaAgreementCode"));
        AgreementPO po = new AgreementPO();
        po.setPlaAgreementCode(plaAgreementCode);
        AgreementPO modelBy = this.agreementMapper.getModelBy(po);
        AgreementSkuPO skuPO = new AgreementSkuPO();
        skuPO.setAgreementId(modelBy.getAgreementId());
        List<AgreementSkuPO> agreementSkuMapperList = this.agreementSkuMapper.getList(skuPO);
        rspBO.setRows(agreementSkuMapperList);
        return rspBO;
    }

    private void count(int type, AgreementSkuChangePO skuChangePO, BigDecimal currentPrice, BigDecimal price, int i, List<Map<Integer, String>> rspList, Map<Integer, String> rspMap, List<AgreementSkuChangePO> addSkuChange) {
        AgreementSkuChangePO po = new AgreementSkuChangePO();
        BigDecimal buyPrice = BigDecimal.ZERO;
        switch (type) {
            case 1: {
                buyPrice = skuChangePO.getBidderAmount().add(currentPrice.subtract(price));
                break;
            }
            case 2: {
                buyPrice = skuChangePO.getBidderAmount().add(currentPrice.subtract(price).multiply(skuChangePO.getMetalContent()).divide(new BigDecimal(1000), 8, 2));
                break;
            }
            case 3: {
                buyPrice = skuChangePO.getBidderAmount().multiply(BigDecimal.ONE.add(currentPrice.subtract(price).divide(price, 8, 2)));
                break;
            }
            case 4: {
                buyPrice = skuChangePO.getBidderAmount().add(currentPrice.subtract(price));
            }
        }
        if (buyPrice.compareTo(BigDecimal.ZERO) > 0) {
            try {
                po.setBuyPrice(MoneyUtils.calculate2Decimals(buyPrice, 10));
                po.setBuyPriceSum(MoneyUtils.calculate2Decimals(buyPrice.multiply(skuChangePO.getBuyNumber()), 2));
                po.setSalePrice(MoneyUtils.calculate2Decimals(buyPrice.multiply(BigDecimal.valueOf(1.0 + skuChangePO.getMarkupRate())), 10));
                po.setSalePriceSum(MoneyUtils.calculate2Decimals(buyPrice.multiply(BigDecimal.valueOf(1.0 + skuChangePO.getMarkupRate())).multiply(skuChangePO.getBuyNumber()), 2));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            po.setSkuChangeId(skuChangePO.getSkuChangeId());
            addSkuChange.add(po);
        } else {
            rspMap.put(i, skuChangePO.getMaterialCode());
        }
    }

    @PostMapping(value={"updateReference"})
    public AgrPublicAbilityRspBO updateReference(@RequestBody AgrPublicAbilityReqBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        String type = reqBO.getM().get("type").toString();
        List req = (List)reqBO.getT();
        List agreementSkuStockAbilityBOList = JSON.parseArray((String)JSON.toJSONString((Object)req), AgreementSkuStockAbilityBO.class);
        if (!ObjectUtils.isEmpty((Object)agreementSkuStockAbilityBOList)) {
            if (type.equals("1")) {
                this.agreementSkuMapper.updateReferenceSubtract(agreementSkuStockAbilityBOList);
            } else if (type.equals("2")) {
                this.agreementSkuMapper.updateReferenceAdd(agreementSkuStockAbilityBOList);
            }
        }
        return rspBO;
    }

    @PostMapping(value={"selectWarning"})
    public AgrPublicAbilityRspBO selectWarning(@RequestBody AgrPublicAbilityReqBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        List<Map<String, Object>> skuPO = this.agreementSkuMapper.selectWarning(reqBO.getM());
        rspBO.setRows(skuPO);
        return rspBO;
    }

    @PostMapping(value={"updateWarningFlag"})
    public AgrPublicAbilityRspBO updateWarningFlag(@RequestBody AgrPublicAbilityReqBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        List agreementSkuIds = (List)reqBO.getM().get("agreementSkuIds");
        int flag = (Integer)reqBO.getM().get("flag");
        this.agreementSkuMapper.updateWarningFlag(agreementSkuIds, flag);
        return rspBO;
    }

    @PostMapping(value={"selectShortName"})
    public AgrPublicAbilityRspBO selectShortName(@RequestBody AgrPublicAbilityReqBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        AgrShortNameListLinePO po = new AgrShortNameListLinePO();
        po.setAgreementId(Long.valueOf(String.valueOf(reqBO.getM().get("agreementId"))));
        Long shorNamelistId = this.agrShortNameListLineMapper.selectShortName(po);
        if (!ObjectUtils.isEmpty((Object)shorNamelistId) && shorNamelistId > 0L) {
            rspBO.setFlag(true);
            rspBO.setT((Object)shorNamelistId);
        } else {
            rspBO.setFlag(false);
        }
        return rspBO;
    }

    @PostMapping(value={"updateContractChangeHint"})
    public AgrPublicAbilityRspBO updateContractChangeHint(@RequestBody AgrPublicAbilityReqBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        String s = String.valueOf(reqBO.getM().get("agreementId"));
        this.agreementMapper.updateContractChangeHint(Long.valueOf(s));
        return rspBO;
    }

    @PostMapping(value={"verifyAgreement"})
    public AgrPublicAbilityRspBO verifyAgreement(@RequestBody AgrPublicAbilityReqBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        String s = String.valueOf(reqBO.getM().get("contractId"));
        AgreementPO po = new AgreementPO();
        po.setContractId(Long.valueOf(s));
        AgreementPO agreementPO = this.agreementMapper.selectStatusByContractId(po);
        if (ObjectUtils.isEmpty((Object)agreementPO)) {
            rspBO.setFlag(true);
        } else if (agreementPO.getAgreementStatus() == 2 || agreementPO.getAgreementStatus() == 10) {
            rspBO.setFlag(false);
        } else {
            AgreementChangePO changePO = new AgreementChangePO();
            changePO.setAgreementId(agreementPO.getAgreementId());
            changePO.setAgreementVersion(agreementPO.getAgreementVersion());
            AgreementChangePO change = this.agreementChangeMapper.selectStatusByAgreementId(changePO);
            if (ObjectUtils.isEmpty((Object)change)) {
                rspBO.setFlag(true);
            } else if (change.getStatus() == 1 || change.getStatus() == 4) {
                rspBO.setFlag(false);
            } else {
                rspBO.setFlag(true);
            }
        }
        return rspBO;
    }

    @PostMapping(value={"verifyContract"})
    public AgrPublicAbilityRspBO verifyContract(@RequestBody AgrPublicAbilityReqBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        String s = String.valueOf(reqBO.getM().get("agreementId"));
        AgreementPO po = new AgreementPO();
        po.setAgreementId(Long.valueOf(s));
        AgreementPO modelBy = this.agreementMapper.getModelBy(po);
        if (!ObjectUtils.isEmpty((Object)modelBy) && !ObjectUtils.isEmpty((Object)modelBy.getContractId())) {
            ContractDetailQueryAbilityReqBO contract = (ContractDetailQueryAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ContractDetailQueryAbilityReqBO.class);
            contract.setContractId(modelBy.getContractId());
            ContractDetailQueryAbilityRspBO contractDetailQueryAbilityRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(contract);
            if (!ObjectUtils.isEmpty((Object)contractDetailQueryAbilityRspBO) && !contractDetailQueryAbilityRspBO.getContractStatus().equals(8)) {
                rspBO.setFlag(false);
            } else {
                rspBO.setFlag(true);
            }
        } else {
            rspBO.setFlag(true);
        }
        return rspBO;
    }

    @PostMapping(value={"contractWithdraw"})
    public AgrPublicAbilityRspBO contractWithdraw(@RequestBody AgrPublicAbilityReqBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        String s = String.valueOf(reqBO.getM().get("contractId"));
        AgreementPO po = new AgreementPO();
        po.setContractId(Long.valueOf(s));
        AgreementPO modelBy = this.agreementMapper.contractWithdraw(po);
        if (!ObjectUtils.isEmpty((Object)modelBy) && !ObjectUtils.isEmpty((Object)modelBy.getContractId())) {
            AgrAgreementStatusChangeAtomReqBO atomReqBO = new AgrAgreementStatusChangeAtomReqBO();
            HashSet<Long> agreementIds = new HashSet<Long>();
            agreementIds.add(modelBy.getAgreementId());
            atomReqBO.setAgreementIds(agreementIds);
            atomReqBO.setAgreementStatusPre(modelBy.getAgreementStatus());
            atomReqBO.setAgreementStatusPost(modelBy.getAgreementPreStatus());
            AgrAgreementStatusChangeAtomRspBO atomRspBO = this.agrAgreementStatusChangeAtomService.updateAgreementStatus(atomReqBO);
            rspBO.setFlag(true);
            rspBO.setT((Object)modelBy);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                rspBO.setFlag(false);
                return rspBO;
            }
        }
        return rspBO;
    }

    @PostMapping(value={"selectAmountLimit"})
    public AgrPublicAbilityRspBO selectAmountLimit(@RequestBody AgrPublicAbilityReqBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        String s = String.valueOf(reqBO.getM().get("agreementId"));
        AgreementPO po = new AgreementPO();
        po.setAgreementId(Long.valueOf(s));
        AgreementPO modelBy = this.agreementMapper.getModelBy(po);
        if (ObjectUtils.isEmpty((Object)modelBy)) {
            throw new BusinessException("8888", "\u534f\u8bae\u4e0d\u5b58\u5728" + s);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (ObjectUtils.isEmpty((Object)modelBy.getAmountLimit())) {
            hashMap.put("amountLimit", "0");
            hashMap.put("amountLimitUse", "0");
            hashMap.put("remain", "0");
        } else {
            hashMap.put("amountLimit", modelBy.getAmountLimit().setScale(2, 4).toPlainString());
            hashMap.put("amountLimitUse", modelBy.getAmountLimitUse().setScale(2, 4).toPlainString());
            hashMap.put("remain", modelBy.getAmountLimit().subtract(modelBy.getAmountLimitUse()).setScale(2, 4).toPlainString());
        }
        rspBO.setT(hashMap);
        return rspBO;
    }

    @PostMapping(value={"updateAmountLimit"})
    public AgrPublicAbilityRspBO updateAmountLimit(@RequestBody AgrPublicAbilityReqBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        List agreementBOs = JSON.parseArray((String)JSON.toJSONString(reqBO.getM().get("agreementBOs")), Map.class);
        for (Map m : agreementBOs) {
            if (!(ObjectUtils.isEmpty(m.get("agreementId")) || ObjectUtils.isEmpty(m.get("amountLimitUse")) || ObjectUtils.isEmpty(m.get("type")))) {
                String amountLimitUse;
                AgreementPO po = new AgreementPO();
                po.setAgreementId(Long.valueOf((String)m.get("agreementId")));
                AgreementPO modelBy = this.agreementMapper.getModelBy(po);
                if (ObjectUtils.isEmpty((Object)modelBy)) {
                    rspBO.setCode("8888");
                    rspBO.setMessage("\u5931\u8d25");
                    throw new BusinessException("8888", "\u534f\u8bae\u4e0d\u5b58\u5728" + po.getAgreementId());
                }
                if (ObjectUtils.isEmpty((Object)modelBy.getAmountLimit()) || modelBy.getAmountLimit().compareTo(BigDecimal.ZERO) == 0) continue;
                String type = ObjectUtils.isEmpty(m.get("type")) ? "0" : (String)m.get("type");
                String string = amountLimitUse = ObjectUtils.isEmpty(m.get("amountLimitUse")) ? "0" : (String)m.get("amountLimitUse");
                if ("1".equals(type)) {
                    po.setAmountLimitUse(modelBy.getAmountLimitUse().add(new BigDecimal(amountLimitUse)));
                } else {
                    po.setAmountLimitUse(modelBy.getAmountLimitUse().subtract(new BigDecimal(amountLimitUse)));
                }
                if (modelBy.getAmountLimit().subtract(po.getAmountLimitUse()).compareTo(BigDecimal.ZERO) > 0) {
                    if (modelBy.getAmountLimitAbort().equals(1) && modelBy.getAgreementStatus().equals(AgrCommConstant.AgreementStatus.TERMINATION)) {
                        po.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
                    }
                    po.setAmountLimitAbort(0);
                } else {
                    po.setAgreementStatus(AgrCommConstant.AgreementStatus.TERMINATION);
                    po.setAmountLimitAbort(1);
                }
                this.agreementMapper.updateByCondition(po);
                continue;
            }
            rspBO.setCode("8888");
            rspBO.setMessage("\u5931\u8d25");
            throw new BusinessException("8888", "\u5165\u53c2\u6709\u8bef");
        }
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"isAmountLimitOrders"})
    public AgrPublicAbilityRspBO isAmountLimitOrders(@RequestBody AgrPublicAbilityReqBO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        String s = String.valueOf(reqBO.getM().get("agreementId"));
        AgreementPO po = new AgreementPO();
        po.setAgreementId(Long.valueOf(s));
        po.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
        AgreementPO modelBy = this.agreementMapper.getModelBy(po);
        if (ObjectUtils.isEmpty((Object)modelBy)) {
            rspBO.setCode("8888");
            rspBO.setMessage("\u5931\u8d25");
            throw new BusinessException("8888", "\u534f\u8bae\u4e0d\u662f\u542f\u7528\u72b6\u6001\u6216\u4e0d\u5b58\u5728" + s);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("remain", "-1");
        if (ObjectUtils.isEmpty((Object)modelBy.getAmountLimit()) || modelBy.getAmountLimit().compareTo(BigDecimal.ZERO) == 0) {
            hashMap.put("remain", "1");
        } else if (!ObjectUtils.isEmpty((Object)modelBy.getAmountLimit()) && modelBy.getAmountLimit().subtract(modelBy.getAmountLimitUse()).compareTo(BigDecimal.ZERO) > 0) {
            hashMap.put("remain", modelBy.getAmountLimit().subtract(modelBy.getAmountLimitUse()).toPlainString());
        }
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        rspBO.setT(hashMap);
        return rspBO;
    }
}

