/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.api.AgrAgreementChangeApplyApprovalAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementChangeApplyApprovalAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementChangeApplyApprovalAbilityRspBO;
import com.tydic.agreement.atom.bo.AgrSendNotificationExtAtomReqBO;
import com.tydic.agreement.bo.AgrTodoBO;
import com.tydic.agreement.busi.api.AgrAgreementChangeApplyApprovalBusiService;
import com.tydic.agreement.busi.bo.AgrAgreementChangeApplyApprovalBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAgreementChangeApplyApprovalBusiRspBO;
import com.tydic.agreement.comb.api.AgrTodoCombService;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.enums.ApproveTypeEnum;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.utils.CommonUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrAgreementChangeApplyApprovalAbilityService"})
public class AgrAgreementChangeApplyApprovalAbilityServiceImpl
implements AgrAgreementChangeApplyApprovalAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementChangeApplyApprovalAbilityServiceImpl.class);
    @Autowired
    private AgrAgreementChangeApplyApprovalBusiService agrAgreementChangeApplyApprovalBusiService;
    @Resource(name="agrPushPlanMsgProvider")
    private ProxyMessageProducer agrPushPlanMsgProvider;
    @Resource(name="agreementExpireSendMessageMqService")
    private ProxyMessageProducer agreementExpireSendMessageMqService;
    @Autowired
    private AgrTodoCombService agrTodoCombService;
    @Value(value="${AGR_PUSH_PLAN_TOPIC:AGR_PUSH_PLAN}")
    private String topic;
    @Value(value="${AGR_PUSH_PLAN_TAG:*}")
    private String tag;
    @Value(value="${PLAN_AGR_EXPIRE_TOPIC:PLAN_AGR_EXPIRE_TOPIC}")
    private String planAgrExpireTopic;
    @Value(value="${PLAN_AGR_EXPIRE_TAG:*}")
    private String planAgrExpireTag;
    @Value(value="${AGR_SYNC_TODO_TOPIC:AGR_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${AGR_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="agrPushTodoProvider")
    private ProxyMessageProducer agrPushTodoProvider;
    @Resource(name="agrSendNotificationProvider")
    private ProxyMessageProducer agrSendNotificationProvider;
    @Value(value="${AGR_SEND_NOTIFICATION_TOPIC:AGR_SEND_NOTIFICATION_TOPIC}")
    private String sendTopic;
    @Value(value="${AGR_SEND_NOTIFICATION_TAG:*}")
    private String sendTag;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;

    @PostMapping(value={"approvalAgreementChangeApply"})
    public AgrAgreementChangeApplyApprovalAbilityRspBO approvalAgreementChangeApply(@RequestBody AgrAgreementChangeApplyApprovalAbilityReqBO abilityReqBO) {
        AgrAgreementChangeApplyApprovalAbilityRspBO abilityRspBO = new AgrAgreementChangeApplyApprovalAbilityRspBO();
        this.validReqParam(abilityReqBO);
        HashMap currentStationMap = new HashMap();
        abilityReqBO.getChangeIds().forEach(changeId -> {
            String currentStationId = this.agrTodoCombService.getNextStationId(String.valueOf(changeId), AgrCommConstant.AuditObjType.AGREEMENT_ADD_AUDIT);
            if (!StringUtils.isEmpty((Object)currentStationId)) {
                currentStationMap.put(changeId, currentStationId);
            }
        });
        AgrAgreementChangeApplyApprovalBusiReqBO busiReqBO = new AgrAgreementChangeApplyApprovalBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)((Object)busiReqBO));
        AgrAgreementChangeApplyApprovalBusiRspBO busiRspBO = this.agrAgreementChangeApplyApprovalBusiService.approvalAgreementChangeApply(busiReqBO);
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)abilityRspBO);
        if (!CollectionUtils.isEmpty(busiRspBO.getAgreementIds())) {
            for (Long id : busiRspBO.getAgreementIds()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("agrId", (Object)id);
                this.agrPushPlanMsgProvider.send(new ProxyMessage(this.topic, this.tag, jsonObject.toJSONString()));
            }
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getExpireTimeAgreementIds())) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("agreementIds", busiRspBO.getExpireTimeAgreementIds());
            this.agreementExpireSendMessageMqService.send(new ProxyMessage(this.planAgrExpireTopic, this.planAgrExpireTag, jsonObject.toJSONString()));
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getAgreementIds())) {
            for (Long agreementId : busiRspBO.getAgreementIds()) {
                JSONObject json = new JSONObject();
                json.put("contractId", (Object)agreementId);
                this.agrSendNotificationProvider.send(new ProxyMessage(this.pushContractTzTopic, this.pushContractTzTag, json.toJSONString()));
            }
        }
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(3000L);
                currentStationMap.forEach((changeId, currentStationId) -> {
                    AgrTodoBO agrTodoBO = new AgrTodoBO();
                    agrTodoBO.setStationId(Long.valueOf(currentStationId));
                    agrTodoBO.setChangeId((Long)changeId);
                    agrTodoBO.setApproveType(ApproveTypeEnum.APPROVE.getCode());
                    agrTodoBO.setOperatorId(String.valueOf(abilityReqBO.getUserId()));
                    agrTodoBO.setOperatorNo(abilityReqBO.getUserName());
                    agrTodoBO.setOperatorName(abilityReqBO.getName());
                    agrTodoBO.setOrgId(abilityReqBO.getOrgId());
                    agrTodoBO.setAuditStatus(AgrCommConstant.AuditResult.ADOPT.equals(abilityReqBO.getAuditResult()));
                    agrTodoBO.setAuditRemark(abilityReqBO.getAuditAdvice());
                    agrTodoBO.setChangeYn(true);
                    if (!CollectionUtils.isEmpty(busiRspBO.getBhChangeIds()) && busiRspBO.getBhChangeIds().contains(changeId)) {
                        AgrSendNotificationExtAtomReqBO sendAtomReqBO = new AgrSendNotificationExtAtomReqBO();
                        sendAtomReqBO.setOperType("4");
                        sendAtomReqBO.setChangeId((Long)changeId);
                        sendAtomReqBO.setUserId(abilityReqBO.getUserId());
                        sendAtomReqBO.setAuditResult(1);
                        this.agrSendNotificationProvider.send(new ProxyMessage(this.sendTopic, this.sendTag, JSON.toJSONString((Object)((Object)sendAtomReqBO))));
                    }
                    if (!CollectionUtils.isEmpty(busiRspBO.getChangeIds()) && busiRspBO.getChangeIds().contains(changeId) || AgrCommConstant.AuditResult.NOT_PASS.equals(abilityReqBO.getAuditResult())) {
                        agrTodoBO.setFinishYn(Boolean.TRUE);
                        agrTodoBO.setFinishTime(new Date());
                        abilityRspBO.setFinishYn(Boolean.TRUE);
                    } else {
                        String nextStationId = this.agrTodoCombService.getNextStationId(String.valueOf(changeId), AgrCommConstant.AuditObjType.AGREEMENT_ADD_AUDIT);
                        if (StringUtils.isEmpty((Object)nextStationId)) {
                            log.error("\u5185\u8d38\u534f\u8bae\u53d8\u66f4\u5ba1\u6279\u672a\u67e5\u8be2\u5230\u4e0b\u4e00\u7ea7\u5f85\u5ba1\u6279\u6570\u636e");
                            return;
                        }
                        agrTodoBO.setNextStationId(Long.valueOf(nextStationId));
                        AgrSendNotificationExtAtomReqBO sendAtomReqBO = new AgrSendNotificationExtAtomReqBO();
                        sendAtomReqBO.setOperType("4");
                        sendAtomReqBO.setChangeId((Long)changeId);
                        sendAtomReqBO.setNextStationId(nextStationId);
                        sendAtomReqBO.setUserId(abilityReqBO.getUserId());
                        this.agrSendNotificationProvider.send(new ProxyMessage(this.sendTopic, this.sendTag, JSON.toJSONString((Object)((Object)sendAtomReqBO))));
                    }
                    this.agrPushTodoProvider.send(new ProxyMessage(this.todoTopic, this.todoTag, JSON.toJSONString((Object)agrTodoBO)));
                });
            }
            catch (Exception ex) {
                log.error("AgrAgreementSubmitAbilityServiceImpl \u65b0\u589e\u5185\u8d38\u534f\u8bae\u53d8\u66f4\u5ba1\u6279\u63a8\u9001\u5f85\u529e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + ex + "\uff1a" + CommonUtils.dealStackTrace(ex));
            }
        });
        return abilityRspBO;
    }

    private void validReqParam(AgrAgreementChangeApplyApprovalAbilityReqBO abilityReqBO) {
        if (abilityReqBO == null) {
            throw new BusinessException("22000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (abilityReqBO.getMemIdIn() == null) {
            throw new BusinessException("0001", "\u64cd\u4f5c\u4ebaID\u3010memIdIn\u3011\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getChangeIds())) {
            throw new BusinessException("0001", "\u53d8\u66f4\u7533\u8bf7ID\u96c6\u5408\u3010changeIds\u3011\u4e3a\u7a7a");
        }
        if (abilityReqBO.getAuditResult() == null) {
            throw new BusinessException("0001", "\u5ba1\u6279\u7ed3\u679c\u3010auditResult\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getStationCodes()) && !abilityReqBO.getNotFindFlag().booleanValue()) {
            throw new BusinessException("0001", "\u5c97\u4f4d\u7f16\u7801\u96c6\u5408\u3010stationCodes\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

