/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.api.AgrAgreementSubmitAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementSubmitAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementSubmitAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrPublicAbilityRspBO;
import com.tydic.agreement.atom.bo.AgrSendNotificationExtAtomReqBO;
import com.tydic.agreement.bo.AgrTodoBO;
import com.tydic.agreement.busi.api.AgrAgreementSubmitBusiService;
import com.tydic.agreement.busi.bo.AgrAgreementSubmitBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAgreementSubmitBusiRspBO;
import com.tydic.agreement.comb.api.AgrTodoCombService;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.enums.ApproveTypeEnum;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementSkuChangePO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.po.UccCommodityTaxTypePO;
import com.tydic.agreement.utils.CommonUtils;
import com.tydic.commodity.common.ability.api.UccUpperTaxCatCodeQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccPublicRspBO;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityReqBo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrAgreementSubmitAbilityService"})
public class AgrAgreementSubmitAbilityServiceImpl
implements AgrAgreementSubmitAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementSubmitAbilityServiceImpl.class);
    @Autowired
    private AgrAgreementSubmitBusiService agrAgreementSubmitBusiService;
    @Value(value="${AGR_SYNC_TODO_TOPIC:AGR_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${AGR_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="agrPushTodoProvider")
    private ProxyMessageProducer agrPushTodoProvider;
    @Autowired
    private AgrTodoCombService agrTodoCombService;
    @Resource(name="agrSendNotificationProvider")
    private ProxyMessageProducer agrSendNotificationProvider;
    @Value(value="${AGR_SEND_NOTIFICATION_TOPIC:AGR_SEND_NOTIFICATION_TOPIC}")
    private String sendTopic;
    @Value(value="${AGR_SEND_NOTIFICATION_TAG:*}")
    private String sendTag;
    @Autowired
    private UccUpperTaxCatCodeQryAbilityService uccUpperTaxCatCodeQryAbilityService;

    @PostMapping(value={"submitAgreementInfo"})
    public AgrAgreementSubmitAbilityRspBO submitAgreementInfo(@RequestBody AgrAgreementSubmitAbilityReqBO abilityReqBO) {
        AgrAgreementSubmitAbilityRspBO abilityRspBO = new AgrAgreementSubmitAbilityRspBO();
        if (abilityReqBO == null) {
            throw new BusinessException("22000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (abilityReqBO.getAgreementId() == null) {
            throw new BusinessException("0001", "\u534f\u8baeId\u3010greementId\u3011\u4e3a\u7a7a");
        }
        if (abilityReqBO.getOperType() == null) {
            throw new BusinessException("0001", "\u64cd\u4f5c\u7c7b\u578b\u3010operType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AgrAgreementSubmitBusiReqBO busiReqBO = new AgrAgreementSubmitBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)((Object)busiReqBO));
        AgrAgreementSubmitBusiRspBO busiRspBO = this.agrAgreementSubmitBusiService.submitAgreementInfo(busiReqBO);
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)abilityRspBO);
        if (AgrCommConstant.AgrSaveOrSubmit.SUBMIT.equals(abilityReqBO.getOperType())) {
            CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(3000L);
                    String nextStationId = this.agrTodoCombService.getNextStationId(String.valueOf(abilityReqBO.getAgreementId()), AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
                    if (StringUtils.isEmpty((Object)nextStationId)) {
                        log.error("\u5185\u8d38\u534f\u8bae\u63d0\u4ea4\u5ba1\u6279\u672a\u67e5\u8be2\u5230\u4e0b\u4e00\u7ea7\u5f85\u5ba1\u6279\u6570\u636e");
                        return;
                    }
                    AgrTodoBO agrTodoBO = new AgrTodoBO();
                    agrTodoBO.setAgreementId(abilityReqBO.getAgreementId());
                    agrTodoBO.setApproveType(ApproveTypeEnum.COMMIT_APPROVE.getCode());
                    agrTodoBO.setOperatorId(String.valueOf(abilityReqBO.getUserId()));
                    agrTodoBO.setOperatorNo(abilityReqBO.getUserName());
                    agrTodoBO.setOperatorName(abilityReqBO.getName());
                    agrTodoBO.setOrgId(abilityReqBO.getOrgId());
                    agrTodoBO.setNextStationId(Long.valueOf(nextStationId));
                    agrTodoBO.setChangeYn(false);
                    this.agrPushTodoProvider.send(new ProxyMessage(this.todoTopic, this.todoTag, JSON.toJSONString((Object)agrTodoBO)));
                    AgrSendNotificationExtAtomReqBO sendAtomReqBO = new AgrSendNotificationExtAtomReqBO();
                    sendAtomReqBO.setOperType("1");
                    sendAtomReqBO.setAgreementId(abilityReqBO.getAgreementId());
                    sendAtomReqBO.setNextStationId(nextStationId);
                    sendAtomReqBO.setUserId(abilityReqBO.getUserId());
                    this.agrSendNotificationProvider.send(new ProxyMessage(this.sendTopic, this.sendTag, JSON.toJSONString((Object)((Object)sendAtomReqBO))));
                }
                catch (Exception ex) {
                    log.error("AgrAgreementSubmitAbilityServiceImpl \u65b0\u589e\u5185\u8d38\u534f\u8bae\u63a8\u9001\u5f85\u529e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + ex + "\uff1a" + CommonUtils.dealStackTrace(ex));
                }
            });
        }
        return abilityRspBO;
    }

    @PostMapping(value={"checkTaxCode"})
    public AgrPublicAbilityRspBO checkTaxCode(@RequestBody AgrAgreementSubmitAbilityReqBO abilityReqBO) {
        List skuPOs;
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        AgrAgreementSubmitBusiReqBO busiReqBO = new AgrAgreementSubmitBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)((Object)busiReqBO));
        AgrPublicAbilityRspBO busiRspBO = this.agrAgreementSubmitBusiService.checkTaxCode(busiReqBO);
        if (!(ObjectUtils.isEmpty((Object)busiRspBO) || ObjectUtils.isEmpty((Object)busiRspBO.getT()) || ObjectUtils.isEmpty((Object)(skuPOs = (List)busiRspBO.getT())))) {
            UccPublicRspBO taxCatCode = this.uccUpperTaxCatCodeQryAbilityService.selectTaxCataLog(new UccUpperTaxCatCodeQryAbilityReqBo());
            if (ObjectUtils.isEmpty((Object)taxCatCode) || ObjectUtils.isEmpty((Object)taxCatCode.getT())) {
                throw new BusinessException("8888", "\u7a0e\u63a7\u7f16\u7801\u67e5\u8be2\u4e3a\u7a7a");
            }
            log.info("^^^^^^^^^^^^^^^^^^^^^^^^^busiRspBO{}^^^^^^^^^taxCatCode{}", (Object)JSON.toJSONString((Object)busiRspBO), (Object)JSON.toJSONString((Object)taxCatCode));
            List taxCatCodes = JSON.parseArray((String)JSON.toJSONString((Object)taxCatCode.getT()), UccCommodityTaxTypePO.class);
            List taxCodes = taxCatCodes.stream().map(a -> a.getTaxCode()).collect(Collectors.toList());
            ArrayList<String> materialCodes = new ArrayList<String>();
            for (AgreementSkuPO po : skuPOs) {
                if (taxCodes.contains(po.getTaxCatalog())) continue;
                materialCodes.add(po.getMaterialCode());
            }
            rspBO.setT(materialCodes);
        }
        return rspBO;
    }

    @PostMapping(value={"checkTaxCodeChange"})
    public AgrPublicAbilityRspBO checkTaxCodeChange(@RequestBody AgrAgreementSubmitAbilityReqBO abilityReqBO) {
        List skuPOs;
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        AgrAgreementSubmitBusiReqBO busiReqBO = new AgrAgreementSubmitBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)((Object)busiReqBO));
        AgrPublicAbilityRspBO busiRspBO = this.agrAgreementSubmitBusiService.checkTaxCodeChange(busiReqBO);
        if (!(ObjectUtils.isEmpty((Object)busiRspBO) || ObjectUtils.isEmpty((Object)busiRspBO.getT()) || ObjectUtils.isEmpty((Object)(skuPOs = (List)busiRspBO.getT())))) {
            UccPublicRspBO taxCatCode = this.uccUpperTaxCatCodeQryAbilityService.selectTaxCataLog(new UccUpperTaxCatCodeQryAbilityReqBo());
            if (ObjectUtils.isEmpty((Object)taxCatCode) || ObjectUtils.isEmpty((Object)taxCatCode.getT())) {
                throw new BusinessException("8888", "\u7a0e\u63a7\u7f16\u7801\u67e5\u8be2\u4e3a\u7a7a");
            }
            log.info("^^^^^^^^^^^^^^^^^^^^^^^^^busiRspBO{}^^^^^^^^^taxCatCode{}", (Object)JSON.toJSONString((Object)busiRspBO), (Object)JSON.toJSONString((Object)taxCatCode));
            List taxCatCodes = JSON.parseArray((String)JSON.toJSONString((Object)taxCatCode.getT()), UccCommodityTaxTypePO.class);
            List taxCodes = taxCatCodes.stream().map(a -> a.getTaxCode()).collect(Collectors.toList());
            ArrayList<String> materialCodes = new ArrayList<String>();
            for (AgreementSkuChangePO po : skuPOs) {
                if (taxCodes.contains(po.getTaxCatalog())) continue;
                materialCodes.add(po.getMaterialCode());
            }
            rspBO.setT(materialCodes);
        }
        return rspBO;
    }
}

