/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.api.AgrCreateAgreementChangeApplyAbilityService;
import com.tydic.agreement.ability.bo.AgrCreateAgreementChangeApplyAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrCreateAgreementChangeApplyAbilityRspBO;
import com.tydic.agreement.atom.bo.AgrSendNotificationExtAtomReqBO;
import com.tydic.agreement.bo.AgrTodoBO;
import com.tydic.agreement.busi.api.AgrCreateAgreementChangeApplyBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementChangeApplyBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementChangeApplyBusiRspBO;
import com.tydic.agreement.comb.api.AgrTodoCombService;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.enums.ApproveTypeEnum;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.utils.CommonUtils;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrCreateAgreementChangeApplyAbilityService"})
public class AgrCreateAgreementChangeApplyAbilityServiceImpl
implements AgrCreateAgreementChangeApplyAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrCreateAgreementChangeApplyAbilityServiceImpl.class);
    @Autowired
    private AgrCreateAgreementChangeApplyBusiService agrCreateAgreementChangeApplyBusiService;
    @Autowired
    private AgreementChangeMapper agreementChangeMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Value(value="${AGR_SYNC_TODO_TOPIC:AGR_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${AGR_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="agrPushTodoProvider")
    private ProxyMessageProducer agrPushTodoProvider;
    @Autowired
    private AgrTodoCombService agrTodoCombService;
    @Resource(name="agrSendNotificationProvider")
    private ProxyMessageProducer agrSendNotificationProvider;
    @Value(value="${AGR_SEND_NOTIFICATION_TOPIC:AGR_SEND_NOTIFICATION_TOPIC}")
    private String sendTopic;
    @Value(value="${AGR_SEND_NOTIFICATION_TAG:*}")
    private String sendTag;

    @PostMapping(value={"createAgreementChangeApply"})
    public AgrCreateAgreementChangeApplyAbilityRspBO createAgreementChangeApply(@RequestBody AgrCreateAgreementChangeApplyAbilityReqBO abilityReqBO) {
        AgrCreateAgreementChangeApplyAbilityRspBO abilityRspBO = new AgrCreateAgreementChangeApplyAbilityRspBO();
        if (!StringUtils.hasText((String)abilityReqBO.getChangeCode())) {
            throw new BusinessException("0001", "\u7533\u8bf7\u7f16\u53f7\u3010changeCode\u3011\u4e3a\u7a7a");
        }
        String s = JSONObject.toJSONString((Object)abilityReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
        AgrCreateAgreementChangeApplyBusiReqBO busiReqBO = (AgrCreateAgreementChangeApplyBusiReqBO)((Object)JSONObject.parseObject((String)s, AgrCreateAgreementChangeApplyBusiReqBO.class));
        if (busiReqBO.getAgrAgreementChangeBO().getAgreementId() == null) {
            busiReqBO.getAgrAgreementChangeBO().setAgreementId(busiReqBO.getAgreementId());
        }
        AgrCreateAgreementChangeApplyBusiRspBO busiRspBO = this.agrCreateAgreementChangeApplyBusiService.createAgreementChangeApply(busiReqBO);
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)abilityRspBO);
        if (AgrCommConstant.AgrSaveOrSubmit.SUBMIT.equals(abilityReqBO.getOperType())) {
            CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(3000L);
                    String nextStationId = this.agrTodoCombService.getNextStationId(String.valueOf(abilityReqBO.getChangeId()), AgrCommConstant.AuditObjType.AGREEMENT_ADD_AUDIT);
                    if (StringUtils.isEmpty((Object)nextStationId)) {
                        log.error("AgrCreateAgreementChangeApplyAbilityServiceImpl\uff1a\u5185\u8d38\u534f\u8bae\u53d8\u66f4\u63d0\u4ea4\u5ba1\u6279\u672a\u67e5\u8be2\u5230\u4e0b\u4e00\u7ea7\u5f85\u5ba1\u6279\u6570\u636e");
                        return;
                    }
                    AgrTodoBO agrTodoBO = new AgrTodoBO();
                    agrTodoBO.setChangeId(abilityReqBO.getChangeId());
                    agrTodoBO.setApproveType(ApproveTypeEnum.COMMIT_APPROVE.getCode());
                    agrTodoBO.setOperatorId(String.valueOf(abilityReqBO.getUserId()));
                    agrTodoBO.setOperatorNo(abilityReqBO.getUserName());
                    agrTodoBO.setOperatorName(abilityReqBO.getName());
                    agrTodoBO.setOrgId(abilityReqBO.getOrgId());
                    agrTodoBO.setNextStationId(Long.valueOf(nextStationId));
                    agrTodoBO.setChangeYn(true);
                    this.agrPushTodoProvider.send(new ProxyMessage(this.todoTopic, this.todoTag, JSON.toJSONString((Object)agrTodoBO)));
                    AgrSendNotificationExtAtomReqBO sendAtomReqBO = new AgrSendNotificationExtAtomReqBO();
                    sendAtomReqBO.setOperType("2");
                    sendAtomReqBO.setAgreementId(abilityReqBO.getAgreementId());
                    sendAtomReqBO.setNextStationId(nextStationId);
                    sendAtomReqBO.setUserId(abilityReqBO.getUserId());
                    this.agrSendNotificationProvider.send(new ProxyMessage(this.sendTopic, this.sendTag, JSON.toJSONString((Object)((Object)sendAtomReqBO))));
                }
                catch (Exception ex) {
                    log.error("AgrCreateAgreementChangeApplyAbilityServiceImpl \u65b0\u589e\u5185\u8d38\u534f\u8bae\u53d8\u66f4\u63a8\u9001\u5f85\u529e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + ex + "\uff1a" + CommonUtils.dealStackTrace(ex));
                }
            });
        }
        return abilityRspBO;
    }
}

