/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.tydic.agreement.ability.api.AgrCreateAgreementSkuAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.ability.bo.AgrCreateAgreementSkuAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrCreateAgreementSkuAbilityRspBO;
import com.tydic.agreement.busi.api.AgrCreateAgreementSkuBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuBusiRspBO;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrCreateAgreementSkuAbilityService"})
public class AgrCreateAgreementSkuAbilityServiceImpl
implements AgrCreateAgreementSkuAbilityService {
    @Autowired
    private AgrCreateAgreementSkuBusiService agrCreateAgreementSkuBusiService;
    @Autowired
    private AgreementMapper agreementMapper;

    @PostMapping(value={"createAgreementSku"})
    public AgrCreateAgreementSkuAbilityRspBO createAgreementSku(@RequestBody AgrCreateAgreementSkuAbilityReqBO abilityReqBO) {
        AgrCreateAgreementSkuAbilityRspBO rsp = new AgrCreateAgreementSkuAbilityRspBO();
        if (abilityReqBO.isCheckFlag()) {
            this.validateParam(abilityReqBO);
        }
        AgrCreateAgreementSkuBusiReqBO agrCreateAgreementSkuBusiReqBO = new AgrCreateAgreementSkuBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)((Object)agrCreateAgreementSkuBusiReqBO));
        AgrCreateAgreementSkuBusiRspBO agrCreateAgreementSkuBusiRspBO = this.agrCreateAgreementSkuBusiService.createAgreementSku(agrCreateAgreementSkuBusiReqBO);
        BeanUtils.copyProperties((Object)((Object)agrCreateAgreementSkuBusiRspBO), (Object)rsp);
        return rsp;
    }

    private void validateParam(AgrCreateAgreementSkuAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO.getMemIdIn()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010memIdIn\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getAgreementId()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agreementId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getAgrAgreementSkuBOs())) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(abilityReqBO.getAgreementId());
        AgreementPO agreementPO1 = this.agreementMapper.getModelBy(agreementPO);
        if (agreementPO1 == null) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e0d\u5b58\u5728\uff01");
        }
        boolean isSupermarketStaff = agreementPO1.getIsSupermarketStaff() != null && agreementPO1.getIsSupermarketStaff() == 1;
        abilityReqBO.setSupermarketStaff(isSupermarketStaff);
        for (AgrAgreementSkuBO bo : abilityReqBO.getAgrAgreementSkuBOs()) {
            if (!isSupermarketStaff && StringUtils.isBlank((CharSequence)bo.getMaterialId())) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.materialId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!isSupermarketStaff && StringUtils.isBlank((CharSequence)bo.getMaterialName())) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.materialName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)bo.getMeasureName())) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.measureName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == bo.getBuyPrice()) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.buyPrice\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!isSupermarketStaff && null == bo.getBuyPriceSum()) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.buyPriceSum\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == bo.getMarkupRate()) {
                bo.setMarkupRate(Double.valueOf(0.0));
            }
            if (null == bo.getSalePrice()) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.salePrice\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!isSupermarketStaff && null == bo.getSalePriceSum()) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.salePriceSum\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null != bo.getSupplyCycle()) continue;
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementSkuBOs.supplyCycle\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

