/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.tydic.agreement.ability.api.AgrDeleteAgreementChangeApplyAbilityService;
import com.tydic.agreement.ability.bo.AgrDeleteAgreementChangeApplyAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrDeleteAgreementChangeApplyAbilityRspBO;
import com.tydic.agreement.busi.api.AgrDeleteAgreementChangeApplyBusiService;
import com.tydic.agreement.busi.bo.AgrDeleteAgreementChangeApplyBusiReqBO;
import com.tydic.agreement.busi.bo.AgrDeleteAgreementChangeApplyBusiRspBO;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.todo.ability.api.TodoWaitDoneWriteAbilityService;
import com.tydic.todo.ability.bo.TodoDeleteWaitDoneAbilityReqBO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrDeleteAgreementChangeApplyAbilityService"})
public class AgrDeleteAgreementChangeApplyAbilityServiceImpl
implements AgrDeleteAgreementChangeApplyAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrDeleteAgreementChangeApplyAbilityServiceImpl.class);
    @Autowired
    private AgrDeleteAgreementChangeApplyBusiService agrDeleteAgreementChangeApplyBusiService;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private TodoWaitDoneWriteAbilityService todoWaitDoneWriteAbilityService;

    @PostMapping(value={"deleteAgreementChangeApply"})
    public AgrDeleteAgreementChangeApplyAbilityRspBO deleteAgreementChangeApply(@RequestBody AgrDeleteAgreementChangeApplyAbilityReqBO abilityReqBO) {
        AgrDeleteAgreementChangeApplyAbilityRspBO abilityRspBO = new AgrDeleteAgreementChangeApplyAbilityRspBO();
        this.validParam(abilityReqBO);
        AgrDeleteAgreementChangeApplyBusiReqBO busiReqBO = new AgrDeleteAgreementChangeApplyBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)((Object)busiReqBO));
        AgrDeleteAgreementChangeApplyBusiRspBO busiRspBO = this.agrDeleteAgreementChangeApplyBusiService.deleteAgreementChangeApply(busiReqBO);
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)abilityRspBO);
        if ("0000".equals(busiRspBO.getRespCode())) {
            this.deleteXtFlow(abilityReqBO);
        }
        return abilityRspBO;
    }

    private void deleteXtFlow(AgrDeleteAgreementChangeApplyAbilityReqBO abilityReqBO) {
        try {
            CompletableFuture.runAsync(() -> abilityReqBO.getChangeIds().forEach(changeId -> {
                UacQryAuditLogReqBO reqBO = new UacQryAuditLogReqBO();
                reqBO.setObjId(changeId.toString());
                UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLastLog(reqBO);
                if (Objects.isNull(uacQryAuditLogRspBO) || !"0000".equals(uacQryAuditLogRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)uacQryAuditLogRspBO.getRows())) {
                    log.error("\u5220\u9664\u534f\u540c\u5f85\u529e\u6d41\u7a0b \u83b7\u53d6\u5ba1\u6279\u5386\u53f2\u8bb0\u5f55 \u5f02\u5e38 changeId:{}", changeId);
                    return;
                }
                List rows = uacQryAuditLogRspBO.getRows();
                ApprovalLogBO approvalLogBO = (ApprovalLogBO)rows.get(0);
                Long auditOrderId = approvalLogBO.getAuditOrderId();
                TodoDeleteWaitDoneAbilityReqBO todoDeleteWaitDoneAbilityReqBO = new TodoDeleteWaitDoneAbilityReqBO();
                todoDeleteWaitDoneAbilityReqBO.setUserHandlerNo(abilityReqBO.getUserName());
                todoDeleteWaitDoneAbilityReqBO.setObjId(changeId.toString());
                todoDeleteWaitDoneAbilityReqBO.setFlowId(auditOrderId.toString());
                this.todoWaitDoneWriteAbilityService.deleteWaitDone(todoDeleteWaitDoneAbilityReqBO);
            }));
        }
        catch (Exception e) {
            log.error("deleteXtFlow ChangeIds:{} error:{}", (Object)abilityReqBO.getChangeIds(), (Object)e);
        }
    }

    private void validParam(AgrDeleteAgreementChangeApplyAbilityReqBO abilityReqBO) {
        if (abilityReqBO == null) {
            throw new BusinessException("22000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (abilityReqBO.getMemIdIn() == null) {
            throw new BusinessException("0001", "\u64cd\u4f5c\u4ebaID\u3010memIdIn\u3011\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getChangeIds())) {
            throw new BusinessException("0001", "\u53d8\u66f4Id\u96c6\u5408\u3010changeIds\u3011\u4e3a\u7a7a");
        }
    }
}

