/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.agreement.ability.api.AgrPushPlanAbilityService;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuCartAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuCartAbilityRspBO;
import com.tydic.agreement.atom.bo.PushPlanItem;
import com.tydic.agreement.atom.bo.PushPlanReqBO;
import com.tydic.agreement.busi.api.AgrPushPlanBusiService;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementScopePO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.utils.HttpUtils;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQueryAbilityService;
import com.tydic.umc.general.ability.api.UmcMemDetailQueryAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQueryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailInfoAbilityBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrPushPlanAbilityService"})
public class AgrPushPlanAbilityServiceImpl
implements AgrPushPlanAbilityService {
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private UmcEnterpriseOrgQueryAbilityService umcEnterpriseOrgQueryAbilityService;
    @Autowired
    private UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;
    @Value(value="${agr.plan.url:http://172.16.8.147:8070/plan/agreementController/addaAllAgreement}")
    private String planUrl;
    @Autowired
    private AgrPushPlanBusiService agrPushPlanBusiService;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;

    @PostMapping(value={"push"})
    public AgrQryAgreementSkuCartAbilityRspBO push(@RequestBody AgrQryAgreementSkuCartAbilityReqBO reqBO) {
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(reqBO.getAgreementId());
        agreementPO = this.agreementMapper.getModelBy(agreementPO);
        AgreementSkuPO skuPO = new AgreementSkuPO();
        skuPO.setAgreementId(agreementPO.getAgreementId());
        List<AgreementSkuPO> list = this.agreementSkuMapper.getList(skuPO);
        PushPlanReqBO pushPlanReqBO = new PushPlanReqBO();
        pushPlanReqBO.setAgreementId(agreementPO.getAgreementId());
        pushPlanReqBO.setAgreementName(agreementPO.getAgreementName());
        pushPlanReqBO.setAgreementSrc((byte)1);
        pushPlanReqBO.setAgreementStatus(agreementPO.getAgreementStatus());
        pushPlanReqBO.setAgreementType((byte)2);
        pushPlanReqBO.setAgreementVariety(agreementPO.getAgreementVariety());
        pushPlanReqBO.setCurrency(agreementPO.getCurrency());
        pushPlanReqBO.setEffDate(agreementPO.getEffDate());
        pushPlanReqBO.setIsDelete(agreementPO.getIsDelete());
        pushPlanReqBO.setPlaAgreementCode(agreementPO.getPlaAgreementCode());
        pushPlanReqBO.setProducerCode(agreementPO.getProducerCode());
        pushPlanReqBO.setProducerId(this.getMemErp(agreementPO.getProducerId()));
        pushPlanReqBO.setProducerName(agreementPO.getProducerName());
        pushPlanReqBO.setRemark(agreementPO.getRemark());
        pushPlanReqBO.setScopeType(agreementPO.getScopeType());
        pushPlanReqBO.setSignTime(agreementPO.getSignTime());
        pushPlanReqBO.setSupplierId(this.getMemErp(agreementPO.getSupplierId()));
        pushPlanReqBO.setSupplierName(agreementPO.getSupplierName());
        pushPlanReqBO.setUpdateLoginId(agreementPO.getUpdateLoginId());
        pushPlanReqBO.setUpdateName(agreementPO.getUpdateName());
        pushPlanReqBO.setUpdateTime(agreementPO.getUpdateTime());
        pushPlanReqBO.setVendorCode(this.getOrgErp(agreementPO.getVendorId()));
        pushPlanReqBO.setVendorId(this.getOrgErp(agreementPO.getVendorId()));
        pushPlanReqBO.setVendorName(agreementPO.getVendorName());
        ArrayList<String> ouList = new ArrayList<String>();
        if (agreementPO.getScopeType() != 0) {
            AgreementScopePO agreementScopePO = new AgreementScopePO();
            agreementScopePO.setAgreementId(agreementPO.getAgreementId());
            List<AgreementScopePO> agreementScopePOS = this.agreementScopeMapper.getList(agreementScopePO);
            if (!CollectionUtils.isEmpty((Collection)agreementScopePOS)) {
                Iterator iterator = agreementScopePOS.iterator();
                while (iterator.hasNext()) {
                    AgreementScopePO scopePO = (AgreementScopePO)iterator.next();
                    if (scopePO.getScopeCode() == null) continue;
                    ouList.add(this.getErpOrgCode(scopePO.getScopeCode()));
                }
            }
        }
        pushPlanReqBO.setOuList(ouList);
        ArrayList<PushPlanItem> childEntityList = new ArrayList<PushPlanItem>();
        for (AgreementSkuPO item : list) {
            PushPlanItem sh = new PushPlanItem();
            sh.setAgreementId(item.getAgreementId());
            sh.setAgreementSkuId(item.getAgreementSkuId());
            sh.setCreateLoginId(pushPlanReqBO.getProducerId());
            sh.setCreateName(pushPlanReqBO.getProducerName());
            sh.setCreateTime(agreementPO.getEffDate());
            sh.setEffDate(agreementPO.getEffDate());
            sh.setExpDate(agreementPO.getExpDate());
            sh.setMaterialCode(item.getMaterialCode());
            sh.setMaterialId(item.getMaterialId());
            sh.setMaterialName(item.getMaterialName());
            sh.setRemark(item.getRemark());
            sh.setIsDelete(item.getIsDelete());
            try {
                sh.setSalePrice(item.getSalePrice());
            }
            catch (Exception exception) {
                // empty catch block
            }
            sh.setSkuStatus(item.getSkuStatus().byteValue());
            sh.setTaxRate(item.getTaxRate().byteValue());
            sh.setUpdateLoginId(pushPlanReqBO.getUpdateLoginId());
            sh.setUpdateName(pushPlanReqBO.getUpdateName());
            sh.setUpdateTime(pushPlanReqBO.getUpdateTime());
            childEntityList.add(sh);
        }
        pushPlanReqBO.setChildEntityList(childEntityList);
        String result = HttpUtils.doPost(this.planUrl, JSONObject.toJSONString((Object)pushPlanReqBO));
        reqBO.setInContent(JSONObject.toJSONString((Object)pushPlanReqBO));
        reqBO.setOutContent(result);
        this.agrPushPlanBusiService.addPush(reqBO);
        AgrQryAgreementSkuCartAbilityRspBO rspBO = new AgrQryAgreementSkuCartAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(result);
        return rspBO;
    }

    private String getMemErp(Long memId) {
        UmcMemDetailQueryAbilityReqBO reqBO = new UmcMemDetailQueryAbilityReqBO();
        reqBO.setMemId(memId);
        UmcMemDetailQueryAbilityRspBO abilityRspBO = this.umcMemDetailQueryAbilityService.memDetailQuery(reqBO);
        if (abilityRspBO.getUmcMemDetailInfoAbilityRspBO() != null) {
            UmcMemDetailInfoAbilityBO abilityBO = abilityRspBO.getUmcMemDetailInfoAbilityRspBO();
            return abilityBO.getAgentAccount();
        }
        return null;
    }

    private String getOrgErp(Long orgId) {
        UmcEnterpriseOrgQueryAbilityReqBO reqBO = new UmcEnterpriseOrgQueryAbilityReqBO();
        reqBO.setOrgIdWeb(orgId);
        UmcEnterpriseOrgDetailAbilityRspBO abilityRspBO = this.umcEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(reqBO);
        if (abilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
            return abilityRspBO.getUmcEnterpriseOrgAbilityBO().getOrgCode();
        }
        return null;
    }

    private String getErpOrgCode(Long orgId) {
        UmcEnterpriseOrgQueryAbilityReqBO reqBO = new UmcEnterpriseOrgQueryAbilityReqBO();
        reqBO.setOrgIdWeb(orgId);
        UmcEnterpriseOrgDetailAbilityRspBO abilityRspBO = this.umcEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(reqBO);
        if (abilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
            return abilityRspBO.getUmcEnterpriseOrgAbilityBO().getErpOrgCode();
        }
        return null;
    }
}

