/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.agreement.ability.api.AgrQueryAgreementApprovalProcessListPageAbilityService;
import com.tydic.agreement.ability.bo.AgrApprovalLogBO;
import com.tydic.agreement.ability.bo.AgrQueryAgreementApprovalProcessListPageReqBO;
import com.tydic.agreement.ability.bo.AgrQueryAgreementApprovalProcessListPageRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.UocOrdTaskMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.UocOrdTaskPO;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import com.tydic.uac.dao.ApprovalObjMapper;
import com.tydic.uac.po.ApprovalObjPO;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrQueryAgreementApprovalProcessListPageAbilityService"})
public class AgrQueryAgreementApprovalProcessListPageAbilityServiceImpl
implements AgrQueryAgreementApprovalProcessListPageAbilityService {
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private ApprovalObjMapper approvalObjMapper;
    @Autowired
    private UocOrdTaskMapper uocOrdTaskMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;

    @PostMapping(value={"queryAgreementApprovalProcessListPage"})
    public AgrQueryAgreementApprovalProcessListPageRspBO queryAgreementApprovalProcessListPage(@RequestBody AgrQueryAgreementApprovalProcessListPageReqBO reqBO) {
        UacQryAuditLogRspBO uacQryAuditLogRspBO;
        AgrQueryAgreementApprovalProcessListPageRspBO rspBO = new AgrQueryAgreementApprovalProcessListPageRspBO();
        if (reqBO.getAgreementId() == null && reqBO.getChangeId() == null && reqBO.getOrderId() == null) {
            throw new BusinessException("8888", "agreementId \u548c changeId,orderId \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a!");
        }
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        if (null == reqBO.getChangeId()) {
            uacQryAuditLogReqBO.setObjId(reqBO.getAgreementId().toString());
            uacQryAuditLogReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        } else {
            uacQryAuditLogReqBO.setObjId(reqBO.getChangeId().toString());
            uacQryAuditLogReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_ADD_AUDIT);
        }
        if (reqBO.getAgreementId() != null && reqBO.getChangeId() != null) {
            ApprovalObjPO approvalObjPO = new ApprovalObjPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)approvalObjPO);
            List list = this.approvalObjMapper.getList(approvalObjPO);
            if (list == null || list.size() < 1) {
                throw new BusinessException("8888", "\u5ba1\u6279\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            ApprovalObjPO approvalObj = (ApprovalObjPO)list.get(0);
            for (ApprovalObjPO itemPO : list) {
                if (itemPO.getId() < approvalObj.getId()) continue;
                approvalObj = itemPO;
            }
        }
        if (!"0000".equals((uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO)).getRespCode())) {
            throw new BusinessException(uacQryAuditLogRspBO.getRespCode(), uacQryAuditLogRspBO.getRespDesc());
        }
        ArrayList<AgrApprovalLogBO> approvalLogBOS = new ArrayList<AgrApprovalLogBO>();
        String currentStepId = "";
        String nextStationId = "";
        Long auditOrderId = null;
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List logRspBORows = uacQryAuditLogRspBO.getRows();
        if (logRspBORows != null && logRspBORows.size() > 0) {
            nextStationId = ((ApprovalLogBO)logRspBORows.get(0)).getNextStationId();
            LocalDateTime lastDealTime = null;
            if (((ApprovalLogBO)logRspBORows.get(0)).getDealTime() != null) {
                lastDealTime = ((ApprovalLogBO)logRspBORows.get(0)).getDealTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            for (int i = 0; i < logRspBORows.size(); ++i) {
                ApprovalLogBO approvalLogBO = (ApprovalLogBO)logRspBORows.get(i);
                currentStepId = approvalLogBO.getStepId();
                auditOrderId = approvalLogBO.getAuditOrderId();
                if (approvalLogBO.getAuditResult() == null) {
                    approvalLogBO.setAudit("\u63d0\u4ea4");
                    approvalLogBO.setAuditAdvice("");
                } else {
                    approvalLogBO.setAudit(String.valueOf(approvalLogBO.getAuditResult()).equals("0") ? "\u901a\u8fc7" : "\u62d2\u7edd");
                }
                if (i < logRspBORows.size() - 1) {
                    Date date = ((ApprovalLogBO)logRspBORows.get(i + 1)).getDealTime();
                    long time = approvalLogBO.getDealTime().getTime() - date.getTime();
                    long hours = time / 3600000L % 24L;
                    long lestMinutes = time % 3600000L;
                    long minutes = lestMinutes / 60000L;
                    long lestS = lestMinutes % 60000L;
                    long s = lestS / 1000L;
                    long day = time / 3600000L / 24L;
                    String str = "";
                    if (day > 0L) {
                        str = day + "\u5929";
                    }
                    if (hours > 0L) {
                        str = str + hours + "\u5c0f\u65f6";
                    }
                    if (minutes > 0L) {
                        str = str + minutes + "\u5206";
                    } else if (StringUtils.isNotBlank((String)str)) {
                        str = str + "0\u5206";
                    }
                    if (s > 0L) {
                        str = str + s + "\u79d2";
                    } else if (StringUtils.isNotBlank((String)str)) {
                        str = str + "0\u79d2";
                    }
                    approvalLogBO.setProcessTimeStr(str);
                    approvalLogBO.setProcessTime(Long.valueOf(time));
                }
                AgrApprovalLogBO agrApprovalLogBO = new AgrApprovalLogBO();
                BeanUtils.copyProperties((Object)approvalLogBO, (Object)agrApprovalLogBO);
                agrApprovalLogBO.setDurationTime(approvalLogBO.getProcessTimeStr());
                if (approvalLogBO.getCreateTime() != null) {
                    agrApprovalLogBO.setCreateTimeStr(DateUtils.dateToStr((Date)approvalLogBO.getCreateTime()));
                }
                if (approvalLogBO.getDealTime() != null) {
                    agrApprovalLogBO.setDealTimeStr(DateUtils.dateToStr((Date)approvalLogBO.getDealTime()));
                }
                approvalLogBOS.add(0, agrApprovalLogBO);
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)nextStationId)) {
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(Long.parseLong(nextStationId)));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
                for (UserBO itemBO : dycStationOrgSelectUserNameRspBO.getUserList()) {
                    AgrApprovalLogBO uocApprovalLogBO = new AgrApprovalLogBO();
                    uocApprovalLogBO.setOperName(itemBO.getName());
                    uocApprovalLogBO.setOperDept(itemBO.getCompanyFullName());
                    uocApprovalLogBO.setUrgingFlag("1");
                    approvalLogBOS.add(uocApprovalLogBO);
                }
            }
        }
        Long agrId = 0L;
        agrId = null == reqBO.getChangeId() ? reqBO.getAgreementId() : reqBO.getChangeId();
        List<UocOrdTaskPO> uocOrdTaskPOS = this.uocOrdTaskMapper.selectProcInstIdById(agrId);
        if (uocOrdTaskPOS != null && uocOrdTaskPOS.size() > 0) {
            rspBO.setProcDefId(uocOrdTaskPOS.get(0).getProcInstId());
        }
        rspBO.setCurrentStepId(currentStepId);
        rspBO.setRows(approvalLogBOS);
        rspBO.setTotal(uacQryAuditLogRspBO.getTotalPages());
        rspBO.setRecordsTotal(uacQryAuditLogRspBO.getTotalRecords());
        rspBO.setPageNo(uacQryAuditLogRspBO.getPageNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

