/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.google.common.collect.Lists;
import com.tydic.agreement.ability.api.AgrWaitDoneListQryAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrWaitDoneQueryAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrWaitDoneQueryAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrWaitDoneQueryItemBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.bo.AgrQryAgreementByPageBusiReqBO;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.po.AgreementChangePO;
import com.tydic.agreement.utils.AgrDateUtils;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.umc.general.ability.api.UmcWorkBenchOvertimeConfigQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcWorkBenchOvertimeConfigQryReqBo;
import com.tydic.umc.general.ability.bo.UmcWorkBenchOvertimeConfigQryRspBoData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrWaitDoneListQryAbilityService"})
public class AgrWaitDoneListQryAbilityServiceImpl
implements AgrWaitDoneListQryAbilityService {
    @Autowired
    private UmcWorkBenchOvertimeConfigQryAbilityService umcWorkBenchOvertimeConfigQryAbilityService;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    private static final String contractChangeEffect = "1051";
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementChangeMapper agreementChangeMapper;

    @PostMapping(value={"queryWaitDoneForCode"})
    public AgrWaitDoneQueryAbilityRspBO queryWaitDoneForCode(@RequestBody AgrWaitDoneQueryAbilityReqBO reqBO) {
        AgrWaitDoneQueryAbilityRspBO rspBo = new AgrWaitDoneQueryAbilityRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (StringUtils.isEmpty((CharSequence)reqBO.getOccupation())) {
            return rspBo;
        }
        ArrayList<AgrWaitDoneQueryItemBO> rows = new ArrayList<AgrWaitDoneQueryItemBO>();
        Integer itemDetailTotal = 0;
        Integer overtimeTotal = 0;
        Integer willOvertimeTotal = 0;
        UmcWorkBenchOvertimeConfigQryReqBo configQryReqBo = new UmcWorkBenchOvertimeConfigQryReqBo();
        configQryReqBo.setOvertimeType(Integer.valueOf(3));
        configQryReqBo.setCenterCode("AGR");
        BasePageRspBo configRspBO = this.umcWorkBenchOvertimeConfigQryAbilityService.qryOvertimeConfigList(configQryReqBo);
        if (CollectionUtils.isEmpty((Collection)configRspBO.getRows())) {
            rspBo.setRespDesc("\u83b7\u53d6\u8d85\u9650\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
            return rspBo;
        }
        Map<String, Long> overtimeMap = configRspBO.getRows().stream().collect(Collectors.toMap(UmcWorkBenchOvertimeConfigQryRspBoData::getBusiCode, UmcWorkBenchOvertimeConfigQryRspBoData::getOvertime));
        if (reqBO.getWaitDoneCodeList().contains(contractChangeEffect)) {
            AgrQryAgreementByPageBusiReqBO busiReqBO = new AgrQryAgreementByPageBusiReqBO();
            String agreementStatusTableStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "EFF_AGREEMENT_STATUS_PCODE", "4");
            if (StringUtils.isNotBlank((CharSequence)agreementStatusTableStr)) {
                List<String> agreementStatusStr = Arrays.asList(agreementStatusTableStr.split(","));
                ArrayList<Byte> agreementStatuss = new ArrayList<Byte>();
                for (String agreementStatus : agreementStatusStr) {
                    agreementStatuss.add(Byte.valueOf(agreementStatus));
                }
                busiReqBO.setAgreementStatuss(agreementStatuss);
            }
            busiReqBO.setAgreementMode((byte)2);
            busiReqBO.setAgreementStatus((byte)14);
            busiReqBO.setProducerCode(reqBO.getOccupation());
            busiReqBO.setSupermarketStaffFlag(0);
            busiReqBO.setTableType("1");
            busiReqBO.setTradeModes(Lists.newArrayList((Object[])new Byte[]{(byte)2, (byte)3, (byte)4}));
            busiReqBO.setMemIdIn(reqBO.getMemIdIn());
            List<AgrAgreementBO> agrList = this.agreementMapper.getWaitList(busiReqBO);
            if (!CollectionUtils.isEmpty(agrList)) {
                AgrWaitDoneQueryItemBO itemBO = new AgrWaitDoneQueryItemBO();
                itemBO.setItemCode(contractChangeEffect);
                itemBO.setItemCount(Integer.valueOf(agrList.size()));
                itemDetailTotal = itemDetailTotal + itemBO.getItemCount();
                List<Long> agreementIds = agrList.stream().map(AgrAgreementBO::getAgreementId).distinct().collect(Collectors.toList());
                List<AgreementChangePO> changePOList = this.agreementChangeMapper.getWaitListByAgreementIds(agreementIds);
                if (!CollectionUtils.isEmpty(changePOList)) {
                    Long day = overtimeMap.get(contractChangeEffect);
                    Date overtimeDate = AgrDateUtils.computeWorkDayBefore(day.intValue());
                    Date willOvertimeDate = AgrDateUtils.computeWorkDayBefore(day.intValue() - 1);
                    long overtimeCount = changePOList.stream().filter(e -> e.getAuditTime().before(overtimeDate)).count();
                    long willOvertimeCount = changePOList.stream().filter(e -> e.getAuditTime().after(overtimeDate)).filter(e -> e.getAuditTime().before(willOvertimeDate)).count();
                    itemBO.setOvertimeCount(Integer.valueOf((int)overtimeCount));
                    overtimeTotal = overtimeTotal + itemBO.getOvertimeCount();
                    itemBO.setWillOvertimeCount(Integer.valueOf((int)willOvertimeCount));
                    willOvertimeTotal = willOvertimeTotal + itemBO.getWillOvertimeCount();
                }
                rows.add(itemBO);
            }
        }
        rspBo.setRows(rows);
        rspBo.setOvertimeTotal(overtimeTotal);
        rspBo.setItemDetailTotal(itemDetailTotal);
        rspBo.setWillOvertimeTotal(willOvertimeTotal);
        return rspBo;
    }
}

