/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.atom.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.atom.api.AgrCreateAgreementSkuAtomService;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementSkuLogMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementSkuLogPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.utils.MoneyUtils;
import com.tydic.commodity.common.ability.api.UccUpperTaxCatCodeQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrCreateAgreementSkuAtomServiceImpl
implements AgrCreateAgreementSkuAtomService {
    private static final Logger log = LoggerFactory.getLogger(AgrCreateAgreementSkuAtomServiceImpl.class);
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementSkuLogMapper agreementSkuLogMapper;
    @Autowired
    private UccUpperTaxCatCodeQryAbilityService uccUpperTaxCatCodeQryAbilityService;

    @Override
    public AgrCreateAgreementSkuAtomRspBO createAgreementSku(AgrCreateAgreementSkuAtomReqBO atomReqBO) {
        List<String> materialIds;
        AgrCreateAgreementSkuAtomRspBO rsp = new AgrCreateAgreementSkuAtomRspBO();
        if (!(atomReqBO.isSupermarketStaff() || atomReqBO.isContractAgr() || ObjectUtils.isEmpty((Object)atomReqBO.getOrderMethod()) || !atomReqBO.getOrderMethod().equals(2) || CollectionUtils.isEmpty(materialIds = this.agreementSkuMapper.selectMaterialIds(atomReqBO.getAgreementId())))) {
            for (AgrAgreementSkuBO each : atomReqBO.getAgrAgreementSkuBOs()) {
                if (!materialIds.contains(each.getMaterialId())) continue;
                throw new ZTBusinessException("\u8be5\u534f\u8bae\u4e0b\u5df2\u5b58\u5728\u7269\u6599\uff1a" + each.getMaterialName());
            }
        }
        ArrayList<AgreementSkuPO> agrAgreementSkuPOs = new ArrayList<AgreementSkuPO>();
        ArrayList<AgreementSkuLogPO> agrAgreementSkuLogPOs = new ArrayList<AgreementSkuLogPO>();
        List taxCodes = atomReqBO.getAgrAgreementSkuBOs().stream().filter(a -> !StringUtils.isEmpty((Object)a.getTaxCatalog())).map(a -> a.getTaxCatalog()).distinct().collect(Collectors.toList());
        Map taxCatCodeMap = new HashMap();
        try {
            if (!CollectionUtils.isEmpty(taxCodes)) {
                UccUpperTaxCatCodeQryAbilityReqBo uccUpperTaxCatCodeQryAbilityReqBo = new UccUpperTaxCatCodeQryAbilityReqBo();
                uccUpperTaxCatCodeQryAbilityReqBo.setTaxCodes(taxCodes);
                UccUpperTaxCatCodeQryAbilityRspBo uccUpperTaxCatCodeQryAbilityRspBo = this.uccUpperTaxCatCodeQryAbilityService.qryUpperTaxCatCode(uccUpperTaxCatCodeQryAbilityReqBo);
                if ("0000".equals(uccUpperTaxCatCodeQryAbilityRspBo.getRespCode()) && null == (taxCatCodeMap = uccUpperTaxCatCodeQryAbilityRspBo.getTaxCatCodeMap())) {
                    taxCatCodeMap = new HashMap();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        for (AgrAgreementSkuBO bo : atomReqBO.getAgrAgreementSkuBOs()) {
            List taxIds;
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            AgreementSkuLogPO agreementSkuLogPO = new AgreementSkuLogPO();
            if (ObjectUtils.isEmpty((Object)bo.getBuyNumber())) {
                bo.setBuyNumber(BigDecimal.ZERO);
            }
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuPO);
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuLogPO);
            if (!StringUtils.isEmpty((Object)agreementSkuPO.getTaxCatalog()) && !CollectionUtils.isEmpty((Collection)(taxIds = (List)taxCatCodeMap.get(agreementSkuPO.getTaxCatalog())))) {
                String taxCatalogList = org.apache.commons.lang3.StringUtils.join((Iterable)taxIds, (String)",");
                agreementSkuPO.setTaxCatalogList(taxCatalogList);
            }
            Long agreementSkuId = Sequence.getInstance().nextId();
            agreementSkuPO.setAgreementSkuId(agreementSkuId);
            agreementSkuPO.setAgreementId(atomReqBO.getAgreementId());
            agreementSkuPO.setAgreementVersion(atomReqBO.getAgreementVersion());
            agreementSkuPO.setSupplierId(atomReqBO.getSupplierId());
            agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuPO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuPO.setCreateLoginId(atomReqBO.getMemIdIn());
            agreementSkuPO.setCreateName(atomReqBO.getUserName());
            agreementSkuPO.setCreateTime(new Date());
            if (!StringUtils.isEmpty((Object)bo.getPackingRate())) {
                agreementSkuPO.setPackingRate(bo.getPackingRate());
            } else {
                agreementSkuPO.setPackingRate("1");
            }
            if (agreementSkuPO.getBuyNumber() != null) {
                agreementSkuPO.setBuyPriceSum(agreementSkuPO.getBuyPrice().multiply(agreementSkuPO.getBuyNumber()));
                if (agreementSkuPO.getSalePrice() != null) {
                    agreementSkuPO.setSalePriceSum(agreementSkuPO.getSalePrice().multiply(agreementSkuPO.getBuyNumber()));
                }
                if (agreementSkuPO.getSalePrice() == null) {
                    agreementSkuPO.setSalePrice(agreementSkuPO.getBuyPrice().add(agreementSkuPO.getBuyPrice().multiply(new BigDecimal(agreementSkuPO.getMarkupRate().toString())).divide(new BigDecimal(100))));
                    agreementSkuPO.setSalePriceSum(agreementSkuPO.getSalePrice().multiply(agreementSkuPO.getBuyNumber()));
                }
                agreementSkuPO.setCurrentStockNumber(agreementSkuPO.getBuyNumber());
            }
            agreementSkuPO.setBuyPrice(MoneyUtils.calculate2Decimals(agreementSkuPO.getBuyPrice(), 10));
            agreementSkuPO.setBuyPriceSum(MoneyUtils.calculate2Decimals(agreementSkuPO.getBuyPriceSum(), 2));
            agreementSkuPO.setSalePrice(MoneyUtils.calculate2Decimals(agreementSkuPO.getSalePrice(), 10));
            agreementSkuPO.setSalePriceSum(MoneyUtils.calculate2Decimals(agreementSkuPO.getSalePriceSum(), 2));
            agrAgreementSkuPOs.add(agreementSkuPO);
            BeanUtils.copyProperties((Object)agreementSkuPO, (Object)agreementSkuLogPO);
            Long agreementSkuLogId = Sequence.getInstance().nextId();
            agreementSkuLogPO.setAgreementSkuLogId(agreementSkuLogId);
            agreementSkuLogPO.setAgreementSkuId(agreementSkuId);
            agreementSkuLogPO.setAgreementLogId(atomReqBO.getAgreementLogId());
            agreementSkuLogPO.setAgreementId(atomReqBO.getAgreementId());
            agreementSkuLogPO.setAgreementVersion(atomReqBO.getAgreementVersion());
            agreementSkuLogPO.setSupplierId(atomReqBO.getSupplierId());
            agreementSkuLogPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuLogPO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuLogPO.setCreateLoginId(atomReqBO.getMemIdIn());
            agreementSkuLogPO.setCreateName(atomReqBO.getUserName());
            agreementSkuLogPO.setCreateTime(new Date());
            agrAgreementSkuLogPOs.add(agreementSkuLogPO);
        }
        int isInsert = this.agreementSkuMapper.insertBatch(agrAgreementSkuPOs);
        int isInsert2 = this.agreementSkuLogMapper.insertBatch(agrAgreementSkuLogPOs);
        if (isInsert != agrAgreementSkuPOs.size()) {
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u521b\u5efa\u6210\u529f\uff01");
        return rsp;
    }

    @Override
    public AgrCreateAgreementSkuAtomRspBO createExtAgreementSku(AgrCreateAgreementSkuAtomReqBO atomReqBO) {
        AgrCreateAgreementSkuAtomRspBO rsp = new AgrCreateAgreementSkuAtomRspBO();
        ArrayList<AgreementSkuPO> agrAgreementSkuPOs = new ArrayList<AgreementSkuPO>();
        List taxCodes = atomReqBO.getAgrAgreementSkuBOs().stream().filter(a -> !StringUtils.isEmpty((Object)a.getTaxCatalog())).map(a -> a.getTaxCatalog()).distinct().collect(Collectors.toList());
        HashMap taxCatCodeMap = null;
        try {
            if (!CollectionUtils.isEmpty(taxCodes)) {
                UccUpperTaxCatCodeQryAbilityReqBo uccUpperTaxCatCodeQryAbilityReqBo = new UccUpperTaxCatCodeQryAbilityReqBo();
                uccUpperTaxCatCodeQryAbilityReqBo.setTaxCodes(taxCodes);
                UccUpperTaxCatCodeQryAbilityRspBo uccUpperTaxCatCodeQryAbilityRspBo = this.uccUpperTaxCatCodeQryAbilityService.qryUpperTaxCatCode(uccUpperTaxCatCodeQryAbilityReqBo);
                if ("0000".equals(uccUpperTaxCatCodeQryAbilityRspBo.getRespCode()) && null == (taxCatCodeMap = uccUpperTaxCatCodeQryAbilityRspBo.getTaxCatCodeMap())) {
                    taxCatCodeMap = new HashMap();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        for (AgrAgreementSkuBO bo : atomReqBO.getAgrAgreementSkuBOs()) {
            List taxIds;
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuPO);
            Long agreementSkuId = Sequence.getInstance().nextId();
            agreementSkuPO.setAgreementSkuId(agreementSkuId);
            agreementSkuPO.setAgreementId(atomReqBO.getAgreementId());
            agreementSkuPO.setSupplierId(atomReqBO.getSupplierId());
            agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuPO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuPO.setCreateLoginId(atomReqBO.getMemIdIn());
            agreementSkuPO.setCreateName(atomReqBO.getUserName());
            agreementSkuPO.setCreateTime(new Date());
            agreementSkuPO.setAgreementVersion("null");
            agreementSkuPO.setManufacturer("null");
            agreementSkuPO.setBuyPriceSum(BigDecimal.ZERO);
            agreementSkuPO.setMarkupRate(0.0);
            agreementSkuPO.setSalePrice(BigDecimal.ZERO);
            agreementSkuPO.setSalePriceSum(BigDecimal.ZERO);
            agreementSkuPO.setMeasureName("null");
            agreementSkuPO.setBuyNumber(BigDecimal.ZERO);
            if (!(StringUtils.isEmpty((Object)agreementSkuPO.getTaxCatalog()) || ObjectUtils.isEmpty(taxCatCodeMap) || CollectionUtils.isEmpty((Collection)(taxIds = (List)taxCatCodeMap.get(agreementSkuPO.getTaxCatalog()))))) {
                String taxCatalogList = org.apache.commons.lang3.StringUtils.join((Iterable)taxIds, (String)",");
                agreementSkuPO.setTaxCatalogList(taxCatalogList);
            }
            agreementSkuPO.setBuyPrice(MoneyUtils.calculate2Decimals(agreementSkuPO.getBuyPrice(), 10));
            agreementSkuPO.setBuyPriceSum(MoneyUtils.calculate2Decimals(agreementSkuPO.getBuyPriceSum(), 2));
            agreementSkuPO.setSalePrice(MoneyUtils.calculate2Decimals(agreementSkuPO.getSalePrice(), 10));
            agreementSkuPO.setSalePriceSum(MoneyUtils.calculate2Decimals(agreementSkuPO.getSalePriceSum(), 2));
            agrAgreementSkuPOs.add(agreementSkuPO);
        }
        int isInsert = this.agreementSkuMapper.insertBatch(agrAgreementSkuPOs);
        if (isInsert != agrAgreementSkuPOs.size()) {
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u521b\u5efa\u6210\u529f\uff01");
        return rsp;
    }
}

