/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.agreement.ability.bo.AgrAuditBO;
import com.tydic.agreement.atom.api.AgrSyncSkuStatusToCommidityAtomService;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomReqBO;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomRspBO;
import com.tydic.agreement.busi.api.AgrAgreementAddApprovalBusiService;
import com.tydic.agreement.busi.bo.AgrAgreementAddApprovalBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAgreementAddApprovalBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAuditMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrAuditPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.cfc.ability.api.CfcUpdateExpressRelationStatusAbilityService;
import com.tydic.cfc.ability.bo.CfcUpdateExpressRelationStatusAbilityReqBO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrAgreementAddApprovalBusiServiceImpl
implements AgrAgreementAddApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementAddApprovalBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAuditMapper agrAuditMapper;
    @Value(value="${hasConfirmLike}")
    private Boolean hasConfirmLike;
    @Autowired
    private AgrSyncSkuStatusToCommidityAtomService agrSyncSkuStatusToCommidityAtomService;
    @Autowired
    private CfcUpdateExpressRelationStatusAbilityService cfcUpdateExpressRelationStatusAbilityService;

    @Override
    public AgrAgreementAddApprovalBusiRspBO approvalAgreementAdd(AgrAgreementAddApprovalBusiReqBO busiReqBO) {
        AgrAgreementAddApprovalBusiRspBO rsp = new AgrAgreementAddApprovalBusiRspBO();
        Map<String, Set<Long>> stepAgreementIdMap = this.validAgreementInfo(busiReqBO);
        ArrayList<Long> finish = new ArrayList<Long>();
        ArrayList<Long> bhFinish = new ArrayList<Long>();
        for (String stepId : stepAgreementIdMap.keySet()) {
            busiReqBO.setAgreementIds(new ArrayList<Long>((Collection)stepAgreementIdMap.get(stepId)));
            Boolean processEndFlag = this.invokeProcess(busiReqBO, stepId);
            if (processEndFlag.booleanValue()) {
                for (Long agreementId : busiReqBO.getAgreementIds()) {
                    AgreementPO agreementPO = new AgreementPO();
                    agreementPO.setAgreementId(agreementId);
                    agreementPO.setSupplierId(busiReqBO.getSupplierId());
                    agreementPO.setAuditResult(busiReqBO.getAuditResult());
                    agreementPO.setAuditAdvice(busiReqBO.getAuditAdvice());
                    AgreementPO apo = this.agreementMapper.getModelBy(agreementPO);
                    if (AgrCommConstant.AuditResult.ADOPT.equals(busiReqBO.getAuditResult())) {
                        finish.add(agreementId);
                        if (apo == null) {
                            throw new com.tydic.uac.exception.BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868\u72b6\u6001\u5931\u8d25");
                        }
                        Date date = new Date();
                        Date effDate = apo.getEffDate();
                        int i = date.compareTo(effDate);
                        if (i < 0) {
                            agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.WAIT_ENABLE);
                        } else {
                            agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
                        }
                        this.delexpressRelation(apo.getAgreementId());
                    } else if (AgrCommConstant.AuditResult.NOT_PASS.equals(busiReqBO.getAuditResult())) {
                        if (apo.getAgreementStatus() == 8) {
                            agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.NO_CONFIRM);
                        } else {
                            agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.REJECT);
                            bhFinish.add(agreementId);
                        }
                    }
                    int count = this.agreementMapper.updateByCondition(agreementPO);
                    if (count != 1) {
                        throw new com.tydic.uac.exception.BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868\u72b6\u6001\u5931\u8d25");
                    }
                    if (!AgrCommConstant.AgreementStatus.ENABLE.equals(agreementPO.getAgreementStatus())) continue;
                    AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO1 = new AgrSyncSkuStatusToCommidityAtomReqBO();
                    HashSet<Long> agreementIds = new HashSet<Long>();
                    agreementIds.add(agreementId);
                    atomReqBO1.setAgreementIds(agreementIds);
                    atomReqBO1.setSkuStatus(AgrCommConstant.CommiditySkuStatus.BE_SHELF);
                    AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO1 = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO1);
                    if ("0000".equals(atomRspBO1.getRespCode())) continue;
                    throw new BusinessException(atomRspBO1.getRespCode(), atomRspBO1.getRespDesc());
                }
            } else if (this.hasConfirmLike.booleanValue()) {
                AgreementPO agreementPO1 = new AgreementPO();
                agreementPO1.setAgreementIds(busiReqBO.getAgreementIds());
                agreementPO1.setSupplierId(busiReqBO.getSupplierId());
                if (AgrCommConstant.AuditResult.ADOPT.equals(busiReqBO.getAuditResult())) {
                    agreementPO1.setAgreementStatus(AgrCommConstant.AgreementStatus.IN_AUDIT);
                } else {
                    agreementPO1.setAgreementStatus(AgrCommConstant.AgreementStatus.NO_CONFIRM);
                }
                Date date = new Date();
                String pattern = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                String dateString = simpleDateFormat.format(date);
                agreementPO1.setExtField3(dateString);
                int count = this.agreementMapper.updateByCondition(agreementPO1);
                if (count != busiReqBO.getAgreementIds().size()) {
                    throw new com.tydic.uac.exception.BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868\u72b6\u6001\u5931\u8d25");
                }
            }
            AgreementPO agreementPO2 = new AgreementPO();
            agreementPO2.setSupplierId(busiReqBO.getSupplierId());
            agreementPO2.setAgreementIds(busiReqBO.getAgreementIds());
            agreementPO2.setAuditTime(new Date());
            agreementPO2.setAuditUserId(busiReqBO.getUserId() + "");
            agreementPO2.setAuditUserCode(busiReqBO.getOccupation());
            agreementPO2.setAuditUserName(busiReqBO.getName());
            int num = this.agreementMapper.updateByCondition(agreementPO2);
            if (num == busiReqBO.getAgreementIds().size()) continue;
            throw new com.tydic.uac.exception.BusinessException("22005", "\u66f4\u65b0\u5ba1\u6279\u4fe1\u606f\u5931\u8d25");
        }
        rsp.setAgreementIds(finish);
        rsp.setBhAgreementIds(bhFinish);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u65b0\u589e\u5ba1\u6279\u6210\u529f\uff01");
        return rsp;
    }

    private Map<String, Set<Long>> validAgreementInfo(AgrAgreementAddApprovalBusiReqBO busiReqBO) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setAgreementIds(busiReqBO.getAgreementIds());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementPO> agreementPOS = this.agreementMapper.getList(agreementPO);
        if (CollectionUtils.isEmpty(agreementPOS)) {
            throw new com.tydic.uac.exception.BusinessException("22001", "\u534f\u8bae\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        HashSet<Long> statusErrors = new HashSet<Long>();
        HashSet<Long> agreementIds = new HashSet<Long>();
        for (AgreementPO po : agreementPOS) {
            if (!AgrCommConstant.AgreementStatus.IN_AUDIT.equals(po.getAgreementStatus()) && !AgrCommConstant.AgreementStatus.TO_CONFIRM.equals(po.getAgreementStatus())) {
                statusErrors.add(po.getAgreementId());
            }
            agreementIds.add(po.getAgreementId());
        }
        if (statusErrors.size() > 0) {
            throw new com.tydic.uac.exception.BusinessException("22002", "\u534f\u8bae\u3010" + ((Object)statusErrors).toString() + "\u3011\u72b6\u6001\u4e0d\u662f\u5ba1\u6838\u4e2d\u6216\u8005\u5f85\u786e\u8ba4");
        }
        if (agreementIds.size() < busiReqBO.getAgreementIds().size()) {
            busiReqBO.getAgreementIds().removeAll(agreementIds);
            throw new com.tydic.uac.exception.BusinessException("22006", "\u534f\u8bae\u3010" + busiReqBO.getAgreementIds() + "\u3011\u4e0d\u5b58\u5728");
        }
        AgrAuditPO agrAuditPO = new AgrAuditPO();
        agrAuditPO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        agrAuditPO.setObjIds(agreementIds);
        agrAuditPO.setTabValue(1);
        agrAuditPO.setStationCodes(busiReqBO.getStationCodes());
        List<AgrAuditBO> agrAuditBOs = this.agrAuditMapper.getAuditInfoByObjIds(agrAuditPO);
        if (CollectionUtils.isEmpty(agrAuditBOs)) {
            throw new com.tydic.uac.exception.BusinessException("22001", "\u8be5\u8d26\u53f7\u672a\u914d\u7f6e\u5bf9\u5e94\u5c97\u4f4d\uff01");
        }
        HashSet stepIds = new HashSet();
        HashSet<Long> auditSize = new HashSet<Long>();
        Object stepId = null;
        for (AgrAuditBO agrAuditBO : agrAuditBOs) {
            HashSet<Long> agreeementIdSet = (HashSet<Long>)result.get(agrAuditBO.getStepId());
            if (null == agreeementIdSet) {
                agreeementIdSet = new HashSet<Long>();
            }
            agreeementIdSet.add(agrAuditBO.getObjId());
            result.put(agrAuditBO.getStepId(), agreeementIdSet);
            auditSize.add(agrAuditBO.getObjId());
        }
        if (auditSize.size() < busiReqBO.getAgreementIds().size()) {
            busiReqBO.getAgreementIds().removeAll(auditSize);
            throw new com.tydic.uac.exception.BusinessException("22006", "\u534f\u8bae\u3010" + busiReqBO.getAgreementIds() + "\u3011\u4e0d\u5b58\u5728\u6d41\u7a0b\u4fe1\u606f");
        }
        return result;
    }

    private Boolean invokeProcess(AgrAgreementAddApprovalBusiReqBO busiReqBO, String stepId) {
        UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        uacNoTaskAuditOrderAuditReqBO.setObjId(busiReqBO.getAgreementIds());
        uacNoTaskAuditOrderAuditReqBO.setStepId(stepId);
        uacNoTaskAuditOrderAuditReqBO.setAuditResult(busiReqBO.getAuditResult());
        uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(busiReqBO.getAuditAdvice());
        uacNoTaskAuditOrderAuditReqBO.setOperId(busiReqBO.getMemIdIn().toString());
        uacNoTaskAuditOrderAuditReqBO.setUsername(busiReqBO.getName());
        uacNoTaskAuditOrderAuditReqBO.setOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditOrderAuditReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        uacNoTaskAuditOrderAuditReqBO.setMsgFlag(Integer.valueOf(1));
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditReqBO));
        UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditRspBO));
        if (!"0000".equals(uacNoTaskAuditOrderAuditRspBO.getRespCode())) {
            throw new com.tydic.uac.exception.BusinessException(uacNoTaskAuditOrderAuditRspBO.getRespCode(), uacNoTaskAuditOrderAuditRspBO.getRespDesc());
        }
        return uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish();
    }

    public void delexpressRelation(Long id) {
        CfcUpdateExpressRelationStatusAbilityReqBO reqBO = new CfcUpdateExpressRelationStatusAbilityReqBO();
        reqBO.setObjId(id);
        this.cfcUpdateExpressRelationStatusAbilityService.updateExpressRelationStatus(reqBO);
    }
}

