/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.busi.api.AgrCopyAgreementSkuBusiService;
import com.tydic.agreement.busi.bo.AgrCopyAgreementSkuBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCopyAgreementSkuBusiRspBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuByPageBusiReqBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuLogPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.utils.MoneyUtils;
import com.tydic.commodity.common.ability.api.UccCodegenerationAbilityService;
import com.tydic.commodity.common.ability.api.UccUpperTaxCatCodeQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccCodegenerationAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCodegenerationAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrCopyAgreementSkuBusiServiceImpl
implements AgrCopyAgreementSkuBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrCopyAgreementSkuBusiServiceImpl.class);
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private UccUpperTaxCatCodeQryAbilityService uccUpperTaxCatCodeQryAbilityService;
    @Autowired
    private UccCodegenerationAbilityService uccCodegenerationAbilityService;

    @Override
    public AgrCopyAgreementSkuBusiRspBO copyAgreementSku(AgrCopyAgreementSkuBusiReqBO reqBO) {
        AgrCopyAgreementSkuBusiRspBO busiRspBO = new AgrCopyAgreementSkuBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(reqBO.getCopyAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (agreement == null) {
            throw new ZTBusinessException("\u590d\u5236\u7684\u76ee\u6807\u534f\u8bae\u4e0d\u5b58\u5728!");
        }
        reqBO.setSupplierId(agreement.getSupplierId());
        reqBO.setAgreementVersion(agreement.getAgreementVersion());
        AgrQryAgreementSkuByPageBusiReqBO agrQryAgreementSkuByPageBusiReqBO = new AgrQryAgreementSkuByPageBusiReqBO();
        agrQryAgreementSkuByPageBusiReqBO.setAgreementId(reqBO.getCopyAgreementId());
        Page page = new Page(1, 2000);
        List<AgrAgreementSkuBO> agrAgreementSkuBOS = this.agreementSkuMapper.getListPageByCondition(agrQryAgreementSkuByPageBusiReqBO, (Page<AgrAgreementSkuBO>)page);
        if (page.getTotalPages() >= 1) {
            if (agreement.getIsSupermarketStaff() != null && agreement.getIsSupermarketStaff() == 1) {
                UccCodegenerationAbilityReqBO uccCodegenerationAbilityReqBO = new UccCodegenerationAbilityReqBO();
                uccCodegenerationAbilityReqBO.setCount(Integer.valueOf(agrAgreementSkuBOS.size()));
                uccCodegenerationAbilityReqBO.setCodeType("01");
                UccCodegenerationAbilityRspBO uccCodegenerationAbilityRspBO = this.uccCodegenerationAbilityService.dealUccCodegeneration(uccCodegenerationAbilityReqBO);
                if (!"0000".equals(uccCodegenerationAbilityRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)uccCodegenerationAbilityRspBO.getCodeList()) || uccCodegenerationAbilityRspBO.getCodeList().size() != agrAgreementSkuBOS.size()) {
                    throw new ZTBusinessException("\u751f\u6210\u5546\u54c1\u7f16\u7801\u5f02\u5e38" + uccCodegenerationAbilityRspBO.getRespDesc());
                }
                for (int i = 0; i < agrAgreementSkuBOS.size(); ++i) {
                    agrAgreementSkuBOS.get(i).setMaterialCode((String)uccCodegenerationAbilityRspBO.getCodeList().get(i));
                }
            }
            this.insert(reqBO, agrAgreementSkuBOS, agreement);
        }
        if (page.getTotalPages() > 1) {
            for (int i = 2; i <= page.getTotalPages(); ++i) {
                Page tempPage = new Page(i, 2000);
                List<AgrAgreementSkuBO> agrAgreementSkuBOList = this.agreementSkuMapper.getListPageByCondition(agrQryAgreementSkuByPageBusiReqBO, (Page<AgrAgreementSkuBO>)tempPage);
                if (CollectionUtils.isEmpty(agrAgreementSkuBOList)) continue;
                if (agreement.getIsSupermarketStaff() != null && agreement.getIsSupermarketStaff() == 1) {
                    UccCodegenerationAbilityReqBO uccCodegenerationAbilityReqBO = new UccCodegenerationAbilityReqBO();
                    uccCodegenerationAbilityReqBO.setCount(Integer.valueOf(agrAgreementSkuBOList.size()));
                    uccCodegenerationAbilityReqBO.setCodeType("01");
                    UccCodegenerationAbilityRspBO uccCodegenerationAbilityRspBO = this.uccCodegenerationAbilityService.dealUccCodegeneration(uccCodegenerationAbilityReqBO);
                    if (!"0000".equals(uccCodegenerationAbilityRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)uccCodegenerationAbilityRspBO.getCodeList()) || uccCodegenerationAbilityRspBO.getCodeList().size() != agrAgreementSkuBOList.size()) {
                        throw new ZTBusinessException("\u751f\u6210\u5546\u54c1\u7f16\u7801\u5f02\u5e38" + uccCodegenerationAbilityRspBO.getRespDesc());
                    }
                    for (int j = 0; j < agrAgreementSkuBOList.size(); ++j) {
                        agrAgreementSkuBOList.get(j).setMaterialCode((String)uccCodegenerationAbilityRspBO.getCodeList().get(j));
                    }
                }
                this.insert(reqBO, agrAgreementSkuBOList, agreement);
            }
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f\uff01");
        return busiRspBO;
    }

    private void insert(AgrCopyAgreementSkuBusiReqBO busiReqBO, List<AgrAgreementSkuBO> agrAgreementSkuBOS, AgreementPO agreement) {
        ArrayList<AgreementSkuPO> agrAgreementSkuPOs = new ArrayList<AgreementSkuPO>();
        List taxCodes = agrAgreementSkuBOS.stream().filter(a -> !StringUtils.isEmpty((Object)a.getTaxCatalog())).map(a -> a.getTaxCatalog()).distinct().collect(Collectors.toList());
        HashMap taxCatCodeMap = null;
        try {
            if (!CollectionUtils.isEmpty(taxCodes)) {
                UccUpperTaxCatCodeQryAbilityReqBo uccUpperTaxCatCodeQryAbilityReqBo = new UccUpperTaxCatCodeQryAbilityReqBo();
                uccUpperTaxCatCodeQryAbilityReqBo.setTaxCodes(taxCodes);
                UccUpperTaxCatCodeQryAbilityRspBo uccUpperTaxCatCodeQryAbilityRspBo = this.uccUpperTaxCatCodeQryAbilityService.qryUpperTaxCatCode(uccUpperTaxCatCodeQryAbilityReqBo);
                if ("0000".equals(uccUpperTaxCatCodeQryAbilityRspBo.getRespCode()) && null == (taxCatCodeMap = uccUpperTaxCatCodeQryAbilityRspBo.getTaxCatCodeMap())) {
                    taxCatCodeMap = new HashMap();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        for (AgrAgreementSkuBO bo : agrAgreementSkuBOS) {
            List taxIds;
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            AgreementSkuLogPO agreementSkuLogPO = new AgreementSkuLogPO();
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuPO);
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuLogPO);
            Long agreementSkuId = Sequence.getInstance().nextId();
            agreementSkuPO.setAgreementSkuId(agreementSkuId);
            agreementSkuPO.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuPO.setAgreementVersion(busiReqBO.getAgreementVersion());
            agreementSkuPO.setSupplierId(busiReqBO.getSupplierId());
            agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuPO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuPO.setCreateLoginId(busiReqBO.getMemIdIn());
            agreementSkuPO.setCreateName(busiReqBO.getUserName());
            agreementSkuPO.setCreateTime(new Date());
            if (agreementSkuPO.getBuyNumber() != null) {
                agreementSkuPO.setBuyPriceSum(agreementSkuPO.getBuyPrice().multiply(agreementSkuPO.getBuyNumber()));
                agreementSkuPO.setSalePrice(agreementSkuPO.getBuyPrice().add(agreementSkuPO.getBuyPrice().multiply(new BigDecimal(agreementSkuPO.getMarkupRate().toString())).divide(new BigDecimal(100))));
                agreementSkuPO.setSalePriceSum(agreementSkuPO.getSalePrice().multiply(agreementSkuPO.getBuyNumber()));
            }
            agreementSkuPO.setSkuSource("1");
            if (!(StringUtils.isEmpty((Object)agreementSkuPO.getTaxCatalog()) || ObjectUtils.isEmpty(taxCatCodeMap) || CollectionUtils.isEmpty((Collection)(taxIds = (List)taxCatCodeMap.get(agreementSkuPO.getTaxCatalog()))))) {
                String taxCatalogList = org.apache.commons.lang3.StringUtils.join((Iterable)taxIds, (String)",");
                agreementSkuPO.setTaxCatalogList(taxCatalogList);
            }
            agreementSkuPO.setBuyPrice(MoneyUtils.calculate2Decimals(agreementSkuPO.getBuyPrice(), 10));
            agreementSkuPO.setBuyPriceSum(MoneyUtils.calculate2Decimals(agreementSkuPO.getBuyPriceSum(), 2));
            agreementSkuPO.setSalePrice(MoneyUtils.calculate2Decimals(agreementSkuPO.getSalePrice(), 10));
            agreementSkuPO.setSalePriceSum(MoneyUtils.calculate2Decimals(agreementSkuPO.getSalePriceSum(), 2));
            agrAgreementSkuPOs.add(agreementSkuPO);
        }
        int isInsert = this.agreementSkuMapper.insertBatch(agrAgreementSkuPOs);
        if (isInsert != agrAgreementSkuPOs.size()) {
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
    }
}

