/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeBO;
import com.tydic.agreement.busi.api.AgrCreateAgreementSkuChangeBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementChangePO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuChangePO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.utils.MoneyUtils;
import com.tydic.commodity.common.ability.api.UccUpperTaxCatCodeQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrCreateAgreementSkuChangeBusiServiceImpl
implements AgrCreateAgreementSkuChangeBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrCreateAgreementSkuChangeBusiServiceImpl.class);
    @Autowired
    private AgreementSkuChangeMapper agreementSkuChangeMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementChangeMapper agreementChangeMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private UccUpperTaxCatCodeQryAbilityService uccUpperTaxCatCodeQryAbilityService;

    @Override
    public AgrCreateAgreementSkuChangeBusiRspBO createAgreementSkuChange(AgrCreateAgreementSkuChangeBusiReqBO busiReqBO) {
        int isInsert;
        AgrCreateAgreementSkuChangeBusiRspBO rsp = new AgrCreateAgreementSkuChangeBusiRspBO();
        if (CollectionUtils.isEmpty(busiReqBO.getAgrAgreementSkuChangeBOs())) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u53d8\u66f4\u660e\u7ec6\u96c6\u5408\u4e3a\u7a7a\uff01");
            return rsp;
        }
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        AgreementChangePO agreementChangePO = new AgreementChangePO();
        if (!StringUtils.isEmpty((Object)busiReqBO.getChangeCode())) {
            agreementChangePO.setChangeCode(busiReqBO.getChangeCode());
        }
        agreementChangePO.setChangeId(busiReqBO.getChangeId());
        agreementChangePO.setAgreementId(busiReqBO.getAgreementId());
        agreementChangePO.setSupplierId(busiReqBO.getSupplierId());
        AgreementChangePO daoRsp = this.agreementChangeMapper.getModelBy(agreementChangePO);
        if (!(null == daoRsp || AgrCommConstant.ChangeApplyStatus.DRAFT.equals(daoRsp.getStatus()) || AgrCommConstant.ChangeApplyStatus.NO_PASS.equals(daoRsp.getStatus()) || AgrCommConstant.ChangeApplyStatus.NO_CONFIRM.equals(daoRsp.getStatus()))) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53d8\u66f4\u53ef\u4ee5\u521b\u5efa\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\uff01");
        }
        ArrayList<Long> agreementSkuIds = new ArrayList<Long>();
        ArrayList<AgreementSkuChangePO> agreementSkuChangePOs = new ArrayList<AgreementSkuChangePO>();
        List taxCodes = busiReqBO.getAgrAgreementSkuChangeBOs().stream().filter(a -> !StringUtils.isEmpty((Object)a.getTaxCatalog())).map(a -> a.getTaxCatalog()).distinct().collect(Collectors.toList());
        Map taxCatCodeMap = new HashMap();
        try {
            if (!CollectionUtils.isEmpty(taxCodes)) {
                UccUpperTaxCatCodeQryAbilityReqBo uccUpperTaxCatCodeQryAbilityReqBo = new UccUpperTaxCatCodeQryAbilityReqBo();
                uccUpperTaxCatCodeQryAbilityReqBo.setTaxCodes(taxCodes);
                UccUpperTaxCatCodeQryAbilityRspBo uccUpperTaxCatCodeQryAbilityRspBo = this.uccUpperTaxCatCodeQryAbilityService.qryUpperTaxCatCode(uccUpperTaxCatCodeQryAbilityReqBo);
                if ("0000".equals(uccUpperTaxCatCodeQryAbilityRspBo.getRespCode()) && null == (taxCatCodeMap = uccUpperTaxCatCodeQryAbilityRspBo.getTaxCatCodeMap())) {
                    taxCatCodeMap = new HashMap();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        for (AgrAgreementSkuChangeBO bo : busiReqBO.getAgrAgreementSkuChangeBOs()) {
            List taxIds;
            if (null != bo.getAgreementSkuId()) {
                agreementSkuIds.add(bo.getAgreementSkuId());
            }
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            if (bo.getAgreementSkuId() != null) {
                agreementSkuPO.setAgreementSkuId(bo.getAgreementSkuId());
                agreementSkuPO = this.agreementSkuMapper.getModelBy(agreementSkuPO);
            }
            AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuChangePO);
            agreementSkuChangePO.setMiniStock(bo.getMiniStock());
            agreementSkuChangePO.setReferenceStock(bo.getReferenceStock());
            agreementSkuChangePO.setSkuChangeId(Sequence.getInstance().nextId());
            agreementSkuChangePO.setAgreementVersion(agreement.getAgreementVersion());
            agreementSkuChangePO.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuChangePO.setSupplierId(agreement.getSupplierId());
            agreementSkuChangePO.setChangeId(busiReqBO.getChangeId());
            if (!StringUtils.isEmpty((Object)busiReqBO.getChangeCode())) {
                agreementSkuChangePO.setChangeCode(busiReqBO.getChangeCode());
            }
            agreementSkuChangePO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuChangePO.setCreateLoginId(busiReqBO.getMemIdIn());
            agreementSkuChangePO.setCreateName(busiReqBO.getUserName());
            agreementSkuChangePO.setCreateTime(new Date());
            agreementSkuChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            String skuSource = StringUtils.isEmpty((Object)agreementSkuPO.getSkuSource()) ? "1" : agreementSkuPO.getSkuSource();
            agreementSkuChangePO.setSkuSource(skuSource);
            if (!StringUtils.isEmpty((Object)agreementSkuChangePO.getTaxCatalog()) && !CollectionUtils.isEmpty((Collection)(taxIds = (List)taxCatCodeMap.get(agreementSkuChangePO.getTaxCatalog())))) {
                String taxCatalogList = org.apache.commons.lang3.StringUtils.join((Iterable)taxIds, (String)",");
                agreementSkuChangePO.setTaxCatalogList(taxCatalogList);
            }
            agreementSkuChangePO.setBuyPrice(MoneyUtils.calculate2Decimals(agreementSkuChangePO.getBuyPrice(), 10));
            agreementSkuChangePO.setBuyPriceSum(MoneyUtils.calculate2Decimals(agreementSkuChangePO.getBuyPriceSum(), 2));
            agreementSkuChangePO.setSalePrice(MoneyUtils.calculate2Decimals(agreementSkuChangePO.getSalePrice(), 10));
            agreementSkuChangePO.setSalePriceSum(MoneyUtils.calculate2Decimals(agreementSkuChangePO.getSalePriceSum(), 2));
            agreementSkuChangePOs.add(agreementSkuChangePO);
        }
        if (!CollectionUtils.isEmpty(agreementSkuIds)) {
            AgreementSkuChangePO agreementSkuChangePO1 = new AgreementSkuChangePO();
            agreementSkuChangePO1.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuChangePO1.setSupplierId(agreement.getSupplierId());
            agreementSkuChangePO1.setChangeId(busiReqBO.getChangeId());
            if (!StringUtils.isEmpty((Object)busiReqBO.getChangeCode())) {
                agreementSkuChangePO1.setChangeCode(busiReqBO.getChangeCode());
            }
            agreementSkuChangePO1.setAgreementSkuIds(agreementSkuIds);
            this.agreementSkuChangeMapper.deleteBy(agreementSkuChangePO1);
        }
        if ((isInsert = this.agreementSkuChangeMapper.insertBatch(agreementSkuChangePOs)) != agreementSkuChangePOs.size()) {
            throw new BusinessException("22003", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u8868\u65b0\u589e\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u65b0\u589e\u6210\u529f\uff01");
        return rsp;
    }

    @Override
    public AgrCreateAgreementSkuChangeBusiRspBO createAgreementChangePriceSkuChange(AgrCreateAgreementSkuChangeBusiReqBO busiReqBO) {
        log.info("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~createAgreementChangePriceSkuChange!!!!!!!!~~~~~~~~~~~~~~~~{}", (Object)JSON.toJSONString((Object)((Object)busiReqBO)));
        AgrCreateAgreementSkuChangeBusiRspBO rsp = new AgrCreateAgreementSkuChangeBusiRspBO();
        if (CollectionUtils.isEmpty(busiReqBO.getAgrAgreementSkuChangeBOs())) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u53d8\u66f4\u660e\u7ec6\u96c6\u5408\u4e3a\u7a7a\uff01");
            return rsp;
        }
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        AgreementChangePO agreementChangePO = new AgreementChangePO();
        if (!StringUtils.isEmpty((Object)busiReqBO.getChangeCode())) {
            agreementChangePO.setChangeCode(busiReqBO.getChangeCode());
        }
        agreementChangePO.setChangeId(busiReqBO.getChangeId());
        agreementChangePO.setAgreementId(busiReqBO.getAgreementId());
        agreementChangePO.setSupplierId(busiReqBO.getSupplierId());
        AgreementChangePO daoRsp = this.agreementChangeMapper.getModelBy(agreementChangePO);
        if (!(null == daoRsp || AgrCommConstant.ChangeApplyStatus.DRAFT.equals(daoRsp.getStatus()) || AgrCommConstant.ChangeApplyStatus.NO_PASS.equals(daoRsp.getStatus()) || AgrCommConstant.ChangeApplyStatus.NO_CONFIRM.equals(daoRsp.getStatus()))) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53d8\u66f4\u53ef\u4ee5\u521b\u5efa\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\uff01");
        }
        ArrayList<Long> agreementSkuIds = new ArrayList<Long>();
        ArrayList<AgreementSkuChangePO> agreementSkuChangePOs = new ArrayList<AgreementSkuChangePO>();
        List taxCodes = busiReqBO.getAgrAgreementSkuChangeBOs().stream().filter(a -> !StringUtils.isEmpty((Object)a.getTaxCatalog())).map(a -> a.getTaxCatalog()).distinct().collect(Collectors.toList());
        Map taxCatCodeMap = new HashMap();
        try {
            if (!CollectionUtils.isEmpty(taxCodes)) {
                UccUpperTaxCatCodeQryAbilityReqBo uccUpperTaxCatCodeQryAbilityReqBo = new UccUpperTaxCatCodeQryAbilityReqBo();
                uccUpperTaxCatCodeQryAbilityReqBo.setTaxCodes(taxCodes);
                UccUpperTaxCatCodeQryAbilityRspBo uccUpperTaxCatCodeQryAbilityRspBo = this.uccUpperTaxCatCodeQryAbilityService.qryUpperTaxCatCode(uccUpperTaxCatCodeQryAbilityReqBo);
                if ("0000".equals(uccUpperTaxCatCodeQryAbilityRspBo.getRespCode()) && null == (taxCatCodeMap = uccUpperTaxCatCodeQryAbilityRspBo.getTaxCatCodeMap())) {
                    taxCatCodeMap = new HashMap();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        for (AgrAgreementSkuChangeBO bo : busiReqBO.getAgrAgreementSkuChangeBOs()) {
            List taxIds;
            log.info("AgrAgreementSkuChangeBO___________________{}", JSON.toJSON((Object)bo));
            if (null != bo.getAgreementSkuId()) {
                agreementSkuIds.add(bo.getAgreementSkuId());
            }
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            if (bo.getAgreementSkuId() != null) {
                agreementSkuPO.setAgreementSkuId(bo.getAgreementSkuId());
                agreementSkuPO = this.agreementSkuMapper.getModelBy(agreementSkuPO);
            }
            AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
            BeanUtils.copyProperties((Object)agreementSkuPO, (Object)agreementSkuChangePO);
            agreementSkuChangePO.setMiniStock(bo.getMiniStock());
            agreementSkuChangePO.setReferenceStock(bo.getReferenceStock());
            agreementSkuChangePO.setExtField1(null);
            agreementSkuChangePO.setExtField2(null);
            agreementSkuChangePO.setExtField3(null);
            agreementSkuChangePO.setSkuChangeId(Sequence.getInstance().nextId());
            agreementSkuChangePO.setAgreementVersion(agreement.getAgreementVersion());
            agreementSkuChangePO.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuChangePO.setSupplierId(agreement.getSupplierId());
            if (!StringUtils.isEmpty((Object)busiReqBO.getChangeCode())) {
                agreementSkuChangePO.setChangeCode(busiReqBO.getChangeCode());
            }
            agreementSkuChangePO.setChangeId(busiReqBO.getChangeId());
            agreementSkuChangePO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuChangePO.setCreateLoginId(busiReqBO.getMemIdIn());
            agreementSkuChangePO.setCreateName(busiReqBO.getUserName());
            agreementSkuChangePO.setCreateTime(new Date());
            agreementSkuChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuChangePO.setChangeType((byte)2);
            String skuSource = StringUtils.isEmpty((Object)agreementSkuPO.getSkuSource()) ? "1" : agreementSkuPO.getSkuSource();
            agreementSkuChangePO.setSkuSource(skuSource);
            if (!StringUtils.isEmpty((Object)agreementSkuChangePO.getTaxCatalog()) && !CollectionUtils.isEmpty((Collection)(taxIds = (List)taxCatCodeMap.get(agreementSkuChangePO.getTaxCatalog())))) {
                String taxCatalogList = org.apache.commons.lang3.StringUtils.join((Iterable)taxIds, (String)",");
                agreementSkuChangePO.setTaxCatalogList(taxCatalogList);
            }
            if (agreement.getTradeMode() != 1) {
                agreementSkuChangePO.setSaleStatus(bo.getSaleStatus());
                agreementSkuChangePO.setBuyNumber(bo.getBuyNumber());
                agreementSkuChangePO.setSalePrice(bo.getSalePrice());
                agreementSkuChangePO.setSalePriceSum(bo.getSalePriceSum());
                agreementSkuChangePO.setBuyPrice(bo.getSalePrice());
                agreementSkuChangePO.setBuyPriceSum(bo.getSalePriceSum());
            } else if (agreement.getTradeMode() == 1) {
                if (agreement.getIsSupermarketStaff() == null || agreement.getIsSupermarketStaff() != 1) {
                    agreementSkuChangePO.setBuyNumber(bo.getBuyNumber());
                    agreementSkuChangePO.setBuyPrice(bo.getBuyPrice());
                    agreementSkuChangePO.setMarkupRate(bo.getMarkupRate());
                    agreementSkuChangePO.setSalePrice(bo.getSalePrice());
                    agreementSkuChangePO.setSalePriceSum(bo.getSalePriceSum());
                    agreementSkuChangePO.setBuyPriceSum(bo.getBuyPriceSum());
                    agreementSkuChangePO.setSaleStatus(bo.getSaleStatus());
                } else {
                    agreementSkuChangePO.setSaleStatus(bo.getSaleStatus());
                    agreementSkuChangePO.setBuyPrice(bo.getBuyPrice());
                    agreementSkuChangePO.setMarkupRate(bo.getMarkupRate());
                    agreementSkuChangePO.setSalePrice(bo.getSalePrice());
                    agreementSkuChangePO.setSalePriceSum(bo.getSalePriceSum());
                    agreementSkuChangePO.setBuyPriceSum(bo.getBuyPriceSum());
                    agreementSkuChangePO.setTaxRate(bo.getTaxRate());
                    agreementSkuChangePO.setSupplyCycle(bo.getSupplyCycle());
                    agreementSkuChangePO.setWarantty(bo.getWarantty());
                    agreementSkuChangePO.setRemark(bo.getRemark());
                }
            }
            log.info(")))))))))))))))))))))))))))))))))))))agreementSkuChangePO{}", (Object)JSON.toJSONString((Object)agreementSkuChangePO));
            agreementSkuChangePO.setBuyPrice(MoneyUtils.calculate2Decimals(agreementSkuChangePO.getBuyPrice(), 10));
            agreementSkuChangePO.setBuyPriceSum(MoneyUtils.calculate2Decimals(agreementSkuChangePO.getBuyPriceSum(), 2));
            agreementSkuChangePO.setSalePrice(MoneyUtils.calculate2Decimals(agreementSkuChangePO.getSalePrice(), 10));
            agreementSkuChangePO.setSalePriceSum(MoneyUtils.calculate2Decimals(agreementSkuChangePO.getSalePriceSum(), 2));
            agreementSkuChangePOs.add(agreementSkuChangePO);
        }
        if (!CollectionUtils.isEmpty(agreementSkuIds)) {
            AgreementSkuChangePO agreementSkuChangePO1 = new AgreementSkuChangePO();
            agreementSkuChangePO1.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuChangePO1.setSupplierId(agreement.getSupplierId());
            agreementSkuChangePO1.setChangeId(busiReqBO.getChangeId());
            if (!StringUtils.isEmpty((Object)busiReqBO.getChangeCode())) {
                agreementSkuChangePO1.setChangeCode(busiReqBO.getChangeCode());
            }
            agreementSkuChangePO1.setAgreementSkuIds(agreementSkuIds);
            this.agreementSkuChangeMapper.deleteBy(agreementSkuChangePO1);
        }
        log.info("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&agreementSkuChangePOs&&{}", (Object)JSON.toJSONString(agreementSkuChangePOs));
        int isInsert = this.agreementSkuChangeMapper.insertBatch(agreementSkuChangePOs);
        if (isInsert != agreementSkuChangePOs.size()) {
            throw new BusinessException("22003", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u8868\u65b0\u589e\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u8c03\u4ef7\u53d8\u66f4\u65b0\u589e\u6210\u529f\uff01");
        return rsp;
    }
}

