/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgreementSettlementBO;
import com.tydic.agreement.ability.bo.DistributeAreaReqBo;
import com.tydic.agreement.atom.api.AgrCreateAgreementOtherAtomService;
import com.tydic.agreement.atom.api.AgrCreateAgreementSettlementAtomService;
import com.tydic.agreement.atom.api.AgrCreateAgreementSkuAtomService;
import com.tydic.agreement.atom.api.AgrCreateCodeAtomService;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrCreateAgreementOtherAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementOtherAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSettlementAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSettlementAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomRspBO;
import com.tydic.agreement.busi.api.AgrCreateAgreementSubjectBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSubjectBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSubjectBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementAttachLogMapper;
import com.tydic.agreement.dao.AgrDistributeAreaMapper;
import com.tydic.agreement.dao.AgreementAttachMapper;
import com.tydic.agreement.dao.AgreementLogMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeLogMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.AgreementSettlementLogMapper;
import com.tydic.agreement.dao.AgreementSettlementMapper;
import com.tydic.agreement.dao.AgreementSkuLogMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrAgreementAttachLogPO;
import com.tydic.agreement.po.AgrDistributeAreaPO;
import com.tydic.agreement.po.AgreementAttachPO;
import com.tydic.agreement.po.AgreementLogPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementScopeLogPO;
import com.tydic.agreement.po.AgreementScopePO;
import com.tydic.agreement.po.AgreementSettlementLogPO;
import com.tydic.agreement.po.AgreementSettlementPO;
import com.tydic.agreement.po.AgreementSkuLogPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.cfc.ability.api.CfcExpressRelationBatchInsertAbilityService;
import com.tydic.cfc.ability.bo.CfcExpressRelationBatchInsertAbilityReqBO;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.fsc.bo.FscMerchantPayeeBO;
import com.tydic.fsc.common.ability.api.FscMerchantCreateAbilityService;
import com.tydic.fsc.common.ability.api.FscMerchantPayeeCreateAbilityService;
import com.tydic.fsc.common.ability.api.FscPayChannelEditAbilityService;
import com.tydic.fsc.common.ability.bo.FscMerchantCreateAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscMerchantCreateAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscMerchantPayeeCreateAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayChannelEditAbilityReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class AgrCreateAgreementSubjectBusiServiceImpl
implements AgrCreateAgreementSubjectBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrCreateAgreementSubjectBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementLogMapper agreementLogMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private AgreementScopeLogMapper agreementScopeLogMapper;
    @Autowired
    private AgreementAttachMapper agreementAttachMapper;
    @Autowired
    private AgrAgreementAttachLogMapper agrAgreementAttachLogMapper;
    @Autowired
    private AgreementSkuLogMapper agreementSkuLogMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementSettlementMapper agreementSettlementMapper;
    @Autowired
    private AgreementSettlementLogMapper agreementSettlementLogMapper;
    @Autowired
    private AgrCreateAgreementSkuAtomService agrCreateAgreementSkuAtomService;
    @Autowired
    private AgrCreateAgreementOtherAtomService agrCreateAgreementOtherAtomService;
    @Autowired
    private AgrCreateCodeAtomService agrCreateCodeAtomService;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgrCreateAgreementSettlementAtomService agrCreateAgreementSettlementAtomService;
    @Autowired
    private FscMerchantCreateAbilityService fscMerchantCreateAbilityService;
    @Autowired
    private FscPayChannelEditAbilityService fscPayChannelEditAbilityService;
    @Autowired
    private FscMerchantPayeeCreateAbilityService fscMerchantPayeeCreateAbilityService;
    @Autowired
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    @Autowired
    private AgrDistributeAreaMapper agrDistributeAreaMapper;
    @Autowired
    private CfcExpressRelationBatchInsertAbilityService cfcExpressRelationBatchInsertAbilityService;

    @Override
    public AgrCreateAgreementSubjectBusiRspBO createAgreementSubjectInfo(AgrCreateAgreementSubjectBusiReqBO busiReqBO) {
        AgrCreateAgreementSubjectBusiRspBO rsp = new AgrCreateAgreementSubjectBusiRspBO();
        this.validPlaAgreementCode(busiReqBO);
        Long agreementId = Sequence.getInstance().nextId();
        AgreementPO agreementPO = this.insertAgreement(busiReqBO, agreementId);
        try {
            if (null != busiReqBO.getCfcExpressRelationAbilityBO() && !CollectionUtils.isEmpty((Collection)busiReqBO.getCfcExpressRelationAbilityBO().getExpressRelationList())) {
                CfcExpressRelationBatchInsertAbilityReqBO cfcExpressRelationBatchInsertAbilityReqBO = (CfcExpressRelationBatchInsertAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)busiReqBO.getCfcExpressRelationAbilityBO()), CfcExpressRelationBatchInsertAbilityReqBO.class);
                cfcExpressRelationBatchInsertAbilityReqBO.setObjId(agreementId);
                cfcExpressRelationBatchInsertAbilityReqBO.setObjNo(agreementPO.getPlaAgreementCode());
                cfcExpressRelationBatchInsertAbilityReqBO.setSuitType(Integer.valueOf(2));
                log.info("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^cfcExpressRelationBatchInsertAbilityReqBOcfcExpressRelationBatchInsertAbilityReqBO{}--------", JSON.toJSON((Object)cfcExpressRelationBatchInsertAbilityReqBO));
                this.cfcExpressRelationBatchInsertAbilityService.expressRelationBatchInsert(cfcExpressRelationBatchInsertAbilityReqBO);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.insertAgreementSettlement(busiReqBO, agreementId);
        log.info(JSON.toJSONString((Object)agreementPO));
        if (!CollectionUtils.isEmpty(busiReqBO.getAgrAgreementAttachBOs()) || !CollectionUtils.isEmpty((Collection)busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs())) {
            this.insertAgreementOther(busiReqBO, agreementPO);
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getAgrAgreementBO().getDistributeAreaInfo())) {
            this.insertDistributeAreaInfo(busiReqBO, agreementPO);
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getAgrAgreementSkuBOs())) {
            this.insertAgreementSku(busiReqBO, agreementPO);
        }
        Long agreementLogId = Sequence.getInstance().nextId();
        try {
            AgreementLogPO agreementLogPO = new AgreementLogPO();
            BeanUtils.copyProperties((Object)agreementPO, (Object)agreementLogPO);
            agreementLogPO.setAgreementLogId(agreementLogId);
            agreementLogPO.setLogStatus("2");
            agreementLogPO.setChangeType(new Byte("99"));
            agreementLogPO.setChangeTime(new Date());
            this.agreementLogMapper.insert(agreementLogPO);
            HashSet<Long> agreementIds = new HashSet<Long>();
            agreementIds.add(agreementId);
            this.insertAgreementSkuLog(agreementIds, agreementPO.getSupplierId(), agreementLogId);
            this.insertAgreementScopeLog(agreementIds, agreementPO.getSupplierId(), agreementLogId);
            this.insertAgreementAttachLog(agreementIds, agreementPO.getSupplierId(), agreementLogId);
            this.insertAgreementSettlementLog(agreementIds, agreementPO.getSupplierId(), agreementLogId);
        }
        catch (Exception e) {
            throw new BusinessException("0101", "\u751f\u6210\u534f\u8bae\u7248\u672c\u5f02\u5e38\uff01\uff01" + e);
        }
        this.valiteMerchant(busiReqBO);
        rsp.setAgreementId(agreementId);
        rsp.setAgreementLogId(agreementLogId);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u4e3b\u4f53\u521b\u5efa\u6210\u529f\uff01");
        return rsp;
    }

    private AgreementPO insertAgreement(AgrCreateAgreementSubjectBusiReqBO busiReqBO, Long agreementId) {
        int isInsert;
        int num;
        AgreementPO agreementPO = new AgreementPO();
        BeanUtils.copyProperties((Object)busiReqBO.getAgrAgreementBO(), (Object)agreementPO);
        agreementPO.setIsSupermarketStaff(busiReqBO.getAgrAgreementBO().getSupermarketStaffFlag());
        if (agreementPO.getSupplierMode() == 2) {
            agreementPO.setVendorDepartmentId(agreementPO.getVendorId());
            agreementPO.setVendorDepartmentName(agreementPO.getVendorName());
            agreementPO.setUnitAccountId(agreementPO.getVendorId());
            agreementPO.setUnitAccountName(agreementPO.getVendorName());
        } else {
            agreementPO.setVendorDepartmentId(busiReqBO.getCompanyId());
            agreementPO.setVendorDepartmentName(busiReqBO.getCompanyName());
            agreementPO.setUnitAccountId(busiReqBO.getCompanyId());
            agreementPO.setUnitAccountName(busiReqBO.getCompanyName());
        }
        if (busiReqBO.getAgrAgreementBO().getContractId() != null && (num = this.agreementMapper.getContractDoNum(busiReqBO.getAgrAgreementBO().getContractId(), Lists.newArrayList((Object[])new Long[]{0L, 99L}))) > 0) {
            throw new BusinessException("0101", "\u8be5\u534f\u8bae\u9009\u62e9\u7684\u5408\u540c\u5df2\u7ecf\u88ab\u5176\u5b83\u534f\u8bae\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5408\u540c\uff01");
        }
        String agreementVersion = "V1";
        agreementPO.setAgreementId(agreementId);
        agreementPO.setAgreementVersion(agreementVersion);
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setSupplierName(busiReqBO.getSupplierName());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.NO_ASS);
        agreementPO.setAssignStatus(AgrCommConstant.AssignStatus.BE_ASSIGN);
        agreementPO.setProducerId(busiReqBO.getMemIdIn());
        agreementPO.setProducerName(busiReqBO.getName());
        agreementPO.setAssignStatus(AgrCommConstant.AssignStatus.BE_ASSIGN);
        agreementPO.setProduceTime(new Date());
        agreementPO.setCreateOrgId(busiReqBO.getCompanyId());
        agreementPO.setCreateOrgName(busiReqBO.getCompanyName());
        Long originVendorId = Sequence.getInstance().nextId();
        agreementPO.setOriginVendorId(originVendorId);
        agreementPO.setOriginVendorCode(busiReqBO.getOriginVendorCode());
        agreementPO.setOriginVendorName(busiReqBO.getOriginVendorName());
        agreementPO.setIsprofess(Integer.valueOf(busiReqBO.getIsprofess()));
        if (ObjectUtils.isEmpty((Object)agreementPO.getOrderMethod())) {
            agreementPO.setOrderMethod(1);
        }
        if ((isInsert = this.agreementMapper.insert(agreementPO)) < 1) {
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u8868\u5931\u8d25\uff01");
        }
        return agreementPO;
    }

    private void insertAgreementSkuLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId) {
        int count;
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        agreementSkuPO.setSupplierId(supplierId);
        agreementSkuPO.setAgreementIds(agreementIds);
        agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementSkuPO> agreementSkuList = this.agreementSkuMapper.getList(agreementSkuPO);
        ArrayList<AgreementSkuLogPO> agreementSkuLogPOList = new ArrayList<AgreementSkuLogPO>();
        for (AgreementSkuPO agreementSkuPO1 : agreementSkuList) {
            AgreementSkuLogPO agreementSkuLogPO = new AgreementSkuLogPO();
            BeanUtils.copyProperties((Object)agreementSkuPO1, (Object)agreementSkuLogPO);
            agreementSkuLogPO.setAgreementLogId(agreementLogId);
            agreementSkuLogPOList.add(agreementSkuLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementSkuLogPOList) && (count = this.agreementSkuLogMapper.insertBatch(agreementSkuLogPOList)) != agreementSkuLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementSettlementLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId) {
        AgreementSettlementPO agreementSettlementPO = new AgreementSettlementPO();
        agreementSettlementPO.setAgreementIds(agreementIds);
        List<AgreementSettlementPO> list = this.agreementSettlementMapper.getList(agreementSettlementPO);
        ArrayList<AgreementSettlementLogPO> agreementSettlementLogPOList = new ArrayList<AgreementSettlementLogPO>();
        for (AgreementSettlementPO as : list) {
            AgreementSettlementLogPO agreementSettlementLogPO = new AgreementSettlementLogPO();
            BeanUtils.copyProperties((Object)as, (Object)agreementSettlementLogPO);
            Long settleMentLogId = Sequence.getInstance().nextId();
            agreementSettlementLogPO.setAgreementLogId(agreementLogId);
            agreementSettlementLogPO.setSettlementLogId(settleMentLogId);
            agreementSettlementLogPOList.add(agreementSettlementLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementSettlementLogPOList)) {
            log.info("\u534f\u8bae\u4ed8\u6b3e\u65b9\u5f0f\u5199\u5165\u5165\u53c2==========================================" + agreementSettlementLogPOList);
            int count = this.agreementSettlementLogMapper.insertBatch(agreementSettlementLogPOList);
            if (count != agreementSettlementLogPOList.size()) {
                throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u8868\u5931\u8d25");
            }
        }
    }

    private void insertAgreementScopeLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId) {
        int count;
        AgreementScopePO agreementScopePO = new AgreementScopePO();
        agreementScopePO.setSupplierId(supplierId);
        agreementScopePO.setAgreementIds(agreementIds);
        agreementScopePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementScopePO> agreementScopeList = this.agreementScopeMapper.getList(agreementScopePO);
        ArrayList<AgreementScopeLogPO> agreementScopeLogPOList = new ArrayList<AgreementScopeLogPO>();
        for (AgreementScopePO agreementScopePO1 : agreementScopeList) {
            AgreementScopeLogPO agreementScopeLogPO = new AgreementScopeLogPO();
            BeanUtils.copyProperties((Object)agreementScopePO1, (Object)agreementScopeLogPO);
            agreementScopeLogPO.setAgreementLogId(agreementLogId);
            agreementScopeLogPOList.add(agreementScopeLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementScopeLogPOList) && (count = this.agreementScopeLogMapper.insertBatch(agreementScopeLogPOList)) != agreementScopeLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u8303\u56f4\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementAttachLog(Set<Long> agreementIds, Long supplierId, Long agreementLogId) {
        int count;
        AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
        agreementAttachPO.setSupplierId(supplierId);
        agreementAttachPO.setAgreementIds(agreementIds);
        agreementAttachPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementAttachPO> agreementAttachList = this.agreementAttachMapper.getList(agreementAttachPO);
        ArrayList<AgrAgreementAttachLogPO> agrAgreementAttachLogPOList = new ArrayList<AgrAgreementAttachLogPO>();
        for (AgreementAttachPO agreementAttachPO1 : agreementAttachList) {
            AgrAgreementAttachLogPO agrAgreementAttachLogPO = new AgrAgreementAttachLogPO();
            BeanUtils.copyProperties((Object)agreementAttachPO1, (Object)agrAgreementAttachLogPO);
            agrAgreementAttachLogPO.setAgreementLogId(agreementLogId);
            agrAgreementAttachLogPOList.add(agrAgreementAttachLogPO);
        }
        if (!CollectionUtils.isEmpty(agrAgreementAttachLogPOList) && (count = this.agrAgreementAttachLogMapper.insertBatch(agrAgreementAttachLogPOList)) != agrAgreementAttachLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u9644\u4ef6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertDistributeAreaInfo(AgrCreateAgreementSubjectBusiReqBO busiReqBO, AgreementPO agreementPO) {
        ArrayList<AgrDistributeAreaPO> insertPos = new ArrayList<AgrDistributeAreaPO>();
        for (DistributeAreaReqBo distributeAreaReqBo : busiReqBO.getAgrAgreementBO().getDistributeAreaInfo()) {
            AgrDistributeAreaPO agrDistributeAreaPO = new AgrDistributeAreaPO();
            BeanUtils.copyProperties((Object)distributeAreaReqBo, (Object)agrDistributeAreaPO);
            agrDistributeAreaPO.setAgreementId(agreementPO.getAgreementId());
            Long id = Sequence.getInstance().nextId();
            agrDistributeAreaPO.setId(id);
            insertPos.add(agrDistributeAreaPO);
        }
        if (!CollectionUtils.isEmpty(insertPos)) {
            this.agrDistributeAreaMapper.insertBatch(insertPos);
        }
    }

    private void insertAgreementOther(AgrCreateAgreementSubjectBusiReqBO busiReqBO, AgreementPO agreementPO) {
        AgrCreateAgreementOtherAtomReqBO atomReqBO = new AgrCreateAgreementOtherAtomReqBO();
        atomReqBO.setMemIdIn(busiReqBO.getMemIdIn());
        atomReqBO.setSupplierId(busiReqBO.getSupplierId());
        atomReqBO.setUserName(busiReqBO.getUserName());
        atomReqBO.setAgreementId(agreementPO.getAgreementId());
        atomReqBO.setAgreementVersion(agreementPO.getAgreementVersion());
        atomReqBO.setAgrAgreementAttachBOs(busiReqBO.getAgrAgreementAttachBOs());
        atomReqBO.setAgrAgreementScopeBOs(busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs());
        atomReqBO.setScopeType(agreementPO.getScopeType());
        atomReqBO.setOperType("add");
        AgrCreateAgreementOtherAtomRspBO atomRspBO = this.agrCreateAgreementOtherAtomService.createAgreementOtherInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }

    private void insertAgreementSettlement(AgrCreateAgreementSubjectBusiReqBO busiReqBO, Long agreementId) {
        List<AgreementSettlementBO> paymentMethodList = busiReqBO.getPaymentMethod();
        log.error("paymentMethodList\u7684\u503c" + paymentMethodList);
        if (paymentMethodList == null) {
            throw new BusinessException("0101", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (busiReqBO.getAgrAgreementBO().getSupermarketStaffFlag() != null && busiReqBO.getAgrAgreementBO().getSupermarketStaffFlag() == 1 && !paymentMethodList.stream().map(a -> a.getSettlementObject()).collect(Collectors.toList()).contains("2")) {
            AgreementSettlementBO agreementSettlementBO = new AgreementSettlementBO();
            agreementSettlementBO.setSettlementObject("2");
            agreementSettlementBO.setSettlementObjectName("\u91c7\u8d2d\u5546");
            agreementSettlementBO.setSettlementType("0");
            agreementSettlementBO.setAssign("2");
            agreementSettlementBO.setComPay(BigDecimal.ZERO);
            agreementSettlementBO.setPayMethod("2");
            agreementSettlementBO.setPrePay(BigDecimal.ZERO);
            agreementSettlementBO.setQuaPay(BigDecimal.ZERO);
            agreementSettlementBO.setSettlementDate("0");
            agreementSettlementBO.setTryPay(BigDecimal.ZERO);
            paymentMethodList.add(agreementSettlementBO);
            log.error("\u5458\u5de5\u8d85\u5e02\u6dfb\u52a0paymentMethodList\u7684\u503c" + agreementSettlementBO);
        }
        for (AgreementSettlementBO asb : paymentMethodList) {
            AgrCreateAgreementSettlementAtomReqBO atomReqBO = new AgrCreateAgreementSettlementAtomReqBO();
            BeanUtils.copyProperties((Object)asb, (Object)((Object)atomReqBO));
            atomReqBO.setAgreementId(agreementId);
            AgrCreateAgreementSettlementAtomRspBO agreementSettlementInfo = this.agrCreateAgreementSettlementAtomService.createAgreementSettlementInfo(atomReqBO);
            if ("0000".equals(agreementSettlementInfo.getRespCode())) continue;
            throw new BusinessException(agreementSettlementInfo.getRespCode(), agreementSettlementInfo.getRespDesc());
        }
    }

    private void insertAgreementSku(AgrCreateAgreementSubjectBusiReqBO busiReqBO, AgreementPO agreementPO) {
        AgrCreateAgreementSkuAtomReqBO agrCreateAgreementSkuAtomReqBO = new AgrCreateAgreementSkuAtomReqBO();
        agrCreateAgreementSkuAtomReqBO.setAgrAgreementSkuBOs(busiReqBO.getAgrAgreementSkuBOs());
        agrCreateAgreementSkuAtomReqBO.setSupplierId(busiReqBO.getSupplierId());
        agrCreateAgreementSkuAtomReqBO.setAgreementVersion(agreementPO.getAgreementVersion());
        agrCreateAgreementSkuAtomReqBO.setAgreementId(agreementPO.getAgreementId());
        AgrCreateAgreementSkuAtomRspBO agrCreateAgreementSkuAtomRspBO = this.agrCreateAgreementSkuAtomService.createAgreementSku(agrCreateAgreementSkuAtomReqBO);
        if (!"0000".equals(agrCreateAgreementSkuAtomRspBO.getRespCode())) {
            throw new BusinessException(agrCreateAgreementSkuAtomRspBO.getRespCode(), agrCreateAgreementSkuAtomRspBO.getRespDesc());
        }
    }

    private void validPlaAgreementCode(AgrCreateAgreementSubjectBusiReqBO busiReqBO) {
        AgrAgreementBO agrAgreementBO = busiReqBO.getAgrAgreementBO();
        AgreementPO checkAgreementPO = new AgreementPO();
        checkAgreementPO.setPlaAgreementCode(agrAgreementBO.getPlaAgreementCode());
        AgreementPO checkAgreement = this.agreementMapper.getModelBy(checkAgreementPO);
        if (null != checkAgreement && !checkAgreement.getAgreementStatus().equals(AgrCommConstant.AgreementStatus.NO_ASS)) {
            throw new BusinessException("22053", "\u534f\u8bae\u7f16\u53f7\u3010" + checkAgreement.getPlaAgreementCode() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
    }

    void valiteMerchant(AgrCreateAgreementSubjectBusiReqBO reqBO) {
        FscMerchantCreateAbilityReqBO fscMerchantCreateAbilityReqBO = (FscMerchantCreateAbilityReqBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscMerchantCreateAbilityReqBO.class);
        fscMerchantCreateAbilityReqBO.setDealType(Integer.valueOf(0));
        fscMerchantCreateAbilityReqBO.setOrgId(reqBO.getAgrAgreementBO().getVendorId());
        fscMerchantCreateAbilityReqBO.setOrgName(reqBO.getAgrAgreementBO().getVendorName());
        fscMerchantCreateAbilityReqBO.setMerchantType(Integer.valueOf(1));
        fscMerchantCreateAbilityReqBO.setContactName(reqBO.getAgrAgreementBO().getVendorContact());
        fscMerchantCreateAbilityReqBO.setContactPhone(reqBO.getAgrAgreementBO().getVendorPhone());
        fscMerchantCreateAbilityReqBO.setContactPhoneBak(reqBO.getAgrAgreementBO().getVendorPhone());
        fscMerchantCreateAbilityReqBO.setMerchantCategory(Integer.valueOf(2));
        fscMerchantCreateAbilityReqBO.setModelAllowExceptionFlag(Integer.valueOf(1));
        fscMerchantCreateAbilityReqBO.setPayCreditAmount(new BigDecimal(0));
        fscMerchantCreateAbilityReqBO.setPayBreakScale(new BigDecimal(0));
        fscMerchantCreateAbilityReqBO.setCreditExhaustion(Integer.valueOf(0));
        fscMerchantCreateAbilityReqBO.setLiquidatedDamages(Integer.valueOf(1));
        fscMerchantCreateAbilityReqBO.setPayFlag(Integer.valueOf(0));
        fscMerchantCreateAbilityReqBO.setPayBusiSceneRange("2");
        fscMerchantCreateAbilityReqBO.setPayUserIdentity(Integer.valueOf(0));
        fscMerchantCreateAbilityReqBO.setPayAllowExceptionFlag(Integer.valueOf(1));
        FscMerchantCreateAbilityRspBO fscMerchantCreateAbilityRspBO = this.fscMerchantCreateAbilityService.dealCreate(fscMerchantCreateAbilityReqBO);
        if ("0000".equals(fscMerchantCreateAbilityRspBO.getRespCode())) {
            Long merchantId = fscMerchantCreateAbilityRspBO.getMerchantId();
            FscPayChannelEditAbilityReqBO fscPayChannelEditAbilityReqBO = new FscPayChannelEditAbilityReqBO();
            fscPayChannelEditAbilityReqBO.setOperType("1");
            fscPayChannelEditAbilityReqBO.setMerchantId(merchantId);
            fscPayChannelEditAbilityReqBO.setPayChannel("3");
            fscPayChannelEditAbilityReqBO.setPayMethod("30");
            fscPayChannelEditAbilityReqBO.setPayJson("[{\"parameterCode\":\"mchid\",\"parameterValue\":\"-\"}]");
            fscPayChannelEditAbilityReqBO.setName(reqBO.getName());
            fscPayChannelEditAbilityReqBO.setUserId(reqBO.getUserId());
            this.fscPayChannelEditAbilityService.dealEdit(fscPayChannelEditAbilityReqBO);
            FscMerchantPayeeBO fscMerchantPayeeBO = new FscMerchantPayeeBO();
            ArrayList<FscMerchantPayeeBO> createPayeeBOS = new ArrayList<FscMerchantPayeeBO>();
            FscMerchantPayeeCreateAbilityReqBO fscMerchantPayeeCreateAbilityReqBO = new FscMerchantPayeeCreateAbilityReqBO();
            if (new Byte("2").equals(reqBO.getAgrAgreementBO().getAgreementSrc())) {
                Long contractId = reqBO.getAgrAgreementBO().getContractId();
                ContractDetailQueryAbilityReqBO contractDetailQueryAbilityReqBO = new ContractDetailQueryAbilityReqBO();
                contractDetailQueryAbilityReqBO.setContractId(contractId);
                ContractDetailQueryAbilityRspBO contractDetailQueryAbilityRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(contractDetailQueryAbilityReqBO);
                if (StringUtils.isNotEmpty((CharSequence)contractDetailQueryAbilityRspBO.getSupplierBankName()) && StringUtils.isNotEmpty((CharSequence)contractDetailQueryAbilityRspBO.getSupplierAccount())) {
                    fscMerchantPayeeBO.setPayeeBankName(contractDetailQueryAbilityRspBO.getSupplierBankName());
                    fscMerchantPayeeBO.setPayeeBankAccount(contractDetailQueryAbilityRspBO.getSupplierAccount());
                    fscMerchantPayeeBO.setPayeeAccountName("-");
                    createPayeeBOS.add(fscMerchantPayeeBO);
                    fscMerchantPayeeCreateAbilityReqBO.setCreatePayeeBOS(createPayeeBOS);
                    this.fscMerchantPayeeCreateAbilityService.createPayee(fscMerchantPayeeCreateAbilityReqBO);
                }
            } else {
                fscMerchantPayeeBO.setMerchantId(merchantId);
                fscMerchantPayeeBO.setPayeeBankName("1");
                fscMerchantPayeeBO.setPayeeBankAccount("1");
                fscMerchantPayeeBO.setPayeeAccountName("1");
                createPayeeBOS.add(fscMerchantPayeeBO);
                fscMerchantPayeeCreateAbilityReqBO.setCreatePayeeBOS(createPayeeBOS);
                this.fscMerchantPayeeCreateAbilityService.createPayee(fscMerchantPayeeCreateAbilityReqBO);
            }
            fscMerchantCreateAbilityReqBO.setDealType(Integer.valueOf(1));
            this.fscMerchantCreateAbilityService.dealCreate(fscMerchantCreateAbilityReqBO);
        }
    }
}

