/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.google.common.collect.Lists;
import com.tydic.agreement.ability.bo.AgrskuChangePriceBO;
import com.tydic.agreement.atom.api.AgrSyncSkuStatusToCommidityAtomService;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomReqBO;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomRspBO;
import com.tydic.agreement.busi.api.AgrModifyAgreementSkuBusiService;
import com.tydic.agreement.busi.bo.AgrModifyAgreementSkuBusiReqBO;
import com.tydic.agreement.busi.bo.AgrModifyAgreementSkuBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.utils.MoneyUtils;
import com.tydic.commodity.common.ability.api.UccUpperTaxCatCodeQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrModifyAgreementSkuBusiServiceImpl
implements AgrModifyAgreementSkuBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrModifyAgreementSkuBusiServiceImpl.class);
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrSyncSkuStatusToCommidityAtomService agrSyncSkuStatusToCommidityAtomService;
    @Autowired
    private UccUpperTaxCatCodeQryAbilityService uccUpperTaxCatCodeQryAbilityService;

    @Override
    public AgrModifyAgreementSkuBusiRspBO modifyAgreementSku(AgrModifyAgreementSkuBusiReqBO busiReqBO) {
        AgrModifyAgreementSkuBusiRspBO rsp = new AgrModifyAgreementSkuBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgrAgreementSkuBOs().getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        if (!(AgrCommConstant.AgreementStatus.DRAFT.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.REJECT.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.NO_ASS.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.NO_CONFIRM.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.CONTRACT_CONFIRM.equals(agreement.getAgreementStatus()) || busiReqBO.isSyncSkuFlag())) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d\u3001\u672a\u63a5\u53d7\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u4fee\u6539\u534f\u8bae\u660e\u7ec6\uff01");
        }
        AgreementSkuPO updateAgreementSkuPO = new AgreementSkuPO();
        BeanUtils.copyProperties((Object)busiReqBO.getAgrAgreementSkuBOs(), (Object)updateAgreementSkuPO);
        updateAgreementSkuPO.setUpdateLoginId(busiReqBO.getMemIdIn());
        updateAgreementSkuPO.setUpdateName(busiReqBO.getUserName());
        updateAgreementSkuPO.setUpdateTime(new Date());
        updateAgreementSkuPO.setSkuSource(null);
        if (!StringUtils.isEmpty((Object)updateAgreementSkuPO.getTaxCatalog())) {
            List taxIds;
            ArrayList taxCodes = Lists.newArrayList((Object[])new String[]{updateAgreementSkuPO.getTaxCatalog()});
            HashMap taxCatCodeMap = null;
            try {
                if (!CollectionUtils.isEmpty((Collection)taxCodes)) {
                    UccUpperTaxCatCodeQryAbilityReqBo uccUpperTaxCatCodeQryAbilityReqBo = new UccUpperTaxCatCodeQryAbilityReqBo();
                    uccUpperTaxCatCodeQryAbilityReqBo.setTaxCodes((List)taxCodes);
                    UccUpperTaxCatCodeQryAbilityRspBo uccUpperTaxCatCodeQryAbilityRspBo = this.uccUpperTaxCatCodeQryAbilityService.qryUpperTaxCatCode(uccUpperTaxCatCodeQryAbilityReqBo);
                    if ("0000".equals(uccUpperTaxCatCodeQryAbilityRspBo.getRespCode()) && null == (taxCatCodeMap = uccUpperTaxCatCodeQryAbilityRspBo.getTaxCatCodeMap())) {
                        taxCatCodeMap = new HashMap();
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            if (!ObjectUtils.isEmpty(taxCatCodeMap) && !CollectionUtils.isEmpty((Collection)(taxIds = (List)taxCatCodeMap.get(updateAgreementSkuPO.getTaxCatalog())))) {
                String taxCatalogList = org.apache.commons.lang3.StringUtils.join((Iterable)taxIds, (String)",");
                updateAgreementSkuPO.setTaxCatalogList(taxCatalogList);
            }
        }
        updateAgreementSkuPO.setCurrentStockNumber(updateAgreementSkuPO.getBuyNumber());
        updateAgreementSkuPO.setBuyPrice(MoneyUtils.calculate2Decimals(updateAgreementSkuPO.getBuyPrice(), 10));
        updateAgreementSkuPO.setBuyPriceSum(MoneyUtils.calculate2Decimals(updateAgreementSkuPO.getBuyPriceSum(), 2));
        updateAgreementSkuPO.setSalePrice(MoneyUtils.calculate2Decimals(updateAgreementSkuPO.getSalePrice(), 10));
        updateAgreementSkuPO.setSalePriceSum(MoneyUtils.calculate2Decimals(updateAgreementSkuPO.getSalePriceSum(), 2));
        this.agreementSkuMapper.updateBy(updateAgreementSkuPO);
        if (updateAgreementSkuPO.getSalePrice() == null && (null != updateAgreementSkuPO.getBuyNumber() || null != updateAgreementSkuPO.getBuyPrice() || null != updateAgreementSkuPO.getMarkupRate())) {
            this.agreementSkuMapper.updateByCaculate(updateAgreementSkuPO);
        }
        if (AgrCommConstant.AgreementStatus.CONTRACT_CONFIRM.equals(agreement.getAgreementStatus()) || busiReqBO.isSyncSkuFlag()) {
            ArrayList<AgrskuChangePriceBO> skuChangePriceBOs = new ArrayList<AgrskuChangePriceBO>();
            AgrskuChangePriceBO bo = new AgrskuChangePriceBO();
            bo.setAgreementId(updateAgreementSkuPO.getAgreementId());
            bo.setAgreementSkuId(updateAgreementSkuPO.getAgreementSkuId());
            bo.setBuyPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong(updateAgreementSkuPO.getBuyPrice())));
            bo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong(updateAgreementSkuPO.getSalePrice())));
            if (updateAgreementSkuPO.getSaleStatus().equals("3")) {
                bo.setCommiditySkuStatus(AgrCommConstant.CommiditySkuStatus.INVALID);
            }
            skuChangePriceBOs.add(bo);
            AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
            atomReqBO.setSkuChangePriceBOs(skuChangePriceBOs);
            AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new com.tydic.uac.exception.BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespCode());
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u4fee\u6539\u6210\u529f\uff01");
        return rsp;
    }
}

