/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrAgreementScopeBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.api.AgrQryAgreementSkuDetailsBusiService;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuDetailsBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuDetailsBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementScopePO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.utils.MoneyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrQryAgreementSkuDetailsBusiServiceImpl
implements AgrQryAgreementSkuDetailsBusiService {
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;

    @Override
    public AgrQryAgreementSkuDetailsBusiRspBO qryAgreementSkuDetails(AgrQryAgreementSkuDetailsBusiReqBO busiReqBO) {
        AgrQryAgreementSkuDetailsBusiRspBO rsp = new AgrQryAgreementSkuDetailsBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        BeanUtils.copyProperties((Object)busiReqBO, (Object)agreementSkuPO);
        agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementSkuPO agreementSku = this.agreementSkuMapper.getModelBy(agreementSkuPO);
        if (null == agreementSku) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        AgrAgreementSkuBO agrAgreementSkuBO = new AgrAgreementSkuBO();
        BeanUtils.copyProperties((Object)agreementSku, (Object)agrAgreementSkuBO);
        AgrAgreementBO agrAgreementBO = new AgrAgreementBO();
        AgreementScopePO agreementScopePO = new AgreementScopePO();
        agreementScopePO.setAgreementId(busiReqBO.getAgreementId());
        agreementScopePO.setSupplierId(agreement.getSupplierId());
        agreementScopePO.setAgreementVersion(agreement.getAgreementVersion());
        agreementScopePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementScopePO> agreementScopePOs = this.agreementScopeMapper.getList(agreementScopePO);
        if (!CollectionUtils.isEmpty(agreementScopePOs)) {
            ArrayList<AgrAgreementScopeBO> agrAgreementScopeBOs = new ArrayList<AgrAgreementScopeBO>();
            for (AgreementScopePO po : agreementScopePOs) {
                AgrAgreementScopeBO agrAgreementScopeBO = new AgrAgreementScopeBO();
                BeanUtils.copyProperties((Object)po, (Object)agrAgreementScopeBO);
                agrAgreementScopeBOs.add(agrAgreementScopeBO);
            }
            if (agreementScopePOs.size() != 1 || !agreementScopePOs.get(0).getScopeType().equals((byte)0)) {
                AgrAgreementScopeBO agrAgreementScopeBO = new AgrAgreementScopeBO();
                agrAgreementScopeBO.setAgreementId(busiReqBO.getAgreementId());
                agrAgreementScopeBO.setIsDelete(new Byte("0"));
                agrAgreementScopeBO.setScopeCode(agreement.getVendorId());
                agrAgreementScopeBO.setSupplierId(agreement.getSupplierId());
                agrAgreementScopeBOs.add(agrAgreementScopeBO);
            }
            agrAgreementBO.setAgrAgreementScopeBOs(agrAgreementScopeBOs);
        }
        BeanUtils.copyProperties((Object)agreement, (Object)agrAgreementBO);
        this.tanslate(agrAgreementBO);
        agrAgreementSkuBO.setAgrAgreementBO(agrAgreementBO);
        if (agrAgreementSkuBO.getIsOil() != null) {
            String isOilStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_OIL_PCODE", agrAgreementSkuBO.getIsOil().toString());
            Map<String, String> skuSourceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "SKU_SOURCE_PCODE");
            Map<String, String> saleStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "SALE_STATUS_PCODE");
            agrAgreementSkuBO.setIsOilStr(isOilStr);
            if (null != agrAgreementSkuBO.getSkuSource()) {
                agrAgreementSkuBO.setSkuSourceStr(skuSourceStr.get(agrAgreementSkuBO.getSkuSource()));
            }
            if (null != agrAgreementSkuBO.getSaleStatus()) {
                agrAgreementSkuBO.setSaleStatusStr(saleStatusStr.get(agrAgreementSkuBO.getSaleStatus()));
            }
        }
        agrAgreementSkuBO.setBuyPrice(MoneyUtils.calculate2Decimals(agrAgreementSkuBO.getBuyPrice(), 10));
        agrAgreementSkuBO.setBuyPriceSum(MoneyUtils.calculate2Decimals(agrAgreementSkuBO.getBuyPriceSum(), 2));
        agrAgreementSkuBO.setSalePrice(MoneyUtils.calculate2Decimals(agrAgreementSkuBO.getSalePrice(), 10));
        agrAgreementSkuBO.setSalePriceSum(MoneyUtils.calculate2Decimals(agrAgreementSkuBO.getSalePriceSum(), 2));
        rsp.setAgrAgreementSkuBO(agrAgreementSkuBO);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u8be6\u60c5\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }

    private void tanslate(AgrAgreementBO agrAgreementBO) {
        if (null != agrAgreementBO.getAgreementMode()) {
            String agreementModeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_MODE_PCODE", agrAgreementBO.getAgreementMode().toString());
            agrAgreementBO.setAgreementModeStr(agreementModeStr);
        }
        if (null != agrAgreementBO.getPriceType()) {
            String priceTypeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "PRICE_TYPE_PCODE", agrAgreementBO.getPriceType().toString());
            agrAgreementBO.setPriceTypeStr(priceTypeStr);
        }
        if (null != agrAgreementBO.getAgreementType()) {
            String agreementTypeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_TYPE_PCODE", agrAgreementBO.getAgreementType().toString());
            agrAgreementBO.setAgreementTypeStr(agreementTypeStr);
        }
        if (null != agrAgreementBO.getAgreementSrc()) {
            String agreementSrcStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_SRC_PCODE", agrAgreementBO.getAgreementSrc().toString());
            agrAgreementBO.setAgreementSrcStr(agreementSrcStr);
        }
        if (null != agrAgreementBO.getAgreementVariety()) {
            String agreementVarietyStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_VARIETY_PCODE", agrAgreementBO.getAgreementVariety().toString());
            agrAgreementBO.setAgreementVarietyStr(agreementVarietyStr);
        }
        if (null != agrAgreementBO.getCurrency()) {
            String currencyStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "CURRENCY_PCODE", agrAgreementBO.getCurrency().toString());
            agrAgreementBO.setCurrencyStr(currencyStr);
        }
        if (null != agrAgreementBO.getIsDispatch()) {
            String isDispatchStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_DISPATCH_PCODE", agrAgreementBO.getIsDispatch().toString());
            agrAgreementBO.setIsDispatchStr(isDispatchStr);
        }
        if (null != agrAgreementBO.getAdjustPrice()) {
            String adjustPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "ADJUST_PRICE_PCODE", agrAgreementBO.getAdjustPrice().toString());
            agrAgreementBO.setAdjustPriceStr(adjustPriceStr);
        }
        if (null != agrAgreementBO.getIsAdjustPriceFormula()) {
            String isAdjustPriceFormulaStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_ADJUST_PRICE_FORMULA_PCODE", agrAgreementBO.getIsAdjustPriceFormula().toString());
            agrAgreementBO.setIsAdjustPriceFormulaStr(isAdjustPriceFormulaStr);
        }
        if (null != agrAgreementBO.getIsModifyBuyPrice()) {
            String isModifyBuyPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_MODIFY_BUY_PRICE_PCODE", agrAgreementBO.getIsModifyBuyPrice().toString());
            agrAgreementBO.setIsModifyBuyPriceStr(isModifyBuyPriceStr);
        }
        if (null != agrAgreementBO.getIsAddPrice()) {
            String isAddPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_ADD_PRICE_PCODE", agrAgreementBO.getIsAddPrice().toString());
            agrAgreementBO.setIsAddPriceStr(isAddPriceStr);
        }
        if (null != agrAgreementBO.getAgrLocation()) {
            String agrLocationStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGR_LOCATION_PCODE", agrAgreementBO.getAgrLocation().toString());
            agrAgreementBO.setAgrLocationStr(agrLocationStr);
        }
        if (null != agrAgreementBO.getAgreementStatus()) {
            String agreementStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_STATUS_PCODE", agrAgreementBO.getAgreementStatus().toString());
            agrAgreementBO.setAgreementStatusStr(agreementStatusStr);
        }
        if (null != agrAgreementBO.getAssignStatus()) {
            String assignStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "ASSIGN_STATUS_PCODE", agrAgreementBO.getAssignStatus().toString());
            agrAgreementBO.setAssignStatusStr(assignStatusStr);
        }
        if (null != agrAgreementBO.getSupplierMode()) {
            String supplierModeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "SUPPLIER_MODE_PCODE", agrAgreementBO.getSupplierMode().toString());
            agrAgreementBO.setSupplierModeStr(supplierModeStr);
        }
        if (null != agrAgreementBO.getTradeMode()) {
            String tradeModeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "TRADE_MODE_PCODE", agrAgreementBO.getTradeMode().toString());
            agrAgreementBO.setTradeModeStr(tradeModeStr);
        }
        if (null != agrAgreementBO.getScopeType()) {
            String scopeTypeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "SCOPE_TYPE_PCODE", agrAgreementBO.getScopeType().toString());
            agrAgreementBO.setScopeTypeStr(scopeTypeStr);
        }
    }
}

