/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.api.AgrQryAgreementSkuRecordListBusiService;
import com.tydic.agreement.busi.bo.AgrAgreementSkuRecordBusiBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuRecordListBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuRecordListBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementSkuRecordMapper;
import com.tydic.agreement.po.AgrAgreementSkuRecordPO;
import com.tydic.agreement.utils.MoneyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrQryAgreementSkuRecordListBusiServiceImpl
implements AgrQryAgreementSkuRecordListBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrQryAgreementSkuRecordListBusiServiceImpl.class);
    @Autowired
    private AgrAgreementSkuRecordMapper agrAgreementSkuRecordMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;

    @Override
    public AgrQryAgreementSkuRecordListBusiRspBO qryAgreementSkuRecordListByIds(AgrQryAgreementSkuRecordListBusiReqBO reqBO) {
        AgrQryAgreementSkuRecordListBusiRspBO rspBO = new AgrQryAgreementSkuRecordListBusiRspBO();
        if (CollectionUtils.isEmpty(reqBO.getAgreementSkuIds())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setAgrAgreementSkuRecordBOList(new ArrayList<AgrAgreementSkuRecordBusiBO>());
            return rspBO;
        }
        List<AgrAgreementSkuRecordPO> agrAgreementSkuRecordPOList = this.agrAgreementSkuRecordMapper.getListByIds(reqBO.getAgreementSkuIds());
        List agrAgreementSkuRecordBOList = JSON.parseArray((String)JSON.toJSONString(agrAgreementSkuRecordPOList), AgrAgreementSkuRecordBusiBO.class);
        rspBO.setAgrAgreementSkuRecordBOList(agrAgreementSkuRecordBOList);
        this.translationData(rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void translationData(AgrQryAgreementSkuRecordListBusiRspBO rspBO) {
        if (!CollectionUtils.isEmpty(rspBO.getAgrAgreementSkuRecordBOList())) {
            Map<String, String> isOilStrMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_OIL_PCODE");
            Map<String, String> saleStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "SALE_STATUS_PCODE");
            for (AgrAgreementSkuRecordBusiBO agrAgreementSkuRecordBO : rspBO.getAgrAgreementSkuRecordBOList()) {
                agrAgreementSkuRecordBO.setBuyPrice(MoneyUtils.calculate2Decimals(agrAgreementSkuRecordBO.getBuyPrice(), 8));
                agrAgreementSkuRecordBO.setBuyPriceSum(MoneyUtils.calculate2Decimals(agrAgreementSkuRecordBO.getBuyPriceSum(), 2));
                agrAgreementSkuRecordBO.setSalePrice(MoneyUtils.calculate2Decimals(agrAgreementSkuRecordBO.getSalePrice(), 8));
                agrAgreementSkuRecordBO.setSalePriceSum(MoneyUtils.calculate2Decimals(agrAgreementSkuRecordBO.getSalePriceSum(), 2));
                try {
                    if (ObjectUtil.isNotEmpty((Object)agrAgreementSkuRecordBO.getContractItemStatus())) {
                        agrAgreementSkuRecordBO.setContractItemStatusStr(AgrCommConstant.ContractItemStatusEnum.getDesc(agrAgreementSkuRecordBO.getContractItemStatus()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)agrAgreementSkuRecordBO.getIsOil())) {
                        agrAgreementSkuRecordBO.setIsOilStr(isOilStrMap.get(agrAgreementSkuRecordBO.getIsOil().toString()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)agrAgreementSkuRecordBO.getSaleStatus())) {
                        agrAgreementSkuRecordBO.setSaleStatusStr(saleStatusStr.get(agrAgreementSkuRecordBO.getSaleStatus()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)agrAgreementSkuRecordBO.getBuyPrice())) {
                        agrAgreementSkuRecordBO.setBuyPriceStr(agrAgreementSkuRecordBO.getBuyPrice().toPlainString());
                    }
                    if (ObjectUtil.isNotEmpty((Object)agrAgreementSkuRecordBO.getBuyPriceSum())) {
                        agrAgreementSkuRecordBO.setBuyPriceSumStr(agrAgreementSkuRecordBO.getBuyPriceSum().toPlainString());
                    }
                    if (ObjectUtil.isNotEmpty((Object)agrAgreementSkuRecordBO.getSalePrice())) {
                        agrAgreementSkuRecordBO.setSalePriceStr(agrAgreementSkuRecordBO.getSalePrice().toPlainString());
                    }
                    if (!ObjectUtil.isNotEmpty((Object)agrAgreementSkuRecordBO.getSalePriceSum())) continue;
                    agrAgreementSkuRecordBO.setSalePriceSumStr(agrAgreementSkuRecordBO.getSalePriceSum().toPlainString());
                }
                catch (Exception e) {
                    log.error("\u5355\u4f4d\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }
}

