/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.ability.bo.AgrAgreementSkuLogBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.api.AgrQryAgreementSkuVersionByPageBusiService;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuByPageBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuLogByPageBusiRspBO;
import com.tydic.agreement.dao.AgreementSkuLogMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.utils.MoneyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrQryAgreementSkuVersionByPageBusiServiceImpl
implements AgrQryAgreementSkuVersionByPageBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrQryAgreementSkuVersionByPageBusiServiceImpl.class);
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementSkuLogMapper agreementSkuLogMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;

    @Override
    public AgrQryAgreementSkuLogByPageBusiRspBO qryAgreementSkuByPageVersion(AgrQryAgreementSkuByPageBusiReqBO busiReqBO) {
        AgrQryAgreementSkuLogByPageBusiRspBO rsp = new AgrQryAgreementSkuLogByPageBusiRspBO();
        List<Object> rows = new ArrayList();
        if (busiReqBO.getPageQueryFlag().booleanValue()) {
            Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
            rows = this.agreementSkuLogMapper.getListPageByCondition(busiReqBO, (Page<AgrAgreementSkuLogBO>)page);
            rsp.setTotal(page.getTotalPages());
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setPageNo(page.getPageNo());
        }
        if (!CollectionUtils.isEmpty(rows)) {
            Map<String, String> isOilStrMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_OIL_PCODE");
            Map<String, String> isDispatchStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_DISPATCH_PCODE");
            Map<String, String> agreementStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGREEMENT_STATUS_PCODE");
            Map<String, String> adjustPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "ADJUST_PRICE_PCODE");
            for (AgrAgreementSkuLogBO agrAgreementSkuLogBO : rows) {
                agrAgreementSkuLogBO.setBuyPrice(MoneyUtils.calculate2Decimals(agrAgreementSkuLogBO.getBuyPrice(), 8));
                agrAgreementSkuLogBO.setBuyPriceSum(MoneyUtils.calculate2Decimals(agrAgreementSkuLogBO.getBuyPriceSum(), 2));
                agrAgreementSkuLogBO.setSalePrice(MoneyUtils.calculate2Decimals(agrAgreementSkuLogBO.getSalePrice(), 8));
                agrAgreementSkuLogBO.setSalePriceSum(MoneyUtils.calculate2Decimals(agrAgreementSkuLogBO.getSalePriceSum(), 2));
                if (agrAgreementSkuLogBO.getIsOil() != null) {
                    agrAgreementSkuLogBO.setIsOilStr(isOilStrMap.get(agrAgreementSkuLogBO.getIsOil().toString()));
                }
                if (null != agrAgreementSkuLogBO.getIsDispatch()) {
                    agrAgreementSkuLogBO.setIsDispatchStr(isDispatchStr.get(agrAgreementSkuLogBO.getIsDispatch().toString()));
                }
                if (null != agrAgreementSkuLogBO.getAgreementStatus()) {
                    agrAgreementSkuLogBO.setAgreementStatusStr(agreementStatusStr.get(agrAgreementSkuLogBO.getAgreementStatus().toString()));
                }
                if (null != agrAgreementSkuLogBO.getAdjustPrice()) {
                    agrAgreementSkuLogBO.setAdjustPriceStr(adjustPriceStr.get(agrAgreementSkuLogBO.getAdjustPrice().toString()));
                }
                try {
                    if (agrAgreementSkuLogBO.getBuyPrice() != null) {
                        agrAgreementSkuLogBO.setBuyPriceStr(agrAgreementSkuLogBO.getBuyPrice().toPlainString());
                    }
                    if (agrAgreementSkuLogBO.getBuyPriceSum() != null) {
                        agrAgreementSkuLogBO.setBuyPriceSumStr(agrAgreementSkuLogBO.getBuyPriceSum().toPlainString());
                    }
                    if (agrAgreementSkuLogBO.getSalePrice() != null) {
                        agrAgreementSkuLogBO.setSalePriceStr(agrAgreementSkuLogBO.getSalePrice().toPlainString());
                    }
                    if (agrAgreementSkuLogBO.getSalePriceSum() == null) continue;
                    agrAgreementSkuLogBO.setSalePriceSumStr(agrAgreementSkuLogBO.getSalePriceSum().toPlainString());
                }
                catch (Exception e) {
                    log.error("\u5355\u4f4d\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        if (CollectionUtils.isEmpty(rows)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u7248\u672c\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        rsp.setRows(rows);
        return rsp;
    }
}

