/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrPublicAbilityRspBO;
import com.tydic.agreement.busi.api.AgrShortNameListService;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrShortNameListLineMapper;
import com.tydic.agreement.dao.AgrShortNameListMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrShortNameListLinePO;
import com.tydic.agreement.po.AgrShortNameListPO;
import com.tydic.agreement.utils.AgrDateUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrShortNameListServiceImpl
implements AgrShortNameListService {
    private static final Logger log = LoggerFactory.getLogger(AgrShortNameListServiceImpl.class);
    @Autowired
    private AgrShortNameListMapper agrShortNameListMapper;
    @Autowired
    private AgrShortNameListLineMapper agrShortNameListLineMapper;

    @Override
    public AgrPublicAbilityRspBO selectListPage(AgrShortNameListPO reqBO) {
        List<Long> shortNamelistIds;
        List<AgrShortNameListPO> pos;
        log.info("-----------reqBO:\u72b6\u6001" + reqBO.getShorNamelistStatus());
        AgrPublicAbilityRspBO rspBo = new AgrPublicAbilityRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<AgrShortNameListPO> list = this.agrShortNameListMapper.getListPage(reqBO, (Page<AgrShortNameListPO>)page);
        rspBo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBo.setRows(list);
        if (reqBO.getPageNo() != null && reqBO.getPageNo() > 0) {
            rspBo.setPageNo(reqBO.getPageNo());
        }
        if (reqBO.getQryVendorCount() != null && reqBO.getQryVendorCount() == 1 && !CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(pos = this.agrShortNameListMapper.getVendorCodoByShortnamelistId(shortNamelistIds = list.stream().map(AgrShortNameListPO::getShorNamelistId).collect(Collectors.toList())))) {
            Map<Long, List<AgrShortNameListPO>> shorNamelistIdMap = pos.stream().collect(Collectors.groupingBy(AgrShortNameListPO::getShorNamelistId));
            for (AgrShortNameListPO agrShortNameListPO : list) {
                List<AgrShortNameListPO> allVendorList = shorNamelistIdMap.get(agrShortNameListPO.getShorNamelistId());
                if (!CollectionUtils.isEmpty(allVendorList)) {
                    agrShortNameListPO.setVendorCount(allVendorList.size());
                    Set vendorCodeSet = allVendorList.stream().map(AgrShortNameListPO::getVendorCode).collect(Collectors.toSet());
                    agrShortNameListPO.setDistVendorCount(vendorCodeSet.size());
                    continue;
                }
                agrShortNameListPO.setVendorCount(0);
                agrShortNameListPO.setDistVendorCount(0);
            }
        }
        return rspBo;
    }

    @Override
    public AgrPublicAbilityRspBO insertOrUpdateShortNameList(AgrShortNameListPO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        rspBO.setFlag(false);
        if (reqBO.getShorNamelistId() == null) {
            Long scopeId = Sequence.getInstance().nextId();
            reqBO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            reqBO.setCreateTime(new Date());
            reqBO.setUpdateTime(new Date());
            reqBO.setShorNamelistId(scopeId);
            int isInsert = this.agrShortNameListMapper.insert(reqBO);
            if (isInsert < 1) {
                throw new BusinessException("0101", "\u77ed\u540d\u5355\u65b0\u589e\u8868\u5931\u8d25\uff01");
            }
            rspBO.setCode("0000");
        } else {
            reqBO.setUpdateTime(new Date());
            int isInsert = this.agrShortNameListMapper.updateBy(reqBO);
            if (isInsert < 1) {
                throw new BusinessException("0101", "\u77ed\u540d\u5355\u4fee\u6539\u8868\u5931\u8d25\uff01");
            }
            rspBO.setCode("0000");
        }
        rspBO.setT((Object)reqBO);
        return rspBO;
    }

    @Override
    public AgrPublicAbilityRspBO getById(AgrShortNameListPO reqBO) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        List<AgrShortNameListPO> list = this.agrShortNameListMapper.getById(reqBO);
        rspBO.setRows(list);
        return rspBO;
    }

    @Override
    public AgrPublicAbilityRspBO createCode() {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        String yearMonth = AgrDateUtils.DateToStr(new Date(), "yyyyMM");
        String maxOrderNum = this.agrShortNameListMapper.selectMaxOrderNum(yearMonth);
        String serialNumber = "0001";
        if (maxOrderNum != null && !"".equals(maxOrderNum)) {
            serialNumber = String.format("%04d", Integer.parseInt(maxOrderNum) + 1);
        }
        String code = "JCMD-" + yearMonth + "-" + serialNumber;
        rspBO.setT((Object)code);
        rspBO.setCode("0000");
        return rspBO;
    }

    @Override
    public AgrPublicAbilityRspBO deleteBy(AgrShortNameListPO agrShortNameList) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        rspBO.setFlag(false);
        if (agrShortNameList.getShorNamelistId() == null) {
            throw new BusinessException("0001", "\u8bf7\u4f20\u5165id\uff01");
        }
        int isUpdate = this.agrShortNameListMapper.deleteBy(agrShortNameList);
        if (isUpdate < 1) {
            throw new BusinessException("22004", "\u77ed\u540d\u5355\u4fee\u6539\u5931\u8d25\uff01");
        }
        AgrShortNameListLinePO po = new AgrShortNameListLinePO();
        po.setShorNamelistId(agrShortNameList.getShorNamelistId());
        this.agrShortNameListLineMapper.deleteBy(po);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u77ed\u540d\u5355\u5220\u9664\u6210\u529f\uff01");
        return rspBO;
    }

    @Override
    public AgrPublicAbilityRspBO updateStatus(AgrShortNameListPO agrShortNameList) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        int isUpdate = this.agrShortNameListMapper.updateStatus(agrShortNameList);
        if (isUpdate < 1) {
            throw new BusinessException("22004", "\u77ed\u540d\u5355\u72b6\u6001\u4fee\u6539\u5931\u8d25\uff01");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u77ed\u540d\u5355\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01");
        return rspBO;
    }
}

