/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.tydic.agreement.ability.bo.AgrUpdateAgreementSkuChangeReqBO;
import com.tydic.agreement.ability.bo.AgrUpdateAgreementSkuChangeRspBO;
import com.tydic.agreement.busi.api.AgrUpdateAgreementSkuChangeBusiService;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuChangePO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.utils.MoneyUtils;
import com.tydic.commodity.common.ability.api.UccUpperTaxCatCodeQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrUpdateAgreementSkuChangeBusiServiceImpl
implements AgrUpdateAgreementSkuChangeBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrUpdateAgreementSkuChangeBusiServiceImpl.class);
    @Autowired
    private AgreementSkuChangeMapper agreementSkuChangeMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private UccUpperTaxCatCodeQryAbilityService uccUpperTaxCatCodeQryAbilityService;

    @Override
    public AgrUpdateAgreementSkuChangeRspBO updateAgreementSkuChange(AgrUpdateAgreementSkuChangeReqBO reqBO) {
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(reqBO.getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        AgrUpdateAgreementSkuChangeRspBO rsp = new AgrUpdateAgreementSkuChangeRspBO();
        AgreementSkuChangePO agreementSkuChangePO = (AgreementSkuChangePO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getAgrAgreementSkuChangeBO()), AgreementSkuChangePO.class);
        agreementSkuChangePO.setUpdateLoginId(reqBO.getMemIdIn());
        agreementSkuChangePO.setUpdateName(reqBO.getUserName());
        agreementSkuChangePO.setUpdateTime(new Date());
        if (agreementSkuChangePO.getBuyNumber() != null) {
            if (agreementSkuChangePO.getSaleStatus() != null && agreementSkuChangePO.getSaleStatus().equals("2") && agreementSkuChangePO.getAgreementSkuId() != null) {
                AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
                agreementSkuPO.setAgreementSkuId(agreementSkuChangePO.getAgreementSkuId());
                agreementSkuPO = this.agreementSkuMapper.getModelBy(agreementSkuPO);
            }
            agreementSkuChangePO.setBuyPriceSum(agreementSkuChangePO.getBuyPrice().multiply(agreementSkuChangePO.getBuyNumber()));
            if (agreementSkuChangePO.getSalePrice() == null) {
                agreementSkuChangePO.setSalePrice(agreementSkuChangePO.getBuyPrice().add(agreementSkuChangePO.getBuyPrice().multiply(new BigDecimal(agreementSkuChangePO.getMarkupRate().toString())).divide(new BigDecimal(100))));
                agreementSkuChangePO.setSalePriceSum(agreementSkuChangePO.getSalePrice().multiply(agreementSkuChangePO.getBuyNumber()));
            }
        }
        if (!StringUtils.isEmpty((Object)agreementSkuChangePO.getTaxCatalog())) {
            List taxIds;
            ArrayList taxCodes = Lists.newArrayList((Object[])new String[]{agreementSkuChangePO.getTaxCatalog()});
            HashMap taxCatCodeMap = null;
            try {
                if (!CollectionUtils.isEmpty((Collection)taxCodes)) {
                    UccUpperTaxCatCodeQryAbilityReqBo uccUpperTaxCatCodeQryAbilityReqBo = new UccUpperTaxCatCodeQryAbilityReqBo();
                    uccUpperTaxCatCodeQryAbilityReqBo.setTaxCodes((List)taxCodes);
                    UccUpperTaxCatCodeQryAbilityRspBo uccUpperTaxCatCodeQryAbilityRspBo = this.uccUpperTaxCatCodeQryAbilityService.qryUpperTaxCatCode(uccUpperTaxCatCodeQryAbilityReqBo);
                    if ("0000".equals(uccUpperTaxCatCodeQryAbilityRspBo.getRespCode()) && null == (taxCatCodeMap = uccUpperTaxCatCodeQryAbilityRspBo.getTaxCatCodeMap())) {
                        taxCatCodeMap = new HashMap();
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            if (!ObjectUtils.isEmpty(taxCatCodeMap) && !CollectionUtils.isEmpty((Collection)(taxIds = (List)taxCatCodeMap.get(agreementSkuChangePO.getTaxCatalog())))) {
                String taxCatalogList = org.apache.commons.lang3.StringUtils.join((Iterable)taxIds, (String)",");
                agreementSkuChangePO.setTaxCatalogList(taxCatalogList);
            }
        }
        agreementSkuChangePO.setBuyPrice(MoneyUtils.calculate2Decimals(agreementSkuChangePO.getBuyPrice(), 10));
        agreementSkuChangePO.setBuyPriceSum(MoneyUtils.calculate2Decimals(agreementSkuChangePO.getBuyPriceSum(), 2));
        agreementSkuChangePO.setSalePrice(MoneyUtils.calculate2Decimals(agreementSkuChangePO.getSalePrice(), 10));
        agreementSkuChangePO.setSalePriceSum(MoneyUtils.calculate2Decimals(agreementSkuChangePO.getSalePriceSum(), 2));
        this.agreementSkuChangeMapper.updateBy(agreementSkuChangePO);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u4fee\u6539\u6210\u529f\uff01");
        return rsp;
    }
}

