/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.agreement.bo.AgrTodoBO;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.enums.AgrWaitDoneCodeEnum;
import com.tydic.agreement.enums.ApproveTypeEnum;
import com.tydic.agreement.po.AgreementChangePO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.utils.CommonUtils;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.todo.ability.api.TodoWaitDoneWriteAbilityService;
import com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityParamBO;
import com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityReqBO;
import com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityRspBO;
import com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityParamBO;
import com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityReqBO;
import com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityRspBO;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityParamBO;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityReqBO;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityRspBO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import com.tydic.umc.general.ability.api.UmcQryWaitDoneConfigListAbilityService;
import com.tydic.umc.general.ability.bo.UmcQryWaitDoneConfigListAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryWaitDoneConfigListAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcWaitDoneConfigBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AgrTodoConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(AgrTodoConsumer.class);
    private static final String SYSTEM_CODE = "1";
    private static final String CENTER_CODE = "agr";
    private static final Integer PAGE_SIZE = 999;
    @Resource
    private AgreementMapper agreementMapper;
    @Resource
    private AgreementChangeMapper agreementChangeMapper;
    @Autowired
    private TodoWaitDoneWriteAbilityService todoWaitDoneWriteAbilityService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private UmcQryWaitDoneConfigListAbilityService umcQryWaitDoneConfigListAbilityService;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        boolean flag;
        try {
            log.info("---------------\u534f\u8bae\u5f85\u529e\u63a8\u9001\u5f85\u529e\u4e2d\u5fc3\u6d88\u8d39\u8005\u5f00\u59cb---------------");
            AgrTodoBO agrTodoBO = (AgrTodoBO)JSON.parseObject((String)message.getContent(), (TypeReference)new TypeReference<AgrTodoBO>(){}, (Feature[])new Feature[0]);
            if (Objects.isNull(agrTodoBO)) {
                log.error("AgrTodoConsumer:\u534f\u8bae\u5f85\u529e\u63a8\u9001\u5f85\u529e\u4e2d\u5fc3\u6d88\u8d39\u8005\u6d88\u606f\u4f53\u4e3a\u7a7a\uff01");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            log.info("-\u534f\u8bae\u5f85\u529e\u63a8\u9001\u5f85\u529e\u4e2d\u5fc3\u6d88\u8d39\u8005\u5165\u53c2\uff1a" + JSON.toJSONString((Object)agrTodoBO));
            if (!agrTodoBO.getChangeYn().booleanValue() && Objects.isNull(agrTodoBO.getAgreementId()) || agrTodoBO.getChangeYn().booleanValue() && Objects.isNull(agrTodoBO.getChangeId())) {
                log.error("AgrTodoConsumer: \u4e1a\u52a1\u7f16\u7801ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            if (agrTodoBO.getChangeYn().booleanValue()) {
                AgreementChangePO agreementChangePO = new AgreementChangePO();
                agreementChangePO.setChangeId(agrTodoBO.getChangeId());
                agreementChangePO = this.agreementChangeMapper.getModelBy(agreementChangePO);
                agrTodoBO.setAgreementId(agreementChangePO.getAgreementId());
                agrTodoBO.setAgreementName(agreementChangePO.getChangeComment());
                agrTodoBO.setPlaAgreementCode(agreementChangePO.getChangeCode());
            }
            AgreementPO agreementPO = new AgreementPO();
            agreementPO.setAgreementId(agrTodoBO.getAgreementId());
            agreementPO = this.agreementMapper.getModelBy(agreementPO);
            if (!agrTodoBO.getChangeYn().booleanValue()) {
                agrTodoBO.setAgreementName(agreementPO.getAgreementName());
                agrTodoBO.setPlaAgreementCode(agreementPO.getPlaAgreementCode());
            }
            agrTodoBO.setCreateId(agreementPO.getProducerCode());
            agrTodoBO.setCreateName(agreementPO.getProducerName());
            agrTodoBO.setSupplierId(agreementPO.getSupplierId());
            if (Objects.nonNull(agreementPO.getAgreementMode()) && agreementPO.getAgreementMode() == 2) {
                agrTodoBO.setBusiCode(agrTodoBO.getChangeYn() != false ? AgrWaitDoneCodeEnum.SETTLE_CHANGE_ADD.getCode() : AgrWaitDoneCodeEnum.SETTLE_ADD.getCode());
            } else if (Objects.nonNull(agreementPO.getAgreementMode()) && agreementPO.getAgreementMode() == 1) {
                if (agrTodoBO.getChangeYn().booleanValue()) {
                    agrTodoBO.setBusiCode(Objects.nonNull(agreementPO.getIsSupermarketStaff()) && agreementPO.getIsSupermarketStaff() == 1 ? AgrWaitDoneCodeEnum.SUPERMARKET_STAFF_CHANGE_ADD.getCode() : AgrWaitDoneCodeEnum.APPROVE.getCode());
                } else {
                    agrTodoBO.setBusiCode(Objects.nonNull(agreementPO.getIsSupermarketStaff()) && agreementPO.getIsSupermarketStaff() == 1 ? AgrWaitDoneCodeEnum.SUPERMARKET_STAFF_ADD.getCode() : AgrWaitDoneCodeEnum.ADD.getCode());
                }
            } else {
                log.error("\u5f53\u524d\u534f\u8bae\u7c7b\u578b\u65e0\u9700\u5bf9\u63a5\u5f85\u529e\u4e2d\u5fc3\uff0c\u534f\u8bae\u7f16\u53f7\uff1a" + agrTodoBO.getAgreementId());
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            this.qryWaitDoneConfig(agrTodoBO);
            this.buildFlowLink(agrTodoBO);
            if (ApproveTypeEnum.COMMIT_APPROVE.getCode().equals(agrTodoBO.getApproveType())) {
                boolean flag2 = this.addWaitDone(agrTodoBO);
                return flag2 ? ProxyConsumerStatus.CONSUME_SUCCESS : ProxyConsumerStatus.RECONSUME_LATER;
            }
            flag = this.addAlreadyDone(agrTodoBO);
            if (!flag) {
                return ProxyConsumerStatus.RECONSUME_LATER;
            }
            flag = this.cancelWaitDone(agrTodoBO);
            if (!flag) {
                return ProxyConsumerStatus.RECONSUME_LATER;
            }
            if (Objects.nonNull(agrTodoBO.getNextStationId())) {
                flag = this.addWaitDone(agrTodoBO);
            }
        }
        catch (Exception exception) {
            log.error("AgrTodoConsumer: \u534f\u8bae\u5f85\u529e\u63a8\u9001\u5f85\u529e\u4e2d\u5fc3\u6d88\u8d39\u8005\u6d88\u8d39\u5f02\u5e38\uff01" + exception + "\uff1a" + CommonUtils.dealStackTrace(exception));
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        log.info("---------------\u534f\u8bae\u5f85\u529e\u63a8\u9001\u5f85\u529e\u4e2d\u5fc3\u6d88\u8d39\u7ed3\u675f---------------");
        return flag ? ProxyConsumerStatus.CONSUME_SUCCESS : ProxyConsumerStatus.RECONSUME_LATER;
    }

    private void buildFlowLink(AgrTodoBO agrTodoBO) {
        ApprovalLogBO logInfo;
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        uacQryAuditLogReqBO.setPageNo(Integer.valueOf(1));
        uacQryAuditLogReqBO.setPageSize(Integer.valueOf(999));
        uacQryAuditLogReqBO.setObjId(agrTodoBO.getChangeYn() != false ? agrTodoBO.getChangeId() + "" : agrTodoBO.getAgreementId() + "");
        log.info("\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogReqBO));
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLastLog(uacQryAuditLogReqBO);
        log.info("\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogRspBO));
        if ("0000".equals(uacQryAuditLogRspBO.getRespCode()) && Objects.nonNull(logInfo = uacQryAuditLogRspBO.getLogInfo())) {
            agrTodoBO.setAuditOrderId(logInfo.getAuditOrderId() + "");
            agrTodoBO.setLinkId(logInfo.getId() + "");
            agrTodoBO.setLinkName(logInfo.getNextStepName());
        }
    }

    private Boolean addWaitDone(AgrTodoBO agrTodoBO) {
        TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
        todoAddWaitDoneAbilityReqBO.setCenterCode(CENTER_CODE);
        todoAddWaitDoneAbilityReqBO.setBusiCode(agrTodoBO.getBusiCode());
        todoAddWaitDoneAbilityReqBO.setBusiName(agrTodoBO.getBusiName());
        todoAddWaitDoneAbilityReqBO.setSystemCode(SYSTEM_CODE);
        todoAddWaitDoneAbilityReqBO.setOperatorId(agrTodoBO.getOperatorNo());
        todoAddWaitDoneAbilityReqBO.setOperatorName(agrTodoBO.getOperatorName());
        todoAddWaitDoneAbilityReqBO.setExt1(agrTodoBO.getAgreementName());
        todoAddWaitDoneAbilityReqBO.setCreateId(agrTodoBO.getCreateId());
        todoAddWaitDoneAbilityReqBO.setCreateName(agrTodoBO.getCreateName());
        todoAddWaitDoneAbilityReqBO.setExt7(agrTodoBO.getAuditOrderId());
        todoAddWaitDoneAbilityReqBO.setExt8(agrTodoBO.getLinkId());
        todoAddWaitDoneAbilityReqBO.setRemark(agrTodoBO.getLinkName());
        if (agrTodoBO.getChangeYn().booleanValue()) {
            todoAddWaitDoneAbilityReqBO.setExt2(String.valueOf(agrTodoBO.getAgreementId()));
        }
        todoAddWaitDoneAbilityReqBO.setExt3(String.valueOf(agrTodoBO.getSupplierId()));
        List<UserBO> userBOList = this.qryDealApprovalPersons(agrTodoBO.getNextStationId(), agrTodoBO.getOrgId());
        if (CollectionUtils.isEmpty(userBOList)) {
            log.error("AgrTodoConsumer: \u6839\u636e\u5c97\u4f4d\u7f16\u7801\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5f85\u529e\u4eba\u5458\u4fe1\u606f\uff1a\u5c97\u4f4d\u7f16\u7801\uff1a{}\uff0c \u673a\u6784\u7f16\u7801\uff1a{}", (Object)agrTodoBO.getNextStationId(), (Object)agrTodoBO.getOrgId());
            return false;
        }
        ArrayList waitDoneList = new ArrayList();
        userBOList.forEach(e -> {
            TodoAddWaitDoneAbilityParamBO paramBO = new TodoAddWaitDoneAbilityParamBO();
            paramBO.setObjId(agrTodoBO.getChangeYn() != false ? String.valueOf(agrTodoBO.getChangeId()) : String.valueOf(agrTodoBO.getAgreementId()));
            paramBO.setObjNo(agrTodoBO.getPlaAgreementCode());
            paramBO.setHandleUserNo(e.getLoginName());
            paramBO.setHandleUserName(e.getName());
            waitDoneList.add(paramBO);
        });
        todoAddWaitDoneAbilityReqBO.setWaitDoneList(waitDoneList);
        log.info("\u65b0\u589e\u5f85\u529e\u5165\u53c2\uff1a" + JSON.toJSONString((Object)todoAddWaitDoneAbilityReqBO));
        TodoAddWaitDoneAbilityRspBO todoRspBO = this.todoWaitDoneWriteAbilityService.addWaitDone(todoAddWaitDoneAbilityReqBO);
        if (Objects.isNull(todoRspBO)) {
            log.error("\u65b0\u589e\u5f85\u529e\u5931\u8d25, \u5f85\u529e\u4e2d\u5fc3\u8fd4\u56de\u7a7a\u5bf9\u8c61");
            return false;
        }
        if (!"0000".equals(todoRspBO.getRespCode())) {
            log.error("\u65b0\u589e\u5f85\u529e\u5931\u8d25\uff01" + todoRspBO.getRespDesc());
            return false;
        }
        return true;
    }

    private Boolean addAlreadyDone(AgrTodoBO agrTodoBO) {
        TodoAddAlreadyDoneAbilityReqBO todoReqBO = new TodoAddAlreadyDoneAbilityReqBO();
        todoReqBO.setCenterCode(CENTER_CODE);
        todoReqBO.setBusiCode(agrTodoBO.getBusiCode());
        todoReqBO.setOperatorId(agrTodoBO.getOperatorId());
        todoReqBO.setOperatorName(agrTodoBO.getOperatorName());
        todoReqBO.setHandleUserNo(agrTodoBO.getOperatorNo());
        TodoAddAlreadyDoneAbilityParamBO todoParamBO = new TodoAddAlreadyDoneAbilityParamBO();
        todoParamBO.setObjId(agrTodoBO.getChangeYn() != false ? String.valueOf(agrTodoBO.getChangeId()) : String.valueOf(agrTodoBO.getAgreementId()));
        todoParamBO.setAuditStatus(agrTodoBO.getAuditStatus());
        todoParamBO.setAuditRemark(agrTodoBO.getAuditRemark());
        todoParamBO.setFinishYn(agrTodoBO.getFinishYn());
        todoParamBO.setFinishTime(agrTodoBO.getFinishTime());
        todoReqBO.setCreateId(agrTodoBO.getCreateId());
        todoReqBO.setCreateName(agrTodoBO.getCreateName());
        todoReqBO.setDoneList(Collections.singletonList(todoParamBO));
        if (agrTodoBO.getChangeYn().booleanValue()) {
            todoReqBO.setExt2(String.valueOf(agrTodoBO.getAgreementId()));
        }
        todoReqBO.setExt3(String.valueOf(agrTodoBO.getSupplierId()));
        TodoAddAlreadyDoneAbilityRspBO todoRspBO = this.todoWaitDoneWriteAbilityService.AddAlreadyDone(todoReqBO);
        if (Objects.isNull(todoRspBO)) {
            log.error("AgrTodoConsumer: \u65b0\u589e\u5df2\u529e\u5931\u8d25, \u5f85\u529e\u4e2d\u5fc3\u8fd4\u56de\u7a7a\u5bf9\u8c61");
            return false;
        }
        if (!"0000".equals(todoRspBO.getRespCode())) {
            log.error("AgrTodoConsumer: \u65b0\u589e\u5df2\u529e\u5931\u8d25\uff01" + todoRspBO.getRespDesc());
            return false;
        }
        return true;
    }

    private Boolean cancelWaitDone(AgrTodoBO agrTodoBO) {
        List<UserBO> userBOList = this.qryDealApprovalPersons(agrTodoBO.getStationId(), agrTodoBO.getOrgId());
        if (CollectionUtils.isEmpty(userBOList)) {
            log.error("AgrTodoConsumer: \u6839\u636e\u5c97\u4f4d\u7f16\u7801\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5f85\u529e\u4eba\u5458\u4fe1\u606f\uff1a\u5c97\u4f4d\u7f16\u7801\uff1a{}\uff0c \u673a\u6784\u7f16\u7801\uff1a{}", (Object)agrTodoBO.getNextStationId(), (Object)agrTodoBO.getOrgId());
            return false;
        }
        TodoCancelWaitDoneAbilityReqBO todoReqBO = new TodoCancelWaitDoneAbilityReqBO();
        todoReqBO.setCenterCode(CENTER_CODE);
        todoReqBO.setBusiCode(agrTodoBO.getBusiCode());
        todoReqBO.setOperatorId(agrTodoBO.getOperatorId());
        todoReqBO.setOperatorName(agrTodoBO.getOperatorName());
        ArrayList cancelList = new ArrayList();
        userBOList.forEach(e -> {
            if (Objects.nonNull(agrTodoBO.getOperatorNo()) && agrTodoBO.getOperatorNo().equals(e.getLoginName())) {
                return;
            }
            TodoCancelWaitDoneAbilityParamBO paramBO = new TodoCancelWaitDoneAbilityParamBO();
            paramBO.setObjId(agrTodoBO.getChangeYn() != false ? String.valueOf(agrTodoBO.getChangeId()) : String.valueOf(agrTodoBO.getAgreementId()));
            paramBO.setHandleUserNo(e.getLoginName());
            cancelList.add(paramBO);
        });
        if (CollectionUtils.isEmpty(cancelList)) {
            return true;
        }
        todoReqBO.setCancelList(cancelList);
        log.info("\u53d6\u6d88\u5f85\u529e\u5165\u53c2\uff1a" + JSON.toJSONString((Object)todoReqBO));
        TodoCancelWaitDoneAbilityRspBO todoRspBO = this.todoWaitDoneWriteAbilityService.cancelWaitDone(todoReqBO);
        if (Objects.isNull(todoRspBO)) {
            log.error("AgrTodoConsumer: \u53d6\u6d88\u5f85\u529e\u5931\u8d25, \u5f85\u529e\u4e2d\u5fc3\u8fd4\u56de\u7a7a\u5bf9\u8c61");
            return false;
        }
        if (!"0000".equals(todoRspBO.getRespCode())) {
            log.error("AgrTodoConsumer: \u53d6\u6d88\u5f85\u529e\u5931\u8d25\uff01" + todoRspBO.getRespDesc());
            return false;
        }
        return true;
    }

    private List<UserBO> qryDealApprovalPersons(Long stationId, Long orgId) {
        if (Objects.nonNull(stationId)) {
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(stationId);
            dycStationOrgSelectUserNameReqBO.setOrgIdWeb(orgId);
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
                return dycStationOrgSelectUserNameRspBO.getUserList();
            }
        }
        return new ArrayList<UserBO>();
    }

    private void qryWaitDoneConfig(AgrTodoBO agrTodoBO) {
        UmcQryWaitDoneConfigListAbilityReqBO umcQryWaitDoneConfigListAbilityReqBO = new UmcQryWaitDoneConfigListAbilityReqBO();
        umcQryWaitDoneConfigListAbilityReqBO.setCenter(CENTER_CODE);
        umcQryWaitDoneConfigListAbilityReqBO.setPageSize(PAGE_SIZE);
        UmcQryWaitDoneConfigListAbilityRspBO umcQryWaitDoneConfigListAbilityRspBO = this.umcQryWaitDoneConfigListAbilityService.qryWaitDoneList(umcQryWaitDoneConfigListAbilityReqBO);
        if (!"0000".equals(umcQryWaitDoneConfigListAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException(umcQryWaitDoneConfigListAbilityRspBO.getRespDesc());
        }
        List umcWaitDoneConfigBOS = umcQryWaitDoneConfigListAbilityRspBO.getRows();
        if (CollectionUtils.isEmpty((Collection)umcWaitDoneConfigBOS)) {
            log.error("AgrTodoConsumer: \u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5f85\u529e\u914d\u7f6e\uff01center:agr");
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5f85\u529e\u914d\u7f6e\uff01center:agr");
        }
        Map<String, String> waitDoneConfigMap = umcWaitDoneConfigBOS.stream().collect(Collectors.toMap(UmcWaitDoneConfigBO::getItemCode, UmcWaitDoneConfigBO::getItemName, (k1, k2) -> k1));
        if (!waitDoneConfigMap.containsKey(agrTodoBO.getBusiCode())) {
            log.error("AgrTodoConsumer: \u672a\u67e5\u8be2\u5f85\u529e\u5c0f\u5206\u7c7b\u5230\u5bf9\u5e94\u7684\u5f85\u529e\u914d\u7f6e\uff01item_code:" + agrTodoBO.getBusiCode());
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5f85\u529e\u914d\u7f6e\uff01item_code:" + agrTodoBO.getBusiCode());
        }
        agrTodoBO.setBusiName(waitDoneConfigMap.get(agrTodoBO.getBusiCode()));
    }
}

