/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.api.AgrAgreementAddApprovalAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementAddApprovalAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementAddApprovalAbilityRspBO;
import com.tydic.agreement.atom.bo.AgrSendNotificationExtAtomReqBO;
import com.tydic.agreement.bo.AgrTodoBO;
import com.tydic.agreement.busi.api.AgrAgreementAddApprovalBusiService;
import com.tydic.agreement.busi.bo.AgrAgreementAddApprovalBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAgreementAddApprovalBusiRspBO;
import com.tydic.agreement.comb.api.AgrTodoCombService;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.enums.ApproveTypeEnum;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.utils.CommonUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrAgreementAddApprovalAbilityService"})
public class AgrAgreementAddApprovalAbilityServiceImpl
implements AgrAgreementAddApprovalAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementAddApprovalAbilityServiceImpl.class);
    @Autowired
    private AgrAgreementAddApprovalBusiService agrAgreementAddApprovalBusiService;
    @Resource(name="agrPushPlanMsgProvider")
    private ProxyMessageProducer agrPushPlanMsgProvider;
    @Autowired
    private AgrTodoCombService agrTodoCombService;
    @Value(value="${AGR_PUSH_PLAN_TOPIC:AGR_PUSH_PLAN}")
    private String topic;
    @Value(value="${AGR_PUSH_PLAN_TAG:*}")
    private String tag;
    @Value(value="${AGR_SYNC_TODO_TOPIC:AGR_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${AGR_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="agrPushTodoProvider")
    private ProxyMessageProducer agrPushTodoProvider;
    @Resource(name="agrSendNotificationProvider")
    private ProxyMessageProducer agrSendNotificationProvider;
    @Value(value="${AGR_SEND_NOTIFICATION_TOPIC:AGR_SEND_NOTIFICATION_TOPIC}")
    private String sendTopic;
    @Value(value="${AGR_SEND_NOTIFICATION_TAG:*}")
    private String sendTag;

    @PostMapping(value={"approvalAgreementAdd"})
    public AgrAgreementAddApprovalAbilityRspBO approvalAgreementAdd(@RequestBody AgrAgreementAddApprovalAbilityReqBO abilityReqBO) {
        AgrAgreementAddApprovalAbilityRspBO rsp = new AgrAgreementAddApprovalAbilityRspBO();
        if (null == abilityReqBO.getMemIdIn()) {
            throw new BusinessException("0001", "\u534f\u8bae\u65b0\u589e\u5ba1\u6279API\u5165\u53c2\u3010memIdIn\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getAgreementIds())) {
            throw new BusinessException("0001", "\u534f\u8bae\u65b0\u589e\u5ba1\u6279API\u5165\u53c2\u3010agreementIds\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getAuditResult()) {
            throw new BusinessException("0001", "\u534f\u8bae\u65b0\u589e\u5ba1\u6279API\u5165\u53c2\u3010auditResult\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getStationCodes())) {
            throw new BusinessException("0001", "\u5c97\u4f4d\u7f16\u7801\u96c6\u5408\u3010stationCodes\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap currentStationMap = new HashMap();
        abilityReqBO.getAgreementIds().forEach(agreementId -> {
            String currentStationId = this.agrTodoCombService.getNextStationId(String.valueOf(agreementId), AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
            if (!StringUtils.isEmpty((Object)currentStationId)) {
                currentStationMap.put(agreementId, currentStationId);
            }
        });
        AgrAgreementAddApprovalBusiReqBO agrAgreementAddApprovalBusiReqBO = new AgrAgreementAddApprovalBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)((Object)agrAgreementAddApprovalBusiReqBO));
        AgrAgreementAddApprovalBusiRspBO agrAgreementAddApprovalBusiRspBO = this.agrAgreementAddApprovalBusiService.approvalAgreementAdd(agrAgreementAddApprovalBusiReqBO);
        BeanUtils.copyProperties((Object)((Object)agrAgreementAddApprovalBusiRspBO), (Object)rsp);
        if (!CollectionUtils.isEmpty(agrAgreementAddApprovalBusiRspBO.getAgreementIds())) {
            for (Long id : agrAgreementAddApprovalBusiRspBO.getAgreementIds()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("agrId", (Object)id);
                this.agrPushPlanMsgProvider.send(new ProxyMessage(this.topic, this.tag, jsonObject.toJSONString()));
            }
        }
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(3000L);
                currentStationMap.forEach((agreementId, currentStationId) -> {
                    AgrTodoBO agrTodoBO = new AgrTodoBO();
                    agrTodoBO.setStationId(Long.valueOf(currentStationId));
                    agrTodoBO.setAgreementId((Long)agreementId);
                    agrTodoBO.setApproveType(ApproveTypeEnum.APPROVE.getCode());
                    agrTodoBO.setOperatorId(String.valueOf(abilityReqBO.getUserId()));
                    agrTodoBO.setOperatorNo(abilityReqBO.getUserName());
                    agrTodoBO.setOperatorName(abilityReqBO.getName());
                    agrTodoBO.setOrgId(abilityReqBO.getOrgId());
                    agrTodoBO.setAuditStatus(AgrCommConstant.AuditResult.ADOPT.equals(abilityReqBO.getAuditResult()));
                    agrTodoBO.setAuditRemark(abilityReqBO.getAuditAdvice());
                    agrTodoBO.setChangeYn(false);
                    log.info("\u5f53\u524d\u5ba1\u6279\u7684agreementId->>>>>." + agreementId);
                    if (!CollectionUtils.isEmpty(agrAgreementAddApprovalBusiRspBO.getBhAgreementIds()) && agrAgreementAddApprovalBusiRspBO.getBhAgreementIds().contains(agreementId)) {
                        log.info("\u8fdb\u5165\u6d88\u606f\u53d1\u9001\u7684agreementId->>>>>" + agreementId);
                        AgrSendNotificationExtAtomReqBO sendAtomReqBO = new AgrSendNotificationExtAtomReqBO();
                        sendAtomReqBO.setOperType("3");
                        sendAtomReqBO.setAgreementId((Long)agreementId);
                        sendAtomReqBO.setUserId(abilityReqBO.getUserId());
                        sendAtomReqBO.setAuditResult(1);
                        this.agrSendNotificationProvider.send(new ProxyMessage(this.sendTopic, this.sendTag, JSON.toJSONString((Object)((Object)sendAtomReqBO))));
                    }
                    if (!CollectionUtils.isEmpty(agrAgreementAddApprovalBusiRspBO.getAgreementIds()) && agrAgreementAddApprovalBusiRspBO.getAgreementIds().contains(agreementId) || AgrCommConstant.AuditResult.NOT_PASS.equals(abilityReqBO.getAuditResult())) {
                        agrTodoBO.setFinishYn(Boolean.TRUE);
                        agrTodoBO.setFinishTime(new Date());
                    } else {
                        String nextStationId = this.agrTodoCombService.getNextStationId(String.valueOf(agreementId), AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
                        if (StringUtils.isEmpty((Object)nextStationId)) {
                            log.error("\u5185\u8d38\u534f\u8bae\u63d0\u4ea4\u5ba1\u6279\u672a\u67e5\u8be2\u5230\u4e0b\u4e00\u7ea7\u5f85\u5ba1\u6279\u6570\u636e");
                            return;
                        }
                        agrTodoBO.setNextStationId(Long.valueOf(nextStationId));
                        AgrSendNotificationExtAtomReqBO sendAtomReqBO = new AgrSendNotificationExtAtomReqBO();
                        sendAtomReqBO.setOperType("3");
                        sendAtomReqBO.setAgreementId((Long)agreementId);
                        sendAtomReqBO.setUserId(abilityReqBO.getUserId());
                        sendAtomReqBO.setNextStationId(nextStationId);
                        this.agrSendNotificationProvider.send(new ProxyMessage(this.sendTopic, this.sendTag, JSON.toJSONString((Object)((Object)sendAtomReqBO))));
                    }
                    this.agrPushTodoProvider.send(new ProxyMessage(this.todoTopic, this.todoTag, JSON.toJSONString((Object)agrTodoBO)));
                });
            }
            catch (Exception ex) {
                log.error("AgrAgreementSubmitAbilityServiceImpl \u65b0\u589e\u5185\u8d38\u534f\u8bae\u63a8\u9001\u5f85\u529e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + ex + "\uff1a" + CommonUtils.dealStackTrace(ex));
            }
        });
        return rsp;
    }
}

