/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.tydic.agreement.ability.api.AgrAgreementBargainingCheckStockAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementCheckStockAbilityParamBO;
import com.tydic.agreement.ability.bo.AgrAgreementCheckStockAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementCheckStockAbilityRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementSkuPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrAgreementBargainingCheckStockAbilityService"})
public class AgrAgreementBargainingCheckStockAbilityServiceImpl
implements AgrAgreementBargainingCheckStockAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementBargainingCheckStockAbilityServiceImpl.class);
    @Resource
    private AgreementSkuMapper agreementSkuMapper;

    @PostMapping(value={"checkStockLimit"})
    public AgrAgreementCheckStockAbilityRspBO checkStockLimit(@RequestBody AgrAgreementCheckStockAbilityReqBO reqBO) {
        this.checkInput(reqBO);
        AgrAgreementCheckStockAbilityRspBO rspBO = new AgrAgreementCheckStockAbilityRspBO();
        rspBO.setCheckFlag(Boolean.FALSE);
        Map<Long, List<AgrAgreementCheckStockAbilityParamBO>> checkMap = reqBO.getCheckList().stream().collect(Collectors.groupingBy(AgrAgreementCheckStockAbilityParamBO::getAgreementSkuId));
        List<Long> agreementSkuIdList = reqBO.getCheckList().stream().map(AgrAgreementCheckStockAbilityParamBO::getAgreementSkuId).distinct().collect(Collectors.toList());
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        agreementSkuPO.setAgreementSkuIds(agreementSkuIdList);
        agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementSkuPO> agreementSkuPOList = this.agreementSkuMapper.getList(agreementSkuPO);
        if (CollectionUtils.isEmpty(agreementSkuPOList)) {
            log.error("\u672a\u67e5\u8be2\u5230\u534f\u8bae\u7f16\u53f7\u96c6\u5408\uff1a" + agreementSkuIdList);
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u534f\u8bae\u4fe1\u606f");
        }
        Map skuPOMap = agreementSkuPOList.stream().collect(Collectors.toMap(AgreementSkuPO::getAgreementSkuId, Function.identity(), (k1, k2) -> k1));
        checkMap.forEach((key, val) -> {
            if (CollectionUtils.isEmpty((Map)skuPOMap) || Objects.isNull(skuPOMap.get(key))) {
                log.error("\u672a\u67e5\u8be2\u5230\u534f\u8bae\u4fe1\u606f\uff0c\u534f\u8bae\u7f16\u53f7\uff1a" + key);
                throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u534f\u8bae\u4fe1\u606f\uff0c\u534f\u8bae\u7f16\u53f7\uff1a" + ((AgrAgreementCheckStockAbilityParamBO)val.get(0)).getAgreementCode());
            }
            AgreementSkuPO skuInfo = (AgreementSkuPO)skuPOMap.get(key);
            if (Objects.nonNull(skuInfo.getSaleStatus()) && skuInfo.getSaleStatus().equals("3")) {
                log.error("\u534f\u8baeid\uff1a{}  \u534f\u8bae\u660e\u7ec6\u9500\u552e\u72b6\u6001\u4e3a\u201d\u5931\u6548\u201c\uff0c\u4e0d\u53ef\u8fdb\u884c\u4e0b\u5355", key);
                throw new BusinessException("8888", "\u534f\u8bae\u660e\u7ec6\u9500\u552e\u72b6\u6001\u4e3a\u201d\u5931\u6548\u201c\uff1a\u4e0d\u53ef\u8fdb\u884c\u4e0b\u5355\uff01\u534f\u8bae\u7f16\u7801\uff1a\u3010" + ((AgrAgreementCheckStockAbilityParamBO)val.get(0)).getAgreementCode() + "\u3011");
            }
            if (Objects.nonNull(skuInfo.getSaleStatus()) && skuInfo.getSaleStatus().equals("2")) {
                BigDecimal orderNum = val.stream().map(AgrAgreementCheckStockAbilityParamBO::getOrderNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (Objects.nonNull(skuInfo.getCurrentStockNumber()) && orderNum.compareTo(skuInfo.getCurrentStockNumber()) > 0) {
                    log.error("\u534f\u8baeid\uff1a{}  \u5f53\u524d\u4e0b\u5355\u6570\u91cf\u5927\u4e8e\u534f\u8bae\u660e\u7ec6\u5269\u4f59\u5e93\u5b58\u6570\u91cf\uff0c\u4e0d\u53ef\u8fdb\u884c\u4e0b\u5355", key);
                    throw new BusinessException("8888", "\u5f53\u524d\u4e0b\u5355\u6570\u91cf\u5927\u4e8e\u534f\u8bae\u660e\u7ec6\u5269\u4f59\u5e93\u5b58\u6570\u91cf\uff0c\u4e0d\u53ef\u8fdb\u884c\u4e0b\u5355\uff01\u534f\u8bae\u7f16\u7801\uff1a\u3010" + ((AgrAgreementCheckStockAbilityParamBO)val.get(0)).getAgreementCode() + "\u3011");
                }
            }
        });
        rspBO.setCheckFlag(Boolean.TRUE);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkInput(AgrAgreementCheckStockAbilityReqBO reqBO) {
        if (Objects.isNull(reqBO) || CollectionUtils.isEmpty((Collection)reqBO.getCheckList())) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getCheckList().forEach(e -> {
            if (Objects.isNull(e.getAgreementCode())) {
                throw new BusinessException("0001", "\u5165\u53c2\u534f\u8bae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(e.getAgreementSkuId())) {
                throw new BusinessException("0001", "\u5165\u53c2\u534f\u8bae\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(e.getOrderNum())) {
                throw new BusinessException("0001", "\u5165\u53c2\u4e0b\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }
}

