/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.tydic.agreement.ability.api.AgrDistributeAreaCheckAbilityServie;
import com.tydic.agreement.ability.bo.AgrDistributeAreaCheckAbilityReqBo;
import com.tydic.agreement.ability.bo.AgrDistributeAreaCheckAbilityRspBo;
import com.tydic.agreement.dao.AgrDistributeAreaMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.po.AgrDistributeAreaPO;
import com.tydic.agreement.po.AgreementPO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrDistributeAreaCheckAbilityServie"})
public class AgrDistributeAreaCheckAbilityServieImpl
implements AgrDistributeAreaCheckAbilityServie {
    @Autowired
    private AgrDistributeAreaMapper agrDistributeAreaMapper;
    @Autowired
    private AgreementMapper agreementMapper;

    @PostMapping(value={"distributeAreaCheck"})
    public AgrDistributeAreaCheckAbilityRspBo distributeAreaCheck(@RequestBody AgrDistributeAreaCheckAbilityReqBo reqBo) {
        AgrDistributeAreaCheckAbilityRspBo rspBo = new AgrDistributeAreaCheckAbilityRspBo();
        if (CollectionUtils.isEmpty((Collection)reqBo.getAgreementIds())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u534f\u8baeID");
            return rspBo;
        }
        if (StringUtils.isEmpty((Object)reqBo.getProvinceId())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u7701\u5730\u5740ID");
            return rspBo;
        }
        HashMap<Long, Boolean> checkResult = new HashMap<Long, Boolean>();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementIds(reqBo.getAgreementIds());
        List<AgreementPO> agreementPOS = this.agreementMapper.getList(agreementPO);
        if (!CollectionUtils.isEmpty(agreementPOS)) {
            for (AgreementPO po : agreementPOS) {
                if (po.getIsSupermarketStaff() != null && po.getIsSupermarketStaff() == 1) continue;
                checkResult.put(po.getAgreementId(), true);
            }
        }
        AgrDistributeAreaPO agrDistributeAreaPO = new AgrDistributeAreaPO();
        agrDistributeAreaPO.setAgreementIds(reqBo.getAgreementIds());
        List<AgrDistributeAreaPO> agrDistributeAreaPOS = this.agrDistributeAreaMapper.getList(agrDistributeAreaPO);
        if (CollectionUtils.isEmpty(agrDistributeAreaPOS)) {
            for (Long agreementId : reqBo.getAgreementIds()) {
                if (checkResult.containsKey(agreementId)) continue;
                checkResult.put(agreementId, false);
            }
        } else {
            Map<Long, List<AgrDistributeAreaPO>> areaMap = agrDistributeAreaPOS.stream().collect(Collectors.groupingBy(a -> a.getAgreementId()));
            for (Map.Entry<Long, List<AgrDistributeAreaPO>> each : areaMap.entrySet()) {
                List province = each.getValue().stream().filter(a -> !StringUtils.isEmpty((Object)a.getProvince())).map(a -> a.getProvince()).distinct().collect(Collectors.toList());
                if (CollectionUtils.isEmpty(province)) {
                    checkResult.put(each.getKey(), false);
                    continue;
                }
                if (checkResult.containsKey(each.getKey())) continue;
                if (province.contains("0")) {
                    checkResult.put(each.getKey(), true);
                    continue;
                }
                if (province.contains(reqBo.getProvinceId())) {
                    checkResult.put(each.getKey(), true);
                    continue;
                }
                checkResult.put(each.getKey(), false);
            }
            for (Long agreementId : reqBo.getAgreementIds()) {
                if (checkResult.containsKey(agreementId)) continue;
                checkResult.put(agreementId, false);
            }
        }
        rspBo.setCheckResult(checkResult);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

