/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrAgreementChangeBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.ability.bo.AgreementSettlementBO;
import com.tydic.agreement.busi.api.AgrAgreementGetAgreementBusiService;
import com.tydic.agreement.busi.bo.AgrAgreementGetAgreementBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAgreementGetAgreementBusiRspBO;
import com.tydic.agreement.busi.impl.AgrQryAgreementSubjectDetailsBusiServiceImpl;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSettlementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgreementChangePO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSettlementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgrAgreementGetAgreementBusiServiceImpl
implements AgrAgreementGetAgreementBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementGetAgreementBusiServiceImpl.class);
    @Autowired
    AgreementMapper agreementMapper;
    @Autowired
    AgreementSkuMapper agreementSkuMapper;
    @Autowired
    AgreementSettlementMapper agreementSettlementMapper;
    @Autowired
    AgreementChangeMapper agreementChangeMapper;
    @Autowired
    AgrQryAgreementSubjectDetailsBusiServiceImpl agrQryAgreementSubjectDetailsBusiService;

    @Override
    public AgrAgreementGetAgreementBusiRspBO getAgreement(AgrAgreementGetAgreementBusiReqBO reqBO) {
        AgreementChangePO modelBy;
        AgrAgreementGetAgreementBusiRspBO rspBO = new AgrAgreementGetAgreementBusiRspBO();
        AgrAgreementBO agrAgreementBO = new AgrAgreementBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(reqBO.getAgreementId());
        if (!StringUtil.isBlank((String)reqBO.getAgreementVersion())) {
            agreementPO.setAgreementVersion(reqBO.getAgreementVersion());
        }
        AgreementPO mapperModelBy = this.agreementMapper.getModelBy(agreementPO);
        BeanUtils.copyProperties((Object)mapperModelBy, (Object)agrAgreementBO);
        ArrayList<AgreementSettlementBO> agreementSettlementBOS = new ArrayList<AgreementSettlementBO>();
        AgreementSettlementPO agreementSettlementPO = new AgreementSettlementPO();
        agreementSettlementPO.setAgreementId(agrAgreementBO.getAgreementId());
        List<AgreementSettlementPO> agreementSettlementPOList = this.agreementSettlementMapper.queryList(agreementSettlementPO);
        if (agreementSettlementPOList != null && agreementSettlementPOList.size() > 0) {
            for (AgreementSettlementPO apo : agreementSettlementPOList) {
                AgreementSettlementBO agreementSettlementBO = new AgreementSettlementBO();
                BeanUtils.copyProperties((Object)apo, (Object)agreementSettlementBO);
                if (apo.getSettlementObject().equals("1")) {
                    agreementSettlementBO.setSettlementObjectName("\u4f9b\u5e94\u5546");
                } else {
                    agreementSettlementBO.setSettlementObjectName("\u91c7\u8d2d\u5546");
                }
                this.agrQryAgreementSubjectDetailsBusiService.getSettleDetail(agreementSettlementBO);
                agreementSettlementBO.setSettlementTypeStr(AgrCommConstant.PayType.getDesc(agreementSettlementBO.getSettlementType()));
                agreementSettlementBOS.add(agreementSettlementBO);
            }
        }
        agrAgreementBO.setPaymentMethod(agreementSettlementBOS);
        ArrayList<AgrAgreementSkuBO> agrAgreementSkuBOList = new ArrayList<AgrAgreementSkuBO>();
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        agreementSkuPO.setAgreementId(agrAgreementBO.getAgreementId());
        agreementSkuPO.setAgreementVersion(agrAgreementBO.getAgreementVersion());
        List<AgreementSkuPO> listToCaiGou = this.agreementSkuMapper.getListToCaiGou(agreementSkuPO);
        if (!CollectionUtils.isEmpty(listToCaiGou)) {
            for (AgreementSkuPO agreementSkuPO1 : listToCaiGou) {
                AgrAgreementSkuBO agrAgreementSkuBO = new AgrAgreementSkuBO();
                BeanUtils.copyProperties((Object)agreementSkuPO1, (Object)agrAgreementSkuBO);
                agrAgreementSkuBOList.add(agrAgreementSkuBO);
            }
        }
        if ((modelBy = this.agreementChangeMapper.getModelByAgreementId(agrAgreementBO.getAgreementId())) != null) {
            agrAgreementBO.setChangeCode(modelBy.getChangeCode());
            agrAgreementBO.setChangeCreateName(modelBy.getCreateName());
            agrAgreementBO.setChangeType(modelBy.getChangeType());
        }
        ArrayList<AgrAgreementChangeBO> agreementChangeBOS = new ArrayList<AgrAgreementChangeBO>();
        List<AgreementChangePO> agreementChangePOS = this.agreementChangeMapper.getListByAgreement(reqBO.getAgreementId());
        if (!CollectionUtils.isEmpty(agreementChangePOS)) {
            for (AgreementChangePO agreementChangePO : agreementChangePOS) {
                AgrAgreementChangeBO agrAgreementChangeBO = new AgrAgreementChangeBO();
                BeanUtils.copyProperties((Object)agreementChangePO, (Object)agrAgreementChangeBO);
                agreementChangeBOS.add(agrAgreementChangeBO);
            }
        }
        rspBO.setAgreementChangeBOS(agreementChangeBOS);
        rspBO.setAgrAgreementBO(agrAgreementBO);
        rspBO.setAgreementSkuList(agrAgreementSkuBOList);
        return rspBO;
    }
}

